/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.ApplyAfterFunction;
import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.BinaryPattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataDerivFunction;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.FindElementFunction;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.NameFormatter;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.match.Matcher;
import com.thaiopensource.util.Equal;
import com.thaiopensource.xml.util.Name;
import java.util.Hashtable;
import java.util.Vector;
import org.relaxng.datatype.ValidationContext;

class PatternMatcher
implements Cloneable,
Matcher {
    private PatternMemo memo;
    private boolean textTyped;
    private boolean hadError;
    private boolean ignoreNextEndTag;
    private String errorMessage;
    private final Shared shared;

    PatternMatcher(Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder) {
        this.shared = new Shared(pattern, validatorPatternBuilder);
        this.memo = validatorPatternBuilder.getPatternMemo(pattern);
    }

    public boolean equals(Object object) {
        PatternMatcher patternMatcher = (PatternMatcher)object;
        if (patternMatcher == null) {
            return false;
        }
        return this.memo == patternMatcher.memo && this.hadError == patternMatcher.hadError && Equal.equal(this.errorMessage, patternMatcher.errorMessage) && this.ignoreNextEndTag == patternMatcher.ignoreNextEndTag && this.textTyped == patternMatcher.textTyped;
    }

    public int hashCode() {
        return this.memo.hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("unexpected CloneNotSupportedException");
        }
    }

    public Matcher copy() {
        return (Matcher)this.clone();
    }

    public boolean matchStartDocument() {
        if (this.memo.isNotAllowed()) {
            return this.error("schema_allows_nothing");
        }
        return true;
    }

    public boolean matchStartTagOpen(Name name2) {
        if (this.setMemo(this.memo.startTagOpenDeriv(name2))) {
            return true;
        }
        PatternMemo patternMemo = this.memo.startTagOpenRecoverDeriv(name2);
        if (!patternMemo.isNotAllowed()) {
            this.memo = patternMemo;
            return this.error("required_elements_missing");
        }
        ValidatorPatternBuilder validatorPatternBuilder = this.shared.builder;
        this.memo = patternMemo = validatorPatternBuilder.getPatternMemo(validatorPatternBuilder.makeAfter(this.shared.findElement(name2), this.memo.getPattern()));
        return this.error(patternMemo.isNotAllowed() ? "unknown_element" : "out_of_context_element", name2);
    }

    public boolean matchAttributeName(Name name2) {
        if (this.setMemo(this.memo.startAttributeDeriv(name2))) {
            return true;
        }
        this.ignoreNextEndTag = true;
        return this.error("impossible_attribute_ignored", name2);
    }

    public boolean matchAttributeValue(String string2, ValidationContext validationContext) {
        if (this.ignoreNextEndTag) {
            this.ignoreNextEndTag = false;
            return true;
        }
        if (this.setMemo(this.memo.dataDeriv(string2, validationContext))) {
            return true;
        }
        this.memo = this.memo.recoverAfter();
        return this.error("bad_attribute_value_no_name");
    }

    public boolean matchStartTagClose() {
        boolean bl;
        if (this.setMemo(this.memo.endAttributes())) {
            bl = true;
        } else {
            this.memo = this.memo.ignoreMissingAttributes();
            bl = this.error("required_attributes_missing");
        }
        this.textTyped = this.memo.getPattern().getContentType() == 3;
        return bl;
    }

    public boolean matchText(String string2, ValidationContext validationContext, boolean bl) {
        if (this.textTyped && bl) {
            this.ignoreNextEndTag = true;
            return this.setDataDeriv(string2, validationContext);
        }
        if (DataDerivFunction.isBlank(string2)) {
            return true;
        }
        return this.matchUntypedText();
    }

    public boolean matchUntypedText() {
        if (this.setMemo(this.memo.mixedTextDeriv())) {
            return true;
        }
        return this.error("text_not_allowed");
    }

    public boolean isTextTyped() {
        return this.textTyped;
    }

    private boolean setDataDeriv(String string2, ValidationContext validationContext) {
        this.textTyped = false;
        if (!this.setMemo(this.memo.textOnly())) {
            this.memo = this.memo.recoverAfter();
            return this.error("only_text_not_allowed");
        }
        if (this.setMemo(this.memo.dataDeriv(string2, validationContext))) {
            this.ignoreNextEndTag = true;
            return true;
        }
        PatternMemo patternMemo = this.memo.recoverAfter();
        boolean bl = true;
        if (!(this.memo.isNotAllowed() || patternMemo.isNotAllowed() && !this.shared.fixAfter(this.memo).dataDeriv(string2, validationContext).isNotAllowed())) {
            bl = this.error("string_not_allowed");
        }
        this.memo = patternMemo;
        return bl;
    }

    public boolean matchEndTag(ValidationContext validationContext) {
        if (this.ignoreNextEndTag) {
            this.ignoreNextEndTag = false;
            return true;
        }
        if (this.textTyped) {
            return this.setDataDeriv("", validationContext);
        }
        this.textTyped = false;
        if (this.setMemo(this.memo.endTagDeriv())) {
            return true;
        }
        PatternMemo patternMemo = this.memo.recoverAfter();
        if (this.memo.isNotAllowed() && (!patternMemo.isNotAllowed() || this.shared.fixAfter(this.memo).endTagDeriv().isNotAllowed())) {
            this.memo = patternMemo;
            return this.error("unfinished_element");
        }
        this.memo = patternMemo;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isValidSoFar() {
        return !this.hadError;
    }

    public Vector possibleStartTags(Vector vector) {
        return new PossibleStartTagsFunction().applyTo(this.memo.getPattern(), vector);
    }

    public Vector possibleAttributes(Vector vector) {
        return new PossibleAttributesFunction().applyTo(this.memo.getPattern(), vector);
    }

    private boolean setMemo(PatternMemo patternMemo) {
        if (patternMemo.isNotAllowed()) {
            return false;
        }
        this.memo = patternMemo;
        return true;
    }

    private boolean error(String string2) {
        if (this.hadError && this.memo.isNotAllowed()) {
            return true;
        }
        this.hadError = true;
        this.errorMessage = SchemaBuilderImpl.localizer.message(string2);
        return false;
    }

    private boolean error(String string2, Name name2) {
        return this.error(string2, NameFormatter.format(name2));
    }

    private boolean error(String string2, String string3) {
        if (this.hadError && this.memo.isNotAllowed()) {
            return true;
        }
        this.hadError = true;
        this.errorMessage = SchemaBuilderImpl.localizer.message(string2, string3);
        return false;
    }

    static class PossibleAttributesFunction
    extends PossibleNamesFunction {
        PossibleAttributesFunction() {
        }

        public Object caseAttribute(AttributePattern attributePattern) {
            attributePattern.getNameClass().accept(this);
            return null;
        }

        public Object caseGroup(GroupPattern groupPattern) {
            return this.caseBinary(groupPattern);
        }
    }

    static class PossibleStartTagsFunction
    extends PossibleNamesFunction {
        PossibleStartTagsFunction() {
        }

        public Object caseElement(ElementPattern elementPattern) {
            elementPattern.getNameClass().accept(this);
            return null;
        }

        public Object caseGroup(GroupPattern groupPattern) {
            groupPattern.getOperand1().apply(this);
            if (groupPattern.getOperand1().isNullable()) {
                groupPattern.getOperand2().apply(this);
            }
            return null;
        }
    }

    static abstract class PossibleNamesFunction
    extends AbstractPatternFunction
    implements NameClassVisitor {
        private Vector knownNames;
        private boolean[] knownNamesAdded;
        private Vector possibleNames;

        PossibleNamesFunction() {
        }

        Vector applyTo(Pattern pattern, Vector vector) {
            this.knownNames = vector;
            this.possibleNames = new Vector();
            if (vector != null) {
                this.knownNamesAdded = new boolean[vector.size()];
            }
            pattern.apply(this);
            return this.possibleNames;
        }

        public Object caseAfter(AfterPattern afterPattern) {
            return afterPattern.getOperand1().apply(this);
        }

        public Object caseBinary(BinaryPattern binaryPattern) {
            binaryPattern.getOperand1().apply(this);
            binaryPattern.getOperand2().apply(this);
            return null;
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            return this.caseBinary(choicePattern);
        }

        public Object caseInterleave(InterleavePattern interleavePattern) {
            return this.caseBinary(interleavePattern);
        }

        public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return oneOrMorePattern.getOperand().apply(this);
        }

        public Object caseOther(Pattern pattern) {
            return null;
        }

        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept(this);
            nameClass2.accept(this);
        }

        public void visitNsName(String string2) {
            if (this.knownNames == null) {
                return;
            }
            boolean bl = true;
            int n = this.knownNames.size();
            for (int j = 0; j < n; ++j) {
                if (this.knownNamesAdded[j]) continue;
                Name name2 = (Name)this.knownNames.elementAt(j);
                if (!name2.getNamespaceUri().equals(string2)) {
                    bl = false;
                    continue;
                }
                this.possibleNames.addElement(name2);
                this.knownNamesAdded[j] = true;
            }
            if (bl) {
                this.knownNames = null;
            }
        }

        public void visitNsNameExcept(String string2, NameClass nameClass) {
            if (this.knownNames == null) {
                return;
            }
            boolean bl = true;
            int n = this.knownNames.size();
            for (int j = 0; j < n; ++j) {
                if (this.knownNamesAdded[j]) continue;
                Name name2 = (Name)this.knownNames.elementAt(j);
                if (!name2.getNamespaceUri().equals(string2) || nameClass.contains(name2)) {
                    bl = false;
                    continue;
                }
                this.knownNamesAdded[j] = true;
                this.possibleNames.addElement(name2);
            }
            if (bl) {
                this.knownNames = null;
            }
        }

        public void visitAnyName() {
            if (this.knownNames == null) {
                return;
            }
            int n = this.knownNames.size();
            for (int j = 0; j < n; ++j) {
                if (this.knownNamesAdded[j]) continue;
                this.possibleNames.addElement(this.knownNames.elementAt(j));
            }
            this.knownNames = null;
        }

        public void visitAnyNameExcept(NameClass nameClass) {
            if (this.knownNames == null) {
                return;
            }
            boolean bl = true;
            int n = this.knownNames.size();
            for (int j = 0; j < n; ++j) {
                if (this.knownNamesAdded[j]) continue;
                Name name2 = (Name)this.knownNames.elementAt(j);
                if (nameClass.contains(name2)) {
                    bl = false;
                    continue;
                }
                this.knownNamesAdded[j] = true;
                this.possibleNames.addElement(name2);
            }
            if (bl) {
                this.knownNames = null;
            }
        }

        public void visitName(Name name2) {
            this.possibleNames.addElement(name2);
        }

        public void visitNull() {
        }

        public void visitError() {
        }
    }

    private static class Shared {
        private final Pattern start;
        private final ValidatorPatternBuilder builder;
        private Hashtable recoverPatternTable;

        Shared(Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder) {
            this.start = pattern;
            this.builder = validatorPatternBuilder;
        }

        Pattern findElement(Name name2) {
            Pattern pattern;
            if (this.recoverPatternTable == null) {
                this.recoverPatternTable = new Hashtable();
            }
            if ((pattern = (Pattern)this.recoverPatternTable.get(name2)) == null) {
                pattern = FindElementFunction.findElement(this.builder, name2, this.start);
                this.recoverPatternTable.put(name2, pattern);
            }
            return pattern;
        }

        PatternMemo fixAfter(PatternMemo patternMemo) {
            return this.builder.getPatternMemo(patternMemo.getPattern().applyForPattern(new ApplyAfterFunction(this.builder){

                Pattern apply(Pattern pattern) {
                    return Shared.this.builder.makeEmpty();
                }
            }));
        }
    }
}

