/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.util.Name;
import com.thaiopensource.xml.util.StringSplitter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class IdSoundnessChecker
implements Validator,
ContentHandler {
    private final IdTypeMap idTypeMap;
    private final ErrorHandler eh;
    private Locator locator;
    private final Hashtable table = new Hashtable();

    public IdSoundnessChecker(IdTypeMap idTypeMap, ErrorHandler errorHandler) {
        this.idTypeMap = idTypeMap;
        this.eh = errorHandler;
    }

    public void reset() {
        this.table.clear();
        this.locator = null;
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
    }

    void setComplete() {
    }

    public void endDocument() throws SAXException {
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Entry entry = (Entry)this.table.get(string2);
            if (entry.hadId) continue;
            Enumeration enumeration2 = entry.idrefLocs.elements();
            while (enumeration2.hasMoreElements()) {
                this.error("missing_id", string2, (Locator)enumeration2.nextElement());
            }
        }
        this.setComplete();
    }

    public void startPrefixMapping(String string2, String string3) throws SAXException {
    }

    public void endPrefixMapping(String string2) throws SAXException {
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        Name name2 = new Name(string2, string3);
        int n = attributes.getLength();
        block5: for (int j = 0; j < n; ++j) {
            Name name3 = new Name(attributes.getURI(j), attributes.getLocalName(j));
            int n2 = this.idTypeMap.getIdType(name2, name3);
            if (n2 == 0) continue;
            String[] stringArray = StringSplitter.split(attributes.getValue(j));
            switch (n2) {
                case 1: {
                    if (stringArray.length == 1) {
                        this.id(stringArray[0]);
                        continue block5;
                    }
                    if (stringArray.length == 0) {
                        this.error("id_no_tokens");
                        continue block5;
                    }
                    this.error("id_multiple_tokens");
                    continue block5;
                }
                case 2: {
                    if (stringArray.length == 1) {
                        this.idref(stringArray[0]);
                        continue block5;
                    }
                    if (stringArray.length == 0) {
                        this.error("idref_no_tokens");
                        continue block5;
                    }
                    this.error("idref_multiple_tokens");
                    continue block5;
                }
                case 3: {
                    if (stringArray.length > 0) {
                        for (int k = 0; k < stringArray.length; ++k) {
                            this.idref(stringArray[k]);
                        }
                        continue block5;
                    }
                    this.error("idrefs_no_tokens");
                }
            }
        }
    }

    private void id(String string2) throws SAXException {
        Entry entry = (Entry)this.table.get(string2);
        if (entry == null) {
            entry = new Entry();
            this.table.put(string2, entry);
        } else if (entry.hadId) {
            this.error("duplicate_id", string2);
            this.error("first_id", string2, entry.idLoc);
            return;
        }
        entry.idLoc = new LocatorImpl(this.locator);
        entry.hadId = true;
    }

    private void idref(String string2) {
        Entry entry = (Entry)this.table.get(string2);
        if (entry == null) {
            entry = new Entry();
            this.table.put(string2, entry);
        }
        if (entry.hadId) {
            return;
        }
        if (entry.idrefLocs == null) {
            entry.idrefLocs = new Vector();
        }
        entry.idrefLocs.addElement(new LocatorImpl(this.locator));
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string2, String string3) throws SAXException {
    }

    public void skippedEntity(String string2) throws SAXException {
    }

    public void notationDecl(String string2, String string3, String string4) throws SAXException {
    }

    public void unparsedEntityDecl(String string2, String string3, String string4, String string5) throws SAXException {
    }

    private void error(String string2) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string2), this.locator));
    }

    private void error(String string2, String string3) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string2, string3), this.locator));
    }

    private void error(String string2, String string3, Locator locator) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string2, string3), locator));
    }

    private static class Entry {
        Locator idLoc;
        Vector idrefLocs;
        boolean hadId;

        private Entry() {
        }
    }
}

