/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.BinaryDatatype;
import org.relaxng.datatype.ValidationContext;

class Base64BinaryDatatype
extends BinaryDatatype {
    private static final byte[] weightTable = Base64BinaryDatatype.makeWeightTable();
    private static final byte INVALID = -1;
    private static final byte WHITESPACE = -2;
    private static final byte PADDING = -3;

    Base64BinaryDatatype() {
    }

    boolean lexicallyAllows(String string2) {
        return Base64BinaryDatatype.byteCount(string2) >= 0;
    }

    private static int byteCount(String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = string2.length();
        block9: for (int j = 0; j < n4; ++j) {
            char c = string2.charAt(j);
            if (c >= '\u0080') {
                return -1;
            }
            int n5 = weightTable[c];
            switch (n5) {
                case -2: {
                    continue block9;
                }
                case -3: {
                    if (++n2 <= 2) continue block9;
                    return -1;
                }
                case -1: {
                    return -1;
                }
                default: {
                    if (n2 > 0) {
                        return -1;
                    }
                    n3 = n5;
                    ++n;
                }
            }
        }
        if ((n + n2 & 3) != 0) {
            return -1;
        }
        switch (n2) {
            case 1: {
                if ((n3 & 3) == 0) break;
                return -1;
            }
            case 2: {
                if ((n3 & 0xF) == 0) break;
                return -1;
            }
        }
        return (n + n2 >> 2) * 3 - n2;
    }

    Object getValue(String string2, ValidationContext validationContext) {
        int n = Base64BinaryDatatype.byteCount(string2);
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = string2.length();
        for (int j = 0; j < n5; ++j) {
            byte by = weightTable[string2.charAt(j)];
            if (by == -2) continue;
            n4 <<= 6;
            if (by != -3) {
                n4 |= by;
            }
            if (++n3 != 4) continue;
            for (int k = 16; k >= 0; k -= 8) {
                if (n2 >= n) continue;
                byArray[n2++] = (byte)(n4 >> k & 0xFF);
            }
            n3 = 0;
            n4 = 0;
        }
        return byArray;
    }

    private static byte[] makeWeightTable() {
        int n;
        byte[] byArray = new byte[128];
        int n2 = -1;
        for (n = 0; n < 128; ++n) {
            byArray[n] = n2;
        }
        n2 = 0;
        n = 65;
        while (n <= 90) {
            byArray[n] = n2;
            ++n;
            n2 = (byte)(n2 + 1);
        }
        n = 97;
        while (n <= 122) {
            byArray[n] = n2;
            ++n;
            n2 = (byte)(n2 + 1);
        }
        n = 48;
        while (n <= 57) {
            byArray[n] = n2;
            ++n;
            n2 = (byte)(n2 + 1);
        }
        int n3 = n2;
        n2 = (byte)(n2 + 1);
        byArray[43] = n3;
        int n4 = n2;
        n2 = (byte)(n2 + 1);
        byArray[47] = n4;
        byArray[10] = -2;
        byArray[13] = -2;
        byArray[9] = -2;
        byArray[32] = -2;
        byArray[61] = -3;
        return byArray;
    }
}

