/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.ParseUtils;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;

public class ShapeReadWriter<CTX extends SpatialContext> {
    protected CTX ctx;

    public ShapeReadWriter(SpatialContext ctx) {
        this.ctx = ctx;
    }

    public Shape readShape(String value2) throws InvalidShapeException {
        Shape s2 = this.readStandardShape(value2);
        if (s2 == null) {
            throw new InvalidShapeException("Unable to read: " + value2);
        }
        return s2;
    }

    public String writeShape(Shape shape) {
        return this.writeShape(shape, ShapeReadWriter.makeNumberFormat(6));
    }

    public String writeShape(Shape shape, NumberFormat nf) {
        if (shape instanceof Point) {
            Point point = (Point)shape;
            return nf.format(point.getX()) + " " + nf.format(point.getY());
        }
        if (shape instanceof Rectangle) {
            Rectangle rect2 = (Rectangle)shape;
            return nf.format(rect2.getMinX()) + " " + nf.format(rect2.getMinY()) + " " + nf.format(rect2.getMaxX()) + " " + nf.format(rect2.getMaxY());
        }
        if (shape instanceof Circle) {
            Circle c = (Circle)shape;
            return "Circle(" + nf.format(c.getCenter().getX()) + " " + nf.format(c.getCenter().getY()) + " " + "d=" + nf.format(c.getRadius()) + ")";
        }
        return shape.toString();
    }

    public static NumberFormat makeNumberFormat(int fractionDigits) {
        NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(fractionDigits);
        nf.setMinimumFractionDigits(fractionDigits);
        return nf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Shape readStandardShape(String str) {
        if (str == null || str.length() == 0) {
            throw new InvalidShapeException(str);
        }
        if (Character.isLetter(str.charAt(0))) {
            Point pt;
            int idx;
            if (!str.startsWith("Circle(") && !str.startsWith("CIRCLE(") || (idx = str.lastIndexOf(41)) <= 0) return null;
            String body = str.substring("Circle(".length(), idx);
            StringTokenizer st = new StringTokenizer(body, " ");
            String token = st.nextToken();
            if (token.indexOf(44) != -1) {
                pt = this.readLatCommaLonPoint(token);
            } else {
                double x = Double.parseDouble(token);
                double y = Double.parseDouble(st.nextToken());
                pt = ((SpatialContext)this.ctx).makePoint(x, y);
            }
            Double d = null;
            String arg2 = st.nextToken();
            idx = arg2.indexOf(61);
            if (idx > 0) {
                String k = arg2.substring(0, idx);
                if (!k.equals("d") && !k.equals("distance")) throw new InvalidShapeException("unknown arg: " + k + " :: " + str);
                d = Double.parseDouble(arg2.substring(idx + 1));
            } else {
                d = Double.parseDouble(arg2);
            }
            if (st.hasMoreTokens()) {
                throw new InvalidShapeException("Extra arguments: " + st.nextToken() + " :: " + str);
            }
            if (d != null) return ((SpatialContext)this.ctx).makeCircle(pt, d);
            throw new InvalidShapeException("Missing Distance: " + str);
        }
        if (str.indexOf(44) != -1) {
            return this.readLatCommaLonPoint(str);
        }
        StringTokenizer st = new StringTokenizer(str, " ");
        double p0 = Double.parseDouble(st.nextToken());
        double p1 = Double.parseDouble(st.nextToken());
        if (!st.hasMoreTokens()) return ((SpatialContext)this.ctx).makePoint(p0, p1);
        double p2 = Double.parseDouble(st.nextToken());
        double p3 = Double.parseDouble(st.nextToken());
        if (!st.hasMoreTokens()) return ((SpatialContext)this.ctx).makeRectangle(p0, p2, p1, p3);
        throw new InvalidShapeException("Only 4 numbers supported (rect) but found more: " + str);
    }

    private Point readLatCommaLonPoint(String value2) throws InvalidShapeException {
        double[] latLon = ParseUtils.parseLatitudeLongitude(value2);
        return ((SpatialContext)this.ctx).makePoint(latLon[1], latLon[0]);
    }
}

