/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.exception.InvalidShapeException;

public class ParseUtils {
    private ParseUtils() {
    }

    public static String[] parsePoint(String[] out, String externalVal, int dimension) throws InvalidShapeException {
        int i2;
        int idx;
        if (out == null || out.length != dimension) {
            out = new String[dimension];
        }
        int end2 = idx = externalVal.indexOf(44);
        int start2 = 0;
        if (idx == -1 && dimension == 1 && externalVal.length() > 0) {
            out[0] = externalVal.trim();
            i2 = 1;
        } else if (idx > 0) {
            for (i2 = 0; i2 < dimension; ++i2) {
                while (start2 < end2 && externalVal.charAt(start2) == ' ') {
                    ++start2;
                }
                while (end2 > start2 && externalVal.charAt(end2 - 1) == ' ') {
                    --end2;
                }
                if (start2 == end2) break;
                out[i2] = externalVal.substring(start2, end2);
                start2 = idx + 1;
                idx = end2 = externalVal.indexOf(44, start2);
                if (end2 != -1) continue;
                end2 = externalVal.length();
            }
        }
        if (i2 != dimension) {
            throw new InvalidShapeException("incompatible dimension (" + dimension + ") and values (" + externalVal + ").  Only " + i2 + " values specified");
        }
        return out;
    }

    public static double[] parsePointDouble(double[] out, String externalVal, int dimension) throws InvalidShapeException {
        int i2;
        int idx;
        if (out == null || out.length != dimension) {
            out = new double[dimension];
        }
        int end2 = idx = externalVal.indexOf(44);
        int start2 = 0;
        if (idx == -1 && dimension == 1 && externalVal.length() > 0) {
            out[0] = Double.parseDouble(externalVal.trim());
            i2 = 1;
        } else if (idx > 0) {
            for (i2 = 0; i2 < dimension; ++i2) {
                while (start2 < end2 && externalVal.charAt(start2) == ' ') {
                    ++start2;
                }
                while (end2 > start2 && externalVal.charAt(end2 - 1) == ' ') {
                    --end2;
                }
                if (start2 == end2) break;
                out[i2] = Double.parseDouble(externalVal.substring(start2, end2));
                start2 = idx + 1;
                idx = end2 = externalVal.indexOf(44, start2);
                if (end2 != -1) continue;
                end2 = externalVal.length();
            }
        }
        if (i2 != dimension) {
            throw new InvalidShapeException("incompatible dimension (" + dimension + ") and values (" + externalVal + ").  Only " + i2 + " values specified");
        }
        return out;
    }

    public static final double[] parseLatitudeLongitude(String latLonStr) throws InvalidShapeException {
        return ParseUtils.parseLatitudeLongitude(null, latLonStr);
    }

    public static final double[] parseLatitudeLongitude(double[] latLon, String latLonStr) throws InvalidShapeException {
        double[] toks;
        if (latLon == null) {
            latLon = new double[2];
        }
        if ((toks = ParseUtils.parsePointDouble(null, latLonStr, 2))[0] < -90.0 || toks[0] > 90.0) {
            throw new InvalidShapeException("Invalid latitude: latitudes are range -90 to 90: provided lat: [" + toks[0] + "]");
        }
        latLon[0] = toks[0];
        if (toks[1] < -180.0 || toks[1] > 180.0) {
            throw new InvalidShapeException("Invalid longitude: longitudes are range -180 to 180: provided lon: [" + toks[1] + "]");
        }
        latLon[1] = toks[1];
        return latLon;
    }
}

