/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context;

import com.spatial4j.core.distance.CartesianDistCalc;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.GeodesicSphereDistCalc;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.ShapeReadWriter;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.impl.CircleImpl;
import com.spatial4j.core.shape.impl.GeoCircle;
import com.spatial4j.core.shape.impl.PointImpl;
import com.spatial4j.core.shape.impl.RectangleImpl;

public class SpatialContext {
    public static final SpatialContext GEO = new SpatialContext(true);
    private final boolean geo;
    private final DistanceCalculator calculator;
    private final Rectangle worldBounds;
    private final ShapeReadWriter shapeReadWriter;

    public SpatialContext(boolean geo, DistanceCalculator calculator, Rectangle worldBounds) {
        this.geo = geo;
        if (calculator == null) {
            calculator = this.isGeo() ? new GeodesicSphereDistCalc.Haversine() : new CartesianDistCalc();
        }
        this.calculator = calculator;
        if (worldBounds == null) {
            worldBounds = this.isGeo() ? new RectangleImpl(-180.0, 180.0, -90.0, 90.0, this) : new RectangleImpl(-1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, this);
        } else {
            if (this.isGeo()) assert (worldBounds.equals(new RectangleImpl(-180.0, 180.0, -90.0, 90.0, this)));
            if (worldBounds.getCrossesDateLine()) {
                throw new IllegalArgumentException("worldBounds shouldn't cross dateline: " + worldBounds);
            }
        }
        this.worldBounds = new RectangleImpl(worldBounds, this);
        this.shapeReadWriter = this.makeShapeReadWriter();
    }

    public SpatialContext(boolean geo) {
        this(geo, null, null);
    }

    protected ShapeReadWriter makeShapeReadWriter() {
        return new ShapeReadWriter(this);
    }

    public DistanceCalculator getDistCalc() {
        return this.calculator;
    }

    public Rectangle getWorldBounds() {
        return this.worldBounds;
    }

    public boolean isGeo() {
        return this.geo;
    }

    public void verifyX(double x) {
        Rectangle bounds = this.getWorldBounds();
        if (!(x >= bounds.getMinX()) || !(x <= bounds.getMaxX())) {
            throw new InvalidShapeException("Bad X value " + x + " is not in boundary " + bounds);
        }
    }

    public void verifyY(double y) {
        Rectangle bounds = this.getWorldBounds();
        if (!(y >= bounds.getMinY()) || !(y <= bounds.getMaxY())) {
            throw new InvalidShapeException("Bad Y value " + y + " is not in boundary " + bounds);
        }
    }

    public Point makePoint(double x, double y) {
        this.verifyX(x);
        this.verifyY(y);
        return new PointImpl(x, y, this);
    }

    public Rectangle makeRectangle(Point lowerLeft, Point upperRight) {
        return this.makeRectangle(lowerLeft.getX(), upperRight.getX(), lowerLeft.getY(), upperRight.getY());
    }

    public Rectangle makeRectangle(double minX, double maxX, double minY, double maxY) {
        Rectangle bounds = this.getWorldBounds();
        if (!(minY >= bounds.getMinY()) || !(maxY <= bounds.getMaxY())) {
            throw new InvalidShapeException("Y values [" + minY + " to " + maxY + "] not in boundary " + bounds);
        }
        if (minY > maxY) {
            throw new InvalidShapeException("maxY must be >= minY: " + minY + " to " + maxY);
        }
        if (this.isGeo()) {
            this.verifyX(minX);
            this.verifyX(maxX);
            if (minX == 180.0 && minX != maxX) {
                minX = -180.0;
            } else if (maxX == -180.0 && minX != maxX) {
                maxX = 180.0;
            }
        } else {
            if (!(minX >= bounds.getMinX()) || !(maxX <= bounds.getMaxX())) {
                throw new InvalidShapeException("X values [" + minX + " to " + maxX + "] not in boundary " + bounds);
            }
            if (minX > maxX) {
                throw new InvalidShapeException("maxX must be >= minX: " + minX + " to " + maxX);
            }
        }
        return new RectangleImpl(minX, maxX, minY, maxY, this);
    }

    public Circle makeCircle(double x, double y, double distance) {
        return this.makeCircle(this.makePoint(x, y), distance);
    }

    public Circle makeCircle(Point point, double distance) {
        if (distance < 0.0) {
            throw new InvalidShapeException("distance must be >= 0; got " + distance);
        }
        if (this.isGeo()) {
            if (distance > 180.0) {
                throw new InvalidShapeException("distance must be <= 180; got " + distance);
            }
            return new GeoCircle(point, distance, this);
        }
        return new CircleImpl(point, distance, this);
    }

    @Deprecated
    public Shape readShape(String value2) throws InvalidShapeException {
        return this.shapeReadWriter.readShape(value2);
    }

    @Deprecated
    public String toString(Shape shape) {
        return this.shapeReadWriter.writeShape(shape);
    }

    public String toString() {
        if (this.equals(GEO)) {
            return GEO.getClass().getSimpleName() + ".GEO";
        }
        return this.getClass().getSimpleName() + "{" + "geo=" + this.geo + ", calculator=" + this.calculator + ", worldBounds=" + this.worldBounds + '}';
    }
}

