/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.profiler;

import com.mysql.jdbc.StringUtils;
import java.util.Date;

public class ProfilerEvent {
    public static final byte TYPE_WARN = 0;
    public static final byte TYPE_OBJECT_CREATION = 1;
    public static final byte TYPE_PREPARE = 2;
    public static final byte TYPE_QUERY = 3;
    public static final byte TYPE_EXECUTE = 4;
    public static final byte TYPE_FETCH = 5;
    public static final byte TYPE_SLOW_QUERY = 6;
    protected byte eventType;
    protected long connectionId;
    protected int statementId;
    protected int resultSetId;
    protected long eventCreationTime;
    protected long eventDuration;
    protected String durationUnits;
    protected int hostNameIndex;
    protected String hostName;
    protected int catalogIndex;
    protected String catalog;
    protected int eventCreationPointIndex;
    protected String eventCreationPointDesc;
    protected String message;

    public ProfilerEvent(byte eventType, String hostName, String catalog, long connectionId, int statementId, int resultSetId, long eventCreationTime, long eventDuration, String durationUnits, String eventCreationPointDesc, String eventCreationPoint, String message2) {
        this.eventType = eventType;
        this.connectionId = connectionId;
        this.statementId = statementId;
        this.resultSetId = resultSetId;
        this.eventCreationTime = eventCreationTime;
        this.eventDuration = eventDuration;
        this.durationUnits = durationUnits;
        this.eventCreationPointDesc = eventCreationPointDesc;
        this.message = message2;
    }

    public String getEventCreationPointAsString() {
        return this.eventCreationPointDesc;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32);
        switch (this.eventType) {
            case 4: {
                buf.append("EXECUTE");
                break;
            }
            case 5: {
                buf.append("FETCH");
                break;
            }
            case 1: {
                buf.append("CONSTRUCT");
                break;
            }
            case 2: {
                buf.append("PREPARE");
                break;
            }
            case 3: {
                buf.append("QUERY");
                break;
            }
            case 0: {
                buf.append("WARN");
                break;
            }
            case 6: {
                buf.append("SLOW QUERY");
                break;
            }
            default: {
                buf.append("UNKNOWN");
            }
        }
        buf.append(" created: ");
        buf.append(new Date(this.eventCreationTime));
        buf.append(" duration: ");
        buf.append(this.eventDuration);
        buf.append(" connection: ");
        buf.append(this.connectionId);
        buf.append(" statement: ");
        buf.append(this.statementId);
        buf.append(" resultset: ");
        buf.append(this.resultSetId);
        if (this.message != null) {
            buf.append(" message: ");
            buf.append(this.message);
        }
        if (this.eventCreationPointDesc != null) {
            buf.append("\n\nEvent Created at:\n");
            buf.append(this.eventCreationPointDesc);
        }
        return buf.toString();
    }

    public static ProfilerEvent unpack(byte[] buf) throws Exception {
        int pos2 = 0;
        byte eventType = buf[pos2++];
        long connectionId = ProfilerEvent.readInt(buf, pos2);
        int statementId = ProfilerEvent.readInt(buf, pos2 += 8);
        int resultSetId = ProfilerEvent.readInt(buf, pos2 += 4);
        long eventCreationTime = ProfilerEvent.readLong(buf, pos2 += 4);
        long eventDuration = ProfilerEvent.readLong(buf, pos2 += 8);
        byte[] eventDurationUnits = ProfilerEvent.readBytes(buf, pos2 += 4);
        pos2 += 4;
        if (eventDurationUnits != null) {
            pos2 += eventDurationUnits.length;
        }
        ProfilerEvent.readInt(buf, pos2);
        byte[] eventCreationAsBytes = ProfilerEvent.readBytes(buf, pos2 += 4);
        pos2 += 4;
        if (eventCreationAsBytes != null) {
            pos2 += eventCreationAsBytes.length;
        }
        byte[] message2 = ProfilerEvent.readBytes(buf, pos2);
        pos2 += 4;
        if (message2 != null) {
            pos2 += message2.length;
        }
        return new ProfilerEvent(eventType, "", "", connectionId, statementId, resultSetId, eventCreationTime, eventDuration, StringUtils.toString(eventDurationUnits, "ISO8859_1"), StringUtils.toString(eventCreationAsBytes, "ISO8859_1"), null, StringUtils.toString(message2, "ISO8859_1"));
    }

    public byte[] pack() throws Exception {
        int len = 29;
        byte[] eventCreationAsBytes = null;
        this.getEventCreationPointAsString();
        if (this.eventCreationPointDesc != null) {
            eventCreationAsBytes = StringUtils.getBytes(this.eventCreationPointDesc, "ISO8859_1");
            len += 4 + eventCreationAsBytes.length;
        } else {
            len += 4;
        }
        byte[] messageAsBytes = null;
        if (this.message != null) {
            messageAsBytes = StringUtils.getBytes(this.message, "ISO8859_1");
            len += 4 + messageAsBytes.length;
        } else {
            len += 4;
        }
        byte[] durationUnitsAsBytes = null;
        if (this.durationUnits != null) {
            durationUnitsAsBytes = StringUtils.getBytes(this.durationUnits, "ISO8859_1");
            len += 4 + durationUnitsAsBytes.length;
        } else {
            len += 4;
            durationUnitsAsBytes = StringUtils.getBytes("", "ISO8859_1");
        }
        byte[] buf = new byte[len];
        int pos2 = 0;
        buf[pos2++] = this.eventType;
        pos2 = ProfilerEvent.writeLong(this.connectionId, buf, pos2);
        pos2 = ProfilerEvent.writeInt(this.statementId, buf, pos2);
        pos2 = ProfilerEvent.writeInt(this.resultSetId, buf, pos2);
        pos2 = ProfilerEvent.writeLong(this.eventCreationTime, buf, pos2);
        pos2 = ProfilerEvent.writeLong(this.eventDuration, buf, pos2);
        pos2 = ProfilerEvent.writeBytes(durationUnitsAsBytes, buf, pos2);
        pos2 = ProfilerEvent.writeInt(this.eventCreationPointIndex, buf, pos2);
        pos2 = eventCreationAsBytes != null ? ProfilerEvent.writeBytes(eventCreationAsBytes, buf, pos2) : ProfilerEvent.writeInt(0, buf, pos2);
        pos2 = messageAsBytes != null ? ProfilerEvent.writeBytes(messageAsBytes, buf, pos2) : ProfilerEvent.writeInt(0, buf, pos2);
        return buf;
    }

    private static int writeInt(int i2, byte[] buf, int pos2) {
        buf[pos2++] = (byte)(i2 & 0xFF);
        buf[pos2++] = (byte)(i2 >>> 8);
        buf[pos2++] = (byte)(i2 >>> 16);
        buf[pos2++] = (byte)(i2 >>> 24);
        return pos2;
    }

    private static int writeLong(long l, byte[] buf, int pos2) {
        buf[pos2++] = (byte)(l & 0xFFL);
        buf[pos2++] = (byte)(l >>> 8);
        buf[pos2++] = (byte)(l >>> 16);
        buf[pos2++] = (byte)(l >>> 24);
        buf[pos2++] = (byte)(l >>> 32);
        buf[pos2++] = (byte)(l >>> 40);
        buf[pos2++] = (byte)(l >>> 48);
        buf[pos2++] = (byte)(l >>> 56);
        return pos2;
    }

    private static int writeBytes(byte[] msg, byte[] buf, int pos2) {
        pos2 = ProfilerEvent.writeInt(msg.length, buf, pos2);
        System.arraycopy(msg, 0, buf, pos2, msg.length);
        return pos2 + msg.length;
    }

    private static int readInt(byte[] buf, int pos2) {
        return buf[pos2++] & 0xFF | (buf[pos2++] & 0xFF) << 8 | (buf[pos2++] & 0xFF) << 16 | (buf[pos2++] & 0xFF) << 24;
    }

    private static long readLong(byte[] buf, int pos2) {
        return (long)(buf[pos2++] & 0xFF) | (long)(buf[pos2++] & 0xFF) << 8 | (long)(buf[pos2++] & 0xFF) << 16 | (long)(buf[pos2++] & 0xFF) << 24 | (long)(buf[pos2++] & 0xFF) << 32 | (long)(buf[pos2++] & 0xFF) << 40 | (long)(buf[pos2++] & 0xFF) << 48 | (long)(buf[pos2++] & 0xFF) << 56;
    }

    private static byte[] readBytes(byte[] buf, int pos2) {
        int length2 = ProfilerEvent.readInt(buf, pos2);
        byte[] msg = new byte[length2];
        System.arraycopy(buf, pos2 += 4, msg, 0, length2);
        return msg;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public long getEventCreationTime() {
        return this.eventCreationTime;
    }

    public long getEventDuration() {
        return this.eventDuration;
    }

    public String getDurationUnits() {
        return this.durationUnits;
    }

    public byte getEventType() {
        return this.eventType;
    }

    public int getResultSetId() {
        return this.resultSetId;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public String getMessage() {
        return this.message;
    }
}

