/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.jmx;

import com.mysql.jdbc.ConnectionGroupManager;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.jmx.LoadBalanceConnectionGroupManagerMBean;
import java.lang.management.ManagementFactory;
import java.sql.SQLException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class LoadBalanceConnectionGroupManager
implements LoadBalanceConnectionGroupManagerMBean {
    private boolean isJmxRegistered = false;

    public synchronized void registerJmx() throws SQLException {
        if (this.isJmxRegistered) {
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name2 = new ObjectName("com.mysql.jdbc.jmx:type=LoadBalanceConnectionGroupManager");
            mbs.registerMBean(this, name2);
            this.isJmxRegistered = true;
        }
        catch (Exception e) {
            throw SQLError.createSQLException("Uable to register load-balance management bean with JMX", null, e, null);
        }
    }

    public void addHost(String group2, String host, boolean forExisting) {
        try {
            ConnectionGroupManager.addHost(group2, host, forExisting);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getActiveHostCount(String group2) {
        return ConnectionGroupManager.getActiveHostCount(group2);
    }

    public long getActiveLogicalConnectionCount(String group2) {
        return ConnectionGroupManager.getActiveLogicalConnectionCount(group2);
    }

    public long getActivePhysicalConnectionCount(String group2) {
        return ConnectionGroupManager.getActivePhysicalConnectionCount(group2);
    }

    public int getTotalHostCount(String group2) {
        return ConnectionGroupManager.getTotalHostCount(group2);
    }

    public long getTotalLogicalConnectionCount(String group2) {
        return ConnectionGroupManager.getTotalLogicalConnectionCount(group2);
    }

    public long getTotalPhysicalConnectionCount(String group2) {
        return ConnectionGroupManager.getTotalPhysicalConnectionCount(group2);
    }

    public long getTotalTransactionCount(String group2) {
        return ConnectionGroupManager.getTotalTransactionCount(group2);
    }

    public void removeHost(String group2, String host) throws SQLException {
        ConnectionGroupManager.removeHost(group2, host);
    }

    public String getActiveHostsList(String group2) {
        return ConnectionGroupManager.getActiveHostLists(group2);
    }

    public String getRegisteredConnectionGroups() {
        return ConnectionGroupManager.getRegisteredConnectionGroups();
    }

    public void stopNewConnectionsToHost(String group2, String host) throws SQLException {
        ConnectionGroupManager.removeHost(group2, host);
    }
}

