/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.BalanceStrategy;
import com.mysql.jdbc.CommunicationsException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.LoadBalancingConnectionProxy;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialBalanceStrategy
implements BalanceStrategy {
    private int currentHostIndex = -1;

    @Override
    public void destroy() {
    }

    @Override
    public void init(Connection conn, Properties props) throws SQLException {
    }

    @Override
    public ConnectionImpl pickConnection(LoadBalancingConnectionProxy proxy2, List<String> configuredHosts, Map<String, ConnectionImpl> liveConnections, long[] responseTimes, int numRetries) throws SQLException {
        int numHosts = configuredHosts.size();
        SQLException ex = null;
        Map<String, Long> blackList = proxy2.getGlobalBlacklist();
        int attempts = 0;
        while (attempts < numRetries) {
            if (numHosts == 1) {
                this.currentHostIndex = 0;
            } else if (this.currentHostIndex == -1) {
                int random;
                int i2;
                for (i2 = random = (int)Math.floor(Math.random() * (double)numHosts); i2 < numHosts; ++i2) {
                    if (blackList.containsKey(configuredHosts.get(i2))) continue;
                    this.currentHostIndex = i2;
                    break;
                }
                if (this.currentHostIndex == -1) {
                    for (i2 = 0; i2 < random; ++i2) {
                        if (blackList.containsKey(configuredHosts.get(i2))) continue;
                        this.currentHostIndex = i2;
                        break;
                    }
                }
                if (this.currentHostIndex == -1) {
                    blackList = proxy2.getGlobalBlacklist();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
            } else {
                int i3;
                boolean foundGoodHost = false;
                for (i3 = this.currentHostIndex + 1; i3 < numHosts; ++i3) {
                    if (blackList.containsKey(configuredHosts.get(i3))) continue;
                    this.currentHostIndex = i3;
                    foundGoodHost = true;
                    break;
                }
                if (!foundGoodHost) {
                    for (i3 = 0; i3 < this.currentHostIndex; ++i3) {
                        if (blackList.containsKey(configuredHosts.get(i3))) continue;
                        this.currentHostIndex = i3;
                        foundGoodHost = true;
                        break;
                    }
                }
                if (!foundGoodHost) {
                    blackList = proxy2.getGlobalBlacklist();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
            }
            String hostPortSpec = configuredHosts.get(this.currentHostIndex);
            ConnectionImpl conn = liveConnections.get(hostPortSpec);
            if (conn == null) {
                try {
                    conn = proxy2.createConnectionForHost(hostPortSpec);
                }
                catch (SQLException sqlEx) {
                    ex = sqlEx;
                    if (sqlEx instanceof CommunicationsException || "08S01".equals(sqlEx.getSQLState())) {
                        proxy2.addToGlobalBlacklist(hostPortSpec);
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    throw sqlEx;
                }
            }
            return conn;
        }
        if (ex != null) {
            throw ex;
        }
        return null;
    }
}

