import java.util.*;

/* options parser */

/* keyword [=value [ delimiter value] ]
/* xx=[prefix]option1,option2 yy = option1 , option2 */
/* gets parsed as (0) xx [prefix] option1 delimiter option2  */

public final class options
{

 public Vector parsed;
 public String opt;

 public static final char whitespace[]={' ','\t','\r','\n'};
 public static final char delimiter[]={',','&'}; // option delimiters  OR AND
 public static final char escape[]={'\\'}; // removes special function from next char
 public static final char prefix[]={'!'}; // NOT

 options (String s)
 {
  // parsed=new Vector();

  opt=s;
  parsed=null;
  parse();
 }


 public final boolean parse()
 {
  String x;
  x=opt;
  if(parsed!=null) return true; // already done
  parsed=new Vector();
  if(x==null) return true;
  x=x.trim();
  if(x.equals("")) return true;

  int xlength=x.length();
  char c='X';
  StringBuffer sb;
  int i=0;

  line:while(i<xlength)
  {
   // System.err.println("new keyword");
   sb=new StringBuffer();

  /* skip initial whitespace */
  while(true)
  {
   c=x.charAt(i++);
   if( matchChar(c,whitespace)) { continue;}
   if(i>=xlength) continue line;
   break;
  }

   /* az do mezery nebo = */
   sb.append(c);
   while(true)
   {
    c=x.charAt(i++);

    if( c=='=') break;

    // EOL check
    if(i>=xlength && !matchChar(c,whitespace))
     {
      sb.append(c);
      parsed.addElement(sb.toString());
      continue line;
     }

    if( matchChar(c,whitespace) )  { parsed.addElement(sb.toString());
                                     continue line;} // no options after keyword

    // TODO: warn when delimiter found?
    sb.append(c);
   }
  // sb.append(" = ");
  sb.append(" ");
  /* skip whitespaces after = */
  optionloop:while(true)
  {
  // if(i>=xlength) { parsed.addElement(sb.toString());break line;}
  //System.err.println("new option loop. sb="+sb);
  while(true)
  {
   c=x.charAt(i++);
   if( matchChar(c,whitespace)) { continue;}
   if(i>=xlength)
    {
     sb.append(c); // fixed?
     parsed.addElement(sb.toString());
     break line;
    }
   if(matchChar(c,prefix))
    {
     sb.append(c+" ");continue;
    }
   break;
  }
  // start option. stop at whitespace or delimiter
  sb.append(c);
  while(true)
  {
   c=x.charAt(i++);
   if(matchChar(c,escape))
   {
       if (c<xlength)
       {
          c=x.charAt(i++);
	  sb.append(c);
	  continue;
       }
   }
   if(matchChar(c,whitespace)) { break;}
   if(matchChar(c,delimiter))
    {
     sb.append(" "+c+" ");
     continue optionloop;
    }
   sb.append(c);
   if(i>=xlength)
    {
     parsed.addElement(sb.toString());
     break line;
    }
  }
  /* search for delimiter, abort when not found. */
  //System.err.println("finite at");
  for(int j=i;j<xlength;j++)
  {
   c=x.charAt(j);
   if(matchChar(c,delimiter)) {sb.append(" "+c+" ");i=j+1;continue optionloop;}
   if(matchChar(c,whitespace)) continue;
   parsed.addElement(sb.toString());
   continue line;
  }

  } /* end opt. loop */
  }/* end line */
  return true;
 }

 public final String toString()
 {
  StringBuffer sb=new StringBuffer(100);
  sb.append("String: "+opt+" parsed as:\n");
  // if(parsed==null) parse();
  for(int i=0;i<parsed.size();i++)
   {
   sb.append(i+" "+parsed.elementAt(i)+"\n");
   }
  return sb.toString();
 }

 public final static boolean matchChar(char c,char where[])
 {
  if(where==null) return false;
  for(int i=where.length;i>0;i--)
   if(c==where[i-1]) return true;

  return false;
 }

 public final static boolean isDelimiter(char c)
 {
  return matchChar(c,delimiter);
 }

 public final static boolean isPrefix(char c)
 {
  return matchChar(c,prefix);
 }

 public final void prioritySort(String keyword,String optionlist[],
                                boolean casesensitive)
 {
  if(optionlist==null || keyword==null || parsed.size()==0)
   return; // No work needed

 if(!casesensitive)

   for(int i=optionlist.length;i>0;i--)
    optionlist[i-1]=optionlist[i-1].toLowerCase();

 /* najdi keyword */
 scanloop:for(int i=0;i<parsed.size();i++)
 {
  StringTokenizer st;
  st=new StringTokenizer((String)parsed.elementAt(i));
  if(!st.hasMoreElements()) continue;
  if(keyword.toLowerCase().equals(st.nextToken().toLowerCase()) )
   {
    Vector opts; /* options  */
    opts=new Vector();
    Vector prfs; /* prefixes */
    prfs=new Vector();
    char sepused='\0'; // allow only ONE type of sepatator
    Character prefixused;
    prefixused= new Character('\0');

    while(st.hasMoreElements())
    {
     String z;
     char c;
     z=st.nextToken();
     if(z.length()==1)
      {
     c=z.charAt(0);
     if(matchChar(c,delimiter))
      {
       if(sepused==0) sepused=c;
        else if (c!=sepused)
          {
           System.err.println("[WARNING] Priority sort doesn't support different separators, leaving unsorted.");
           continue scanloop;
          }

       continue;
      }/* del match  */
     if(matchChar(c,prefix))
      {
       prefixused=new Character(c);
       continue;
      }
     } /* size=1*/

       if(!casesensitive) z=z.toLowerCase();
       opts.addElement(z);
       prfs.addElement(prefixused);
       prefixused= new Character('\0');
    }
    /* all done, start sorting stuff */
    Vector outopts;
    Vector outprfs;
    outopts=new Vector();
    outprfs=new Vector();
    int insertpos=0;
    for(int j=0;j<optionlist.length;j++)
     {

      if(optionlist[j].equals("*")) insertpos=j;
      for(int y=0;y<opts.size();y++)
       {
        if(opts.elementAt(y).equals(optionlist[j]))
         {
           outopts.addElement(opts.elementAt(y));
           outprfs.addElement(prfs.elementAt(y));
           opts.removeElementAt(y);
           prfs.removeElementAt(y);
           y--;continue;

         }
       }

     }
    for(int y=0;y<opts.size();y++)
      {
       outopts.insertElementAt(opts.elementAt(y),insertpos);
       outprfs.insertElementAt(prfs.elementAt(y),insertpos);
      }
    StringBuffer sorted;
    sorted=new StringBuffer(40);
    StringTokenizer st2;
    st2=new StringTokenizer((String)parsed.elementAt(i));
    sorted.append(st2.nextToken());
    for(int y=0;y<outopts.size();y++)
     {
      sorted.append(" ");
      if( outprfs.elementAt(y).equals(new Character('\0')))
        { /* sorted.append(" "); */}
      else
        sorted.append(outprfs.elementAt(y).toString()+" ");
      sorted.append((String)outopts.elementAt(y));
      if(y<outopts.size()-1) sorted.append(" "+sepused);
     }
    parsed.setElementAt(sorted.toString(),i);
    // UFFFF
   }

 }

 }

 public final void addDefault(options def)
 {
  if(def==null) return;
  if(parsed==null) parse();

  next:for(int i=def.parsed.size()-1;i>=0;i--)
  {
   StringTokenizer st;
   String dv;
   dv=(String)def.parsed.elementAt(i);
   st=new StringTokenizer(dv);
   String s;
   if(st.hasMoreTokens()) s=st.nextToken();
     else
    continue;

   /* je ten */
   for(int j=parsed.size()-1;j>=0;j--)
   {
     String s2;
     st=new StringTokenizer((String)parsed.elementAt(j));
     if(st.hasMoreTokens()) s2=st.nextToken();
       else
      continue;
     if(s.equals(s2))  continue next;
   }
   /* add default value */
   parsed.addElement(dv);
  }
 }

} /* class */
