import java.util.*;
import java.io.*;

public class localdir
{
 protected String name;
 protected HashMap <String,localurl> objects;

/**
 Vytvori localdir objekt , name=lokalni adresar s / nakonci
*/
 public localdir(String name)
 {
  this.name=name;
  objects=new HashMap <String,localurl>();
  localinit();
 }

 protected void localinit()
 {
   if(this.name==null) this.name="."+File.separator; else
     if(!this.name.endsWith(File.separator))
         this.name=this.name+File.separator;

   File f=new File(name);
   f.mkdirs();
   if(!f.exists())
    {
      /* likvidujeme up-dirs, mozna je to konflikt se souborem */
      File thisdir=new File(name.substring(0,name.length()-1));
      while(true)
      {
        String par;
        thisdir.delete();
        par=thisdir.getParent();
        if(par==null) break;
        thisdir=new File(par);
      }
      /* 2nd try */
      f.mkdirs();
   }
 }

 public localurl getObject(String Obj)
 {
   localurl z;
   synchronized(this)
   {
    z=objects.get(Obj);
    if(z!=null) return z;
    z=new localurl(name,Obj);
    objects.put(Obj,z);
   }
   return z;
 }

 public int hashCode()
 {
   if(name==null) return 0;
   return name.hashCode();
 }

 public boolean equals(Object o)
 {
  if(o instanceof localdir)
   {
    localdir ld=(localdir)o;
    return name.equals(ld.name);
   }
   return false;
 }

 public void close()
 {
  // System.out.println("[debug] CLosing dir "+name);
  File thisdir=new File(name.substring(0,name.length()-1));

   /* likvidujeme up-dirs*/
   while(thisdir.delete())
    {
     String par;
     par=thisdir.getParent();
     if(par==null) break;
     thisdir=new File(par);
    }
 }

 public static void init(String z[])
 {

 }

}
