<?php

	
	
	/**
	 * \ingroup XML
	 *
	 * represents an enclosure from an rss 2.0 feed. This object needs
	 * our patched version of MagpieRSS which has support for enclosures.
	 *
	 * Objects of this class are returned via the RssItem::getEnclosures() method, as an
	 * array of enclosures in case the RSS item has any.
	 */
	class RssEnclosure 
	{
		var $_url;
		var $_mimeType;
		var $_length;
	
		/**
		 * builds the object based on the results gotten from MagpieRSS
		 *
		 * @param enclosure an array as generated by MagpieRSS containing all the necessary
		 * information from the enclosure
		 */
		function RssEnclosure( $enclosure )
		{
			$this->_url = $enclosure["url"];
			$this->_length = $enclosure["length"];
			$this->_mimeType = $enclosure["type"];
			
			// keep also the array, just in case...
			$this->_enclosure = $enclosure;
		}
		
		/**
		 * returns the length in bytes of the enclosure
		 *
		 * @return the length in bytes
		 */
		function getLength()
		{
			return( $this->_length );
		}
		
		/**
		 * alias of the above
		 * @see getLength()
		 */
		function getSize()
		{
			return( $this->getLength());
		}
		
		/**
		 * returns the mime type as specified by the enclosure
		 *
		 * @return mime type
		 */
		function getMimeType()
		{
			return( $this->_mimeType );
		}
		
		/**
		 * returns the enclosure where the url is located
		 *
		 * @return a url
		 */
		function getUrl()
		{
			return( $this->_url );
		}
	}
?>