# @file    TestReadFromFile7.rb
# @brief   Reads test-data/l2v3-all.xml into memory and tests it.
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Sarah Keating 
#
# $Id: TestReadFromFile7.rb 11522 2010-07-22 00:32:10Z mhucka $
# $HeadURL: http://sbml.svn.sourceforge.net/svnroot/sbml/trunk/libsbml/src/bindings/ruby/test/sbml/TestReadFromFile7.rb $
#
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestReadFromFile7.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestReadFromFile7 < Test::Unit::TestCase

  def test_read_l2v3_all
    reader = LibSBML::SBMLReader.new()
    filename = "../../sbml/test/test-data/"
    filename += "l2v3-all.xml"
    d = reader.readSBML(filename)
    if (d == nil)
    end
    assert( d.getLevel() == 2 )
    assert( d.getVersion() == 3 )
    m = d.getModel()
    assert( m != nil )
    assert( m.getId() ==  "l2v3_all" )
    assert( m.getNumCompartments() == 1 )
    c = m.getCompartment(0)
    assert( c != nil )
    assert( c.getId() ==  "a" )
    assert( c.getCompartmentType() ==  "hh" )
    assert( c.getSBOTerm() == 236 )
    assert( c.getSBOTermID() ==  "SBO:0000236" )
    assert( c.getSize() == 2.3 )
    assert( m.getNumCompartmentTypes() == 1 )
    ct = m.getCompartmentType(0)
    assert( ct != nil )
    assert( ct.getId() ==  "hh" )
    assert( ct.getSBOTerm() == 236 )
    assert( ct.getSBOTermID() ==  "SBO:0000236" )
    assert( m.getNumSpeciesTypes() == 1 )
    st = m.getSpeciesType(0)
    assert( st != nil )
    assert( st.getId() ==  "gg" )
    assert( st.getName() ==  "dd" )
    assert( st.getSBOTerm() == 236 )
    assert( st.getSBOTermID() ==  "SBO:0000236" )
    lost = m.getListOfSpeciesTypes()
    st1 = lost.get(0)
    assert( st1 == st )
    st1 = lost.get("gg")
    assert( st1 == st )
    assert( m.getNumConstraints() == 1 )
    con = m.getConstraint(0)
    assert( con != nil )
    ast = con.getMath()
    assert ((  "lt(x, 3)" == LibSBML::formulaToString(ast) ))
    assert( m.getNumEvents() == 1 )
    e = m.getEvent(0)
    assert( e != nil )
    assert( e.getId() ==  "e1" )
    assert( e.getSBOTerm() == 231 )
    assert( e.getSBOTermID() ==  "SBO:0000231" )
    assert_equal true, e.isSetDelay()
    delay = e.getDelay()
    assert( delay != nil )
    assert( delay.getSBOTerm() == 64 )
    assert( delay.getSBOTermID() ==  "SBO:0000064" )
    ast = delay.getMath()
    assert ((  "p + 3" == LibSBML::formulaToString(ast) ))
    assert_equal true, e.isSetTrigger()
    trigger = e.getTrigger()
    assert( trigger != nil )
    assert( trigger.getSBOTerm() == 64 )
    assert( trigger.getSBOTermID() ==  "SBO:0000064" )
    ast = trigger.getMath()
    assert ((  "lt(x, 3)" == LibSBML::formulaToString(ast) ))
    loe = m.getListOfEvents()
    e1 = loe.get(0)
    assert( e1 == e )
    e1 = loe.get("e1")
    assert( e1 == e )
    assert( e.getNumEventAssignments() == 1 )
    ea = e.getEventAssignment(0)
    assert( ea != nil )
    assert( ea.getVariable() ==  "a" )
    assert( ea.getSBOTerm() == 64 )
    assert( ea.getSBOTermID() ==  "SBO:0000064" )
    ast = ea.getMath()
    assert ((  "x * p3" == LibSBML::formulaToString(ast) ))
    loea = e.getListOfEventAssignments()
    ea1 = loea.get(0)
    assert( ea1 == ea )
    ea1 = loea.get("a")
    assert( ea1 == ea )
    assert( m.getNumFunctionDefinitions() == 1 )
    fd = m.getFunctionDefinition(0)
    assert( fd != nil )
    assert( fd.getId() ==  "fd" )
    assert( fd.getSBOTerm() == 64 )
    assert( fd.getSBOTermID() ==  "SBO:0000064" )
    ast = fd.getMath()
    assert ((  "lambda(x, pow(x, 3))" == LibSBML::formulaToString(ast) ))
    lofd = m.getListOfFunctionDefinitions()
    fd1 = lofd.get(0)
    assert( fd1 == fd )
    fd1 = lofd.get("fd")
    assert( fd1 == fd )
    assert( m.getNumInitialAssignments() == 1 )
    ia = m.getInitialAssignment(0)
    assert( ia != nil )
    assert( ia.getSymbol() ==  "p1" )
    ast = ia.getMath()
    assert ((  "x * p3" == LibSBML::formulaToString(ast) ))
    assert( m.getNumRules() == 3 )
    alg = m.getRule(0)
    assert( alg != nil )
    assert( alg.getSBOTerm() == 64 )
    assert( alg.getSBOTermID() ==  "SBO:0000064" )
    ast = alg.getMath()
    assert ((  "pow(x, 3)" == LibSBML::formulaToString(ast) ))
    ar = m.getRule(1)
    assert( ar != nil )
    assert( ar.getVariable() ==  "p2" )
    assert( ar.getSBOTerm() == 64 )
    assert( ar.getSBOTermID() ==  "SBO:0000064" )
    ast = ar.getMath()
    assert ((  "x * p3" == LibSBML::formulaToString(ast) ))
    rr = m.getRule(2)
    assert( rr != nil )
    assert( rr.getVariable() ==  "p3" )
    assert( rr.getSBOTerm() == 64 )
    assert( rr.getSBOTermID() ==  "SBO:0000064" )
    ast = rr.getMath()
    assert ((  "p1 / p" == LibSBML::formulaToString(ast) ))
    assert( m.getNumSpecies() == 1 )
    s = m.getSpecies(0)
    assert( s != nil )
    assert( s.getId() ==  "s" )
    assert( s.getSpeciesType() ==  "gg" )
    assert( s.getCompartment() ==  "a" )
    assert( s.getSBOTerm() == 236 )
    assert( s.getSBOTermID() ==  "SBO:0000236" )
    assert_equal true, s.isSetInitialAmount()
    assert_equal false, s.isSetInitialConcentration()
    assert( s.getInitialAmount() == 0 )
    assert( m.getNumReactions() == 1 )
    r = m.getReaction(0)
    assert( r != nil )
    assert( r.getId() ==  "r" )
    assert_equal false, r.getReversible()
    assert_equal true, r.getFast()
    assert_equal true, r.isSetKineticLaw()
    kl = r.getKineticLaw()
    assert( kl != nil )
    assert_equal true, kl.isSetMath()
    ast = kl.getMath()
    assert ((  "s * k / p" == LibSBML::formulaToString(ast) ))
    assert( kl.getNumParameters() == 2 )
    p = kl.getParameter(0)
    assert( p != nil )
    assert( p.getId() ==  "k" )
    assert( p.getUnits() ==  "litre" )
    assert( p.getValue() == 9 )
    ud = p.getDerivedUnitDefinition()
    assert( ud.getNumUnits() == 1 )
    assert( ud.getUnit(0).getKind() == LibSBML::UNIT_KIND_LITRE )
    assert( ud.getUnit(0).getExponent() == 1 )
    lop = kl.getListOfParameters()
    p1 = lop.get(0)
    assert( p1 == p )
    p1 = lop.get("k")
    assert( p1 == p )
    p = kl.getParameter(1)
    assert( p != nil )
    assert( p.getId() ==  "k1" )
    assert( p.getUnits() ==  "ud1" )
    assert( p.getValue() == 9 )
    ud = p.getDerivedUnitDefinition()
    assert( ud.getNumUnits() == 1 )
    assert( ud.getUnit(0).getKind() == LibSBML::UNIT_KIND_MOLE )
    assert( ud.getUnit(0).getExponent() == 1 )
    assert( r.getNumReactants() == 1 )
    assert( r.getNumProducts() == 0 )
    assert( r.getNumModifiers() == 0 )
    sr = r.getReactant(0)
    assert( sr != nil )
    assert( sr.getSpecies() ==  "s" )
    assert( sr.getSBOTerm() == 11 )
    assert( sr.getSBOTermID() ==  "SBO:0000011" )
    stoich = sr.getStoichiometryMath()
    assert( stoich != nil )
    assert( stoich.getSBOTerm() == 64 )
    assert( stoich.getSBOTermID() ==  "SBO:0000064" )
    ast = stoich.getMath()
    assert ((  "s * p" == LibSBML::formulaToString(ast) ))
    assert( m.getNumUnitDefinitions() == 1 )
    ud = m.getUnitDefinition(0)
    assert( ud != nil )
    assert( ud.getId() ==  "ud1" )
    loud = m.getListOfUnitDefinitions()
    ud1 = loud.get(0)
    assert( ud1 == ud )
    ud1 = loud.get("ud1")
    assert( ud1 == ud )
    assert( ud.getNumUnits() == 1 )
    u = ud.getUnit(0)
    assert( u != nil )
    assert( u.getKind() == LibSBML::UNIT_KIND_MOLE )
    lou = ud.getListOfUnits()
    u1 = lou.get(0)
    assert( u1 == u )
    d = nil
  end

end
