# @file    TestL3Trigger.rb
# @brief   SBML Trigger unit tests
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Sarah Keating 
#
# $Id$
# $HeadURL$
#
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestL3Trigger.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestL3Trigger < Test::Unit::TestCase

  def setup
    @@t = LibSBML::Trigger.new(3,1)
    if (@@t == nil)
    end
  end

  def teardown
    @@t = nil
  end

  def test_L3Trigger_create
    assert( @@t.getTypeCode() == LibSBML::SBML_TRIGGER )
    assert( @@t.getMetaId() == "" )
    assert( @@t.getNotes() == nil )
    assert( @@t.getAnnotation() == nil )
    assert( @@t.getMath() == nil )
    assert( @@t.getInitialValue() == true )
    assert( @@t.getPersistent() == true )
    assert( @@t.isSetInitialValue() == false )
    assert( @@t.isSetPersistent() == false )
  end

  def test_L3Trigger_setInitialValue
    i = @@t.setInitialValue(false)
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert( @@t.getInitialValue() == false )
    assert( @@t.isSetInitialValue() == true )
    i = @@t.setInitialValue(true)
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert( @@t.getInitialValue() == true )
    assert( @@t.isSetInitialValue() == true )
  end

  def test_L3Trigger_setInitialValue1
    t = LibSBML::Trigger.new(2,4)
    i = t.setInitialValue(false)
    assert( i == LibSBML::LIBSBML_UNEXPECTED_ATTRIBUTE )
    assert( @@t.getInitialValue() == true )
    assert( @@t.isSetInitialValue() == false )
    t = nil
  end

  def test_L3Trigger_setPersistent
    i = @@t.setPersistent(false)
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert( @@t.getPersistent() == false )
    assert( @@t.isSetPersistent() == true )
    i = @@t.setPersistent(true)
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert( @@t.getPersistent() == true )
    assert( @@t.isSetPersistent() == true )
  end

  def test_L3Trigger_setPersistent1
    t = LibSBML::Trigger.new(2,4)
    i = t.setPersistent(false)
    assert( i == LibSBML::LIBSBML_UNEXPECTED_ATTRIBUTE )
    assert( @@t.getPersistent() == true )
    assert( @@t.isSetPersistent() == false )
    t = nil
  end

end
