# @file    TestL3LocalParameter.rb
# @brief   L3 Local Parameter unit tests
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Sarah Keating 
#
# $Id$
# $HeadURL$
#
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestL3LocalParameter.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestL3LocalParameter < Test::Unit::TestCase

  def isnan(x)
    return (x != x)
  end
  def setup
    @@p = LibSBML::LocalParameter.new(3,1)
    if (@@p == nil)
    end
  end

  def teardown
    @@p = nil
  end

  def test_L3_LocalParameter_NS
    assert( @@p.getNamespaces() != nil )
    assert( @@p.getNamespaces().getLength() == 1 )
    assert ((     "http://www.sbml.org/sbml/level3/version1/core" == @@p.getNamespaces().getURI(0) ))
  end

  def test_L3_LocalParameter_create
    assert( @@p.getTypeCode() == LibSBML::SBML_LOCAL_PARAMETER )
    assert( @@p.getMetaId() == "" )
    assert( @@p.getNotes() == nil )
    assert( @@p.getAnnotation() == nil )
    assert( @@p.getId() == "" )
    assert( @@p.getName() == "" )
    assert( @@p.getUnits() == "" )
    assert_equal true, isnan(@@p.getValue())
    assert_equal false, @@p.isSetId()
    assert_equal false, @@p.isSetName()
    assert_equal false, @@p.isSetValue()
    assert_equal false, @@p.isSetUnits()
  end

  def test_L3_LocalParameter_createWithNS
    xmlns = LibSBML::XMLNamespaces.new()
    xmlns.add( "http://www.sbml.org", "testsbml")
    sbmlns = LibSBML::SBMLNamespaces.new(3,1)
    sbmlns.addNamespaces(xmlns)
    p = LibSBML::LocalParameter.new(sbmlns)
    assert( p.getTypeCode() == LibSBML::SBML_LOCAL_PARAMETER )
    assert( p.getMetaId() == "" )
    assert( p.getNotes() == nil )
    assert( p.getAnnotation() == nil )
    assert( p.getLevel() == 3 )
    assert( p.getVersion() == 1 )
    assert( p.getNamespaces() != nil )
    assert( p.getNamespaces().getLength() == 2 )
    assert( p.getId() == "" )
    assert( p.getName() == "" )
    assert( p.getUnits() == "" )
    assert_equal true, isnan(p.getValue())
    assert_equal false, p.isSetId()
    assert_equal false, p.isSetName()
    assert_equal false, p.isSetValue()
    assert_equal false, p.isSetUnits()
    p = nil
  end

  def test_L3_LocalParameter_free_NULL
  end

  def test_L3_LocalParameter_hasRequiredAttributes
    p = LibSBML::LocalParameter.new(3,1)
    assert_equal false, p.hasRequiredAttributes()
    p.setId( "id")
    assert_equal true, p.hasRequiredAttributes()
    p = nil
  end

  def test_L3_LocalParameter_id
    id =  "mitochondria";
    assert_equal false, @@p.isSetId()
    @@p.setId(id)
    assert (( id == @@p.getId() ))
    assert_equal true, @@p.isSetId()
    if (@@p.getId() == id)
    end
  end

  def test_L3_LocalParameter_name
    name =  "My_Favorite_Factory";
    assert_equal false, @@p.isSetName()
    @@p.setName(name)
    assert (( name == @@p.getName() ))
    assert_equal true, @@p.isSetName()
    if (@@p.getName() == name)
    end
    @@p.unsetName()
    assert_equal false, @@p.isSetName()
    if (@@p.getName() != nil)
    end
  end

  def test_L3_LocalParameter_units
    units =  "volume";
    assert_equal false, @@p.isSetUnits()
    @@p.setUnits(units)
    assert (( units == @@p.getUnits() ))
    assert_equal true, @@p.isSetUnits()
    if (@@p.getUnits() == units)
    end
    @@p.unsetUnits()
    assert_equal false, @@p.isSetUnits()
    if (@@p.getUnits() != nil)
    end
  end

  def test_L3_LocalParameter_value
    assert_equal false, @@p.isSetValue()
    assert_equal true, isnan(@@p.getValue())
    @@p.setValue(1.5)
    assert_equal true, @@p.isSetValue()
    assert( @@p.getValue() == 1.5 )
    @@p.unsetValue()
    assert_equal false, @@p.isSetValue()
    assert_equal true, isnan(@@p.getValue())
  end

end
