# -*- perl -*-
# generated by perlify.pl from libsbml/src/sbml/test/TestRDFAnnotation2.cpp
# followed by little human processing to fix syntactic specialties
# perify.pl is unable to handle right now =;) xtof
use Test::More;
BEGIN { plan tests => 43 };

use File::Spec;
use LibSBML;
use strict;
use vars qw/$TestDataDirectory $OSS2 $XOS2 $Filename $d2 $m2/;

#########################

# some global(s)
my @dataPathFrags = (File::Spec->updir(),
		     File::Spec->updir(),
		     qw/annotation test test-data/);
$TestDataDirectory = File::Spec->catdir(@dataPathFrags);
$Filename = File::Spec->catfile($TestDataDirectory, 'annotation2.xml');
ok(-e $Filename);
$OSS2 = new LibSBML::OStringStream();
$XOS2 = new LibSBML::XMLOutputStream($OSS2->get_ostream());

# The following will return a pointer to a new SBMLDocument.
my $rd = new LibSBML::SBMLReader;
my $d2 = $rd->readSBML($Filename);
my $m2 = $d2->getModel();
ok( defined $m2 );
test_RDFAnnotation2_getModelHistory();
test_RDFAnnotation2_modelWithHistoryAndCVTerms();
test_RDFAnnotation2_modelWithHistoryAndMultipleModifiedDates();

#---
sub readSBMLFromString {
 my $s = shift;
 my $rd = new LibSBML::SBMLReader;
 $rd->readSBMLFromString($s);
}

#---
sub test_RDFAnnotation2_getModelHistory {
 my $history = $m2->getModelHistory();
 ok( defined $history );
 SKIP : {
   eval '$history->getListCreators()';
   skip("ModelHistory::getListCreators() is not wrapped.",8) if $@;
   my $mc = $history->getListCreators()->get(0);
   ok( $mc->getFamilyName() eq 'Hucka' );
   ok( $mc->getGivenName() eq 'Mike' );
   ok( $mc->getEmail() eq 'mhucka@caltech.edu' );
   ok( $mc->getOrganisation() eq 'BNMC' );
   my $mc1 = $history->getListCreators()->get(1);
   ok( $mc1->getFamilyName() eq 'Keating' );
   ok( $mc1->getGivenName() eq 'Sarah' );
   ok( $mc1->getEmail() eq 'skeating@caltech.edu' );
   ok( $mc1->getOrganisation() eq 'UH' );
 }
 my $date = $history->getCreatedDate();
 ok( $date->getYear() == 2005 );
 ok( $date->getMonth() == 2 );
 ok( $date->getDay() == 2 );
 ok( $date->getHour() == 14 );
 ok( $date->getMinute() == 56 );
 ok( $date->getSecond() == 11 );
 ok( $date->getSignOffset() == 0 );
 ok( $date->getHoursOffset() == 0 );
 ok( $date->getMinutesOffset() == 0 );
 ok( $date->getDateAsString() eq '2005-02-02T14:56:11Z' );
 $date = $history->getModifiedDate();
 ok( $date->getYear() == 2006 );
 ok( $date->getMonth() == 5 );
 ok( $date->getDay() == 30 );
 ok( $date->getHour() == 10 );
 ok( $date->getMinute() == 46 );
 ok( $date->getSecond() == 2 );
 ok( $date->getSignOffset() == 0 );
 ok( $date->getHoursOffset() == 0 );
 ok( $date->getMinutesOffset() == 0 );
 ok( $date->getDateAsString() eq '2006-05-30T10:46:02Z' );
 $date = $history->getModifiedDate(1);
 ok( $date->getYear() == 2007 );
 ok( $date->getMonth() == 1 );
 ok( $date->getDay() == 16 );
 ok( $date->getHour() == 15 );
 ok( $date->getMinute() == 31 );
 ok( $date->getSecond() == 52 );
 ok( $date->getSignOffset() == 0 );
 ok( $date->getHoursOffset() == 0 );
 ok( $date->getMinutesOffset() == 0 );
 ok( $date->getDateAsString() eq '2007-01-16T15:31:52Z' );
}

#---
sub test_RDFAnnotation2_modelWithHistoryAndCVTerms {
 my $h = new LibSBML::ModelHistory();
 my $c = new LibSBML::ModelCreator();
 $c->setFamilyName('Keating');
 $c->setGivenName('Sarah');
 $h->addCreator($c);

 my $d = new LibSBML::Date(2008,11,17,18,37,0,0,0,0);
 $h->setCreatedDate($d);
 $h->setModifiedDate($d);
 $m2->unsetModelHistory();
 $m2->setModelHistory($h);
 my $cv = new LibSBML::CVTerm();
 $cv->setQualifierType($LibSBML::BIOLOGICAL_QUALIFIER);
 $cv->setBiologicalQualifierType($LibSBML::BQB_IS_VERSION_OF);
 $cv->addResource('http://www.geneontology.org/#GO:0005892');
 $m2->addCVTerm($cv);
 my $result = LibSBML::RDFAnnotationParser::parseModelHistory($m2);
 my $expected =
     "<annotation>\n"
     . "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
     . "    <rdf:Description rdf:about=\"#_000001\">\n"
     . "      <dc:creator rdf:parseType=\"Resource\">\n"
     . "        <rdf:Bag>\n"
     . "          <rdf:li rdf:parseType=\"Resource\">\n"
     . "            <vCard:N rdf:parseType=\"Resource\">\n"
     . "              <vCard:Family>Keating</vCard:Family>\n"
     . "              <vCard:Given>Sarah</vCard:Given>\n"
     . "            </vCard:N>\n"
     . "          </rdf:li>\n"
     . "        </rdf:Bag>\n"
     . "      </dc:creator>\n"
     . "      <dcterms:created rdf:parseType=\"Resource\">\n"
     . "        <dcterms:W3CDTF>2008-11-17T18:37:00Z</dcterms:W3CDTF>\n"
     . "      </dcterms:created>\n"
     . "      <dcterms:modified rdf:parseType=\"Resource\">\n"
     . "        <dcterms:W3CDTF>2008-11-17T18:37:00Z</dcterms:W3CDTF>\n"
     . "      </dcterms:modified>\n"
     . "      <bqbiol:isVersionOf>\n"
     . "        <rdf:Bag>\n"
     . "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0005892\"/>\n"
     . "        </rdf:Bag>\n"
     . "      </bqbiol:isVersionOf>\n"
     . "    </rdf:Description>\n"
     . "  </rdf:RDF>\n"
     . "</annotation>";
 ok( $expected eq $result->toXMLString() );
 $OSS2->str("");
}

#---
sub test_RDFAnnotation2_modelWithHistoryAndMultipleModifiedDates {
 my $h = new LibSBML::ModelHistory();
 my $c = new LibSBML::ModelCreator();
 $c->setFamilyName('Keating');
 $c->setGivenName('Sarah');
 $h->addCreator($c);
 my $d = new LibSBML::Date(2005, 2, 2, 14, 56, 11);
 $h->setCreatedDate($d);
 $h->addModifiedDate($d);
 $h->addModifiedDate($d);
 $m2->unsetModelHistory();
 $m2->setModelHistory($h);
 my $result = LibSBML::RDFAnnotationParser::parseModelHistory($m2);
 my $expected =
       "<annotation>\n"
     . "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n"
     . "    <rdf:Description rdf:about=\"#_000001\">\n"
     . "      <dc:creator rdf:parseType=\"Resource\">\n"
     . "        <rdf:Bag>\n"
     . "          <rdf:li rdf:parseType=\"Resource\">\n"
     . "            <vCard:N rdf:parseType=\"Resource\">\n"
     . "              <vCard:Family>Keating</vCard:Family>\n"
     . "              <vCard:Given>Sarah</vCard:Given>\n"
     . "            </vCard:N>\n"
     . "          </rdf:li>\n"
     . "        </rdf:Bag>\n"
     . "      </dc:creator>\n"
     . "      <dcterms:created rdf:parseType=\"Resource\">\n"
     . "        <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
     . "      </dcterms:created>\n"
     . "      <dcterms:modified rdf:parseType=\"Resource\">\n"
     . "        <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
     . "      </dcterms:modified>\n"
     . "      <dcterms:modified rdf:parseType=\"Resource\">\n"
     . "        <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n"
     . "      </dcterms:modified>\n"
     . "      <bqbiol:isVersionOf>\n"
     . "        <rdf:Bag>\n"
     . "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0005892\"/>\n"
     . "        </rdf:Bag>\n"
     . "      </bqbiol:isVersionOf>\n"
     . "    </rdf:Description>\n"
     . "  </rdf:RDF>\n"
     . "</annotation>";
  ok( $expected eq $result->toXMLString() );
}

