/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.0
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Unit construct.
 * <p>
 * The SBML unit definition facility uses two classes of objects,
 * {@link UnitDefinition} and {@link Unit}.  The approach to defining units in SBML is
 * compositional; for example, <em>meter second<sup> &ndash;2</sup></em> is
 * constructed by combining a {@link Unit} object representing <em>meter</em> with
 * another {@link Unit} object representing <em>second<sup> &ndash;2</sup></em>.
 * The combination is wrapped inside a {@link UnitDefinition}, which provides for
 * assigning an identifier and optional name to the combination.  The
 * identifier can then be referenced from elsewhere in a model.  Thus, the
 * {@link UnitDefinition} class is the container, and {@link Unit} instances are placed
 * inside {@link UnitDefinition} instances.
 * <p>
 * A {@link Unit} structure has four attributes named 'kind', 'exponent', 'scale'
 * and 'multiplier'.  It represents a (possibly transformed) reference to a
 * base unit.  The attribute 'kind' on {@link Unit} indicates the chosen base unit.
 * Its value must be one of the text strings listed below; this list
 * corresponds to SBML Level&nbsp;3 Version&nbsp;1 Core:
 * <p>
 * <div class='code'>
<div>
<ul style='list-style-type: none'>
<li>ampere</li>
<li>avogadro</li>
<li>becquerel</li>
<li>candela</li>
<li>coulomb</li>
<li>dimensionless</li>
</ul>
</div>
<div style='margin-left: 10em; margin-top: -8.5em'>
<ul style='list-style-type: none'>
<li>farad</li>
<li>gram</li>
<li>gray</li>
<li>henry</li>
<li>hertz</li>
<li>item</li>
</ul>
</div>
<div style='margin-left: 19em; margin-top: -8.5em'>
<ul style='list-style-type: none'>
<li>joule</li>
<li>katal</li>
<li>kelvin</li>
<li>kilogram</li>
<li>litre</li>
<li>lumen</li>
</ul>
</div>
<div style='margin-left: 28em; margin-top: -8.5em'>
<ul style='list-style-type: none'>
<li>lux</li>
<li>metre</li>
<li>mole</li>
<li>newton</li>
<li>ohm</li>
<li>pascal</li>
</ul>
</div>
<div style='margin-left: 37em; margin-top: -8.5em'>
<ul style='list-style-type: none'>
<li>radian</li>
<li>second</li>
<li>siemens</li>
<li>sievert</li>
<li>steradian</li>
<li>tesla</li>
</ul>
</div>
<div style='margin-left: 46em; margin-top: -8.5em'>
<ul style='list-style-type: none'>
<li>volt</li>
<li>watt</li>
<li>weber</li>
</ul>
</div>
</div>
<br style='clear: both'>
<p style='padding-bottom: 1em'>

 * <p>
 * This list of predefined base units is nearly identical in SBML
 * Level&nbsp;2 Version&nbsp;4, the exception being that Level&nbsp;2 does
 * not define <code>avogadro.</code>  In SBML Level&nbsp;2 Version&nbsp;1 models, the
 * string <code>Celsius</code> is also permitted.  In SBML Level&nbsp;1 models, the
 * strings <code>meter</code> and <code>liter</code> are also permitted.  In libSBML, each of
 * the predefined base unit names is represented by an enumeration value
 * whose name begins with the
 * characters <code>UNIT_KIND_</code>, discussed in a separate
 * section below.
 * <p>
 * The attribute named 'exponent' on {@link Unit} represents an exponent on the
 * unit.  In SBML Level&nbsp;2, the attribute is optional and has a default
 * value of <code>1</code> (one); in SBML Level&nbsp;3, the attribute is mandatory
 * and there is no default value.  A {@link Unit} structure also has an attribute
 * called 'scale'; its value must be an integer exponent for a power-of-ten
 * multiplier used to set the scale of the unit.  For example, a unit
 * having a 'kind' value of <code>gram</code> and a 'scale' value of <code>-3</code> signifies
 * 10<sup>&nbsp;&ndash;3</sup> &#215; gram, or milligrams.  In SBML
 * Level&nbsp;2, the attribute is optional and has a default value of <code>0</code>
 * (zero), because 10<sup> 0</sup> = 1; in SBML Level&nbsp;3, the attribute
 * is mandatory and has no default value.  Lastly, the attribute named
 * 'multiplier' can be used to multiply the unit by a real-numbered factor;
 * this enables the definition of units that are not power-of-ten multiples
 * of SI units.  For instance, a multiplier of 0.3048 could be used to
 * define <code>foot</code> as a measure of length in terms of a <code>metre.</code>  The
 * 'multiplier' attribute is optional in SBML Level&nbsp;2, where it has a
 * default value of <code>1</code> (one); in SBML Level&nbsp;3, the attribute is
 * mandatory and has not default value.
 * <p>
 * <p>
 * * <h3><a class='anchor' name='UnitKind_t'>%Unit identification codes</a></h3>
 * <p>
 * <p>
 * As discussed above, SBML defines a set of base units which serves as the
 * starting point for new unit definitions.  This set of base units
 * consists of the SI units and a small number of additional convenience
 * units.
 * <p>
 * In SBML Level&nbsp;2 Versions before
 * Version&nbsp;3, there existed an enumeration of units called 
 * <code>UnitKind.</code>  In Version&nbsp;3, this enumeration was removed and the
 * identifier class <code>UnitSId</code> redefined to include the previous 
 * <code>UnitKind</code> values as reserved symbols.  This change has no net effect on
 * permissible models, their representation or their syntax.  The purpose
 * of the change in the SBML specification was simply to clean up an
 * inconsistency about the contexts in which these values were usable.
 * However, libSBML maintains UnitKind in the form of of a set of static
 * integer constants whose names begin with the characters
 * <code>UNIT_KIND_</code>.  These constants are defined in the class
 * <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>.
 * <p>
 * <p>
 * As a consequence of the fact that libSBML supports models in all Levels
 * and Versions of SBML, libSBML's set of <code>UNIT_KIND_</code> values is a union
 * of all the possible base unit names defined in the different SBML
 * specifications.  However, not every base unit is allowed in every
 * Level+Version combination of SBML.  Note in particular the following
 * exceptions:
 * <ul>
 * <li> The alternate spelling <code>'meter'</code> is included in
 * addition to the official SI spelling <code>'metre'.</code>  This spelling is only
 * permitted in SBML Level&nbsp;1 models.
 * <p>
 * <li> The alternate spelling <code>'liter'</code> is included in addition to the
 * official SI spelling <code>'litre'.</code>  This spelling is only permitted in
 * SBML Level&nbsp;1 models.
 * <p>
 * <li> The unit <code>'Celsius'</code> is included because of its presence in
 * specifications of SBML prior to SBML Level&nbsp;2 Version&nbsp;3.
 * <p>
 * <li> The unit <code>avogadro</code> was introduced in SBML Level&nbsp;3, and
 * is only permitted for use in SBML Level&nbsp;3 models.
 * </ul>
 * <p>
 * The table below lists the unit
 * constants defined in libSBML, and their meanings. 
 * <p>
 * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr>
     <th align='left' width='200'>Enumerator</th>
     <th align='left'>Meaning</th>
 </tr>
<tr><td><code>UNIT_KIND_AMPERE</code></td><td>The ampere unit.</td></tr>
<tr><td><code>UNIT_KIND_AVOGADRO</code></td><td>The unit
<code>dimensionless</code> multiplied by the numerical value of Avogadro's
constant. (Introduced in SBML Level&nbsp;3.)</td></tr>
<tr><td><code>UNIT_KIND_BECQUEREL</code></td><td>The becquerel unit.</td></tr>
<tr><td><code>UNIT_KIND_CANDELA</code></td><td>The candela unit.</td></tr>
<tr><td><code>UNIT_KIND_CELSIUS</code></td><td>The Celsius unit.</td></tr>
<tr><td><code>UNIT_KIND_COULOMB</code></td><td>The coulomb unit.</td></tr>
<tr><td><code>UNIT_KIND_DIMENSIONLESS</code></td><td>A pseudo-unit
indicating a dimensionless quantity.</td></tr>
<tr><td><code>UNIT_KIND_FARAD</code></td><td>The farad unit.</td></tr>
<tr><td><code>UNIT_KIND_GRAM</code></td><td>The gram unit.</td></tr>
<tr><td><code>UNIT_KIND_GRAY</code></td><td>The gray unit.</td></tr>
<tr><td><code>UNIT_KIND_HENRY</code></td><td>The henry unit.</td></tr>
<tr><td><code>UNIT_KIND_HERTZ</code></td><td>The hertz unit.</td></tr>
<tr><td><code>UNIT_KIND_ITEM</code></td><td>A pseudo-unit representing a
single 'thing'.</td></tr>
<tr><td><code>UNIT_KIND_JOULE</code></td><td>The joule unit.</td></tr>
<tr><td><code>UNIT_KIND_KATAL</code></td><td>The katal unit.</td></tr>
<tr><td><code>UNIT_KIND_KELVIN</code></td><td>The kelvin unit.</td></tr>
<tr><td><code>UNIT_KIND_KILOGRAM</code></td><td>The kilogram unit.</td></tr>
<tr><td><code>UNIT_KIND_LITER</code></td><td>Alternate spelling of litre.</td></tr>
<tr><td><code>UNIT_KIND_LITRE</code></td><td>The litre unit.</td></tr>
<tr><td><code>UNIT_KIND_LUMEN</code></td><td>The lumen unit.</td></tr>
<tr><td><code>UNIT_KIND_LUX</code></td><td>The lux unit.</td></tr>
<tr><td><code>UNIT_KIND_METER</code></td><td>Alternate spelling of metre.</td></tr>
<tr><td><code>UNIT_KIND_METRE</code></td><td>The metre unit.</td></tr>
<tr><td><code>UNIT_KIND_MOLE</code></td><td>The mole unit.</td></tr>
<tr><td><code>UNIT_KIND_NEWTON</code></td><td>The newton unit.</td></tr>
<tr><td><code>UNIT_KIND_OHM</code></td><td>The ohm unit.</td></tr>
<tr><td><code>UNIT_KIND_PASCAL</code></td><td>The pascal unit.</td></tr>
<tr><td><code>UNIT_KIND_RADIAN</code></td><td>The radian unit.</td></tr>
<tr><td><code>UNIT_KIND_SECOND</code></td><td>The second unit.</td></tr>
<tr><td><code>UNIT_KIND_SIEMENS</code></td><td>The siemens unit.</td></tr>
<tr><td><code>UNIT_KIND_SIEVERT</code></td><td>The sievert unit.</td></tr>
<tr><td><code>UNIT_KIND_STERADIAN</code></td><td>The steradian unit.</td></tr>
<tr><td><code>UNIT_KIND_TESLA</code></td><td>The tesla unit.</td></tr>
<tr><td><code>UNIT_KIND_VOLT</code></td><td>The volt unit.</td></tr>
<tr><td><code>UNIT_KIND_WATT</code></td><td>The watt unit.</td></tr>
<tr><td><code>UNIT_KIND_WEBER</code></td><td>The weber unit.</td></tr>
<tr><td><code>UNIT_KIND_INVALID</code></td><td>Marker used by libSBML
to indicate an invalid or unset unit.</td></tr>
</table>
</center>

 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class Unit extends SBase {
   private long swigCPtr;

   protected Unit(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.Unit_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Unit obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Unit obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Unit(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link Unit} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Unit}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Unit}
   * <p>
   * @note Upon the addition of a {@link Unit} object to an {@link SBMLDocument}, the SBML
   * Level, SBML Version and XML namespace of the document 
   * <em>override</em> the values used when creating the {@link Unit} object via this
   * constructor.  This is necessary to ensure that an SBML document is a
   * consistent structure.  Nevertheless, the ability to supply the values
   * at the time of creation of a {@link Unit} is an important aid to producing
   * valid SBML.  Knowledge of the intented SBML Level and Version
   * determine whether it is valid to assign a particular value to an
   * attribute, or whether it is valid to add an object to an existing
   * {@link SBMLDocument}.
   */
 public Unit(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Unit__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link Unit} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Upon the addition of a {@link Unit} object to an {@link SBMLDocument}, the SBML
   * XML namespace of the document <em>overrides</em> the value used when
   * creating the {@link Unit} object via this constructor.  This is necessary to
   * ensure that an SBML document is a consistent structure.  Nevertheless,
   * the ability to supply the values at the time of creation of a {@link Unit} is
   * an important aid to producing valid SBML.  Knowledge of the intented
   * SBML Level and Version determine whether it is valid to assign a
   * particular value to an attribute, or whether it is valid to add an
   * object to an existing {@link SBMLDocument}.
   */
 public Unit(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Unit__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
  * Copy constructor; creates a copy of this {@link Unit}.
  */
 public Unit(Unit orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Unit__SWIG_2(Unit.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Unit}.
   * <p>
   * @return a (deep) copy of this {@link Unit}.
   */
 public Unit cloneObject() {
    long cPtr = libsbmlJNI.Unit_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Unit(cPtr, true);
  }

  
  /**
   * Initializes the fields of this {@link Unit} object to 'typical' default
   * values.
   * <p>
   * The SBML {@link Unit} component has slightly different aspects and default
   * attribute values in different SBML Levels and Versions.  This method
   * sets the values to certain common defaults, based mostly on what they
   * are in SBML Level&nbsp;2.  Specifically:
   * <ul>
   * <li> Sets attribute 'exponent' to <code>1</code>
   * <li> Sets attribute 'scale' to <code>0</code>
   * <li> Sets attribute 'multiplier' to <code>1.0</code>
   * </ul>
   * <p>
   * The 'kind' attribute is left unchanged.
   */
 public void initDefaults() {
    libsbmlJNI.Unit_initDefaults(swigCPtr, this);
  }

  
  /**
   * Returns the 'kind' of {@link Unit} this is.
   * <p>
   * * @return the value of the 'kind' attribute of this {@link Unit} as a
   * value from the set of constants whose names begin
   * with <code>UNIT_KIND_</code> defined in the class
   * <code><a href='libsbmlConstants.html'>libsbmlConstants</a></code>.
   * <p>
   */
 public int getKind() {
    return libsbmlJNI.Unit_getKind(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'exponent' attribute of this unit.
   * <p>
   * @return the 'exponent' value of this {@link Unit}, as an integer.
   */
 public int getExponent() {
    return libsbmlJNI.Unit_getExponent(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'exponent' attribute of this unit.
   * <p>
   * @return the 'exponent' value of this {@link Unit}, as a double.
   */
 public double getExponentAsDouble() {
    return libsbmlJNI.Unit_getExponentAsDouble(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'scale' attribute of this unit.
   * <p>
   * @return the 'scale' value of this {@link Unit}, as an integer.
   */
 public int getScale() {
    return libsbmlJNI.Unit_getScale(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'multiplier' attribute of this {@link Unit}.
   * <p>
   * @return the 'multiplier' value of this {@link Unit}, as a double.
   */
 public double getMultiplier() {
    return libsbmlJNI.Unit_getMultiplier(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'offset' attribute of this {@link Unit}.
   * <p>
   * @warning The 'offset' attribute is only available in SBML Level&nbsp;2
   * Version&nbsp;1.  This attribute is not present in SBML Level&nbsp;2
   * Version&nbsp;2 or above.  When producing SBML models using these later
   * specifications, modelers and software tools need to account for units
   * with offsets explicitly.  The SBML specification document offers a
   * number of suggestions for how to achieve this.  LibSBML methods such
   * as this one related to 'offset' are retained for compatibility with
   * earlier versions of SBML Level&nbsp;2, but their use is strongly
   * discouraged.
   * <p>
   * @return the 'offset' value of this {@link Unit}, as a double.
   */
 public double getOffset() {
    return libsbmlJNI.Unit_getOffset(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>ampere.</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>ampere</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isAmpere() {
    return libsbmlJNI.Unit_isAmpere(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>avogadro.</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>avogadro</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isAvogadro() {
    return libsbmlJNI.Unit_isAvogadro(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>becquerel</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>becquerel</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isBecquerel() {
    return libsbmlJNI.Unit_isBecquerel(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>candela</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>candela</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isCandela() {
    return libsbmlJNI.Unit_isCandela(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>Celsius</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>Celsius</code>, <code>false</code>
   * otherwise. 
   * <p>
   * @warning The predefined unit <code>Celsius</code> was removed from the list of
   * predefined units in SBML Level&nbsp;2 Version&nbsp;2 at the same time
   * that the 'offset' attribute was removed from {@link Unit} definitions.
   * LibSBML methods such as this one related to <code>Celsius</code> are retained in
   * order to support SBML Level&nbsp;2 Version&nbsp;1, but their use is
   * strongly discouraged.
   */
 public boolean isCelsius() {
    return libsbmlJNI.Unit_isCelsius(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>coulomb</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>coulomb</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isCoulomb() {
    return libsbmlJNI.Unit_isCoulomb(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind 
   * <code>dimensionless.</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>dimensionless</code>, <code>false</code>
   * <p>
   * otherwise.
   */
 public boolean isDimensionless() {
    return libsbmlJNI.Unit_isDimensionless(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>farad</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>farad</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isFarad() {
    return libsbmlJNI.Unit_isFarad(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>gram</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>gram</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isGram() {
    return libsbmlJNI.Unit_isGram(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>gray</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>gray</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isGray() {
    return libsbmlJNI.Unit_isGray(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>henry</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>henry</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isHenry() {
    return libsbmlJNI.Unit_isHenry(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>hertz</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>hertz</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isHertz() {
    return libsbmlJNI.Unit_isHertz(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>item</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>item</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isItem() {
    return libsbmlJNI.Unit_isItem(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>joule</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>joule</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isJoule() {
    return libsbmlJNI.Unit_isJoule(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>katal</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>katal</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isKatal() {
    return libsbmlJNI.Unit_isKatal(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>kelvin</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>kelvin</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isKelvin() {
    return libsbmlJNI.Unit_isKelvin(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>kilogram</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>kilogram</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isKilogram() {
    return libsbmlJNI.Unit_isKilogram(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>litre</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>litre</code> or 'liter', 
   * <code>false</code> 
   * otherwise.
   */
 public boolean isLitre() {
    return libsbmlJNI.Unit_isLitre(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>lumen</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>lumen</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isLumen() {
    return libsbmlJNI.Unit_isLumen(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>lux</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>lux</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isLux() {
    return libsbmlJNI.Unit_isLux(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>metre</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>metre</code> or 'meter', 
   * <code>false</code> 
   * otherwise.
   */
 public boolean isMetre() {
    return libsbmlJNI.Unit_isMetre(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>mole</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>mole</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isMole() {
    return libsbmlJNI.Unit_isMole(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>newton</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>newton</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isNewton() {
    return libsbmlJNI.Unit_isNewton(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>ohm</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>ohm</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isOhm() {
    return libsbmlJNI.Unit_isOhm(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>pascal</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>pascal</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isPascal() {
    return libsbmlJNI.Unit_isPascal(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>radian</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>radian</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isRadian() {
    return libsbmlJNI.Unit_isRadian(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>second</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>second</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isSecond() {
    return libsbmlJNI.Unit_isSecond(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>siemens</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>siemens</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isSiemens() {
    return libsbmlJNI.Unit_isSiemens(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>sievert</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>sievert</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isSievert() {
    return libsbmlJNI.Unit_isSievert(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>steradian</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>steradian</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isSteradian() {
    return libsbmlJNI.Unit_isSteradian(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>tesla</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>tesla</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isTesla() {
    return libsbmlJNI.Unit_isTesla(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>volt</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>volt</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isVolt() {
    return libsbmlJNI.Unit_isVolt(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>watt</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>watt</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isWatt() {
    return libsbmlJNI.Unit_isWatt(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether this {@link Unit} is of the kind <code>weber</code>
   * <p>
   * @return <code>true</code> if the kind of this {@link Unit} is <code>weber</code>, <code>false</code>
   * otherwise. 
   */
 public boolean isWeber() {
    return libsbmlJNI.Unit_isWeber(swigCPtr, this);
  }

  
  /**
   * Predicate to test whether the 'kind' attribute of this {@link Unit} has been set.
   * <p>
   * @return <code>true</code> if the 'kind' attribute of this {@link Unit} has been set, 
   * <code>false</code> otherwise.
   */
 public boolean isSetKind() {
    return libsbmlJNI.Unit_isSetKind(swigCPtr, this);
  }

  
  /**
   * Predicate to test whether the 'exponent' attribute of this {@link Unit} 
   * has been set.
   * <p>
   * @return <code>true</code> if the 'exponent' attribute of this {@link Unit} has been set, 
   * <code>false</code> otherwise.
   */
 public boolean isSetExponent() {
    return libsbmlJNI.Unit_isSetExponent(swigCPtr, this);
  }

  
  /**
   * Predicate to test whether the 'scale' attribute of this {@link Unit} 
   * has been set.
   * <p>
   * @return <code>true</code> if the 'scale' attribute of this {@link Unit} has been set, 
   * <code>false</code> otherwise.
   */
 public boolean isSetScale() {
    return libsbmlJNI.Unit_isSetScale(swigCPtr, this);
  }

  
  /**
   * Predicate to test whether the 'multiplier' attribute of this {@link Unit} 
   * has been set.
   * <p>
   * @return <code>true</code> if the 'multiplier' attribute of this {@link Unit} has been set, 
   * <code>false</code> otherwise.
   */
 public boolean isSetMultiplier() {
    return libsbmlJNI.Unit_isSetMultiplier(swigCPtr, this);
  }

  
  /**
   * Sets the 'kind' attribute value of this {@link Unit}.
   * <p>
   * * @param kind a unit identifier chosen from the set of constants whose
   * names begin with <code>UNIT_KIND_</code> in <code><a
   * href='libsbmlConstants.html'>libsbmlConstants</a></code>.
   * <p>
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   */
 public int setKind(int kind) {
    return libsbmlJNI.Unit_setKind(swigCPtr, this, kind);
  }

  
  /**
   * Sets the 'exponent' attribute value of this {@link Unit}.
   * <p>
   * @param value the integer to which the attribute 'exponent' should be set
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   */
 public int setExponent(int value) {
    return libsbmlJNI.Unit_setExponent__SWIG_0(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'exponent' attribute value of this {@link Unit}.
   * <p>
   * @param value the double to which the attribute 'exponent' should be set
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   */
 public int setExponent(double value) {
    return libsbmlJNI.Unit_setExponent__SWIG_1(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'scale' attribute value of this {@link Unit}.
   * <p>
   * @param value the integer to which the attribute 'scale' should be set
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   */
 public int setScale(int value) {
    return libsbmlJNI.Unit_setScale(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'multipler' attribute value of this {@link Unit}.
   * <p>
   * @param value the floating-point value to which the attribute
   * 'multiplier' should be set
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   */
 public int setMultiplier(double value) {
    return libsbmlJNI.Unit_setMultiplier(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'offset' attribute value of this {@link Unit}.
   * <p>
   * @param value the float-point value to which the attribute 'offset'
   * should set
   * <p>
   * @return integer value indicating success/failure of the
   * function. The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <p>
   * @warning The 'offset' attribute is only available in SBML Level&nbsp;2
   * Version&nbsp;1.  This attribute is not present in SBML Level&nbsp;2
   * Version&nbsp;2 or above.  When producing SBML models using these later
   * specifications, modelers and software tools need to account for units
   * with offsets explicitly.  The SBML specification document offers a
   * number of suggestions for how to achieve this.  LibSBML methods such
   * as this one related to 'offset' are retained for compatibility with
   * earlier versions of SBML Level&nbsp;2, but their use is strongly
   * discouraged.
   */
 public int setOffset(double value) {
    return libsbmlJNI.Unit_setOffset(swigCPtr, this, value);
  }

  
  /**
   * Returns the libSBML type code of this object instance.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in the
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_.</code> 
   * <p>
   * @return the SBML type code for this object, or {@link  libsbmlConstants#SBML_UNKNOWN SBML_UNKNOWN} (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Unit_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Unit}, is
   * always <code>'unit'.</code>
   * <p>
   * @return the name of this element, i.e., <code>'unit'.</code> 
   */
 public String getElementName() {
    return libsbmlJNI.Unit_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate to test whether a given string is the name of a
   * predefined SBML unit.
   * <p>
   * @param name a string to be tested against the predefined unit names
   * <p>
   * @param level the Level of SBML for which the determination should be
   * made.  This is necessary because there are a few small differences
   * in allowed units between SBML Level&nbsp;1 and Level&nbsp;2.
   * <p>
   * @return <code>true</code> if <code>name</code> is one of the five SBML predefined unit
   * identifiers (<code>'substance'</code>, <code>'volume'</code>, <code>'area'</code>, <code>'length'</code> or 
   * <code>'time'</code>), <code>false</code> otherwise.
   * <p>
   * @note The predefined unit identifiers <code>'length'</code> and <code>'area'</code> were
   * added in Level&nbsp;2 Version&nbsp;1
   */
 public static boolean isBuiltIn(String name, long level) {
    return libsbmlJNI.Unit_isBuiltIn(name, level);
  }

  
  /**
   * Predicate to test whether a given string is the name of a valid
   * base unit in SBML (such as <code>'gram'</code> or <code>'mole'</code>).
   * <p>
   * This method exists because prior to SBML Level&nbsp;2 Version&nbsp;3,
   * an enumeration called <code>UnitKind</code> was defined by SBML.  This enumeration
   * was removed in SBML Level&nbsp;2 Version&nbsp;3 and its values were
   * folded into the space of values of a type called <code>UnitSId.</code>  This method
   * therefore has less significance in SBML Level&nbsp;2 Version&nbsp;3
   * and Level&nbsp;2 Version&nbsp;4, but remains for backward
   * compatibility and support for reading models in older Versions of
   * Level&nbsp;2.
   * <p>
   * @param name a string to be tested
   * <p>
   * @param level a long integer representing the SBML specification
   * Level 
   * <p>
   * @param version a long integer representing the SBML specification
   * Version
   * <p>
   * @return <code>true</code> if name is a valid SBML UnitKind, <code>false</code> otherwise
   * <p>
   * @note The allowed unit names differ between SBML Levels&nbsp;1
   * and&nbsp;2 and again slightly between Level&nbsp;2 Versions&nbsp;1
   * and&nbsp;2.
   */
 public static boolean isUnitKind(String name, long level, long version) {
    return libsbmlJNI.Unit_isUnitKind(name, level, version);
  }

  
  /** 
  * Predicate returning <code>true</code> if two
  * {@link Unit} objects are identical.
  * <p>
  * Two {@link Unit} objects are considered to be <em>identical</em> if they match in
  * all attributes.  (Contrast this to the method areEquivalent(Unit u1, Unit u2), which
  * compares {@link Unit} objects only with respect to certain attributes.)
  * <p>
  * @param unit1 the first {@link Unit} object to compare
  * @param unit2 the second {@link Unit} object to compare
  * <p>
  * @return <code>true</code> if all the attributes of unit1 are identical
  * to the attributes of unit2, <code>false</code> otherwise.
  * <p>
  * @see #areEquivalent(Unit u1, Unit u2)
  */
 public static boolean areIdentical(Unit unit1, Unit unit2) {
    return libsbmlJNI.Unit_areIdentical(Unit.getCPtr(unit1), unit1, Unit.getCPtr(unit2), unit2);
  }

  
  /** 
  * Predicate returning <code>true</code> if 
  * {@link Unit} objects are equivalent.
  * <p>
  * Two {@link Unit} objects are considered to be <em>equivalent</em> either if (1) both
  * have a 'kind' attribute value of <code>dimensionless</code>, or (2) their 'kind',
  * 'exponent' and (for SBML Level&nbsp;2 Version&nbsp;1) 'offset'
  * attribute values are equal. (Contrast this to the method
  * areIdentical(Unit u1, Unit u2), which compares {@link Unit} objects with respect to all
  * attributes, not just the 'kind' and 'exponent'.)
  * <p>
  * @param unit1 the first {@link Unit} object to compare
  * @param unit2 the second {@link Unit} object to compare
  * <p>
  * @return <code>true</code> if the 'kind' and 'exponent' attributes of unit1 are
  * identical to the kind and exponent attributes of unit2, <code>false</code>
  * otherwise.
  * <p>
  * @see #areIdentical(Unit u1, Unit u2)
  */
 public static boolean areEquivalent(Unit unit1, Unit unit2) {
    return libsbmlJNI.Unit_areEquivalent(Unit.getCPtr(unit1), unit1, Unit.getCPtr(unit2), unit2);
  }

  
  /** 
  * Manipulates the attributes of the {@link Unit} to express the unit with the 
  * value of the scale attribute reduced to zero.
  * <p>
  * For example, 1 millimetre can be expressed as a {@link Unit} with kind=
  * <code>'metre'</code> multiplier=<code>'1'</code> scale=<code>'-3'</code> exponent=<code>'1'.</code> It can also be
  * expressed as a {@link Unit} with kind=<code>'metre'</code>
  * multiplier=<code>'0.001'</code> scale=<code>'0'</code> exponent=<code>'1'.</code>
  * <p>
  * @param unit the {@link Unit} object to manipulate.
  * <p>
  * @return integer value indicating success/failure of the function.  The
  * possible values returned by this function are:
  * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
  * <p>
  * @see #convertToSI(Unit u)
  * @see #merge(Unit u1, Unit u2)
  */
 public static int removeScale(Unit unit) {
    return libsbmlJNI.Unit_removeScale(Unit.getCPtr(unit), unit);
  }

  
  /** 
  * Merges two {@link Unit} objects with the same 'kind' attribute value into a
  * single {@link Unit}.
  * <p>
  * For example, the following,
  * <div class='fragment'><pre>
  * &lt;unit kind='metre' exponent='2'/&gt;
  * &lt;unit kind='metre' exponent='1'/&gt;</pre></div>
  * would be merged to become
  * <div class='fragment'><pre>
  * &lt;unit kind='metre' exponent='3'/&gt;</pre></div>
  * <p>
  * @param unit1 the first {@link Unit} object; the result of the operation is
  * left as a new version of this unit, modified in-place.
  * <p>
  * @param unit2 the second {@link Unit} object to merge with the first
  * <p>
  * @see #convertToSI(Unit u)
  * @see #removeScale(Unit u)
  */
 public static void merge(Unit unit1, Unit unit2) {
    libsbmlJNI.Unit_merge(Unit.getCPtr(unit1), unit1, Unit.getCPtr(unit2), unit2);
  }

  
  /**
  * Returns a {@link UnitDefinition} object containing the given <code>unit</code> converted
  * to the appropriate SI unit.
  * <p>
  * This method exists because some units can be expressed in terms of
  * others when the same physical dimension is involved.  For example, one
  * hertz is identical to 1&nbsp;sec<sup>-1</sup>, one litre is equivalent
  * to 1 cubic decametre, and so on.
  * <p>
  * @param unit the {@link Unit} object to convert to SI
  * <p>
  * @return a {@link UnitDefinition} object containing the SI unit.
  * <p>
  * @see #merge(Unit u1, Unit u2)
  */
 public static UnitDefinition convertToSI(Unit unit) {
    long cPtr = libsbmlJNI.Unit_convertToSI(Unit.getCPtr(unit), unit);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, true);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * all the required attributes for this {@link Unit} object
   * have been set.
   * <p>
   * @note The required attributes for a {@link Unit} object are:
   * <li> 'kind'
   * <li> 'exponent' (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
   * <li> 'multiplier' (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
   * <li> 'scale' (required in SBML Level&nbsp;3; optional in Level&nbsp;2)
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.Unit_hasRequiredAttributes(swigCPtr, this);
  }

}
