/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.0
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Priority construct for Event.
 * <p>
 * An {@link Event} object defines when the event can occur, the variables that
 * are affected by the event, and how the variables are affected.  The
 * effect of the event can optionally be delayed after the occurrence of
 * the condition which invokes it.  The priority assigned to an event 
 * is defined using an
 * object of class Priority.
 * <p>
 * The object class Priority is derived from {@link SBase} and adds a single
 * subelement called 'math'.  This subelement is used to hold MathML
 * content.  The mathematical formula represented by 'math' must evaluate
 * to a numerical value.  
 * <p>
 */

public class Priority extends SBase {
   private long swigCPtr;

   protected Priority(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.Priority_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Priority obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Priority obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Priority(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new Priority using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this Priority
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * Priority
   * <p>
   * @note Upon the addition of a Priority object to an {@link Event} (e.g., using
   * {@link Event#setPriority(Priority d)}), the SBML Level, SBML Version
   * and XML namespace of the document <em>override</em> the values used when
   * creating the Priority object via this constructor.  This is necessary to
   * ensure that an SBML document is a consistent structure.  Nevertheless,
   * the ability to supply the values at the time of creation of a Priority is
   * an important aid to producing valid SBML.  Knowledge of the intented
   * SBML Level and Version determine whether it is valid to assign a
   * particular value to an attribute, or whether it is valid to add a
   * particular Priority object to an existing {@link Event}.
   */
 public Priority(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Priority__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new Priority using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Upon the addition of a Priority object to an {@link Event} (e.g., using
   * {@link Event#setPriority(Priority d)}), the SBML XML namespace of
   * the document <em>overrides</em> the value used when creating the Priority
   * object via this constructor.  This is necessary to ensure that an SBML
   * document is a consistent structure.  Nevertheless, the ability to
   * supply the values at the time of creation of a Priority is an important
   * aid to producing valid SBML.  Knowledge of the intented SBML Level and
   * Version determine whether it is valid to assign a particular value to
   * an attribute, or whether it is valid to add a particular Priority object
   * to an existing {@link Event}.
   */
 public Priority(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Priority__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Copy constructor; creates a copy of this Priority.
   */
 public Priority(Priority orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Priority__SWIG_2(Priority.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this Priority.
   * <p>
   * @return a (deep) copy of this Priority.
   */
 public Priority cloneObject() {
    long cPtr = libsbmlJNI.Priority_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Priority(cPtr, true);
  }

  
  /**
   * Get the mathematical formula for the priority and return it
   * as an AST.
   * <p>
   * @return the math of this Priority.
   */
 public ASTNode getMath() {
    long cPtr = libsbmlJNI.Priority_getMath(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Predicate to test whether the formula for this delay has been set.
   * <p>
   * @return <code>true</code> if the formula (meaning the <code>math</code> subelement) of
   * this Priority has been set, <code>false</code> otherwise.
   */
 public boolean isSetMath() {
    return libsbmlJNI.Priority_isSetMath(swigCPtr, this);
  }

  
  /**
   * Sets the math expression of this Priority instance to a copy of the given
   * {@link ASTNode}.
   * <p>
   * @param math an {@link ASTNode} representing a formula tree.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT }
   */
 public int setMath(ASTNode math) {
    return libsbmlJNI.Priority_setMath(swigCPtr, this, ASTNode.getCPtr(math), math);
  }

  
  /**
   * Returns the libSBML type code of this object instance.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in the
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_.</code> 
   * <p>
   * @return the SBML type code for this object, or {@link  libsbmlConstants#SBML_UNKNOWN SBML_UNKNOWN} (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Priority_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for Priority, is
   * always <code>'priority'.</code>
   * <p>
   * @return the name of this element, i.e., <code>'priority'.</code>
   * <p>
   * @see #getTypeCode()
   */
 public String getElementName() {
    return libsbmlJNI.Priority_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * all the required elements for this Priority object
   * have been set.
   * <p>
   * @note The required elements for a Priority object are:
   * math
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */
 public boolean hasRequiredElements() {
    return libsbmlJNI.Priority_hasRequiredElements(swigCPtr, this);
  }

}
