/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Representation of MIRIAM-compliant model creator data used
 * in {@link ModelHistory}. 
 * <p>
 * <em style='color: #555'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</em>

 * <p>
 * The SBML specification beginning with Level 2 Version 2 defines a
 * standard approach to recording model history and model creator
 * information in a form that complies with MIRIAM ('Minimum Information
 * Requested in the Annotation of biochemical Models', <i>Nature
 * Biotechnology</i>, vol. 23, no. 12, Dec. 2005).  LibSBML provides the
 * {@link ModelCreator} class as a convenience high-level interface for working
 * with model creator data.
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class ModelCreator {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected ModelCreator(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(ModelCreator obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (ModelCreator obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_ModelCreator(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for ModelCreator.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((ModelCreator)(sb));
  }

  /**
   * Returns a hashcode for this ModelCreator object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
  /**
   * Creates a new {@link ModelCreator}.
   */
 public ModelCreator() {
    this(libsbmlJNI.new_ModelCreator__SWIG_0(), true);
  }

  
  /**
   * Creates a new {@link ModelCreator} from an {@link XMLNode}.
   * <p>
   * @param creator the {@link XMLNode} from which to create the {@link ModelCreator}.
   */
 public ModelCreator(XMLNode creator) {
    this(libsbmlJNI.new_ModelCreator__SWIG_1(XMLNode.getCPtr(creator), creator), true);
  }

  
  /**
   * Copy constructor; creates a copy of the {@link ModelCreator}.
   */
 public ModelCreator(ModelCreator orig) {
    this(libsbmlJNI.new_ModelCreator__SWIG_2(ModelCreator.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a copy of this {@link ModelCreator}.
   * <p>
   * @return a (deep) copy of this {@link ModelCreator}.
   */
 public ModelCreator cloneObject() {
    long cPtr = libsbmlJNI.ModelCreator_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new ModelCreator(cPtr, true);
  }

  
  /**
   * Returns the familyName from the {@link ModelCreator}.
   * <p>
   * @return familyName from the {@link ModelCreator}.
   */
 public String getFamilyName() {
    return libsbmlJNI.ModelCreator_getFamilyName(swigCPtr, this);
  }

  
  /**
   * Returns the givenName from the {@link ModelCreator}.
   * <p>
   * @return givenName from the {@link ModelCreator}.
   */
 public String getGivenName() {
    return libsbmlJNI.ModelCreator_getGivenName(swigCPtr, this);
  }

  
  /**
   * Returns the email from the {@link ModelCreator}.
   * <p>
   * @return email from the {@link ModelCreator}.
   */
 public String getEmail() {
    return libsbmlJNI.ModelCreator_getEmail(swigCPtr, this);
  }

  
  /**
   * Returns the organization from the {@link ModelCreator}.
   * <p>
   * @return organization from the {@link ModelCreator}.
   */
 public String getOrganization() {
    return libsbmlJNI.ModelCreator_getOrganization(swigCPtr, this);
  }

  
  /**
   * Returns the organization from the {@link ModelCreator}.
   * <p>
   * @note This function is an alias of getOrganization().
   * <p>
   * @return organization from the {@link ModelCreator}.
   * <p>
   * @see #getOrganization()
   */
 public String getOrganisation() {
    return libsbmlJNI.ModelCreator_getOrganisation(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link ModelCreator}'s familyName has been set.
   * <p>
   * @return <code>true</code> if the familyName of this {@link ModelCreator} has been set, <code>false</code> otherwise.
   */
 public boolean isSetFamilyName() {
    return libsbmlJNI.ModelCreator_isSetFamilyName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link ModelCreator}'s givenName has been set.
   * <p>
   * @return <code>true</code> if the givenName of this {@link ModelCreator} has been set, <code>false</code> otherwise.
   */
 public boolean isSetGivenName() {
    return libsbmlJNI.ModelCreator_isSetGivenName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link ModelCreator}'s email has been set.
   * <p>
   * @return <code>true</code> if the email of this {@link ModelCreator} has been set, <code>false</code> otherwise.
   */
 public boolean isSetEmail() {
    return libsbmlJNI.ModelCreator_isSetEmail(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link ModelCreator}'s organization has been set.
   * <p>
   * @return <code>true</code> if the organization of this {@link ModelCreator} has been set, <code>false</code> otherwise.
   */
 public boolean isSetOrganization() {
    return libsbmlJNI.ModelCreator_isSetOrganization(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link ModelCreator}'s organization has been set.
   * <p>
   * @note This function is an alias of isSetOrganization().
   * <p>
   * @return <code>true</code> if the organization of this {@link ModelCreator} has been set, <code>false</code> otherwise.
   * <p>
   * @see #isSetOrganization()
   */
 public boolean isSetOrganisation() {
    return libsbmlJNI.ModelCreator_isSetOrganisation(swigCPtr, this);
  }

  
  /**
   * Sets the family name
   * <p>
   * @param familyName a string representing the familyName of the {@link ModelCreator}. 
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   */
 public int setFamilyName(String familyName) {
    return libsbmlJNI.ModelCreator_setFamilyName(swigCPtr, this, familyName);
  }

  
  /**
   * Sets the given name
   * <p>
   * @param givenName a string representing the givenName of the {@link ModelCreator}. 
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   */
 public int setGivenName(String givenName) {
    return libsbmlJNI.ModelCreator_setGivenName(swigCPtr, this, givenName);
  }

  
  /**
   * Sets the email
   * <p>
   * @param email a string representing the email of the {@link ModelCreator}. 
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   */
 public int setEmail(String email) {
    return libsbmlJNI.ModelCreator_setEmail(swigCPtr, this, email);
  }

  
  /**
   * Sets the organization
   * <p>
   * @param organization a string representing the organization of the 
   * {@link ModelCreator}. 
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   */
 public int setOrganization(String organization) {
    return libsbmlJNI.ModelCreator_setOrganization(swigCPtr, this, organization);
  }

  
  /**
   * Sets the organization
   * <p>
   * @param organization a string representing the organization of the
   * {@link ModelCreator}.
   * <p>
   * @note This function is an alias of setOrganization(String organization).
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <p>
   * @see #setOrganization(String organization)
   */
 public int setOrganisation(String organization) {
    return libsbmlJNI.ModelCreator_setOrganisation(swigCPtr, this, organization);
  }

  
  /**
   * Unsets the familyName of this {@link ModelCreator}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   */
 public int unsetFamilyName() {
    return libsbmlJNI.ModelCreator_unsetFamilyName(swigCPtr, this);
  }

  
  /**
   * Unsets the givenName of this {@link ModelCreator}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   */
 public int unsetGivenName() {
    return libsbmlJNI.ModelCreator_unsetGivenName(swigCPtr, this);
  }

  
  /**
   * Unsets the email of this {@link ModelCreator}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   */
 public int unsetEmail() {
    return libsbmlJNI.ModelCreator_unsetEmail(swigCPtr, this);
  }

  
  /**
   * Unsets the organization of this {@link ModelCreator}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   */
 public int unsetOrganization() {
    return libsbmlJNI.ModelCreator_unsetOrganization(swigCPtr, this);
  }

  
  /**
   * Unsets the organization of this {@link ModelCreator}.
   * <p>
   * @note This function is an alias of unsetOrganization().
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @see #unsetOrganization()
   */
 public int unsetOrganisation() {
    return libsbmlJNI.ModelCreator_unsetOrganisation(swigCPtr, this);
  }

  
  /**
   * Unsets the organization of this {@link ModelCreator}.
   * <p>
   * @note This function is an alias of unsetOrganization().
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @see #unsetOrganization()
   <p>
 * @deprecated libSBML internal
 */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.ModelCreator_hasRequiredAttributes(swigCPtr, this);
  }

}
