/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Event construct.
 * <p>
 * An {@link Event} object defines when the event can occur, the variables that are
 * affected by the event, and how the variables are affected.
 * <p>
 * An {@link Event} definition has several parts: an optional identifier (defined
 * by the attribute 'id'), an optional name (defined by the attribute
 * 'name'), a required trigger condition (defined by an object of class
 * {@link Trigger}), and at least one {@link EventAssignment}.  In addition, an event can
 * include an optional delay (defined by an object of class {@link Delay}).
 * <p>
 * The operation of {@link Event} is divided into two phases (even when the event
 * is not delayed): one when the event is <em>fired</em>, and the other when the
 * event is <em>executed</em>.  {@link Trigger} objects define the conditions for firing
 * an event, {@link Delay} objects define when the event is actually executed, and
 * {@link EventAssignment} objects define the effects of executing the event.
 * Please consult the descriptions of {@link Trigger}, {@link Delay} and {@link EventAssignment}
 * for more information.
 * <p>
 * The optional {@link Delay} on {@link Event} means there are two times to consider when
 * computing the results of an event: the time at which the event
 * <em>fires</em>, and the time at which assignments are <em>executed</em>.
 * It is also possible to distinguish between the time at which the
 * {@link EventAssignment}'s expression is calculated, and the time at which the
 * assignment is made: the expression could be evaluated at the same time
 * the assignments are performed, i.e., when the event is
 * <em>executed</em>, but it could also be defined to be evaluated at the
 * time the event <em>fired</em>.
 * <p>
 * In SBML Level&nbsp;2 versions before Version&nbsp;4, the semantics of
 * {@link Event} time delays were defined such that the expressions in the event's
 * assignments were always evaluated at the time the event was
 * <em>fired</em>.  This definition made it difficult to define an event
 * whose assignment formulas were meant to be evaluated at the time the
 * event was <em>executed</em> (i.e., after the time period defined by the
 * value of the {@link Delay} element).  In SBML Level&nbsp;2 Version&nbsp;4 and in
 * Level&nbsp;3, the attribute 'useValuesFromTriggerTime' on {@link Event} allows a
 * model to indicate the time at which the event's assignments are intended
 * the values of the assignment formulas are computed at the moment the
 * event fired, not after the delay.  If 'useValuesFromTriggerTime'=
 * <code>false</code>, it means that the formulas in the event's assignments are to be
 * computed <em>after</em> the delay, at the time the event is executed.
 * <p>
 * <h2>SBML version differences</h2>
 * <p>
 * The definition of {@link Event} in SBML Level&nbsp;2 Versions 1 and 2 includes
 * an additional attribute called 'timeUnits', which allowed the time units
 * of the {@link Delay} to be set explicitly.  Later Versions of SBML Level&nbsp;2
 * as well as SBML Level&nbsp;3 do not define this attribute.  LibSBML
 * supports this attribute for compatibility with previous versions of SBML
 * Level&nbsp;2; however, if a model in SBML Level&nbsp;3 or Level&nbsp;2
 * Versions&nbsp;3&ndash;4 format sets the attribute, the
 * consistency-checking method SBMLDocument.checkConsistency() will report
 * an error.
 * <p>
 * The attribute 'useValuesFromTriggerTime' was introduced in SBML
 * Level&nbsp;2 Version&nbsp;4.  Models defined in prior Versions of SBML
 * Level&nbsp;2 cannot use this attribute, and
 * SBMLDocument.checkConsistency() will report an error if they do.
 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class Event extends SBase {
   private long swigCPtr;

   protected Event(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGEventUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Event obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Event obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Event(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link Event} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Event}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Event}
   * <p>
   * @note Upon the addition of an {@link Event} object to an {@link SBMLDocument} (e.g.,
   * using Model.addEvent()), the SBML Level, SBML Version and XML
   * namespace of the document <em>override</em> the values used when creating
   * the {@link Event} object via this constructor.  This is necessary to ensure
   * that an SBML document is a consistent structure.  Nevertheless, the
   * ability to supply the values at the time of creation of an {@link Event} is an
   * important aid to producing valid SBML.  Knowledge of the intented SBML
   * Level and Version determine whether it is valid to assign a particular
   * value to an attribute, or whether it is valid to add an object to an
   * existing {@link SBMLDocument}.
   */
 public Event(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Event__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link Event} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Upon the addition of an {@link Event} object to an {@link SBMLDocument} (e.g.,
   * using Model.addEvent()), the SBML XML namespace of the document 
   * <em>overrides</em> the value used when creating the {@link Event} object via this
   * constructor.  This is necessary to ensure that an SBML document is a
   * consistent structure.  Nevertheless, the ability to supply the values
   * at the time of creation of a {@link Event} is an important aid to producing
   * valid SBML.  Knowledge of the intented SBML Level and Version
   * determine whether it is valid to assign a particular value to an
   * attribute, or whether it is valid to add an object to an existing
   * {@link SBMLDocument}.
   */
 public Event(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Event__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link Event}.
   */
 public Event(Event orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Event__SWIG_2(Event.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Event}.
   * <p>
   * @return a (deep) copy of this {@link Event}.
   */
 public Event cloneObject() {
    long cPtr = libsbmlJNI.Event_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Event(cPtr, true);
  }

  
  /**
   * Returns the value of the 'id' attribute of this {@link Event}.
   * <p>
   * @return the id of this {@link Event}.
   */
 public String getId() {
    return libsbmlJNI.Event_getId(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'name' attribute of this {@link Event}.
   * <p>
   * @return the name of this {@link Event}.
   */
 public String getName() {
    return libsbmlJNI.Event_getName(swigCPtr, this);
  }

  
  /**
   * Get the event trigger portion of this {@link Event}.
   * <p>
   * @return the {@link Trigger} object of this {@link Event}.
   */
 public Trigger getTrigger() {
    long cPtr = libsbmlJNI.Event_getTrigger__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Trigger(cPtr, false);
  }

  
  /**
   * Get the assignment delay portion of this {@link Event}, if there is one.
   * <p>
   * @return the delay of this {@link Event} if one is defined, or <code>NULL</code> if none
   * is defined.
   */
 public Delay getDelay() {
    long cPtr = libsbmlJNI.Event_getDelay__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Delay(cPtr, false);
  }

  
  /**
   * Get the value of the 'timeUnits' attribute of this {@link Event}, if it has one.
   * <p>
   * @return the value of the attribute 'timeUnits' as a string.
   * <p>
   * @warning Definitions of {@link Event} in SBML Level 2 Versions&nbsp;1
   * and&nbsp;2 included the additional attribute called 'timeUnits', but
   * it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
   * this attribute for compatibility with previous versions of SBML
   * Level&nbsp;2, but its use is discouraged since models in Level 2
   * Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
   * or&nbsp;4 model sets the attribute, the consistency-checking method
   * SBMLDocument.checkConsistency() will report an error.
   */
 public String getTimeUnits() {
    return libsbmlJNI.Event_getTimeUnits(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'useValuesFromTriggerTime' attribute of this {@link Event}.
   * <p>
   * The optional {@link Delay} on {@link Event} means there are two times to consider when
   * computing the results of an event: the time at which the event
   * <em>fires</em>, and the time at which assignments are <em>executed</em>.
   * It is also possible to distinguish between the time at which the
   * {@link EventAssignment}'s expression is calculated, and the time at which the
   * assignment is made: the expression could be evaluated at the same time
   * the assignments are performed, i.e., when the event is
   * <em>executed</em>, but it could also be defined to be evaluated at the
   * time the event <em>fired</em>.
   * <p>
   * In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics of
   * {@link Event} time delays were defined such that the expressions in the event's
   * assignments were always evaluated at the time the event was
   * <em>fired</em>.  This definition made it difficult to define an event
   * whose assignment formulas were meant to be evaluated at the time the
   * event was <em>executed</em> (i.e., after the time period defined by the
   * value of the {@link Delay} element).  In SBML Level&nbsp;2 Version&nbsp;4, the
   * attribute 'useValuesFromTriggerTime' on {@link Event} allows a model to indicate
   * the time at which the event's assignments are intended to be evaluated.
   * The default value is <code>true</code>, which corresponds to the interpretation of
   * event assignments prior to Version&nbsp;4: the values of the assignment
   * formulas are computed at the moment the event fired, not after the
   * delay.  If 'useValuesFromTriggerTime'=<code>false</code>, it means that the
   * formulas in the event's assignments are to be computed after the delay,
   * at the time the event is executed.
   * <p>
   * @return the value of the attribute 'useValuesFromTriggerTime' as a boolean.
   * <p>
   * @warning The attribute 'useValuesFromTriggerTime' was introduced in
   * SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in models defined
   * using SBML Level&nbsp;2 versions prior to Version&nbsp;4.  If a
   * Version&nbsp;1&ndash;&nbsp;3 model sets the attribute, the
   * consistency-checking method SBMLDocument.checkConsistency() will
   * report an error.
   */
 public boolean getUseValuesFromTriggerTime() {
    return libsbmlJNI.Event_getUseValuesFromTriggerTime(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Event}'s 'id' attribute has been set.
   * <p>
   * @return <code>true</code> if the 'id' attribute of this {@link Event} has been
   * set, <code>false</code> otherwise.
   */
 public boolean isSetId() {
    return libsbmlJNI.Event_isSetId(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if this
   * {@link Event}'s 'name' attribute has been set.
   * <p>
   * @return <code>true</code> if the 'name' attribute of this {@link Event} has been
   * set, <code>false</code> otherwise.
   */
 public boolean isSetName() {
    return libsbmlJNI.Event_isSetName(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether the trigger for this {@link Event} has been set.
   * <p>
   * @return <code>true</code> if the trigger of this {@link Event} has been set, <code>false</code>
   * otherwise.
   */
 public boolean isSetTrigger() {
    return libsbmlJNI.Event_isSetTrigger(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether the delay for this {@link Event} has been set.
   * <p>
   * @return <code>true</code> if the delay of this {@link Event} has been set, <code>false</code>
   * otherwise.
   */
 public boolean isSetDelay() {
    return libsbmlJNI.Event_isSetDelay(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether the 'timeUnits' attribute of this {@link Event}
   * has been set.
   * <p>
   * @return <code>true</code> if the 'timeUnits' attribute of this {@link Event} has been
   * set, <code>false</code> otherwise.
   * <p>
   * @warning Definitions of {@link Event} in SBML Level 2 Versions&nbsp;1
   * and&nbsp;2 included the additional attribute called 'timeUnits', but
   * it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
   * this attribute for compatibility with previous versions of SBML
   * Level&nbsp;2, but its use is discouraged since models in Level 2
   * Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
   * or&nbsp;4 model sets the attribute, the consistency-checking method
   * SBMLDocument.checkConsistency() will report an error.
   */
 public boolean isSetTimeUnits() {
    return libsbmlJNI.Event_isSetTimeUnits(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether the 'useValuesFromTriggerTime' attribute of this {@link Event}
   * has been set.
   * <p>
   * @return <code>true</code> if the 'useValuesFromTriggerTime' attribute of this {@link Event} has been
   * set, <code>false</code> otherwise.
   * <p>
   * @warning Definitions of {@link Event} in SBML Level 2 Versions&nbsp;1
   * and&nbsp;2 included the additional attribute called 'timeUnits', but
   * it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
   * this attribute for compatibility with previous versions of SBML
   * Level&nbsp;2, but its use is discouraged since models in Level 2
   * Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
   * or&nbsp;4 model sets the attribute, the consistency-checking method
   * SBMLDocument.checkConsistency() will report an error.
   */
 public boolean isSetUseValuesFromTriggerTime() {
    return libsbmlJNI.Event_isSetUseValuesFromTriggerTime(swigCPtr, this);
  }

  
  /**
   * Sets the value of the 'id' attribute of this {@link Event}.
   * <p>
   * The string <code>sid</code> is copied.  Note that SBML has strict requirements
   * for the syntax of identifiers.  The following is a summary of the definition of the SBML identifier type 
<code>SId</code>, which defines the permitted syntax of identifiers.  We
express the syntax using an extended form of BNF notation: 
<p>
<code style='margin-left: 2em'>letter .= 'a'..'z','A'..'Z'</code><br>
<code style='margin-left: 2em'>digit  .= '0'..'9'</code><br>
<code style='margin-left: 2em'>idChar .= letter | digit | '_'</code><br>
<code style='margin-left: 2em'>SId    .= ( letter | '_' ) idChar*</code><br>
<p>
The characters <code>(</code> and <code>)</code> are used for grouping, the
character <code>*</code> 'zero or more times', and the character
<code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
determined by an exact character sequence match; i.e., comparisons must be
performed in a case-sensitive manner.  In addition, there are a few
conditions for the uniqueness of identifiers in an SBML model.  Please
consult the SBML specifications for the exact formulations.
<p>

   * <p>
   * @param sid the string to use as the identifier of this {@link Event}
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   */
 public int setId(String sid) {
    return libsbmlJNI.Event_setId(swigCPtr, this, sid);
  }

  
  /**
   * Sets the value of the 'name' attribute of this {@link Event}.
   * <p>
   * The string in <code>name</code> is copied.
   * <p>
   * @param name the new name for the {@link Event}
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   */
 public int setName(String name) {
    return libsbmlJNI.Event_setName(swigCPtr, this, name);
  }

  
  /**
   * Sets the trigger definition of this {@link Event} to a copy of the given
   * {@link Trigger} object instance.
   * <p>
   * @param trigger the {@link Trigger} object instance to use.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH }
   */
 public int setTrigger(Trigger trigger) {
    return libsbmlJNI.Event_setTrigger(swigCPtr, this, Trigger.getCPtr(trigger), trigger);
  }

  
  /**
   * Sets the delay definition of this {@link Event} to a copy of the given {@link Delay}
   * object instance.
   * <p>
   * @param delay the {@link Delay} object instance to use
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH }
   */
 public int setDelay(Delay delay) {
    return libsbmlJNI.Event_setDelay(swigCPtr, this, Delay.getCPtr(delay), delay);
  }

  
  /**
   * Sets the 'timeUnits' attribute of this {@link Event} to a copy of <code>sid</code>.
   * <p>
   * @param sid the identifier of the time units to use.
   * <p>
   * @warning Definitions of {@link Event} in SBML Level 2 Versions&nbsp;1
   * and&nbsp;2 included the additional attribute called 'timeUnits', but
   * it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
   * this attribute for compatibility with previous versions of SBML
   * Level&nbsp;2, but its use is discouraged since models in Level 2
   * Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
   * or&nbsp;4 model sets the attribute, the consistency-checking method
   * SBMLDocument.checkConsistency() will report an error.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   */
 public int setTimeUnits(String sid) {
    return libsbmlJNI.Event_setTimeUnits(swigCPtr, this, sid);
  }

  
  /**
   * Sets the 'useValuesFromTriggerTime' attribute of this {@link Event} to a <code>value</code>.
   * <p>
   * The optional {@link Delay} on {@link Event} means there are two times to consider when
   * computing the results of an event: the time at which the event
   * <em>fires</em>, and the time at which assignments are <em>executed</em>.
   * It is also possible to distinguish between the time at which the
   * {@link EventAssignment}'s expression is calculated, and the time at which the
   * assignment is made: the expression could be evaluated at the same time
   * the assignments are performed, i.e., when the event is
   * <em>executed</em>, but it could also be defined to be evaluated at the
   * time the event <em>fired</em>.
   * <p>
   * In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics of
   * {@link Event} time delays were defined such that the expressions in the event's
   * assignments were always evaluated at the time the event was
   * <em>fired</em>.  This definition made it difficult to define an event
   * whose assignment formulas were meant to be evaluated at the time the
   * event was <em>executed</em> (i.e., after the time period defined by the
   * value of the {@link Delay} element).  In SBML Level&nbsp;2 Version&nbsp;4, the
   * attribute 'useValuesFromTriggerTime' on {@link Event} allows a model to indicate
   * the time at which the event's assignments are intended to be evaluated.
   * The default value is <code>true</code>, which corresponds to the interpretation of
   * event assignments prior to Version&nbsp;4: the values of the assignment
   * formulas are computed at the moment the event fired, not after the
   * delay.  If 'useValuesFromTriggerTime'=<code>false</code>, it means that the
   * formulas in the event's assignments are to be computed after the delay,
   * at the time the event is executed.
   * <p>
   * @param value the value of useValuesFromTriggerTime to use.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <p>
   * @warning The attribute 'useValuesFromTriggerTime' was introduced in
   * SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in models defined
   * using SBML Level&nbsp;2 versions prior to Version&nbsp;4.  If a
   * Version&nbsp;1&ndash;&nbsp;3 model sets the attribute, the
   * consistency-checking method SBMLDocument.checkConsistency() will
   * report an error.
   */
 public int setUseValuesFromTriggerTime(boolean value) {
    return libsbmlJNI.Event_setUseValuesFromTriggerTime(swigCPtr, this, value);
  }

  
  /**
   * Unsets the value of the 'id' attribute of this {@link Event}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   */
 public int unsetId() {
    return libsbmlJNI.Event_unsetId(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'name' attribute of this {@link Event}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   */
 public int unsetName() {
    return libsbmlJNI.Event_unsetName(swigCPtr, this);
  }

  
  /**
   * Unsets the {@link Delay} of this {@link Event}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   */
 public int unsetDelay() {
    return libsbmlJNI.Event_unsetDelay(swigCPtr, this);
  }

  
  /**
   * Unsets the 'timeUnits' attribute of this {@link Event}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @warning Definitions of {@link Event} in SBML Level&nbsp;2 Versions 1 and 2
   * included the attribute called 'timeUnits', but it was removed in SBML
   * Level&nbsp;2 Version&nbsp;3.  LibSBML supports this attribute for
   * compatibility with previous versions of SBML Level&nbsp;2, but its use
   * is discouraged since models in Level&nbsp;2 Version&nbsp;3 and
   * Version&nbsp;4 cannot contain it.  If a Version&nbsp;3 or&nbsp;4 model
   * sets this attribute, the consistency-checking method
   * SBMLDocument.checkConsistency() will report an error.
   */
 public int unsetTimeUnits() {
    return libsbmlJNI.Event_unsetTimeUnits(swigCPtr, this);
  }

  
  /**
   * Appends a copy of the given {@link EventAssignment} to this {@link Event}.
   * <p>
   * @param ea the {@link EventAssignment} object to add.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Event}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Event}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see Event.createEventAssignment()
   * for a method that does not lead to these issues.
   * <p>
   * @see #createEventAssignment()
   */
 public int addEventAssignment(EventAssignment ea) {
    return libsbmlJNI.Event_addEventAssignment(swigCPtr, this, EventAssignment.getCPtr(ea), ea);
  }

  
  /**
   * Creates a new, empty {@link EventAssignment}, adds it to this {@link Event}'s list of
   * event assignments and returns the {@link EventAssignment}.
   * <p>
   * @return the newly created {@link EventAssignment} object instance
   * <p>
   * @see #addEventAssignment(EventAssignment  ea)
   */
 public EventAssignment createEventAssignment() {
    long cPtr = libsbmlJNI.Event_createEventAssignment(swigCPtr, this);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, false);
  }

  
  /**
   * Creates a new, empty {@link Trigger}, adds it to this {@link Event} and 
   * returns the {@link Trigger}.
   * <p>
   * @return the newly created {@link Trigger} object instance
   */
 public Trigger createTrigger() {
    long cPtr = libsbmlJNI.Event_createTrigger(swigCPtr, this);
    return (cPtr == 0) ? null : new Trigger(cPtr, false);
  }

  
  /**
   * Creates a new, empty {@link Delay}, adds it to this {@link Event} and 
   * returns the {@link Delay}.
   * <p>
   * @return the newly created {@link Delay} object instance
   */
 public Delay createDelay() {
    long cPtr = libsbmlJNI.Event_createDelay(swigCPtr, this);
    return (cPtr == 0) ? null : new Delay(cPtr, false);
  }

  
  /**
   * Returns the list of event assignments for this {@link Event}.
   * <p>
   * @return the list of EventAssignments for this {@link Event}.
   */
 public ListOfEventAssignments getListOfEventAssignments() {
    long cPtr = libsbmlJNI.Event_getListOfEventAssignments__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfEventAssignments(cPtr, false);
  }

  
  /**
   * Return a specific {@link EventAssignment} object of this {@link Event}.
   * <p>
   * @param n an integer, the index of the {@link EventAssignment} object to return
   * <p>
   * @return the <code>n</code>th {@link EventAssignment} of this {@link Event}.
   */
 public EventAssignment getEventAssignment(long n) {
    long cPtr = libsbmlJNI.Event_getEventAssignment__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, false);
  }

  
  /**
   * Return the event assignment indicated by the given <code>variable</code>.
   * <p>
   * @param variable a string, the identifier of the variable whose
   * {@link EventAssignment} is being sought.
   * <p>
   * @return the {@link EventAssignment} for the given <code>variable</code>, or <code>NULL</code> if
   * no such {@link EventAssignment} exits.
   */
 public EventAssignment getEventAssignment(String variable) {
    long cPtr = libsbmlJNI.Event_getEventAssignment__SWIG_2(swigCPtr, this, variable);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, false);
  }

  
  /**
   * Returns the number of {@link EventAssignment} objects attached to this
   * {@link Event}.
   * <p>
   * @return the number of EventAssignments in this {@link Event}.
   */
 public long getNumEventAssignments() {
    return libsbmlJNI.Event_getNumEventAssignments(swigCPtr, this);
  }

  
  /**
   * Removes the nth {@link EventAssignment} object from this {@link Event} object and
   * returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * <p>
   * @param n the index of the {@link EventAssignment} object to remove
   * <p>
   * @return the {@link EventAssignment} object removed.  As mentioned above, 
   * the caller owns the returned item. <code>NULL</code> is returned if the given index 
   * is out of range.
   * <p>
   */
 public EventAssignment removeEventAssignment(long n) {
    long cPtr = libsbmlJNI.Event_removeEventAssignment__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, true);
  }

  
  /**
   * Removes the {@link EventAssignment} object with the given 'variable' attribute 
   * from this {@link Event} object and returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * If none of the {@link EventAssignment} objects in this {@link Event} object have the 
   * 'variable' attribute <code>variable</code>, then <code>NULL</code> is returned.
   * <p>
   * @param variable the 'variable' attribute of the {@link EventAssignment} object 
   * to remove
   * <p>
   * @return the {@link EventAssignment} object removed.  As mentioned above, the 
   * caller owns the returned object. <code>NULL</code> is returned if no {@link EventAssignment}
   * object with the 'variable' attribute exists in this {@link Event} object.
   */
 public EventAssignment removeEventAssignment(String variable) {
    long cPtr = libsbmlJNI.Event_removeEventAssignment__SWIG_1(swigCPtr, this, variable);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, true);
  }

  
  /**
   * Returns the libSBML type code of this object instance.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or @link SBMLTypeCode_t#SBML_UNKNOWN SBML_UNKNOWN@endlink (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Event_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Event}, is
   * always <code>'event'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'event'</code>. 
   */
 public String getElementName() {
    return libsbmlJNI.Event_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * all the required attributes for this {@link Event} object
   * have been set.
   * <p>
   * @note The required attributes for a {@link Event} object are:
   * <li> 'useValuesfromTriggerTime' (required in SBML Level&nbsp;3)
   */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.Event_hasRequiredAttributes(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> if
   * all the required elements for this {@link Event} object
   * have been set.
   * <p>
   * @note The required elements for a {@link Event} object are:
   * <li> 'trigger'
   * <li> 'listOfEventAssignments' (required in SBML Level&nbsp;2, optional in Level&nbsp;3)
   */
 public boolean hasRequiredElements() {
    return libsbmlJNI.Event_hasRequiredElements(swigCPtr, this);
  }

}
