/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbml {

using System;
using System.Runtime.InteropServices;

public class libsbml {

	
	public static SBase DowncastSBase(IntPtr cPtr, bool owner)
	{
		if (cPtr.Equals(IntPtr.Zero)) return null;
		
		SBase sb = new SBase(cPtr, false);
		switch( sb.getTypeCode() )
		{
			case (int) libsbml.SBML_COMPARTMENT:
				return new Compartment(cPtr, owner);
				
			case (int) libsbml.SBML_COMPARTMENT_TYPE:
				return new CompartmentType(cPtr, owner);

			case (int) libsbml.SBML_CONSTRAINT:
				return new Constraint(cPtr, owner);

			case (int) libsbml.SBML_DOCUMENT:
				return new SBMLDocument(cPtr, owner);

			case (int) libsbml.SBML_DELAY:
				return new Delay(cPtr, owner);
				
			case (int) libsbml.SBML_EVENT:
				return new Event(cPtr, owner);
				
			case (int) libsbml.SBML_EVENT_ASSIGNMENT:
				return new EventAssignment(cPtr, owner);
				
			case (int) libsbml.SBML_FUNCTION_DEFINITION:
				return new FunctionDefinition(cPtr, owner);
				
			case (int) libsbml.SBML_INITIAL_ASSIGNMENT:
				return new InitialAssignment(cPtr, owner);
				
			case (int) libsbml.SBML_KINETIC_LAW:
				return new KineticLaw(cPtr, owner);
				
			case (int) libsbml.SBML_LIST_OF:
			     string name = sb.getElementName();
			     if(name == "listOf")
		             {
				return new ListOf(cPtr, owner);
			     }
			     else if(name == "listOfCompartments")
			     {
				return new ListOfCompartments(cPtr, owner);
			     }
			     else if(name == "listOfCompartmentTypes")
			     {
				return new ListOfCompartmentTypes(cPtr, owner);
			     }
			     else if(name == "listOfConstraints")
			     {
				return new ListOfConstraints(cPtr, owner);
			     }
			     else if(name == "listOfEvents")
			     {
			         return new ListOfEvents(cPtr, owner);
                             }
                             else if(name == "listOfEventAssignments")
                             {
				return new ListOfEventAssignments(cPtr, owner);
        		     }
		             else if(name == "listOfFunctionDefinitions")
		             {
     		               return new ListOfFunctionDefinitions(cPtr, owner);
		             }
		             else if(name == "listOfInitialAssignments")
		             {
		               return new ListOfInitialAssignments(cPtr, owner);
		             }
		             else if(name == "listOfParameters")
		             {
		               return new ListOfParameters(cPtr, owner);
		             }
		             else if(name == "listOfLocalParameters")
		             {
		               return new ListOfLocalParameters(cPtr, owner);
		             }
			     else if(name == "listOfReactions")
		             {
		               return new ListOfReactions(cPtr, owner);
		             }
		             else if(name == "listOfRules")
		             {
		               return new ListOfRules(cPtr, owner);
                             }
		             else if(name == "listOfSpecies")
		             {
		               return new ListOfSpecies(cPtr, owner);
                             }
		             else if(name == "listOfUnknowns")
		             {
		               return new ListOfSpeciesReferences(cPtr, owner);
                             }
		             else if(name == "listOfReactants")
		             {
		               return new ListOfSpeciesReferences(cPtr, owner);
                             }
		             else if(name == "listOfProducts")
		             {
		               return new ListOfSpeciesReferences(cPtr, owner);
                             }
		             else if(name == "listOfModifiers")
		             {
		               return new ListOfSpeciesReferences(cPtr, owner);
                             }
		             else if(name == "listOfSpeciesTypes")
		             {
		               return new ListOfSpeciesTypes(cPtr, owner);
                             }
		             else if(name == "listOfUnits")
		             {
		               return new ListOfUnits(cPtr, owner);
                             }
		             else if(name == "listOfUnitDefinitions")
		             {
		               return new ListOfUnitDefinitions(cPtr, owner);
                             }
		             return new ListOf(cPtr, owner);
				
			case (int) libsbml.SBML_MODEL:
				return new Model(cPtr, owner);
				
			case (int) libsbml.SBML_PARAMETER:
				return new Parameter(cPtr, owner);
				
			case (int) libsbml.SBML_LOCAL_PARAMETER:
				return new LocalParameter(cPtr, owner);
				
			case (int) libsbml.SBML_REACTION:
				return new Reaction(cPtr, owner);
				
			case (int) libsbml.SBML_SPECIES:
				return new Species(cPtr, owner);
				
			case (int) libsbml.SBML_SPECIES_REFERENCE:
				return new SpeciesReference(cPtr, owner);
				
			case (int) libsbml.SBML_MODIFIER_SPECIES_REFERENCE:
				return new ModifierSpeciesReference(cPtr, owner);

			case (int) libsbml.SBML_SPECIES_TYPE:
				return new SpeciesType(cPtr, owner);

			case (int) libsbml.SBML_TRIGGER:
				return new Trigger(cPtr, owner);
				
			case (int) libsbml.SBML_UNIT_DEFINITION:
				return new UnitDefinition(cPtr, owner);
				
			case (int) libsbml.SBML_UNIT:
				return new Unit(cPtr, owner);
				
			case (int) libsbml.SBML_ALGEBRAIC_RULE:
				return new AlgebraicRule(cPtr, owner);
				
			case (int) libsbml.SBML_ASSIGNMENT_RULE:
				return new AssignmentRule(cPtr, owner);
				
			case (int) libsbml.SBML_RATE_RULE:
				return new RateRule(cPtr, owner);

			case (int) libsbml.SBML_STOICHIOMETRY_MATH:
				return new StoichiometryMath(cPtr, owner);
				
			default:
				return new SBase(cPtr, owner);
		}
	}


  public static readonly OStream cout = new OStream(OStream.COUT); 
  public static readonly OStream cerr = new OStream(OStream.CERR); 
  public static readonly OStream clog = new OStream(OStream.CLOG); 

  public static int ASTNode_true(ASTNode node) {
    int ret = libsbmlPINVOKE.ASTNode_true(ASTNode.getCPtr(node));
    return ret;
  }

  public static int getLibSBMLVersion() {
    int ret = libsbmlPINVOKE.getLibSBMLVersion();
    return ret;
  }

  public static string getLibSBMLDottedVersion() {
    string ret = libsbmlPINVOKE.getLibSBMLDottedVersion();
    return ret;
  }

  public static string getLibSBMLVersionString() {
    string ret = libsbmlPINVOKE.getLibSBMLVersionString();
    return ret;
  }

  public static SBMLDocument readSBML(string filename) {
    IntPtr cPtr = libsbmlPINVOKE.readSBML(filename);
    SBMLDocument ret = (cPtr == IntPtr.Zero) ? null : new SBMLDocument(cPtr, true);
    return ret;
  }

  public static SBMLDocument readSBMLFromFile(string filename) {
    IntPtr cPtr = libsbmlPINVOKE.readSBMLFromFile(filename);
    SBMLDocument ret = (cPtr == IntPtr.Zero) ? null : new SBMLDocument(cPtr, true);
    return ret;
  }

  public static SBMLDocument readSBMLFromString(string xml) {
    IntPtr cPtr = libsbmlPINVOKE.readSBMLFromString(xml);
    SBMLDocument ret = (cPtr == IntPtr.Zero) ? null : new SBMLDocument(cPtr, true);
    return ret;
  }

  public static int writeSBML(SBMLDocument d, string filename) {
    int ret = libsbmlPINVOKE.writeSBML(SBMLDocument.getCPtr(d), filename);
    return ret;
  }

  public static string writeSBMLToString(SBMLDocument d) {
    string ret = libsbmlPINVOKE.writeSBMLToString(SBMLDocument.getCPtr(d));
    return ret;
  }

  public static int writeSBMLToFile(SBMLDocument d, string filename) {
    int ret = libsbmlPINVOKE.writeSBMLToFile(SBMLDocument.getCPtr(d), filename);
    return ret;
  }

  public static string SBMLTypeCode_toString(int tc) {
    string ret = libsbmlPINVOKE.SBMLTypeCode_toString(tc);
    return ret;
  }

  public static int UnitKind_equals(int uk1, int uk2) {
    int ret = libsbmlPINVOKE.UnitKind_equals(uk1, uk2);
    return ret;
  }

  public static int UnitKind_forName(string name) {
    int ret = libsbmlPINVOKE.UnitKind_forName(name);
    return ret;
  }

  public static string UnitKind_toString(int uk) {
    string ret = libsbmlPINVOKE.UnitKind_toString(uk);
    return ret;
  }

  public static int UnitKind_isValidUnitKindString(string arg0, long level, long version) {
    int ret = libsbmlPINVOKE.UnitKind_isValidUnitKindString(arg0, level, version);
    return ret;
  }

  public static ASTNode readMathMLFromString(string xml) {
    IntPtr cPtr = libsbmlPINVOKE.readMathMLFromString(xml);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, true);
    return ret;
  }

  public static string writeMathMLToString(ASTNode node) {
    string ret = libsbmlPINVOKE.writeMathMLToString(ASTNode.getCPtr(node));
    return ret;
  }

  public static ASTNode parseFormula(string formula) {
    IntPtr cPtr = libsbmlPINVOKE.parseFormula(formula);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, true);
    return ret;
  }

  public static string formulaToString(ASTNode tree) {
    string ret = libsbmlPINVOKE.formulaToString(ASTNode.getCPtr(tree));
    return ret;
  }

  public const string LIBSBML_DOTTED_VERSION = "4.1.0";
  public const int LIBSBML_VERSION = 40100;
  public const string LIBSBML_VERSION_STRING = "40100";
  // OperationReturnValues_t 
  public const int LIBSBML_OPERATION_SUCCESS = 0;
  public const int LIBSBML_INDEX_EXCEEDS_SIZE = -1;
  public const int LIBSBML_UNEXPECTED_ATTRIBUTE = -2;
  public const int LIBSBML_OPERATION_FAILED = -3;
  public const int LIBSBML_INVALID_ATTRIBUTE_VALUE = -4;
  public const int LIBSBML_INVALID_OBJECT = -5;
  public const int LIBSBML_DUPLICATE_OBJECT_ID = -6;
  public const int LIBSBML_LEVEL_MISMATCH = -7;
  public const int LIBSBML_VERSION_MISMATCH = -8;
  public const int LIBSBML_INVALID_XML_OPERATION = -9;

  // SBMLTypeCode_t 
  public const int SBML_UNKNOWN = 0;
  public const int SBML_COMPARTMENT = SBML_UNKNOWN + 1;
  public const int SBML_COMPARTMENT_TYPE = SBML_COMPARTMENT + 1;
  public const int SBML_CONSTRAINT = SBML_COMPARTMENT_TYPE + 1;
  public const int SBML_DOCUMENT = SBML_CONSTRAINT + 1;
  public const int SBML_EVENT = SBML_DOCUMENT + 1;
  public const int SBML_EVENT_ASSIGNMENT = SBML_EVENT + 1;
  public const int SBML_FUNCTION_DEFINITION = SBML_EVENT_ASSIGNMENT + 1;
  public const int SBML_INITIAL_ASSIGNMENT = SBML_FUNCTION_DEFINITION + 1;
  public const int SBML_KINETIC_LAW = SBML_INITIAL_ASSIGNMENT + 1;
  public const int SBML_LIST_OF = SBML_KINETIC_LAW + 1;
  public const int SBML_MODEL = SBML_LIST_OF + 1;
  public const int SBML_PARAMETER = SBML_MODEL + 1;
  public const int SBML_REACTION = SBML_PARAMETER + 1;
  public const int SBML_RULE = SBML_REACTION + 1;
  public const int SBML_SPECIES = SBML_RULE + 1;
  public const int SBML_SPECIES_REFERENCE = SBML_SPECIES + 1;
  public const int SBML_SPECIES_TYPE = SBML_SPECIES_REFERENCE + 1;
  public const int SBML_MODIFIER_SPECIES_REFERENCE = SBML_SPECIES_TYPE + 1;
  public const int SBML_UNIT_DEFINITION = SBML_MODIFIER_SPECIES_REFERENCE + 1;
  public const int SBML_UNIT = SBML_UNIT_DEFINITION + 1;
  public const int SBML_ALGEBRAIC_RULE = SBML_UNIT + 1;
  public const int SBML_ASSIGNMENT_RULE = SBML_ALGEBRAIC_RULE + 1;
  public const int SBML_RATE_RULE = SBML_ASSIGNMENT_RULE + 1;
  public const int SBML_SPECIES_CONCENTRATION_RULE = SBML_RATE_RULE + 1;
  public const int SBML_COMPARTMENT_VOLUME_RULE = SBML_SPECIES_CONCENTRATION_RULE + 1;
  public const int SBML_PARAMETER_RULE = SBML_COMPARTMENT_VOLUME_RULE + 1;
  public const int SBML_TRIGGER = SBML_PARAMETER_RULE + 1;
  public const int SBML_DELAY = SBML_TRIGGER + 1;
  public const int SBML_STOICHIOMETRY_MATH = SBML_DELAY + 1;
  public const int SBML_LOCAL_PARAMETER = SBML_STOICHIOMETRY_MATH + 1;
  public const int SBML_FORMULA_UNITS_DATA = SBML_LOCAL_PARAMETER + 1;
  public const int SBML_LIST_FORMULA_UNITS_DATA = SBML_FORMULA_UNITS_DATA + 1;
  public const int SBML_LISTOF_COMPARTMENTS = SBML_LIST_FORMULA_UNITS_DATA + 1;
  public const int SBML_LISTOF_COMPARTMENT_TYPES = SBML_LISTOF_COMPARTMENTS + 1;
  public const int SBML_LISTOF_CONSTRAINTS = SBML_LISTOF_COMPARTMENT_TYPES + 1;
  public const int SBML_LISTOF_EVENTS = SBML_LISTOF_CONSTRAINTS + 1;
  public const int SBML_LISTOF_EVENT_ASSIGNMENTS = SBML_LISTOF_EVENTS + 1;
  public const int SBML_LISTOF_FUNCTION_DEFINITIONS = SBML_LISTOF_EVENT_ASSIGNMENTS + 1;
  public const int SBML_LISTOF_INITIAL_ASSIGNMENTS = SBML_LISTOF_FUNCTION_DEFINITIONS + 1;
  public const int SBML_LISTOF_PARAMETERS = SBML_LISTOF_INITIAL_ASSIGNMENTS + 1;
  public const int SBML_LISTOF_REACTIONS = SBML_LISTOF_PARAMETERS + 1;
  public const int SBML_LISTOF_RULES = SBML_LISTOF_REACTIONS + 1;
  public const int SBML_LISTOF_SPECIES = SBML_LISTOF_RULES + 1;
  public const int SBML_LISTOF_SPECIES_REFERENCES = SBML_LISTOF_SPECIES + 1;
  public const int SBML_LISTOF_SPECIES_TYPES = SBML_LISTOF_SPECIES_REFERENCES + 1;
  public const int SBML_LISTOF_UNIT_DEFINITIONS = SBML_LISTOF_SPECIES_TYPES + 1;
  public const int SBML_LISTOF_UNITS = SBML_LISTOF_UNIT_DEFINITIONS + 1;

  public const int IdCheckON = 0x01;
  public const int IdCheckOFF = 0xfe;
  public const int SBMLCheckON = 0x02;
  public const int SBMLCheckOFF = 0xfd;
  public const int SBOCheckON = 0x04;
  public const int SBOCheckOFF = 0xfb;
  public const int MathCheckON = 0x08;
  public const int MathCheckOFF = 0xf7;
  public const int UnitsCheckON = 0x10;
  public const int UnitsCheckOFF = 0xef;
  public const int OverdeterCheckON = 0x20;
  public const int OverdeterCheckOFF = 0xdf;
  public const int PracticeCheckON = 0x40;
  public const int PracticeCheckOFF = 0xbf;
  public const int AllChecksON = 0x7f;
  // UnitKind_t 
  public const int UNIT_KIND_AMPERE = 0;
  public const int UNIT_KIND_AVOGADRO = UNIT_KIND_AMPERE + 1;
  public const int UNIT_KIND_BECQUEREL = UNIT_KIND_AVOGADRO + 1;
  public const int UNIT_KIND_CANDELA = UNIT_KIND_BECQUEREL + 1;
  public const int UNIT_KIND_CELSIUS = UNIT_KIND_CANDELA + 1;
  public const int UNIT_KIND_COULOMB = UNIT_KIND_CELSIUS + 1;
  public const int UNIT_KIND_DIMENSIONLESS = UNIT_KIND_COULOMB + 1;
  public const int UNIT_KIND_FARAD = UNIT_KIND_DIMENSIONLESS + 1;
  public const int UNIT_KIND_GRAM = UNIT_KIND_FARAD + 1;
  public const int UNIT_KIND_GRAY = UNIT_KIND_GRAM + 1;
  public const int UNIT_KIND_HENRY = UNIT_KIND_GRAY + 1;
  public const int UNIT_KIND_HERTZ = UNIT_KIND_HENRY + 1;
  public const int UNIT_KIND_ITEM = UNIT_KIND_HERTZ + 1;
  public const int UNIT_KIND_JOULE = UNIT_KIND_ITEM + 1;
  public const int UNIT_KIND_KATAL = UNIT_KIND_JOULE + 1;
  public const int UNIT_KIND_KELVIN = UNIT_KIND_KATAL + 1;
  public const int UNIT_KIND_KILOGRAM = UNIT_KIND_KELVIN + 1;
  public const int UNIT_KIND_LITER = UNIT_KIND_KILOGRAM + 1;
  public const int UNIT_KIND_LITRE = UNIT_KIND_LITER + 1;
  public const int UNIT_KIND_LUMEN = UNIT_KIND_LITRE + 1;
  public const int UNIT_KIND_LUX = UNIT_KIND_LUMEN + 1;
  public const int UNIT_KIND_METER = UNIT_KIND_LUX + 1;
  public const int UNIT_KIND_METRE = UNIT_KIND_METER + 1;
  public const int UNIT_KIND_MOLE = UNIT_KIND_METRE + 1;
  public const int UNIT_KIND_NEWTON = UNIT_KIND_MOLE + 1;
  public const int UNIT_KIND_OHM = UNIT_KIND_NEWTON + 1;
  public const int UNIT_KIND_PASCAL = UNIT_KIND_OHM + 1;
  public const int UNIT_KIND_RADIAN = UNIT_KIND_PASCAL + 1;
  public const int UNIT_KIND_SECOND = UNIT_KIND_RADIAN + 1;
  public const int UNIT_KIND_SIEMENS = UNIT_KIND_SECOND + 1;
  public const int UNIT_KIND_SIEVERT = UNIT_KIND_SIEMENS + 1;
  public const int UNIT_KIND_STERADIAN = UNIT_KIND_SIEVERT + 1;
  public const int UNIT_KIND_TESLA = UNIT_KIND_STERADIAN + 1;
  public const int UNIT_KIND_VOLT = UNIT_KIND_TESLA + 1;
  public const int UNIT_KIND_WATT = UNIT_KIND_VOLT + 1;
  public const int UNIT_KIND_WEBER = UNIT_KIND_WATT + 1;
  public const int UNIT_KIND_INVALID = UNIT_KIND_WEBER + 1;

  // RuleType_t 
  public const int RULE_TYPE_RATE = 0;
  public const int RULE_TYPE_SCALAR = RULE_TYPE_RATE + 1;
  public const int RULE_TYPE_INVALID = RULE_TYPE_SCALAR + 1;

  public const int SBML_DEFAULT_LEVEL = 3;
  public const int SBML_DEFAULT_VERSION = 1;
  public const string SBML_XMLNS_L1 = "http://www.sbml.org/sbml/level1";
  public const string SBML_XMLNS_L2V1 = "http://www.sbml.org/sbml/level2";
  public const string SBML_XMLNS_L2V2 = "http://www.sbml.org/sbml/level2/version2";
  public const string SBML_XMLNS_L2V3 = "http://www.sbml.org/sbml/level2/version3";
  public const string SBML_XMLNS_L2V4 = "http://www.sbml.org/sbml/level2/version4";
  public const string SBML_XMLNS_L3V1 = "http://www.sbml.org/sbml/level3/version1/core";
  // ASTNodeType_t 
  public const int AST_PLUS = '+';
  public const int AST_MINUS = '-';
  public const int AST_TIMES = '*';
  public const int AST_DIVIDE = '/';
  public const int AST_POWER = '^';
  public const int AST_INTEGER = 256;
  public const int AST_REAL = AST_INTEGER + 1;
  public const int AST_REAL_E = AST_REAL + 1;
  public const int AST_RATIONAL = AST_REAL_E + 1;
  public const int AST_NAME = AST_RATIONAL + 1;
  public const int AST_NAME_AVOGADRO = AST_NAME + 1;
  public const int AST_NAME_TIME = AST_NAME_AVOGADRO + 1;
  public const int AST_CONSTANT_E = AST_NAME_TIME + 1;
  public const int AST_CONSTANT_FALSE = AST_CONSTANT_E + 1;
  public const int AST_CONSTANT_PI = AST_CONSTANT_FALSE + 1;
  public const int AST_CONSTANT_TRUE = AST_CONSTANT_PI + 1;
  public const int AST_LAMBDA = AST_CONSTANT_TRUE + 1;
  public const int AST_FUNCTION = AST_LAMBDA + 1;
  public const int AST_FUNCTION_ABS = AST_FUNCTION + 1;
  public const int AST_FUNCTION_ARCCOS = AST_FUNCTION_ABS + 1;
  public const int AST_FUNCTION_ARCCOSH = AST_FUNCTION_ARCCOS + 1;
  public const int AST_FUNCTION_ARCCOT = AST_FUNCTION_ARCCOSH + 1;
  public const int AST_FUNCTION_ARCCOTH = AST_FUNCTION_ARCCOT + 1;
  public const int AST_FUNCTION_ARCCSC = AST_FUNCTION_ARCCOTH + 1;
  public const int AST_FUNCTION_ARCCSCH = AST_FUNCTION_ARCCSC + 1;
  public const int AST_FUNCTION_ARCSEC = AST_FUNCTION_ARCCSCH + 1;
  public const int AST_FUNCTION_ARCSECH = AST_FUNCTION_ARCSEC + 1;
  public const int AST_FUNCTION_ARCSIN = AST_FUNCTION_ARCSECH + 1;
  public const int AST_FUNCTION_ARCSINH = AST_FUNCTION_ARCSIN + 1;
  public const int AST_FUNCTION_ARCTAN = AST_FUNCTION_ARCSINH + 1;
  public const int AST_FUNCTION_ARCTANH = AST_FUNCTION_ARCTAN + 1;
  public const int AST_FUNCTION_CEILING = AST_FUNCTION_ARCTANH + 1;
  public const int AST_FUNCTION_COS = AST_FUNCTION_CEILING + 1;
  public const int AST_FUNCTION_COSH = AST_FUNCTION_COS + 1;
  public const int AST_FUNCTION_COT = AST_FUNCTION_COSH + 1;
  public const int AST_FUNCTION_COTH = AST_FUNCTION_COT + 1;
  public const int AST_FUNCTION_CSC = AST_FUNCTION_COTH + 1;
  public const int AST_FUNCTION_CSCH = AST_FUNCTION_CSC + 1;
  public const int AST_FUNCTION_DELAY = AST_FUNCTION_CSCH + 1;
  public const int AST_FUNCTION_EXP = AST_FUNCTION_DELAY + 1;
  public const int AST_FUNCTION_FACTORIAL = AST_FUNCTION_EXP + 1;
  public const int AST_FUNCTION_FLOOR = AST_FUNCTION_FACTORIAL + 1;
  public const int AST_FUNCTION_LN = AST_FUNCTION_FLOOR + 1;
  public const int AST_FUNCTION_LOG = AST_FUNCTION_LN + 1;
  public const int AST_FUNCTION_PIECEWISE = AST_FUNCTION_LOG + 1;
  public const int AST_FUNCTION_POWER = AST_FUNCTION_PIECEWISE + 1;
  public const int AST_FUNCTION_ROOT = AST_FUNCTION_POWER + 1;
  public const int AST_FUNCTION_SEC = AST_FUNCTION_ROOT + 1;
  public const int AST_FUNCTION_SECH = AST_FUNCTION_SEC + 1;
  public const int AST_FUNCTION_SIN = AST_FUNCTION_SECH + 1;
  public const int AST_FUNCTION_SINH = AST_FUNCTION_SIN + 1;
  public const int AST_FUNCTION_TAN = AST_FUNCTION_SINH + 1;
  public const int AST_FUNCTION_TANH = AST_FUNCTION_TAN + 1;
  public const int AST_LOGICAL_AND = AST_FUNCTION_TANH + 1;
  public const int AST_LOGICAL_NOT = AST_LOGICAL_AND + 1;
  public const int AST_LOGICAL_OR = AST_LOGICAL_NOT + 1;
  public const int AST_LOGICAL_XOR = AST_LOGICAL_OR + 1;
  public const int AST_RELATIONAL_EQ = AST_LOGICAL_XOR + 1;
  public const int AST_RELATIONAL_GEQ = AST_RELATIONAL_EQ + 1;
  public const int AST_RELATIONAL_GT = AST_RELATIONAL_GEQ + 1;
  public const int AST_RELATIONAL_LEQ = AST_RELATIONAL_GT + 1;
  public const int AST_RELATIONAL_LT = AST_RELATIONAL_LEQ + 1;
  public const int AST_RELATIONAL_NEQ = AST_RELATIONAL_LT + 1;
  public const int AST_UNKNOWN = AST_RELATIONAL_NEQ + 1;

  // XMLErrorCode_t 
  public const int XMLUnknownError = 0;
  public const int XMLOutOfMemory = 1;
  public const int XMLFileUnreadable = 2;
  public const int XMLFileUnwritable = 3;
  public const int XMLFileOperationError = 4;
  public const int XMLNetworkAccessError = 5;
  public const int InternalXMLParserError = 101;
  public const int UnrecognizedXMLParserCode = 102;
  public const int XMLTranscoderError = 103;
  public const int MissingXMLDecl = 1001;
  public const int MissingXMLEncoding = 1002;
  public const int BadXMLDecl = 1003;
  public const int BadXMLDOCTYPE = 1004;
  public const int InvalidCharInXML = 1005;
  public const int BadlyFormedXML = 1006;
  public const int UnclosedXMLToken = 1007;
  public const int InvalidXMLConstruct = 1008;
  public const int XMLTagMismatch = 1009;
  public const int DuplicateXMLAttribute = 1010;
  public const int UndefinedXMLEntity = 1011;
  public const int BadProcessingInstruction = 1012;
  public const int BadXMLPrefix = 1013;
  public const int BadXMLPrefixValue = 1014;
  public const int MissingXMLRequiredAttribute = 1015;
  public const int XMLAttributeTypeMismatch = 1016;
  public const int XMLBadUTF8Content = 1017;
  public const int MissingXMLAttributeValue = 1018;
  public const int BadXMLAttributeValue = 1019;
  public const int BadXMLAttribute = 1020;
  public const int UnrecognizedXMLElement = 1021;
  public const int BadXMLComment = 1022;
  public const int BadXMLDeclLocation = 1023;
  public const int XMLUnexpectedEOF = 1024;
  public const int BadXMLIDValue = 1025;
  public const int BadXMLIDRef = 1026;
  public const int UninterpretableXMLContent = 1027;
  public const int BadXMLDocumentStructure = 1028;
  public const int InvalidAfterXMLContent = 1029;
  public const int XMLExpectedQuotedString = 1030;
  public const int XMLEmptyValueNotPermitted = 1031;
  public const int XMLBadNumber = 1032;
  public const int XMLBadColon = 1033;
  public const int MissingXMLElements = 1034;
  public const int XMLContentEmpty = 1035;
  public const int XMLErrorCodesUpperBound = 9999;

  // XMLErrorCategory_t 
  public const int LIBSBML_CAT_INTERNAL = 0;
  public const int LIBSBML_CAT_SYSTEM = LIBSBML_CAT_INTERNAL + 1;
  public const int LIBSBML_CAT_XML = LIBSBML_CAT_SYSTEM + 1;

  // XMLErrorSeverity_t 
  public const int LIBSBML_SEV_INFO = 0;
  public const int LIBSBML_SEV_WARNING = LIBSBML_SEV_INFO + 1;
  public const int LIBSBML_SEV_ERROR = LIBSBML_SEV_WARNING + 1;
  public const int LIBSBML_SEV_FATAL = LIBSBML_SEV_ERROR + 1;

  // SBMLErrorCode_t 
  public const int UnknownError = 10000;
  public const int NotUTF8 = 10101;
  public const int UnrecognizedElement = 10102;
  public const int NotSchemaConformant = 10103;
  public const int L3NotSchemaConformant = 10104;
  public const int InvalidMathElement = 10201;
  public const int DisallowedMathMLSymbol = 10202;
  public const int DisallowedMathMLEncodingUse = 10203;
  public const int DisallowedDefinitionURLUse = 10204;
  public const int BadCsymbolDefinitionURLValue = 10205;
  public const int DisallowedMathTypeAttributeUse = 10206;
  public const int DisallowedMathTypeAttributeValue = 10207;
  public const int LambdaOnlyAllowedInFunctionDef = 10208;
  public const int BooleanOpsNeedBooleanArgs = 10209;
  public const int NumericOpsNeedNumericArgs = 10210;
  public const int ArgsToEqNeedSameType = 10211;
  public const int PiecewiseNeedsConsistentTypes = 10212;
  public const int PieceNeedsBoolean = 10213;
  public const int ApplyCiMustBeUserFunction = 10214;
  public const int ApplyCiMustBeModelComponent = 10215;
  public const int KineticLawParametersAreLocalOnly = 10216;
  public const int MathResultMustBeNumeric = 10217;
  public const int OpsNeedCorrectNumberOfArgs = 10218;
  public const int InvalidNoArgsPassedToFunctionDef = 10219;
  public const int DisallowedMathUnitsUse = 10220;
  public const int InvalidUnitsValue = 10221;
  public const int DuplicateComponentId = 10301;
  public const int DuplicateUnitDefinitionId = 10302;
  public const int DuplicateLocalParameterId = 10303;
  public const int MultipleAssignmentOrRateRules = 10304;
  public const int MultipleEventAssignmentsForId = 10305;
  public const int EventAndAssignmentRuleForId = 10306;
  public const int DuplicateMetaId = 10307;
  public const int InvalidSBOTermSyntax = 10308;
  public const int InvalidMetaidSyntax = 10309;
  public const int InvalidIdSyntax = 10310;
  public const int InvalidUnitIdSyntax = 10311;
  public const int InvalidNameSyntax = 10312;
  public const int MissingAnnotationNamespace = 10401;
  public const int DuplicateAnnotationNamespaces = 10402;
  public const int SBMLNamespaceInAnnotation = 10403;
  public const int MultipleAnnotations = 10404;
  public const int InconsistentArgUnits = 10501;
  public const int InconsistentKineticLawUnitsL3 = 10503;
  public const int AssignRuleCompartmentMismatch = 10511;
  public const int AssignRuleSpeciesMismatch = 10512;
  public const int AssignRuleParameterMismatch = 10513;
  public const int AssignRuleStoichiometryMismatch = 10514;
  public const int InitAssignCompartmenMismatch = 10521;
  public const int InitAssignSpeciesMismatch = 10522;
  public const int InitAssignParameterMismatch = 10523;
  public const int InitAssignStoichiometryMismatch = 10524;
  public const int RateRuleCompartmentMismatch = 10531;
  public const int RateRuleSpeciesMismatch = 10532;
  public const int RateRuleParameterMismatch = 10533;
  public const int RateRuleStoichiometryMismatch = 10534;
  public const int KineticLawNotSubstancePerTime = 10541;
  public const int SpeciesInvalidExtentUnits = 10542;
  public const int DelayUnitsNotTime = 10551;
  public const int EventAssignCompartmentMismatch = 10561;
  public const int EventAssignSpeciesMismatch = 10562;
  public const int EventAssignParameterMismatch = 10563;
  public const int EventAssignStoichiometryMismatch = 10564;
  public const int OverdeterminedSystem = 10601;
  public const int InvalidModelSBOTerm = 10701;
  public const int InvalidFunctionDefSBOTerm = 10702;
  public const int InvalidParameterSBOTerm = 10703;
  public const int InvalidInitAssignSBOTerm = 10704;
  public const int InvalidRuleSBOTerm = 10705;
  public const int InvalidConstraintSBOTerm = 10706;
  public const int InvalidReactionSBOTerm = 10707;
  public const int InvalidSpeciesReferenceSBOTerm = 10708;
  public const int InvalidKineticLawSBOTerm = 10709;
  public const int InvalidEventSBOTerm = 10710;
  public const int InvalidEventAssignmentSBOTerm = 10711;
  public const int InvalidCompartmentSBOTerm = 10712;
  public const int InvalidSpeciesSBOTerm = 10713;
  public const int InvalidCompartmentTypeSBOTerm = 10714;
  public const int InvalidSpeciesTypeSBOTerm = 10715;
  public const int InvalidTriggerSBOTerm = 10716;
  public const int InvalidDelaySBOTerm = 10717;
  public const int NotesNotInXHTMLNamespace = 10801;
  public const int NotesContainsXMLDecl = 10802;
  public const int NotesContainsDOCTYPE = 10803;
  public const int InvalidNotesContent = 10804;
  public const int OnlyOneNotesElementAllowed = 10805;
  public const int InvalidNamespaceOnSBML = 20101;
  public const int MissingOrInconsistentLevel = 20102;
  public const int MissingOrInconsistentVersion = 20103;
  public const int PackageNSMustMatch = 20104;
  public const int LevelPositiveInteger = 20105;
  public const int VersionPositiveInteger = 20106;
  public const int AllowedAttributesOnSBML = 20108;
  public const int MissingModel = 20201;
  public const int IncorrectOrderInModel = 20202;
  public const int EmptyListElement = 20203;
  public const int NeedCompartmentIfHaveSpecies = 20204;
  public const int OneOfEachListOf = 20205;
  public const int OnlyFuncDefsInListOfFuncDefs = 20206;
  public const int OnlyUnitDefsInListOfUnitDefs = 20207;
  public const int OnlyCompartmentsInListOfCompartments = 20208;
  public const int OnlySpeciesInListOfSpecies = 20209;
  public const int OnlyParametersInListOfParameters = 20210;
  public const int OnlyInitAssignsInListOfInitAssigns = 20211;
  public const int OnlyRulesInListOfRules = 20212;
  public const int OnlyConstraintsInListOfConstraints = 20213;
  public const int OnlyReactionsInListOfReactions = 20214;
  public const int OnlyEventsInListOfEvents = 20215;
  public const int L3ConversionFactorOnModel = 20216;
  public const int L3TimeUnitsOnModel = 20217;
  public const int L3VolumeUnitsOnModel = 20218;
  public const int L3AreaUnitsOnModel = 20219;
  public const int L3LengthUnitsOnModel = 20220;
  public const int L3ExtentUnitsOnModel = 20221;
  public const int AllowedAttributesOnModel = 20222;
  public const int AllowedAttributesOnListOfFuncs = 20223;
  public const int AllowedAttributesOnListOfUnitDefs = 20224;
  public const int AllowedAttributesOnListOfComps = 20225;
  public const int AllowedAttributesOnListOfSpecies = 20226;
  public const int AllowedAttributesOnListOfParams = 20227;
  public const int AllowedAttributesOnListOfInitAssign = 20228;
  public const int AllowedAttributesOnListOfRules = 20229;
  public const int AllowedAttributesOnListOfConstraints = 20230;
  public const int AllowedAttributesOnListOfReactions = 20231;
  public const int AllowedAttributesOnListOfEvents = 20232;
  public const int FunctionDefMathNotLambda = 20301;
  public const int InvalidApplyCiInLambda = 20302;
  public const int RecursiveFunctionDefinition = 20303;
  public const int InvalidCiInLambda = 20304;
  public const int InvalidFunctionDefReturnType = 20305;
  public const int OneMathElementPerFunc = 20306;
  public const int AllowedAttributesOnFunc = 20307;
  public const int InvalidUnitDefId = 20401;
  public const int InvalidSubstanceRedefinition = 20402;
  public const int InvalidLengthRedefinition = 20403;
  public const int InvalidAreaRedefinition = 20404;
  public const int InvalidTimeRedefinition = 20405;
  public const int InvalidVolumeRedefinition = 20406;
  public const int VolumeLitreDefExponentNotOne = 20407;
  public const int VolumeMetreDefExponentNot3 = 20408;
  public const int EmptyListOfUnits = 20409;
  public const int InvalidUnitKind = 20410;
  public const int OffsetNoLongerValid = 20411;
  public const int CelsiusNoLongerValid = 20412;
  public const int EmptyUnitListElement = 20413;
  public const int OneListOfUnitsPerUnitDef = 20414;
  public const int OnlyUnitsInListOfUnits = 20415;
  public const int AllowedAttributesOnUnitDefinition = 20419;
  public const int AllowedAttributesOnListOfUnits = 20420;
  public const int AllowedAttributesOnUnit = 20421;
  public const int ZeroDimensionalCompartmentSize = 20501;
  public const int ZeroDimensionalCompartmentUnits = 20502;
  public const int ZeroDimensionalCompartmentConst = 20503;
  public const int UndefinedOutsideCompartment = 20504;
  public const int RecursiveCompartmentContainment = 20505;
  public const int ZeroDCompartmentContainment = 20506;
  public const int Invalid1DCompartmentUnits = 20507;
  public const int Invalid2DCompartmentUnits = 20508;
  public const int Invalid3DCompartmentUnits = 20509;
  public const int InvalidCompartmentTypeRef = 20510;
  public const int OneDimensionalCompartmentUnits = 20511;
  public const int TwoDimensionalCompartmentUnits = 20512;
  public const int ThreeDimensionalCompartmentUnits = 20513;
  public const int AllowedAttributesOnCompartment = 20517;
  public const int InvalidSpeciesCompartmentRef = 20601;
  public const int HasOnlySubsNoSpatialUnits = 20602;
  public const int NoSpatialUnitsInZeroD = 20603;
  public const int NoConcentrationInZeroD = 20604;
  public const int SpatialUnitsInOneD = 20605;
  public const int SpatialUnitsInTwoD = 20606;
  public const int SpatialUnitsInThreeD = 20607;
  public const int InvalidSpeciesSusbstanceUnits = 20608;
  public const int BothAmountAndConcentrationSet = 20609;
  public const int NonBoundarySpeciesAssignedAndUsed = 20610;
  public const int NonConstantSpeciesUsed = 20611;
  public const int InvalidSpeciesTypeRef = 20612;
  public const int MultSpeciesSameTypeInCompartment = 20613;
  public const int MissingSpeciesCompartment = 20614;
  public const int SpatialSizeUnitsRemoved = 20615;
  public const int SubstanceUnitsOnSpecies = 20616;
  public const int ConversionFactorOnSpecies = 20617;
  public const int AllowedAttributesOnSpecies = 20623;
  public const int InvalidParameterUnits = 20701;
  public const int ParameterUnits = 20702;
  public const int ConversionFactorMustConstant = 20705;
  public const int AllowedAttributesOnParameter = 20706;
  public const int InvalidInitAssignSymbol = 20801;
  public const int MultipleInitAssignments = 20802;
  public const int InitAssignmentAndRuleForSameId = 20803;
  public const int OneMathElementPerInitialAssign = 20804;
  public const int AllowedAttributesOnInitialAssign = 20805;
  public const int InvalidAssignRuleVariable = 20901;
  public const int InvalidRateRuleVariable = 20902;
  public const int AssignmentToConstantEntity = 20903;
  public const int RateRuleForConstantEntity = 20904;
  public const int RepeatedRule10304 = 20905;
  public const int CircularRuleDependency = 20906;
  public const int OneMathElementPerRule = 20907;
  public const int AllowedAttributesOnAssignRule = 20908;
  public const int AllowedAttributesOnRateRule = 20909;
  public const int AllowedAttributesOnAlgRule = 20910;
  public const int ConstraintMathNotBoolean = 21001;
  public const int IncorrectOrderInConstraint = 21002;
  public const int ConstraintNotInXHTMLNamespace = 21003;
  public const int ConstraintContainsXMLDecl = 21004;
  public const int ConstraintContainsDOCTYPE = 21005;
  public const int InvalidConstraintContent = 21006;
  public const int OneMathElementPerConstraint = 21007;
  public const int OneMessageElementPerConstraint = 21008;
  public const int AllowedAttributesOnConstraint = 21009;
  public const int NoReactantsOrProducts = 21101;
  public const int IncorrectOrderInReaction = 21102;
  public const int EmptyListInReaction = 21103;
  public const int InvalidReactantsProductsList = 21104;
  public const int InvalidModifiersList = 21105;
  public const int OneSubElementPerReaction = 21106;
  public const int CompartmentOnReaction = 21107;
  public const int AllowedAttributesOnReaction = 21110;
  public const int InvalidSpeciesReference = 21111;
  public const int RepeatedRule20611 = 21112;
  public const int BothStoichiometryAndMath = 21113;
  public const int AllowedAttributesOnSpeciesReference = 21116;
  public const int AllowedAttributesOnModifier = 21117;
  public const int UndeclaredSpeciesRef = 21121;
  public const int IncorrectOrderInKineticLaw = 21122;
  public const int EmptyListInKineticLaw = 21123;
  public const int NonConstantLocalParameter = 21124;
  public const int SubsUnitsNoLongerValid = 21125;
  public const int TimeUnitsNoLongerValid = 21126;
  public const int OneListOfPerKineticLaw = 21127;
  public const int OnlyLocalParamsInListOfLocalParams = 21128;
  public const int AllowedAttributesOnListOfLocalParam = 21129;
  public const int OneMathPerKineticLaw = 21130;
  public const int UndeclaredSpeciesInStoichMath = 21131;
  public const int AllowedAttributesOnKineticLaw = 21132;
  public const int AllowedAttributesOnListOfSpeciesRef = 21150;
  public const int AllowedAttributesOnListOfMods = 21151;
  public const int AllowedAttributesOnLocalParameter = 21172;
  public const int MissingTriggerInEvent = 21201;
  public const int TriggerMathNotBoolean = 21202;
  public const int MissingEventAssignment = 21203;
  public const int TimeUnitsEvent = 21204;
  public const int IncorrectOrderInEvent = 21205;
  public const int ValuesFromTriggerTimeNeedDelay = 21206;
  public const int DelayNeedsValuesFromTriggerTime = 21207;
  public const int OneMathPerTrigger = 21209;
  public const int OneMathPerDelay = 21210;
  public const int InvalidEventAssignmentVariable = 21211;
  public const int EventAssignmentForConstantEntity = 21212;
  public const int OneMathPerEventAssignment = 21213;
  public const int AllowedAttributesOnEventAssignment = 21214;
  public const int OnlyOneDelayPerEvent = 21221;
  public const int OneListOfEventAssignmentsPerEvent = 21222;
  public const int OnlyEventAssignInListOfEventAssign = 21223;
  public const int AllowedAttributesOnListOfEventAssign = 21224;
  public const int AllowedAttributesOnEvent = 21225;
  public const int AllowedAttributesOnTrigger = 21226;
  public const int AllowedAttributesOnDelay = 21227;
  public const int GeneralWarningNotSpecified = 29999;
  public const int CompartmentShouldHaveSize = 80501;
  public const int ParameterShouldHaveUnits = 80701;
  public const int LocalParameterShadowsId = 81121;
  public const int LibSBMLAdditionalCodesLowerBound = 90000;
  public const int CannotConvertToL1V1 = 90001;
  public const int NoEventsInL1 = 91001;
  public const int NoFunctionDefinitionsInL1 = 91002;
  public const int NoConstraintsInL1 = 91003;
  public const int NoInitialAssignmentsInL1 = 91004;
  public const int NoSpeciesTypesInL1 = 91005;
  public const int NoCompartmentTypeInL1 = 91006;
  public const int NoNon3DComparmentsInL1 = 91007;
  public const int NoFancyStoichiometryMathInL1 = 91008;
  public const int NoNonIntegerStoichiometryInL1 = 91009;
  public const int NoUnitMultipliersOrOffsetsInL1 = 91010;
  public const int SpeciesCompartmentRequiredInL1 = 91011;
  public const int NoSpeciesSpatialSizeUnitsInL1 = 91012;
  public const int NoSBOTermsInL1 = 91013;
  public const int StrictUnitsRequiredInL1 = 91014;
  public const int NoConstraintsInL2v1 = 92001;
  public const int NoInitialAssignmentsInL2v1 = 92002;
  public const int NoSpeciesTypeInL2v1 = 92003;
  public const int NoCompartmentTypeInL2v1 = 92004;
  public const int NoSBOTermsInL2v1 = 92005;
  public const int NoIdOnSpeciesReferenceInL2v1 = 92006;
  public const int NoDelayedEventAssignmentInL2v1 = 92007;
  public const int StrictUnitsRequiredInL2v1 = 92008;
  public const int SBOTermNotUniversalInL2v2 = 93001;
  public const int NoUnitOffsetInL2v2 = 93002;
  public const int NoKineticLawTimeUnitsInL2v2 = 93003;
  public const int NoKineticLawSubstanceUnitsInL2v2 = 93004;
  public const int NoDelayedEventAssignmentInL2v2 = 93005;
  public const int ModelSBOBranchChangedBeyondL2v2 = 93006;
  public const int StrictUnitsRequiredInL2v2 = 93007;
  public const int StrictSBORequiredInL2v2 = 93008;
  public const int DuplicateAnnotationInvalidInL2v2 = 93009;
  public const int NoUnitOffsetInL2v3 = 94001;
  public const int NoKineticLawTimeUnitsInL2v3 = 94002;
  public const int NoKineticLawSubstanceUnitsInL2v3 = 94003;
  public const int NoSpeciesSpatialSizeUnitsInL2v3 = 94004;
  public const int NoEventTimeUnitsInL2v3 = 94005;
  public const int NoDelayedEventAssignmentInL2v3 = 94006;
  public const int ModelSBOBranchChangedBeyondL2v3 = 94007;
  public const int StrictUnitsRequiredInL2v3 = 94008;
  public const int StrictSBORequiredInL2v3 = 94009;
  public const int DuplicateAnnotationInvalidInL2v3 = 94010;
  public const int NoUnitOffsetInL2v4 = 95001;
  public const int NoKineticLawTimeUnitsInL2v4 = 95002;
  public const int NoKineticLawSubstanceUnitsInL2v4 = 95003;
  public const int NoSpeciesSpatialSizeUnitsInL2v4 = 95004;
  public const int NoEventTimeUnitsInL2v4 = 95005;
  public const int ModelSBOBranchChangedInL2v4 = 95006;
  public const int DuplicateAnnotationInvalidInL2v4 = 95007;
  public const int NoSpeciesTypeInL3v1 = 96001;
  public const int NoCompartmentTypeInL3v1 = 96002;
  public const int NoUnitOffsetInL3v1 = 96003;
  public const int NoKineticLawTimeUnitsInL3v1 = 96004;
  public const int NoKineticLawSubstanceUnitsInL3v1 = 96005;
  public const int NoSpeciesSpatialSizeUnitsInL3v1 = 96006;
  public const int NoEventTimeUnitsInL3v1 = 96007;
  public const int ModelSBOBranchChangedInL3v1 = 96008;
  public const int DuplicateAnnotationInvalidInL3v1 = 96009;
  public const int NoCompartmentOutsideInL3v1 = 96010;
  public const int NoStoichiometryMathInL3v1 = 96011;
  public const int InvalidSBMLLevelVersion = 99101;
  public const int AnnotationNotesNotAllowedLevel1 = 99104;
  public const int InvalidRuleOrdering = 99106;
  public const int SubsUnitsAllowedInKL = 99127;
  public const int TimeUnitsAllowedInKL = 99128;
  public const int FormulaInLevel1KL = 99129;
  public const int TimeUnitsRemoved = 99206;
  public const int BadMathML = 99219;
  public const int FailedMathMLReadOfDouble = 99220;
  public const int FailedMathMLReadOfInteger = 99221;
  public const int FailedMathMLReadOfExponential = 99222;
  public const int FailedMathMLReadOfRational = 99223;
  public const int BadMathMLNodeType = 99224;
  public const int NoTimeSymbolInFunctionDef = 99301;
  public const int InconsistentArgUnitsWarnings = 99502;
  public const int InconsistentPowerUnitsWarnings = 99503;
  public const int InconsistentExponUnitsWarnings = 99504;
  public const int UndeclaredUnits = 99505;
  public const int UnrecognisedSBOTerm = 99701;
  public const int ObseleteSBOTerm = 99702;
  public const int IncorrectCompartmentSpatialDimensions = 99901;
  public const int CompartmentTypeNotValidAttribute = 99902;
  public const int ConstantNotValidAttribute = 99903;
  public const int MetaIdNotValidAttribute = 99904;
  public const int SBOTermNotValidAttributeBeforeL2V3 = 99905;
  public const int InvalidL1CompartmentUnits = 99906;
  public const int L1V1CompartmentVolumeReqd = 99907;
  public const int CompartmentTypeNotValidComponent = 99908;
  public const int ConstraintNotValidComponent = 99909;
  public const int EventNotValidComponent = 99910;
  public const int SBOTermNotValidAttributeBeforeL2V2 = 99911;
  public const int FuncDefNotValidComponent = 99912;
  public const int InitialAssignNotValidComponent = 99913;
  public const int VariableNotValidAttribute = 99914;
  public const int UnitsNotValidAttribute = 99915;
  public const int ConstantSpeciesNotValidAttribute = 99916;
  public const int SpatialSizeUnitsNotValidAttribute = 99917;
  public const int SpeciesTypeNotValidAttribute = 99918;
  public const int HasOnlySubsUnitsNotValidAttribute = 99919;
  public const int IdNotValidAttribute = 99920;
  public const int NameNotValidAttribute = 99921;
  public const int SpeciesTypeNotValidComponent = 99922;
  public const int StoichiometryMathNotValidComponent = 99923;
  public const int MultiplierNotValidAttribute = 99924;
  public const int OffsetNotValidAttribute = 99925;
  public const int InvalidTargetLevelVersion = 99997;
  public const int L3NotSupported = 99998;
  public const int SBMLCodesUpperBound = 99999;

  // SBMLErrorCategory_t 
  public const int LIBSBML_CAT_SBML = (LIBSBML_CAT_XML+1);
  public const int LIBSBML_CAT_SBML_L1_COMPAT = LIBSBML_CAT_SBML + 1;
  public const int LIBSBML_CAT_SBML_L2V1_COMPAT = LIBSBML_CAT_SBML_L1_COMPAT + 1;
  public const int LIBSBML_CAT_SBML_L2V2_COMPAT = LIBSBML_CAT_SBML_L2V1_COMPAT + 1;
  public const int LIBSBML_CAT_GENERAL_CONSISTENCY = LIBSBML_CAT_SBML_L2V2_COMPAT + 1;
  public const int LIBSBML_CAT_IDENTIFIER_CONSISTENCY = LIBSBML_CAT_GENERAL_CONSISTENCY + 1;
  public const int LIBSBML_CAT_UNITS_CONSISTENCY = LIBSBML_CAT_IDENTIFIER_CONSISTENCY + 1;
  public const int LIBSBML_CAT_MATHML_CONSISTENCY = LIBSBML_CAT_UNITS_CONSISTENCY + 1;
  public const int LIBSBML_CAT_SBO_CONSISTENCY = LIBSBML_CAT_MATHML_CONSISTENCY + 1;
  public const int LIBSBML_CAT_OVERDETERMINED_MODEL = LIBSBML_CAT_SBO_CONSISTENCY + 1;
  public const int LIBSBML_CAT_SBML_L2V3_COMPAT = LIBSBML_CAT_OVERDETERMINED_MODEL + 1;
  public const int LIBSBML_CAT_MODELING_PRACTICE = LIBSBML_CAT_SBML_L2V3_COMPAT + 1;
  public const int LIBSBML_CAT_INTERNAL_CONSISTENCY = LIBSBML_CAT_MODELING_PRACTICE + 1;
  public const int LIBSBML_CAT_SBML_L2V4_COMPAT = LIBSBML_CAT_INTERNAL_CONSISTENCY + 1;
  public const int LIBSBML_CAT_SBML_L3V1_COMPAT = LIBSBML_CAT_SBML_L2V4_COMPAT + 1;

  // SBMLErrorSeverity_t 
  public const int LIBSBML_SEV_SCHEMA_ERROR = (LIBSBML_SEV_FATAL+1);
  public const int LIBSBML_SEV_GENERAL_WARNING = LIBSBML_SEV_SCHEMA_ERROR + 1;
  public const int LIBSBML_SEV_NOT_APPLICABLE = LIBSBML_SEV_GENERAL_WARNING + 1;

  // QualifierType_t 
  public const int MODEL_QUALIFIER = 0;
  public const int BIOLOGICAL_QUALIFIER = MODEL_QUALIFIER + 1;
  public const int UNKNOWN_QUALIFIER = BIOLOGICAL_QUALIFIER + 1;

  // ModelQualifierType_t 
  public const int BQM_IS = 0;
  public const int BQM_IS_DESCRIBED_BY = BQM_IS + 1;
  public const int BQM_IS_DERIVED_FROM = BQM_IS_DESCRIBED_BY + 1;
  public const int BQM_UNKNOWN = BQM_IS_DERIVED_FROM + 1;

  // BiolQualifierType_t 
  public const int BQB_IS = 0;
  public const int BQB_HAS_PART = BQB_IS + 1;
  public const int BQB_IS_PART_OF = BQB_HAS_PART + 1;
  public const int BQB_IS_VERSION_OF = BQB_IS_PART_OF + 1;
  public const int BQB_HAS_VERSION = BQB_IS_VERSION_OF + 1;
  public const int BQB_IS_HOMOLOG_TO = BQB_HAS_VERSION + 1;
  public const int BQB_IS_DESCRIBED_BY = BQB_IS_HOMOLOG_TO + 1;
  public const int BQB_IS_ENCODED_BY = BQB_IS_DESCRIBED_BY + 1;
  public const int BQB_ENCODES = BQB_IS_ENCODED_BY + 1;
  public const int BQB_OCCURS_IN = BQB_ENCODES + 1;
  public const int BQB_HAS_PROPERTY = BQB_OCCURS_IN + 1;
  public const int BQB_IS_PROPERTY_OF = BQB_HAS_PROPERTY + 1;
  public const int BQB_UNKNOWN = BQB_IS_PROPERTY_OF + 1;

}

}
