#
# @file    TestAlgebraicRule.rb
# @brief   AlgebraicRule unit tests
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Ben Bornstein 
#
# $Id: TestAlgebraicRule.rb 10068 2009-08-21 18:54:20Z ajouraku $
# $HeadURL: https://sbml.svn.sourceforge.net/svnroot/sbml/branches/rel-4-0-0/src/bindings/ruby/test/sbml/TestAlgebraicRule.rb $
#
# This test file was converted from src/sbml/test/TestAlgebraicRule.c
# with the help of conversion sciprt (ctest_converter.pl).
#
#<!---------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2009 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
#--------------------------------------------------------------------------->*/
require 'test/unit'
require 'libSBML'

class TestAlgebraicRule < Test::Unit::TestCase

  def setup
    @@ar = LibSBML::AlgebraicRule.new(2,4)
    if (@@ar == nil)
    end
  end

  def teardown
    @@ar = nil
  end

  def test_AlgebraicRule_create
    assert( @@ar.getTypeCode() == LibSBML::SBML_ALGEBRAIC_RULE )
    assert( @@ar.getMetaId() == "" )
    assert( @@ar.getNotes() == nil )
    assert( @@ar.getAnnotation() == nil )
    assert( @@ar.getFormula() == "" )
    assert( @@ar.getMath() == nil )
  end

  def test_AlgebraicRule_createWithFormula
    ar = LibSBML::AlgebraicRule.new(2,4)
    ar.setFormula( "1 + 1")
    assert( ar.getTypeCode() == LibSBML::SBML_ALGEBRAIC_RULE )
    assert( ar.getMetaId() == "" )
    math = ar.getMath()
    assert( math != nil )
    formula = LibSBML::formulaToString(math)
    assert( formula != nil )
    assert ((  "1 + 1" == formula ))
    assert (( formula == ar.getFormula() ))
    ar = nil
  end

  def test_AlgebraicRule_createWithMath
    math = LibSBML::parseFormula("1 + 1")
    ar = LibSBML::AlgebraicRule.new(2,4)
    ar.setMath(math)
    assert( ar.getTypeCode() == LibSBML::SBML_ALGEBRAIC_RULE )
    assert( ar.getMetaId() == "" )
    assert ((  "1 + 1" == ar.getFormula() ))
    assert( ar.getMath() != math )
    ar = nil
  end

  def test_AlgebraicRule_createWithNS
    xmlns = LibSBML::XMLNamespaces.new()
    xmlns.add( "http://www.sbml.org", "testsbml")
    sbmlns = LibSBML::SBMLNamespaces.new(2,3)
    sbmlns.addNamespaces(xmlns)
    r = LibSBML::AlgebraicRule.new(sbmlns)
    assert( r.getTypeCode() == LibSBML::SBML_ALGEBRAIC_RULE )
    assert( r.getMetaId() == "" )
    assert( r.getNotes() == nil )
    assert( r.getAnnotation() == nil )
    assert( r.getLevel() == 2 )
    assert( r.getVersion() == 3 )
    assert( r.getNamespaces() != nil )
    assert( r.getNamespaces().getLength() == 2 )
    r = nil
  end

  def test_AlgebraicRule_free_NULL
  end

end
