/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's StoichiometryMath construct.
 * <p>
 * In SBML Level 2, product and reactant stoichiometries can be specified
 * using <em>either</em> the 'stoichiometry' attribute or a 'stoichiometryMath'
 * element in a {@link SpeciesReference} object.  The 'stoichiometry' attribute is
 * of type <code>double</code> and should contain values greater than zero (0).  The
 * 'stoichiometryMath' element is implemented as an element containing a
 * MathML expression.  These two are mutually exclusive; only one of
 * 'stoichiometry' or 'stoichiometryMath' should be defined in a given
 * {@link SpeciesReference} instance.  When neither the attribute nor the element
 * is present, the value of 'stoichiometry' in the enclosing
 * {@link SpeciesReference} instance defaults to <code>1</code>.
 * <p>
 * For maximum interoperability, {@link SpeciesReference}'s 'stoichiometry'
 * attribute should be used in preference to 'stoichiometryMath' when a
 * species' stoichiometry is a simple scalar number (integer or decimal).
 * When the stoichiometry is a rational number, or when it is a more
 * complicated formula, 'stoichiometryMath' must be used.  The MathML
 * expression in 'stoichiometryMath' may also refer to identifiers of
 * entities in a model (except reaction identifiers).  However, the only
 * species identifiers that can be used in 'stoichiometryMath' are those
 * referenced in the enclosing {@link Reaction}'s list of reactants, products and
 * modifiers.
 * <p>
 * The 'stoichiometry' attribute and the 'stoichiometryMath' element, when
 * either is used, is each interpreted as a factor applied to the reaction
 * rate to produce the rate of change of the species identified by the
 * 'species' attribute in the enclosing {@link SpeciesReference}.  This is the
 * normal interpretation of a stoichiometry, but in SBML, one additional
 * consideration has to be taken into account.  The reaction rate, which is
 * the result of the {@link KineticLaw}'s 'math' element, is always in the model's
 * <em>substance</em> per <em>time</em> units.  However, the rate of change of the
 * species will involve the species' <em>substance</em> units (i.e., the units
 * identified by the {@link Species} object's 'substanceUnits' attribute), and
 * these units may be different from the model's default <em>substance</em>
 * units.  If the units <em>are</em> different, the stoichiometry must
 * incorporate a conversion factor for converting the model's <em>substance</em>
 * units to the species' <em>substance</em> units.  The conversion factor is
 * assumed to be included in the scalar value of the 'stoichiometry'
 * attribute if 'stoichiometry' is used.  If instead 'stoichiometryMath' is
 * used, then the product of the model's 'substance' units times the
 * 'stoichiometryMath' units must match the <em>substance</em> units of the
 * species.  Note that in either case, if the species' units and the
 * model's default <em>substance</em> units are the same, the stoichiometry ends
 * up being a dimensionless number and equivalent to the standard chemical
 * stoichiometry found in textbooks.  Examples and more explanations of
 * this are given in the SBML specification.
 * <p>
 * The following is a simple example of a species reference for species 
 * <code>'X0'</code>, with stoichiometry <code>2</code>, in a list of reactants within a reaction
 * having the identifier <code>'J1'</code>:
 * <div class='fragment'><pre>
 * &lt;model&gt;
 *     ...
 *     &lt;listOfReactions&gt;
 *         &lt;reaction id='J1'&gt;
 *             &lt;listOfReactants&gt;
 *                 &lt;speciesReference species='X0' stoichiometry='2'&gt;
 *             &lt;/listOfReactants&gt;
 *             ...
 *         &lt;/reaction&gt;
 *         ...
 *     &lt;/listOfReactions&gt;
 *     ...
 * &lt;/model&gt;</pre></div>
 * <p>
 * The following is a more complex example of a species reference for
 * species <code>'X0'</code>, with a stoichiometry formula consisting of
 * a rational number:
 * <div class='fragment'><pre>
 * &lt;model&gt;
 *     ...
 *     &lt;listOfReactions&gt;
 *         &lt;reaction id='J1'&gt;
 *             &lt;listOfReactants&gt;
 *                 &lt;speciesReference species='X0'&gt;
 *                     &lt;stoichiometryMath&gt;
 *                         &lt;math xmlns='http://www.w3.org/1998/Math/MathML'&gt; 
 *                             &lt;cn type='rational'&gt; 3 &lt;sep/&gt; 2 &lt;/cn&gt;
 *                         &lt;/math&gt;
 *                     &lt;/stoichiometryMath&gt;
 *                 &lt;/speciesReference&gt;
 *             &lt;/listOfReactants&gt;
 *             ...
 *         &lt;/reaction&gt;
 *         ...
 *     &lt;/listOfReactions&gt;
 *     ...
 * &lt;/model&gt;</pre></div>
 * <p>
 * Additional discussions of stoichiometries and implications for species
 * and reactions are included in the documentation of {@link SpeciesReference}
 * class.
 * <p>
 * @see SpeciesReference
 * @see Reaction
 */

public class StoichiometryMath extends SBase {
   private long swigCPtr;

   protected StoichiometryMath(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGStoichiometryMathUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(StoichiometryMath obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (StoichiometryMath obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_StoichiometryMath(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link StoichiometryMath} object using the given SBML <code>level</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link StoichiometryMath}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link StoichiometryMath}
   * <p>
   * @note Once a {@link StoichiometryMath} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> for the document <em>override</em> those used
   * to create the {@link StoichiometryMath}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public StoichiometryMath(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_StoichiometryMath__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link StoichiometryMath} object using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp; Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Once a {@link StoichiometryMath} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link StoichiometryMath}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public StoichiometryMath(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_StoichiometryMath__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link StoichiometryMath}.
   */
 public StoichiometryMath(StoichiometryMath orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_StoichiometryMath__SWIG_2(StoichiometryMath.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link StoichiometryMath} object.
   * <p>
   * @return a (deep) copy of this {@link StoichiometryMath}.
   */
 public StoichiometryMath cloneObject() {
    long cPtr = libsbmlJNI.StoichiometryMath_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new StoichiometryMath(cPtr, true);
  }

  
  /**
   * Retrieves the mathematical formula within this {@link StoichiometryMath} and
   * return it as an AST.
   * <p>
   * @return the math of this {@link StoichiometryMath}.
   */
 public ASTNode getMath() {
    long cPtr = libsbmlJNI.StoichiometryMath_getMath(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Predicate to test whether the math for this {@link StoichiometryMath} object
   * has been set.
   * <p>
   * @return <code>true</code> if the formula (meaning the <code>math</code> subelement) of
   * this {@link StoichiometryMath} has been set, <code>false</code> otherwise.
   */
 public boolean isSetMath() {
    return libsbmlJNI.StoichiometryMath_isSetMath(swigCPtr, this);
  }

  
  /**
   * Sets the 'math' expression of this {@link StoichiometryMath} instance to a
   * copy of the given {@link ASTNode}.
   * <p>
   * @param math an {@link ASTNode} representing a formula tree.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_OBJECT
   */
 public int setMath(ASTNode math) {
    return libsbmlJNI.StoichiometryMath_setMath(swigCPtr, this, ASTNode.getCPtr(math), math);
  }

  
  /**
   * Calculates and returns a {@link UnitDefinition} object that expresses the
   * units returned by the math expression in this {@link StoichiometryMath}
   * object.
   * <p>
   * The units are calculated based on the mathematical expression in the
   * {@link StoichiometryMath} and the model quantities referenced by
   * <code>&lt;ci&gt;</code> elements used within that expression.  The
   * StoichiometryMath.getDerivedUnitDefinition() method returns the
   * calculated units.
   * <p>
   * Note that the functionality that facilitates unit analysis depends 
   * on the model as a whole.  Thus, in cases where the object has not 
   * been added to a model or the model itself is incomplete,
   * unit analysis is not possible and this method will return NULL.
   * <p>
   * @warning Note that it is possible the 'math' expression in the
   * {@link StoichiometryMath} instance contains literal numbers or parameters with
   * undeclared units.  In those cases, it is not possible to calculate the
   * units of the overall expression without making assumptions.  LibSBML
   * does not make assumptions about the units, and
   * StoichiometryMath.getDerivedUnitDefinition() only returns the units
   * as far as it is able to determine them.  For example, in an expression
   * <em>X + Y</em>, if <em>X</em> has unambiguously-defined units and
   * <em>Y</em> does not, it will return the units of <em>X</em>.  When
   * using this method, <strong>it is critical that callers also invoke the
   * method</strong> StoichiometryMath.containsUndeclaredUnits()
   * <strong>to determine whether this situation holds</strong>.  Callers
   * should take suitable action in those situations.
   * <p>
   * @return a {@link UnitDefinition} that expresses the units of the math 
   * <p>
   * @see #containsUndeclaredUnits()
   */
 public UnitDefinition getDerivedUnitDefinition() {
    long cPtr = libsbmlJNI.StoichiometryMath_getDerivedUnitDefinition__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether the math
   * expression of this {@link StoichiometryMath} object contains literal numbers
   * or parameters with undeclared units.
   * <p>
   * The StoichiometryMath.getDerivedUnitDefinition() method returns what
   * libSBML computes the units of the Stoichiometry to be, to the extent
   * that libSBML can compute them.  However, if the expression contains
   * literal numbers or parameters with undeclared units, libSBML may not
   * be able to compute the full units of the expression and will only
   * return what it can compute.  Callers should always use
   * StoichiometryMath.containsUndeclaredUnits() when using
   * StoichiometryMath.getDerivedUnitDefinition() to decide whether the
   * returned units may be incomplete.
   * <p>
   * @return <code>true</code> if the math expression of this {@link StoichiometryMath}
   * includes numbers/parameters with undeclared units, <code>false</code> otherwise.
   * <p>
   * @note A return value of <code>true</code> indicates that the {@link UnitDefinition}
   * returned by StoichiometryMath.getDerivedUnitDefinition() may not
   * accurately represent the units of the expression.
   * <p>
   * @see #getDerivedUnitDefinition()
   */
 public boolean containsUndeclaredUnits() {
    return libsbmlJNI.StoichiometryMath_containsUndeclaredUnits__SWIG_0(swigCPtr, this);
  }

  
  /**
   * Returns the libSBML type code of this object instance.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.StoichiometryMath_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link StoichiometryMath}, is
   * always <code>'stoichiometryMath'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'stoichiometryMath'</code>. 
   */
 public String getElementName() {
    return libsbmlJNI.StoichiometryMath_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether
   * all the required elements for this {@link StoichiometryMath} object
   * have been set.
   * <p>
   * @note The required elements for a {@link StoichiometryMath} object are:
   * math
   * <p>
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */
 public boolean hasRequiredElements() {
    return libsbmlJNI.StoichiometryMath_hasRequiredElements(swigCPtr, this);
  }

}
