/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Reaction construct.
 * <p>
 * A <em>reaction</em> represents any transformation, transport or binding
 * process, typically a chemical reaction, that can change the quantity of
 * one or more species.  In SBML, a reaction is defined primarily in terms
 * of the participating reactants and products (and their corresponding
 * stoichiometries), along with optional modifier species, an optional rate
 * at which the reaction takes place, and optional parameters.  These
 * various parts of a reaction are recorded in the {@link Reaction} object and its
 * supporting object classes: {@link KineticLaw}, {@link SpeciesReference},
 * {@link ModifierSpeciesReference}, {@link ListOfSpeciesReferences},
 * ListOfModifierSpeciesReferences, and {@link StoichiometryMath}.  It also uses
 * {@link Parameter} and {@link ListOfParameters}.
 * <p>
 * As with other major object in SBML, {@link Reaction} has a mandatory attribute,
 * 'id', used to give the compartment type an identifier.  The identifier
 * must be a text string conforming to the identifer syntax permitted in
 * SBML.  The reaction 'id' identifier can be used in mathematical
 * formulas elsewhere in an SBML model to represent the rate of that
 * reaction; this usage is explained below.  {@link Reaction} also has an optional
 * 'name' attribute, of type <code>string</code>.  The 'id' and 'name' must be used
 * according to the guidelines described in the SBML specification (e.g.,
 * Section 3.3 in the Level 2 Version 4 specification).
 * <p>
 * The species participating as reactants, products, and/or modifiers in a
 * reaction are declared using lists of {@link SpeciesReference} and/or
 * {@link ModifierSpeciesReference} instances stored in subelements
 * 'listOfReactants', 'listOfProducts' and 'listOfModifiers'.  Certain
 * restrictions are placed on the appearance of species in reaction
 * definitions:
 * <ul>
 * <li> The ability of a species to appear as a reactant or product of any
 * reaction in a model is governed by certain flags in that species'
 * definition; see the definition of {@link Species} for more information.
 * <p>
 * <li> Any species appearing in the mathematical formula of the subelement
 * 'kineticLaw' (described below) of a {@link Reaction} must be declared in at
 * least one of that {@link Reaction}'s lists of reactants, products, and/or
 * modifiers.  Put another way, it is an error for a reaction's kinetic law
 * formula to refer to species that have not been declared for that
 * reaction.
 * <p>
 * <li> A reaction definition can contain an empty list of reactants
 * <em>or</em> an empty list of products, but it must have at least one
 * reactant or product; in other words, a reaction without any reactant or
 * product species is not permitted.  (This restriction does not apply to
 * modifier species, which remain optional in all cases.)
 * </ul>
 * <p>
 * A reaction can contain up to one {@link KineticLaw} object in a subelement named
 * 'kineticLaw'.  It defines the speed at which the process defined by the
 * reaction takes place.  The description of {@link KineticLaw} provides more
 * details about its use.  Note that although the inclusion of a {@link KineticLaw}
 * object in an instance of a {@link Reaction} component is optional, there is no
 * useful default that can be substituted in place of a missing rate
 * expression in a reaction.  Moreover, a reaction's rate cannot be defined
 * in any other way in SBML&mdash;{@link InitialAssignment}, {@link AssignmentRule},
 * {@link RateRule}, {@link AlgebraicRule}, {@link Event}, and other constructs in SBML cannot be
 * used to set the reaction rate separately.  Nevertheless, for some
 * modeling applications, reactions without any defined rate can be
 * perfectly acceptable.
 * <p>
 * {@link Reaction} also has an optional boolean attribute named 'reversible' for
 * indicating whether the reaction is reversible.  The default is <code>true</code>.
 * To say that a reaction is <em>reversible</em> is to say it can proceed in
 * either the forward or the reverse direction.  Although the reversibility
 * of a reaction can sometimes be deduced by inspecting its rate
 * expression, this is not always the case, especially for complicated
 * expressions.  Moreover, the need in SBML to allow rate expressions
 * (i.e., {@link KineticLaw}) to be optional leads to the need for a separate flag
 * indicating reversibility.  Note that labeling a reaction as irreversible
 * is an assertion that the reaction always proceeds in the given forward
 * direction.  (Why else would it be flagged as irreversible?)  This
 * implies the rate expression in the {@link KineticLaw} always has a non-negative
 * value during simulations.  Software tools could provide a means of
 * optionally testing that this condition holds.  The presence of
 * reversibility information in two places (i.e., the rate expression and
 * the 'reversible' attribute on {@link Reaction}) leaves open the possibility that
 * a model could contain contradictory information, but the creation of
 * such a model would be an error on the part of the software generating
 * it.
 * <p>
 * Finally, {@link Reaction} has another optional boolean attribute called 'fast'.
 * It is used to indicate that a reaction occurs on a vastly faster time
 * scale than others in a system.  Readers are directed to the SBML Level
 * 2 Version 4 specification, which provides more detail about the
 * conditions under which a reaction can be considered to be fast in this
 * sense.  The attribute's default value is <code>false</code>.  SBML Level 1 and
 * Level 2 Version 1 incorrectly claimed that software tools could ignore
 * this attribute if they did not implement support for the corresponding
 * concept; however, further research in SBML has revealed that this is
 * not true, and 'fast' <em>cannot be ignored</em> if it is set to <code>true</code>.
 * SBML Level 2 Versions 2, 3 and 4 therefore stipulate that if a model has
 * any reactions with 'fast' set to <code>true</code>, a software tool must be able
 * to respect the attribute or else indicate to the user that it does not
 * have the capacity to do so.  Analysis software cannot ignore the value
 * of the 'fast' attribute because doing so may lead to different results
 * as compared to a software system that <em>does</em> make use of 'fast'.
 * <p>
 * Readers are urged to read the SBML specification for more details about
 * the proper use of {@link Reaction}.
 * <p>
 * <p>
 */

public class Reaction extends SBase {
   private long swigCPtr;

   protected Reaction(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGReactionUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Reaction obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Reaction obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Reaction(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link Reaction} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Reaction}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Reaction}
   * <p>
   * @note Once a {@link Reaction} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> for the document <em>override</em> those used
   * to create the {@link Reaction}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public Reaction(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Reaction__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link Reaction} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp; Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Once a {@link Reaction} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link Reaction}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public Reaction(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Reaction__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link Reaction}.
   */
 public Reaction(Reaction orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Reaction__SWIG_2(Reaction.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Reaction}.
   * <p>
   * @return a (deep) copy of this {@link Reaction}.
   */
 public Reaction cloneObject() {
    long cPtr = libsbmlJNI.Reaction_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Reaction(cPtr, true);
  }

  
  /**
   * Initializes certain attributes of this {@link Reaction} object to default
   * values.
   * <ul>
   * <li> Sets the 'reversible' attribute to <code>true</code>
   * <li> (SBML Level 1 only) Sets the 'fast' attribute to <code>false</code>
   * </ul>
   * <p>
   * @warning The 'fast' attribute must be used with care.  SBML
   * definitions before SBML Level 2 Version 2 incorrectly indicated that
   * software tools could ignore this attribute if they did not implement
   * support for the corresponding concept; however, further research in
   * SBML has revealed that this is not true, and 'fast' <em>cannot be
   * ignored</em> if it is set to <code>true</code>.  SBML Level 2 Versions 2, 3 and 4
   * therefore stipulate that if a model has any reactions with 'fast' set
   * to <code>true</code>, a software tool must be able to respect the attribute or
   * else indicate to the user that it does not have the capacity to do so.
   * Readers are directed to the SBML Level 2 Version 4 specification,
   * which provides more detail about the conditions under which a reaction
   * can be considered to be fast in this sense.
   */
 public void initDefaults() {
    libsbmlJNI.Reaction_initDefaults(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'id' attribute of this {@link Reaction}.
   * <p>
   * @return the id of this {@link Reaction}.
   */
 public String getId() {
    return libsbmlJNI.Reaction_getId(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'name' attribute of this {@link Reaction}.
   * <p>
   * @return the name of this {@link Reaction}.
   */
 public String getName() {
    return libsbmlJNI.Reaction_getName(swigCPtr, this);
  }

  
  /**
   * Returns the {@link KineticLaw} object contained in this {@link Reaction}.
   * <p>
   * @return the {@link KineticLaw} instance.
   */
 public KineticLaw getKineticLaw() {
    long cPtr = libsbmlJNI.Reaction_getKineticLaw__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new KineticLaw(cPtr, false);
  }

  
  /**
   * Returns the value of the 'reversible' attribute on the {@link Reaction} as a
   * boolean value.
   * <p>
   * @return the reversibility status of this {@link Reaction}.
   */
 public boolean getReversible() {
    return libsbmlJNI.Reaction_getReversible(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'fast' attribute of this {@link Reaction}.
   * <p>
   * @return the 'fast' status of this {@link Reaction}.
   * <p>
   * @warning SBML definitions before SBML Level 2 Version 2 incorrectly
   * indicated that software tools could ignore this attribute if they did
   * not implement support for the corresponding concept; however, further
   * research in SBML has revealed that this is not true, and 'fast'
   * <em>cannot be ignored</em> if it is set to <code>true</code>.  SBML Level 2
   * Versions 2, 3 and 4 therefore stipulate that if a model has any reactions
   * with 'fast' set to <code>true</code>, a software tool must be able to respect
   * the attribute or else indicate to the user that it does not have the
   * capacity to do so.  Readers are directed to the SBML Level 2 Version
   * 4 specification, which provides more detail about the conditions under
   * which a reaction can be considered to be fast in this sense.
   */
 public boolean getFast() {
    return libsbmlJNI.Reaction_getFast(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Reaction}'s 'id' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'id' attribute of this {@link Reaction} has been
   * set, <code>false</code> otherwise.
   */
 public boolean isSetId() {
    return libsbmlJNI.Reaction_isSetId(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Reaction}'s 'name' attribute has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'name' attribute of this {@link Reaction} has been
   * set, <code>false</code> otherwise.
   */
 public boolean isSetName() {
    return libsbmlJNI.Reaction_isSetName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Reaction} contains a kinetic law object.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if a {@link KineticLaw} is present in this {@link Reaction},, <code>false</code>
   * otherwise.
   */
 public boolean isSetKineticLaw() {
    return libsbmlJNI.Reaction_isSetKineticLaw(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on the value of
   * the 'fast' attribute on this {@link Reaction}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'fast' attribute is true, <code>false</code> otherwise.
   * <p>
   * @warning SBML definitions before SBML Level 2 Version 2 incorrectly
   * indicated that software tools could ignore this attribute if they did
   * not implement support for the corresponding concept; however, further
   * research in SBML has revealed that this is not true, and 'fast'
   * <em>cannot be ignored</em> if it is set to <code>true</code>.  SBML Level 2
   * Versions 2, 3 and 4 therefore stipulate that if a model has any reactions
   * with 'fast' set to <code>true</code>, a software tool must be able to respect
   * the attribute or else indicate to the user that it does not have the
   * capacity to do so.  Readers are directed to the SBML Level 2 Version
   * 4 specification, which provides more detail about the conditions under
   * which a reaction can be considered to be fast in this sense.  Note
   * also that in SBML Level 1, 'fast' is defined as optional with a
   * default of <code>false</code>, which means it is effectively always set.
   */
 public boolean isSetFast() {
    return libsbmlJNI.Reaction_isSetFast(swigCPtr, this);
  }

  
  /**
   * Sets the value of the 'id' attribute of this {@link Reaction}.
   * <p>
   * The string <code>sid</code> is copied.  Note that SBML has strict requirements
   * for the syntax of identifiers.  The following is summary of the
   * definition of the SBML identifier type <code>SId</code> (here expressed in an
   * extended form of BNF notation):
   * <div class='fragment'><pre>
   *   letter .= 'a'..'z','A'..'Z'
   *   digit  .= '0'..'9'
   *   idChar .= letter | digit | '_'
   *   SId    .= ( letter | '_' ) idChar</pre></div>
   * The equality of SBML identifiers is determined by an exact character
   * sequence match; i.e., comparisons must be performed in a
   * case-sensitive manner.  In addition, there are a few conditions for
   * the uniqueness of identifiers in an SBML model.  Please consult the
   * SBML specifications for the exact formulations.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the string to use as the identifier of this {@link Reaction}
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
 public int setId(String sid) {
    return libsbmlJNI.Reaction_setId(swigCPtr, this, sid);
  }

  
  /**
   * Sets the value of the 'name' attribute of this {@link Reaction}.
   * <p>
   * The string in <code>name</code> is copied.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param name the new name for the {@link Reaction}
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_INVALID_ATTRIBUTE_VALUE
   */
 public int setName(String name) {
    return libsbmlJNI.Reaction_setName(swigCPtr, this, name);
  }

  
  /**
   * Sets the 'kineticLaw' subelement of this {@link Reaction} to a copy of the
   * given {@link KineticLaw} object.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param kl the {@link KineticLaw} object to use.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_LEVEL_MISMATCH
   * <li> LIBSBML_VERSION_MISMATCH
  */
 public int setKineticLaw(KineticLaw kl) {
    return libsbmlJNI.Reaction_setKineticLaw(swigCPtr, this, KineticLaw.getCPtr(kl), kl);
  }

  
  /**
   * Sets the value of the 'reversible' attribute of this {@link Reaction}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param value the value of the 'reversible' attribute.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   */
 public int setReversible(boolean value) {
    return libsbmlJNI.Reaction_setReversible(swigCPtr, this, value);
  }

  
  /**
   * Sets the value of the 'fast' attribute of this {@link Reaction}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param value the value of the 'fast' attribute.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <p>
   * @warning SBML definitions before SBML Level 2 Version 2 incorrectly
   * indicated that software tools could ignore this attribute if they did
   * not implement support for the corresponding concept; however, further
   * research in SBML has revealed that this is not true, and 'fast'
   * <em>cannot be ignored</em> if it is set to <code>true</code>.  SBML Level 2
   * Versions 2, 3 and 4 therefore stipulate that if a model has any reactions
   * with 'fast' set to <code>true</code>, a software tool must be able to respect
   * the attribute or else indicate to the user that it does not have the
   * capacity to do so.  Readers are directed to the SBML Level 2 Version
   * 4 specification, which provides more detail about the conditions under
   * which a reaction can be considered to be fast in this sense.
   */
 public int setFast(boolean value) {
    return libsbmlJNI.Reaction_setFast(swigCPtr, this, value);
  }

  
  /**
   * Unsets the value of the 'name' attribute of this {@link Reaction}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   */
 public int unsetName() {
    return libsbmlJNI.Reaction_unsetName(swigCPtr, this);
  }

  
  /**
   * Unsets the 'kineticLaw' subelement of this {@link Reaction}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   */
 public int unsetKineticLaw() {
    return libsbmlJNI.Reaction_unsetKineticLaw(swigCPtr, this);
  }

  
  /**
   * Unsets the value of the 'fast' attribute of this {@link Reaction}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @warning In SBML Level 1, 'fast' is optional with a default of 
   * <code>false</code>, which means it is effectively always set (and reset to <code>false</code>
   * if this method is called).  Further, SBML definitions before SBML
   * Level 2 Version 2 incorrectly indicated that software tools could
   * ignore this attribute if they did not implement support for the
   * corresponding concept; however, further research in SBML has revealed
   * that this is not true, and 'fast' <em>cannot be ignored</em> if it is
   * set to <code>true</code>.  SBML Level 2 Versions 2, 3 and 4 therefore stipulate
   * that if a model has any reactions with 'fast' set to <code>true</code>, a
   * software tool must be able to respect the attribute or else indicate
   * to the user that it does not have the capacity to do so.  Readers are
   * directed to the SBML Level 2 Version 4 specification, which provides
   * more detail about the conditions under which a reaction can be
   * considered to be fast in this sense.
   */
 public int unsetFast() {
    return libsbmlJNI.Reaction_unsetFast(swigCPtr, this);
  }

  
  /**
   * Adds a given {@link SpeciesReference} object as a reactant in this {@link Reaction}.
   * <p>
   * The {@link SpeciesReference} instance in <code>sr</code> is copied.
   * <p>
   * @param sr a {@link SpeciesReference} object referring to a {@link Species} in the
   * enclosing {@link Model}
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_LEVEL_MISMATCH
   * <li> LIBSBML_VERSION_MISMATCH
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Reaction}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Reaction}</em>.  In addition, the caller should make
   * sure to free the original object if it is no longer being used, or
   * else a memory leak will result.  Please see Reaction.createReactant()
   * for a method that does not lead to these issues.
   * <p>
   * @see #createReactant()
   */
 public int addReactant(SpeciesReference sr) {
    return libsbmlJNI.Reaction_addReactant(swigCPtr, this, SpeciesReference.getCPtr(sr), sr);
  }

  
  /**
   * Adds a given {@link SpeciesReference} object as a product in this {@link Reaction}.
   * <p>
   * The {@link SpeciesReference} instance in <code>sr</code> is copied.
   * <p>
   * @param sr a {@link SpeciesReference} object referring to a {@link Species} in the
   * enclosing {@link Model}
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_LEVEL_MISMATCH
   * <li> LIBSBML_VERSION_MISMATCH
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Reaction}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Reaction}</em>.  In addition, the caller should make
   * sure to free the original object if it is no longer being used, or
   * else a memory leak will result.  Please see Reaction.createProduct()
   * for a method that does not lead to these issues.
   * <p>
   * @see #createProduct()
   */
 public int addProduct(SpeciesReference sr) {
    return libsbmlJNI.Reaction_addProduct(swigCPtr, this, SpeciesReference.getCPtr(sr), sr);
  }

  
  /**
   * Adds a given {@link ModifierSpeciesReference} object as a product in this
   * {@link Reaction}.
   * <p>
   * The {@link ModifierSpeciesReference} instance in <code>msr</code> is copied.
   * <p>
   * @param msr a {@link ModifierSpeciesReference} object referring to a {@link Species} in
   * the enclosing {@link Model}
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   * <li> LIBSBML_LEVEL_MISMATCH
   * <li> LIBSBML_VERSION_MISMATCH
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Reaction}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Reaction}</em>.  In addition, the caller should make
   * sure to free the original object if it is no longer being used, or
   * else a memory leak will result.  Please see Reaction.createModifier()
   * for a method that does not lead to these issues.
   * <p>
   * @see #createModifier()
   */
 public int addModifier(ModifierSpeciesReference msr) {
    return libsbmlJNI.Reaction_addModifier(swigCPtr, this, ModifierSpeciesReference.getCPtr(msr), msr);
  }

  
  /**
   * Creates a new {@link SpeciesReference}, adds it to this {@link Reaction}'s list of
   * reactants, and returns it.
   * <p>
   * @return a new {@link SpeciesReference} object.
   */
 public SpeciesReference createReactant() {
    long cPtr = libsbmlJNI.Reaction_createReactant(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
  /**
   * Creates a new {@link SpeciesReference}, adds it to this {@link Reaction}'s list of
   * products, and returns it.
   * <p>
   * @return a new {@link SpeciesReference} object.
   */
 public SpeciesReference createProduct() {
    long cPtr = libsbmlJNI.Reaction_createProduct(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
  /**
   * Creates a new {@link ModifierSpeciesReference}, adds it to this {@link Reaction}'s
   * list of modifiers and returns it.
   * <p>
   * @return a new {@link ModifierSpeciesReference} object.
   */
 public ModifierSpeciesReference createModifier() {
    long cPtr = libsbmlJNI.Reaction_createModifier(swigCPtr, this);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, false);
  }

  
  /**
   * Creates a new {@link KineticLaw} object, installs it as this {@link Reaction}'s
   * 'kineticLaw' subelement, and returns it.
   * <p>
   * If this {@link Reaction} had a previous {@link KineticLaw}, it will be destroyed.
   * <p>
   * @return the new {@link KineticLaw} object
   */
 public KineticLaw createKineticLaw() {
    long cPtr = libsbmlJNI.Reaction_createKineticLaw(swigCPtr, this);
    return (cPtr == 0) ? null : new KineticLaw(cPtr, false);
  }

  
  /**
   * Returns the list of reactants in this {@link Reaction} object.
   * <p>
   * @return the {@link ListOfSpeciesReferences} containing the references to the
   * species acting as reactants in this reaction
   */
 public ListOfSpeciesReferences getListOfReactants() {
    long cPtr = libsbmlJNI.Reaction_getListOfReactants__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfSpeciesReferences(cPtr, false);
  }

  
  /**
   * Returns the list of products in this {@link Reaction} object.
   * <p>
   * @return the {@link ListOfSpeciesReferences} containing the references to the
   * species acting as products in this reaction
   */
 public ListOfSpeciesReferences getListOfProducts() {
    long cPtr = libsbmlJNI.Reaction_getListOfProducts__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfSpeciesReferences(cPtr, false);
  }

  
  /**
   * Returns the list of modifiers in this {@link Reaction} object.
   * <p>
   * @return the {@link ListOfSpeciesReferences} containing the references to the
   * species acting as modifiers in this reaction
   */
 public ListOfSpeciesReferences getListOfModifiers() {
    long cPtr = libsbmlJNI.Reaction_getListOfModifiers__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfSpeciesReferences(cPtr, false);
  }

  
  /**
   * Returns the nth reactant species (as a {@link SpeciesReference} object) in 
   * the list of reactants in this {@link Reaction}.
   * <p>
   * Callers should first call getNumReactants() to find out how many
   * reactants there are, to avoid using an invalid index number.
   * <p>
   * @param n the index of the reactant sought.
   * <p>
   * @return the nth reactant (as a {@link SpeciesReference} object) of this
   * {@link Reaction}.
   */
 public SpeciesReference getReactant(long n) {
    long cPtr = libsbmlJNI.Reaction_getReactant__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
  /**
   * Returns the reactant species (as a {@link SpeciesReference} object) having 
   * a specific identifier in this {@link Reaction}.
   * <p>
   * @param species the identifier of the reactant {@link Species} ('species' 
   * attribute of the reactant {@link SpeciesReference} object)
   * <p>
   * @return a {@link SpeciesReference} object, or NULL if no species with the
   * given identifier <code>species</code> appears as a reactant in this {@link Reaction}.
   */
 public SpeciesReference getReactant(String species) {
    long cPtr = libsbmlJNI.Reaction_getReactant__SWIG_2(swigCPtr, this, species);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
  /**
   * Returns the nth product species (as a {@link SpeciesReference} object) in 
   * the list of products in this {@link Reaction}.
   * <p>
   * Callers should first call getNumProducts() to find out how many
   * products there are, to avoid using an invalid index number.
   * <p>
   * @param n the index of the product sought.
   * <p>
   * @return the nth product (as a {@link SpeciesReference} object) of this
   * {@link Reaction}.
   */
 public SpeciesReference getProduct(long n) {
    long cPtr = libsbmlJNI.Reaction_getProduct__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
  /**
   * Returns the product species (as a {@link SpeciesReference} object) having 
   * a specific identifier in this {@link Reaction}.
   * <p>
   * @param species the identifier of the product {@link Species} ('species'
   * attribute of the product {@link SpeciesReference} object)
   * <p>
   * @return a {@link SpeciesReference} object, or NULL if no species with the
   * given identifier <code>species</code> appears as a product in this {@link Reaction}.
   */
 public SpeciesReference getProduct(String species) {
    long cPtr = libsbmlJNI.Reaction_getProduct__SWIG_2(swigCPtr, this, species);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
  /**
   * Returns the nth modifier species (as a {@link ModifierSpeciesReference} object) 
   * in the list of modifiers of this {@link Reaction}.
   * <p>
   * Callers should first call getNumModifiers() to find out how many
   * modifiers there are, to avoid using an invalid index number.
   * <p>
   * @param n the index of the modifier species sought
   * <p>
   * @return the nth modifier (as a {@link ModifierSpeciesReference} object) of
   * this {@link Reaction}.
   */
 public ModifierSpeciesReference getModifier(long n) {
    long cPtr = libsbmlJNI.Reaction_getModifier__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, false);
  }

  
  /**
   * Returns the modifier species (as a {@link ModifierSpeciesReference} object) 
   * having a specific identifier in this {@link Reaction}.
   * <p>
   * @param species the identifier of the modifier {@link Species} ('species' 
   * attribute of the {@link ModifierSpeciesReference} object)
   * <p>
   * @return a {@link ModifierSpeciesReference} object, or NULL if no species with
   * the given identifier <code>species</code> appears as a modifier in this
   * {@link Reaction}.
   */
 public ModifierSpeciesReference getModifier(String species) {
    long cPtr = libsbmlJNI.Reaction_getModifier__SWIG_2(swigCPtr, this, species);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, false);
  }

  
  /**
   * Returns the number of reactant species in this {@link Reaction}.
   * <p>
   * @return the number of reactants in this {@link Reaction}.
   */
 public long getNumReactants() {
    return libsbmlJNI.Reaction_getNumReactants(swigCPtr, this);
  }

  
  /**
   * Returns the number of product species in this {@link Reaction}.
   * <p>
   * @return the number of products in this {@link Reaction}.
   */
 public long getNumProducts() {
    return libsbmlJNI.Reaction_getNumProducts(swigCPtr, this);
  }

  
  /**
   * Returns the number of modifier species in this {@link Reaction}.
   * <p>
   * @return the number of modifiers in this {@link Reaction}.
   */
 public long getNumModifiers() {
    return libsbmlJNI.Reaction_getNumModifiers(swigCPtr, this);
  }

  
  /**
   * Removes the nth reactant species (SpeciesReference object) in the list of 
   * reactants in this {@link Reaction} and returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * The caller should first call getNumReactants() to find out how many
   * reactants there are, to avoid using an invalid index number.
   * <p>
   * @param n the index of the reactant {@link SpeciesReference} object to remove
   * <p>
   * @return the removed reactant {@link SpeciesReference} object, or NULL if the 
   * given index is out of range.
   */
 public SpeciesReference removeReactant(long n) {
    long cPtr = libsbmlJNI.Reaction_removeReactant__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, true);
  }

  
  /**
   * Removes the reactant species (SpeciesReference object) having the given  
   * 'species' attribute in this {@link Reaction} and returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * <p>
   * @param species the 'species' attribute of the reactant {@link SpeciesReference} 
   * object
   * <p>
   * @return the removed reactant {@link SpeciesReference} object, or NULL if no 
   * reactant {@link SpeciesReference} object with the given 'species' attribute 
   * <code>species</code> exists in this {@link Reaction}.
   */
 public SpeciesReference removeReactant(String species) {
    long cPtr = libsbmlJNI.Reaction_removeReactant__SWIG_1(swigCPtr, this, species);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, true);
  }

  
  /**
   * Removes the nth product species (SpeciesReference object) in the list of 
   * products in this {@link Reaction} and returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * The caller should first call getNumProducts() to find out how many
   * products there are, to avoid using an invalid index number.
   * <p>
   * @param n the index of the product {@link SpeciesReference} object to remove
   * <p>
   * @return the removed product {@link SpeciesReference} object, or NULL if the 
   * given index is out of range.
   */
 public SpeciesReference removeProduct(long n) {
    long cPtr = libsbmlJNI.Reaction_removeProduct__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, true);
  }

  
  /**
   * Removes the product species (SpeciesReference object) having the given  
   * 'species' attribute in this {@link Reaction} and returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * <p>
   * @param species the 'species' attribute of the product {@link SpeciesReference} 
   * object
   * <p>
   * @return the removed product {@link SpeciesReference} object, or NULL if no 
   * product {@link SpeciesReference} object with the given 'species' attribute 
   * <code>species</code> exists in this {@link Reaction}.
   */
 public SpeciesReference removeProduct(String species) {
    long cPtr = libsbmlJNI.Reaction_removeProduct__SWIG_1(swigCPtr, this, species);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, true);
  }

  
  /**
   * Removes the nth modifier species (ModifierSpeciesReference object) in 
   * the list of  modifiers in this {@link Reaction} and returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * The caller should first call getNumModifiers() to find out how many
   * modifiers there are, to avoid using an invalid index number.
   * <p>
   * @param n the index of the {@link ModifierSpeciesReference} object to remove
   * <p>
   * @return the removed {@link ModifierSpeciesReference} object, or NULL if the 
   * given index is out of range.
   */
 public ModifierSpeciesReference removeModifier(long n) {
    long cPtr = libsbmlJNI.Reaction_removeModifier__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, true);
  }

  
  /**
   * Removes the modifier species (ModifierSpeciesReference object) having 
   * the given 'species' attribute in this {@link Reaction} and returns a pointer to it.
   * <p>
   * The caller owns the returned object and is responsible for deleting it.
   * <p>
   * @param species the 'species' attribute of the {@link ModifierSpeciesReference} 
   * object
   * <p>
   * @return the removed {@link ModifierSpeciesReference} object, or NULL if no 
   * {@link ModifierSpeciesReference} object with the given 'species' attribute @p 
   * species exists in this {@link Reaction}.
   */
 public ModifierSpeciesReference removeModifier(String species) {
    long cPtr = libsbmlJNI.Reaction_removeModifier__SWIG_1(swigCPtr, this, species);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, true);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Reaction_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Reaction}, is
   * always <code>'reaction'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'reaction'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.Reaction_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether
   * all the required attributes for this {@link Reaction} object
   * have been set.
   * <p>
   * @note The required attributes for a {@link Reaction} object are:
   * id
   * <p>
   * @return a boolean value indicating whether all the required
   * attributes for this object have been defined.
   */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.Reaction_hasRequiredAttributes(swigCPtr, this);
  }

}
