/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's SpeciesReference construct.
 * <p>
 * The {@link Reaction} structure provides a way to express which species act as
 * reactants and which species act as products in a reaction.  In a given
 * reaction, references to those species acting as reactants and/or
 * products are made using instances of {@link SpeciesReference} structures in a
 * {@link Reaction} object's lists of reactants and products.
 * <p>
 * The mandatory 'species' attribute of {@link SpeciesReference} must have as its
 * value the identifier of an existing species defined in the enclosing
 * {@link Model}.  The species is thereby designated as a reactant or product in
 * the reaction.  Which one it is (i.e., reactant or product) is indicated
 * by whether the {@link SpeciesReference} appears in the {@link Reaction}'s 'reactant' or
 * 'product' lists.
 * <p>
 * Product and reactant stoichiometries can be specified using
 * <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
 * {@link SpeciesReference} object.  The 'stoichiometry' attribute is of type
 * double and should contain values greater than zero (0).  The
 * 'stoichiometryMath' element is implemented as an element containing a
 * MathML expression.  These two are mutually exclusive; only one of
 * 'stoichiometry' or 'stoichiometryMath' should be defined in a given
 * {@link SpeciesReference} instance.  When neither the attribute nor the element
 * is present, the value of 'stoichiometry' in the {@link SpeciesReference}
 * instance defaults to <code>1</code>.
 * <p>
 * For maximum interoperability, the 'stoichiometry' attribute should be
 * used in preference to 'stoichiometryMath' when a species' stoichiometry
 * is a simple scalar number (integer or decimal).  When the stoichiometry
 * is a rational number, or when it is a more complicated formula,
 * 'stoichiometryMath' must be used.  The MathML expression in
 * 'stoichiometryMath' may also refer to identifiers of entities in a model
 * (except reaction identifiers).  However, the only species identifiers
 * that can be used in 'stoichiometryMath' are those referenced in the
 * {@link Reaction} list of reactants, products and modifiers.
 * <p>
 * The following is a simple example of a species reference for species 
 * <code>X0</code>, with stoichiometry <code>2</code>, in a list of reactants within a reaction
 * having the identifier <code>J1</code>:
 * <div class='fragment'><pre>
 * &lt;model&gt;
 *     ...
 *     &lt;listOfReactions&gt;
 *         &lt;reaction id='J1'&gt;
 *             &lt;listOfReactants&gt;
 *                 &lt;speciesReference species='X0' stoichiometry='2'&gt;
 *             &lt;/listOfReactants&gt;
 *             ...
 *         &lt;/reaction&gt;
 *         ...
 *     &lt;/listOfReactions&gt;
 *     ...
 * &lt;/model&gt;</pre></div>
 * <p>
 * The following is a more complex example of a species reference for
 * species X0, with a stoichiometry formula consisting of the parameter
 * <code>x</code>:
 * <div class='fragment'><pre>
 * &lt;model&gt;
 *     ...
 *     &lt;listOfReactions&gt;
 *         &lt;reaction id='J1'&gt;
 *             &lt;listOfReactants&gt;
 *                 &lt;speciesReference species='X0'&gt;
 *                     &lt;stoichiometryMath&gt;
 *                         &lt;math xmlns='http://www.w3.org/1998/Math/MathML'&gt;
 *                             &lt;ci&gt;x&lt;/ci&gt;
 *                         &lt;/math&gt;
 *                     &lt;/stoichiometryMath&gt;
 *                 &lt;/speciesReference&gt;
 *             &lt;/listOfReactants&gt;
 *             ...
 *         &lt;/reaction&gt;
 *         ...
 *     &lt;/listOfReactions&gt;
 *     ...
 * &lt;/model&gt;</pre></div>
 * <p>
 * A species can occur more than once in the lists of reactants and
 * products of a given {@link Reaction} instance.  The effective stoichiometry for
 * a species in a reaction is the sum of the stoichiometry values given on
 * the {@link SpeciesReference} object in the list of products minus the sum of
 * stoichiometry values given on the {@link SpeciesReference} objects in the list
 * of reactants.  A positive value indicates the species is effectively a
 * product and a negative value indicates the species is effectively a
 * reactant.  SBML places no restrictions on the effective stoichiometry of
 * a species in a reaction; for example, it can be zero.  In the following
 * SBML fragment, the two reactions have the same effective stoichiometry
 * for all their species:
 * <div class='fragment'><pre>
 * &lt;reaction id='x'&gt;
 *     &lt;listOfReactants&gt;
 *         &lt;speciesReference species='a'/&gt;
 *         &lt;speciesReference species='a'/&gt;
 *         &lt;speciesReference species='b'/&gt;
 *     &lt;/listOfReactants&gt;
 *     &lt;listOfProducts&gt;
 *         &lt;speciesReference species='c'/&gt;
 *         &lt;speciesReference species='b'/&gt;
 *     &lt;/listProducts&gt;
 * &lt;/reaction&gt;
 * &lt;reaction id='y'&gt;
 *     &lt;listOfReactants&gt;
 *         &lt;speciesReference species='a' stoichiometry='2'/&gt;
 *     &lt;/listOfReactants&gt;
 *     &lt;listOfProducts&gt;
 *         &lt;speciesReference species='c'/&gt;
 *     &lt;/listProducts&gt;
 * &lt;/reaction&gt;</pre></div>
 * <p>
 * <p>
 * <!---------------------------------------------------------------------- -->
 * <p>
 */

public class SpeciesReference extends SimpleSpeciesReference {
   private long swigCPtr;

   protected SpeciesReference(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGSpeciesReferenceUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SpeciesReference obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SpeciesReference obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_SpeciesReference(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link SpeciesReference} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link SpeciesReference}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link SpeciesReference}
   * <p>
   * @note Once a {@link SpeciesReference} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> for the document <em>override</em> those used
   * to create the {@link SpeciesReference}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public SpeciesReference(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_SpeciesReference__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link SpeciesReference} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Once a {@link SpeciesReference} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link SpeciesReference}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public SpeciesReference(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_SpeciesReference__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link SpeciesReference}.
   */
 public SpeciesReference(SpeciesReference orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_SpeciesReference__SWIG_2(SpeciesReference.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link SpeciesReference} instance.
   * <p>
   * @return a (deep) copy of this {@link SpeciesReference}.
   */
 public SpeciesReference cloneObject() {
    long cPtr = libsbmlJNI.SpeciesReference_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, true);
  }

  
  /**
   * Initializes the attributes of this {@link SpeciesReference} to their defaults.
   * <ul>
   * <li> stoichiometry is set to <code>1</code>
   * <li> denominator is set to <code>1</code>
   * </ul>
   * <p>
   * @see #getDenominator()
   * @see #setDenominator(int value)
   * @see #getStoichiometry()
   * @see #setStoichiometry(double value)
   * @see #getStoichiometryMath()
   * @see #setStoichiometryMath(StoichiometryMath  math)
   */
 public void initDefaults() {
    libsbmlJNI.SpeciesReference_initDefaults(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'stoichiometry' attribute.
   * <p>
   * In SBML Level 2, Product and reactant stoichiometries can be specified
   * using <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
   * {@link SpeciesReference} object.  The former is to be used when a
   * stoichiometry is simply a scalar number, while the latter is for
   * occasions when it needs to be a rational number or it needs to
   * reference other mathematical expressions.  The 'stoichiometry'
   * attribute is of type double and should contain values greater than
   * zero (0).  The 'stoichiometryMath' element is implemented as an
   * element containing a MathML expression.  These two are mutually
   * exclusive; only one of 'stoichiometry' or 'stoichiometryMath' should
   * be defined in a given {@link SpeciesReference} instance.  When neither the
   * attribute nor the element is present, the value of 'stoichiometry' in
   * the {@link SpeciesReference} instance defaults to <code>1</code>.  For maximum
   * interoperability between different software tools, the 'stoichiometry'
   * attribute should be * used in preference to 'stoichiometryMath' when a
   * species' stoichiometry * is a simple scalar number (integer or
   * decimal).
   * <p>
   * @return the value of the (scalar) 'stoichiometry' attribute of this
   * {@link SpeciesReference}.
   * <p>
   * @see #getStoichiometryMath()
   */
 public double getStoichiometry() {
    return libsbmlJNI.SpeciesReference_getStoichiometry(swigCPtr, this);
  }

  
  /**
   * Get the content of the 'stoichiometryMath' subelement as an {@link ASTNode}
   * tree.
   * <p>
   * In SBML Level 2, Product and reactant stoichiometries can be specified
   * using <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
   * {@link SpeciesReference} object.  The former is to be used when a
   * stoichiometry is simply a scalar number, while the latter is for
   * occasions when it needs to be a rational number or it needs to
   * reference other mathematical expressions.  The 'stoichiometry'
   * attribute is of type double and should contain values greater than
   * zero (0).  The 'stoichiometryMath' element is implemented as an
   * element containing a MathML expression.  These two are mutually
   * exclusive; only one of 'stoichiometry' or 'stoichiometryMath' should
   * be defined in a given {@link SpeciesReference} instance.  When neither the
   * attribute nor the element is present, the value of 'stoichiometry' in
   * the {@link SpeciesReference} instance defaults to <code>1</code>.  For maximum
   * interoperability between different software tools, the 'stoichiometry'
   * attribute should be used in preference to 'stoichiometryMath' when a
   * species' stoichiometry is a simple scalar number (integer or
   * decimal).
   * <p>
   * @return the content of the 'stoichiometryMath' subelement of this
   * {@link SpeciesReference}.
   */
 public StoichiometryMath getStoichiometryMath() {
    long cPtr = libsbmlJNI.SpeciesReference_getStoichiometryMath__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new StoichiometryMath(cPtr, false);
  }

  
  /**
   * Get the value of the 'denominator' attribute, for the case of a
   * rational-numbered stoichiometry or a model in SBML Level 1.
   * <p>
   * The 'denominator' attribute is only actually written out in the case
   * of an SBML Level 1 model.  In SBML Level 2, rational-number
   * stoichiometries are written as MathML elements in the
   * 'stoichiometryMath' subelement.  However, as a convenience to users,
   * libSBML allows the creation and manipulation of rational-number
   * stoichiometries by supplying the numerator and denominator directly
   * rather than having to manually create an {@link ASTNode} structure.  LibSBML
   * will write out the appropriate constructs (either a combination of
   * 'stoichiometry' and 'denominator' in the case of SBML Level 1, or a
   * 'stoichiometryMath' subelement in the case of SBML Level 2).
   * <p>
   * @return the value of the 'denominator' attribute of this
   * {@link SpeciesReference}.
   */
 public int getDenominator() {
    return libsbmlJNI.SpeciesReference_getDenominator(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link SpeciesReference}'s 'stoichiometryMath' subelement has been set
   * <p>
   * @return <code>true</code> if the 'stoichiometryMath' subelement of this
   * {@link SpeciesReference} has been set, <code>false</code> otherwise.
   */
 public boolean isSetStoichiometryMath() {
    return libsbmlJNI.SpeciesReference_isSetStoichiometryMath(swigCPtr, this);
  }

  
  /**
   * Sets the value of the 'stoichiometry' attribute of this
   * {@link SpeciesReference}.
   * <p>
   * In SBML Level 2, Product and reactant stoichiometries can be specified
   * using <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
   * {@link SpeciesReference} object.  The former is to be used when a
   * stoichiometry is simply a scalar number, while the latter is for
   * occasions when it needs to be a rational number or it needs to
   * reference other mathematical expressions.  The 'stoichiometry'
   * attribute is of type double and should contain values greater than
   * zero (0).  The 'stoichiometryMath' element is implemented as an
   * element containing a MathML expression.  These two are mutually
   * exclusive; only one of 'stoichiometry' or 'stoichiometryMath' should
   * be defined in a given {@link SpeciesReference} instance.  When neither the
   * attribute nor the element is present, the value of 'stoichiometry' in
   * the {@link SpeciesReference} instance defaults to <code>1</code>.  For maximum
   * interoperability between different software tools, the 'stoichiometry'
   * attribute should be used in preference to 'stoichiometryMath' when a
   * species' stoichiometry is a simple scalar number (integer or
   * decimal).
   * <p>
   * @param value the new value of the 'stoichiometry' attribute
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   */
 public int setStoichiometry(double value) {
    return libsbmlJNI.SpeciesReference_setStoichiometry(swigCPtr, this, value);
  }

  
  /**
   * Sets the 'stoichiometryMath' subelement of this {@link SpeciesReference}.
   * <p>
   * The Abstract Syntax Tree in <code>math</code> is copied.
   * <p>
   * In SBML Level 2, Product and reactant stoichiometries can be specified
   * using <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
   * {@link SpeciesReference} object.  The former is to be used when a
   * stoichiometry is simply a scalar number, while the latter is for
   * occasions when it needs to be a rational number or it needs to
   * reference other mathematical expressions.  The 'stoichiometry'
   * attribute is of type double and should contain values greater than
   * zero (0).  The 'stoichiometryMath' element is implemented as an
   * element containing a MathML expression.  These two are mutually
   * exclusive; only one of 'stoichiometry' or 'stoichiometryMath' should
   * be defined in a given {@link SpeciesReference} instance.  When neither the
   * attribute nor the element is present, the value of 'stoichiometry' in
   * the {@link SpeciesReference} instance defaults to <code>1</code>.  For maximum
   * interoperability between different software tools, the 'stoichiometry'
   * attribute should be used in preference to 'stoichiometryMath' when a
   * species' stoichiometry is a simple scalar number (integer or
   * decimal).
   * <p>
   * @param math the {@link StoichiometryMath} expression that is to be copied as the
   * content of the 'stoichiometryMath' subelement.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_UNEXPECTED_ATTRIBUTE
   * <li> LIBSBML_LEVEL_MISMATCH
   * <li> LIBSBML_VERSION_MISMATCH
   */
 public int setStoichiometryMath(StoichiometryMath math) {
    return libsbmlJNI.SpeciesReference_setStoichiometryMath(swigCPtr, this, StoichiometryMath.getCPtr(math), math);
  }

  
  /**
   * Set the value of the 'denominator' attribute, for the case of a
   * rational-numbered stoichiometry or a model in SBML Level 1.
   * <p>
   * The 'denominator' attribute is only actually written out in the case
   * of an SBML Level 1 model.  In SBML Level 2, rational-number
   * stoichiometries are written as MathML elements in the
   * 'stoichiometryMath' subelement.  However, as a convenience to users,
   * libSBML allows the creation and manipulation of rational-number
   * stoichiometries by supplying the numerator and denominator directly
   * rather than having to manually create an {@link ASTNode} structure.  LibSBML
   * will write out the appropriate constructs (either a combination of
   * 'stoichiometry' and 'denominator' in the case of SBML Level 1, or a
   * 'stoichiometryMath' subelement in the case of SBML Level 2).
   * <p>
   * @param value the scalar value 
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   */
 public int setDenominator(int value) {
    return libsbmlJNI.SpeciesReference_setDenominator(swigCPtr, this, value);
  }

  
  /**
   * Unsets the 'stoichiometryMath' subelement of this {@link SpeciesReference}.
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * In SBML Level 2, Product and reactant stoichiometries can be specified
   * using <em>either</em> 'stoichiometry' or 'stoichiometryMath' in a
   * {@link SpeciesReference} object.  The former is to be used when a
   * stoichiometry is simply a scalar number, while the latter is for
   * occasions when it needs to be a rational number or it needs to
   * reference other mathematical expressions.  The 'stoichiometry'
   * attribute is of type double and should contain values greater than
   * zero (0).  The 'stoichiometryMath' element is implemented as an
   * element containing a MathML expression.  These two are mutually
   * exclusive; only one of 'stoichiometry' or 'stoichiometryMath' should
   * be defined in a given {@link SpeciesReference} instance.  When neither the
   * attribute nor the element is present, the value of 'stoichiometry' in
   * the {@link SpeciesReference} instance defaults to <code>1</code>.  For maximum
   * interoperability between different software tools, the 'stoichiometry'
   * attribute should be used in preference to 'stoichiometryMath' when a
   * species' stoichiometry is a simple scalar number (integer or
   * decimal).
   * <p>
   */
 public int unsetStoichiometryMath() {
    return libsbmlJNI.SpeciesReference_unsetStoichiometryMath(swigCPtr, this);
  }

  
  /**
   * Creates a new, empty {@link StoichiometryMath}, adds it to this {@link SpeciesReference}
   * and returns the {@link StoichiometryMath}.
   * <p>
   * @return the newly created {@link StoichiometryMath} object instance
   * <p>
   * @see Reaction#addReactant(SpeciesReference  sr)
   * @see Reaction#addProduct(SpeciesReference  sr)
   */
 public StoichiometryMath createStoichiometryMath() {
    long cPtr = libsbmlJNI.SpeciesReference_createStoichiometryMath(swigCPtr, this);
    return (cPtr == 0) ? null : new StoichiometryMath(cPtr, false);
  }

  
  /**
   * Sets the value of the 'annotation' subelement of this SBML object to a
   * copy of <code>annotation</code>.
   * <p>
   * Any existing content of the 'annotation' subelement is discarded.
   * Unless you have taken steps to first copy and reconstitute any
   * existing annotations into the <code>annotation</code> that is about to be
   * assigned, it is likely that performing such wholesale replacement is
   * unfriendly towards other software applications whose annotations are
   * discarded.  An alternative may be to use appendAnnotation().
   * <p>
   * @param annotation an XML structure that is to be used as the content
   * of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <p>
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   */
 public int setAnnotation(XMLNode annotation) {
    return libsbmlJNI.SpeciesReference_setAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
  /**
   * Sets the value of the 'annotation' subelement of this SBML object to a
   * copy of <code>annotation</code>.
   * <p>
   * Any existing content of the 'annotation' subelement is discarded.
   * Unless you have taken steps to first copy and reconstitute any
   * existing annotations into the <code>annotation</code> that is about to be
   * assigned, it is likely that performing such wholesale replacement is
   * unfriendly towards other software applications whose annotations are
   * discarded.  An alternative may be to use appendAnnotation().
   * <p>
   * @param annotation an XML string that is to be used as the content
   * of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @see #appendAnnotation(XMLNode  annotation)
   * @see #appendAnnotation(String annotation)
   */
 public int setAnnotation(String annotation) {
    return libsbmlJNI.SpeciesReference_setAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
  /**
   * Appends annotation content to any existing content in the 'annotation'
   * subelement of this object.
   * <p>
   * The content in <code>annotation</code> is copied.  Unlike setAnnotation(), this
   * method allows other annotations to be preserved when an application
   * adds its own data.
   * <p>
   * @param annotation an XML structure that is to be copied and appended
   * to the content of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @see #setAnnotation(String annotation)
   * @see #setAnnotation(XMLNode  annotation)
   */
 public int appendAnnotation(XMLNode annotation) {
    return libsbmlJNI.SpeciesReference_appendAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
  /**
   * Appends annotation content to any existing content in the 'annotation'
   * subelement of this object.
   * <p>
   * The content in <code>annotation</code> is copied.  Unlike setAnnotation(), this
   * method allows other annotations to be preserved when an application
   * adds its own data.
   * <p>
   * @param annotation an XML string that is to be copied and appended
   * to the content of the 'annotation' subelement of this object
   * <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <li> LIBSBML_OPERATION_SUCCESS
   * <li> LIBSBML_OPERATION_FAILED
   * <p>
   * @see #setAnnotation(String annotation)
   * @see #setAnnotation(XMLNode  annotation)
   */
 public int appendAnnotation(String annotation) {
    return libsbmlJNI.SpeciesReference_appendAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.SpeciesReference_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for
   * {@link SpeciesReference}, is always <code>'speciesReference'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'speciesReference'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.SpeciesReference_getElementName(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether
   * all the required attributes for this {@link SpeciesReference} object
   * have been set.
   * <p>
   * @note The required attributes for a {@link SpeciesReference} object are:
   * species
   * <p>
   * @return a boolean value indicating whether all the required
   * attributes for this object have been defined.
   */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.SpeciesReference_hasRequiredAttributes(swigCPtr, this);
  }

}
