/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's RateRule construct.
 * <p>
 * The rule type {@link RateRule} is derived from the parent class {@link Rule}.  It is
 * used to express equations that determine the rates of change of
 * variables.  The left-hand side (the 'variable' attribute) can refer to
 * the identifier of a species, compartment, or parameter (but not a
 * reaction).  The entity identified must have its 'constant' attribute set
 * to <code>false</code>.  The effects of a {@link RateRule} are in general terms the same,
 * but differ in the precise details depending on which variable is being
 * set:
 * <ul>
 * <li> <em>In the case of a species</em>, a {@link RateRule} sets the rate of
 * change of the species' quantity (<em>concentration</em> or <em>amount of
 * substance</em>) to the value determined by the formula in the 'math'
 * subelement of the {@link RateRule} object.  The overall units of the formula in
 * 'math' should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in previous
 * Versions) be <em>species quantity</em>/<em>time</em>, where the
 * <em>time</em> units are the SBML predefined units of time and the
 * <em>species quantity</em> units are the <em>units of the species</em>.
 * <em>Restrictions</em>: There must not be both a {@link RateRule} 'variable'
 * attribute and a {@link SpeciesReference} 'species' attribute having the same
 * value, unless that species has its 'boundaryCondition' attribute is set
 * to <code>true</code>.  This means a rate rule cannot be defined for a species that
 * is created or destroyed in a reaction, unless that species is defined as
 * a boundary condition in the model.
 * <p>
 * <li> <em>In the case of a compartment</em>, a {@link RateRule} sets the rate of
 * change of the compartment's size to the value determined by the formula
 * in the 'math' subelement of the {@link RateRule} object.  The overall units of
 * the formula should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in previous
 * Versions) be <em>size</em>/<em>time</em>, where the <em>time</em>
 * units are the SBML predefined units of time and the <em>size</em> units
 * are the units of size on the compartment.
 * <p>
 * <li> <em>In the case of a parameter</em>, a {@link RateRule} sets the rate of
 * change of the parameter's value to that determined by the formula in the
 * 'math' subelement of the {@link RateRule} object.  The overall units of the
 * formula should (in SBML Level&nbsp;2 Version&nbsp;4) or must (in previous
 * Versions) be <em>x</em>/<em>time</em>, where <em>x</em> are the units
 * of the parameter.
 * </ul>
 * <p>
 * In the context of a simulation, rate rules are in effect for simulation
 * time <em>t</em> &lt; <em>0</em>.  The SBML Level&nbsp;2 Version&nbsp;4
 * specification provides additional information about the semantics of
 * assignments, rules, and entity values for simulation time <em>t</em>
 * &#8804; <em>0</em>.
 * <p>
 * As mentioned in the description of {@link AssignmentRule}, a model must not
 * contain more than one {@link RateRule} or {@link AssignmentRule} object having the same
 * value of 'variable'; in other words, in the set of all assignment rules
 * and rate rules in an SBML model, each variable appearing in the
 * left-hand sides can only appear once.  This simply follows from the fact
 * that an indeterminate system would result if a model contained more than
 * one assignment rule for the same variable or both an assignment rule and
 * a rate rule for the same variable.
 * <p>
 * <h2>General summary of SBML rules</h2>
<p>
In SBML Level&nbsp;2, rules are separated into three subclasses for the
benefit of model analysis software.  The three subclasses are based on
the following three different possible functional forms (where <em>x</em> is
a variable, <em>f</em> is some arbitrary function returning a numerical
result, <b>V</b> is a vector of variables that does not include <em>x</em>,
and <b>W</b> is a vector of variables that may include <em>x</em>):

<p>
<center>
<table border='0' cellpadding='0' style='font-size: small'>
<tr><td width='120px'><em>Algebraic:</em></td><td width='250px'>left-hand side is zero</td><td><em>0 = f(<b>W</b>)</em></td></tr>
<tr><td><em>Assignment:</em></td><td>left-hand side is a scalar:</td><td><em>x = f(<b>V</b>)</em></td></tr>
<tr><td><em>Rate:</em></td><td>left-hand side is a rate-of-change:</td><td><em>dx/dt = f(<b>W</b>)</em></td></tr>
</table>
</center>

<p>
In their general form given above, there is little to distinguish
between <em>assignment</em> and <em>algebraic</em> rules.  They are treated as
separate cases for the following reasons:
<p>
<ul>
<li> <em>Assignment</em> rules can simply be evaluated to calculate
intermediate values for use in numerical methods.  They are statements
of equality that hold at all times.  (For assignments that are only
performed once, see {@link InitialAssignment}.)<p>

<li> SBML needs to place restrictions on assignment rules, for example
the restriction that assignment rules cannot contain algebraic loops.<p>

<li> Some simulators do not contain numerical solvers capable of solving
unconstrained algebraic equations, and providing more direct forms such
as assignment rules may enable those simulators to process models they
could not process if the same assignments were put in the form of
general algebraic equations;<p>

<li> Those simulators that <em>can</em> solve these algebraic equations make a
distinction between the different categories listed above; and<p>

<li> Some specialized numerical analyses of models may only be applicable
to models that do not contain <em>algebraic</em> rules.
</ul>

<p> The approach taken to covering these cases in SBML is to define an
abstract {@link Rule} structure containing a subelement, 'math', to hold the
right-hand side expression, then to derive subtypes of {@link Rule} that add
attributes to distinguish the cases of algebraic, assignment and rate
rules.  The 'math' subelement must contain a MathML expression defining the
mathematical formula of the rule.  This MathML formula must return a
numerical value.  The formula can be an arbitrary expression referencing
the variables and other entities in an SBML model.

<p> Each of the three subclasses of {@link Rule} (AssignmentRule, {@link AlgebraicRule},
{@link RateRule}) inherit the the 'math' subelement and other fields from {@link SBase}.
The {@link AssignmentRule} and {@link RateRule} classes add an additional attribute,
'variable'.  See the definitions of {@link AssignmentRule}, {@link AlgebraicRule} and
{@link RateRule} for details about the structure and interpretation of each one.

<h2>Additional restrictions on SBML rules</h2>

<p> An important design goal of SBML rule semantics is to ensure that a
model's simulation and analysis results will not be dependent on when or
how often rules are evaluated.  To achieve this, SBML needs to place two
restrictions on rule use.  The first concerns algebraic loops in the system
of assignments in a model, and the second concerns overdetermined systems.

<h3>A model must not contain algebraic loops</h3>

<p> The combined set of {@link InitialAssignment}, {@link AssignmentRule} and {@link KineticLaw}
objects in a model constitute a set of assignment statements that should be
considered as a whole.  (A {@link KineticLaw} object is counted as an assignment
because it assigns a value to the symbol contained in the 'id' attribute of
the {@link Reaction} object in which it is defined.)  This combined set of
assignment statements must not contain algebraic loops&mdash;dependency
chains between these statements must terminate.  To put this more formally,
consider a directed graph in which nodes are assignment statements and
directed arcs exist for each occurrence of an SBML species, compartment or
parameter symbol in an assignment statement's 'math' subelement.  Let the
directed arcs point from the statement assigning the symbol to the
statements that contain the symbol in their 'math' subelement expressions.
This graph must be acyclic.

<p> SBML does not specify when or how often rules should be evaluated.
Eliminating algebraic loops ensures that assignment statements can be
evaluated any number of times without the result of those evaluations
changing.  As an example, consider the set of equations <em>x = x + 1</em>,
<em>y = z + 200</em> and <em>z = y + 100</em>.  If this set of equations
were interpreted as a set of assignment statements, it would be invalid
because the rule for <em>x</em> refers to <em>x</em> (exhibiting one type
of loop), and the rule for <em>y</em> refers to <em>z</em> while the rule
for <em>z</em> refers back to <em>y</em> (exhibiting another type of loop).
Conversely, the following set of equations would constitute a valid set of
assignment statements: <em>x = 10</em>, <em>y = z + 200</em>, and <em>z = x
+ 100</em>.

<h3>A model must not be overdetermined</h3>

<p> An SBML model must not be overdetermined; that is, a model must not
define more equations than there are unknowns in a model.  An SBML model
that does not contain {@link AlgebraicRule} structures cannot be overdetermined.

<p> LibSBML 3.3 implements the static analysis procedure described in
Appendix D of the SBML Level&nbsp;2 Version&nbsp;4 specification for
assessing whether a model is overdetermined.

<p> (In summary, assessing whether a given continuous, deterministic,
mathematical model is overdetermined does not require dynamic analysis; it
can be done by analyzing the system of equations created from the model.
One approach is to construct a bipartite graph in which one set of vertices
represents the variables and the other the set of vertices represents the
equations.  Place edges between vertices such that variables in the system
are linked to the equations that determine them.  For algebraic equations,
there will be edges between the equation and each variable occurring in the
equation.  For ordinary differential equations (such as those defined by
rate rules or implied by the reaction rate definitions), there will be a
single edge between the equation and the variable determined by that
differential equation.  A mathematical model is overdetermined if the
maximal matchings of the bipartite graph contain disconnected vertexes
representing equations.  If one maximal matching has this property, then
all the maximal matchings will have this property; i.e., it is only
necessary to find one maximal matching.)

<h3><a class='anchor' name='RuleType_t'>RuleType_t</a></h3>

<p> SBML Level 1 uses a different scheme than SBML Level&nbsp;2 for
distinguishing rules; specifically, it uses an attribute whose value is
drawn from an enumeration.  LibSBML supports this using methods that work
with the RuleType_t enumeration.

<p>
<center>
<table width='90%' cellspacing='1' cellpadding='1' border='0' class='normal-font'>
 <tr style='background: lightgray' class='normal-font'>
     <td><strong>Enumerator</strong></td>
     <td><strong>Meaning</strong></td>
 </tr>
<tr><td><em>RULE_TYPE_RATE</em></td><td>Indicates the rule is a 'rate' rule.</td>
<tr><td><em>RULE_TYPE_SCALAR</em></td><td>Indicates the rule is a 'scalar' rule.</td>
<tr><td><em>RULE_TYPE_UNKNOWN</em></td><td>Indicates the rule type is unknown or not
yet set.</td>
</table>
</center>


 * <p>
 * <!-- leave this next break as-is to work around some doxygen bug -->
 */

public class RateRule extends Rule {
   private long swigCPtr;

   protected RateRule(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGRateRuleUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(RateRule obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (RateRule obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_RateRule(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
  /**
   * Creates a new {@link RateRule} using the given SBML <code>level</code> and <code>version</code>
   * values.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link RateRule}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link RateRule}
   * <p>
   * @note Once a {@link RateRule} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> for the document <em>override</em> those used
   * to create the {@link RateRule}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public RateRule(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_RateRule__SWIG_0(level, version), true);
  }

  
  /**
   * Creates a new {@link RateRule} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   * <p>
   * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
   * information.  It is used to communicate the SBML Level, Version, and
   * (in Level&nbsp;3) packages used in addition to SBML Level&nbsp; Core.
   * A common approach to using this class constructor is to create an
   * {@link SBMLNamespaces} object somewhere in a program, once, then pass it to
   * object constructors such as this one when needed.
   * <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   * <p>
   * @note Once a {@link RateRule} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link RateRule}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   */
 public RateRule(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_RateRule__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Rule}.
   * <p>
   * @return a (deep) copy of this {@link Rule}.
   */
 public RateRule cloneObject() {
    long cPtr = libsbmlJNI.RateRule_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new RateRule(cPtr, true);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether
   * all the required attributes for this {@link RateRule} object
   * have been set.
   * <p>
   * @note The required attributes for a {@link RateRule} object are:
   * variable (compartment/species/name in L1); formula (L1 only)
   */
 public boolean hasRequiredAttributes() {
    return libsbmlJNI.RateRule_hasRequiredAttributes(swigCPtr, this);
  }

}
