/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.40
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbml {

using System;
using System.Runtime.InteropServices;

public class ASTNode : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal ASTNode(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(ASTNode obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (ASTNode obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~ASTNode() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_ASTNode(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  public static bool operator==(ASTNode lhs, ASTNode rhs)
  {
    if((Object)lhs == (Object)rhs)
    {
      return true;
    }

    if( ((Object)lhs == null) || ((Object)rhs == null) )
    {
      return false;
    }

    return (getCPtr(lhs).Handle.ToString() == getCPtr(rhs).Handle.ToString());
  }

  public static bool operator!=(ASTNode lhs, ASTNode rhs)
  {
    return !(lhs == rhs);
  }

  public override bool Equals(Object sb)
  {
    if ( ! (sb is ASTNode) )
    {
      return false;
    }

    return this == (ASTNode)sb;
  }

  public override int GetHashCode()
  {
    return swigCPtr.Handle.ToInt32();
  }

  public ASTNode(int type) : this(libsbmlPINVOKE.new_ASTNode__SWIG_0(type), true) {
  }

  public ASTNode() : this(libsbmlPINVOKE.new_ASTNode__SWIG_1(), true) {
  }

  public ASTNode(ASTNode orig) : this(libsbmlPINVOKE.new_ASTNode__SWIG_2(ASTNode.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  public int freeName() {
    int ret = libsbmlPINVOKE.ASTNode_freeName(swigCPtr);
    return ret;
  }

  public bool canonicalize() {
    bool ret = libsbmlPINVOKE.ASTNode_canonicalize(swigCPtr);
    return ret;
  }

  public int addChild(ASTNode child) {
    int ret = libsbmlPINVOKE.ASTNode_addChild(swigCPtr, ASTNode.getCPtrAndDisown(child));
    return ret;
  }

  public int prependChild(ASTNode child) {
    int ret = libsbmlPINVOKE.ASTNode_prependChild(swigCPtr, ASTNode.getCPtrAndDisown(child));
    return ret;
  }

  public int removeChild(long n) {
    int ret = libsbmlPINVOKE.ASTNode_removeChild(swigCPtr, n);
    return ret;
  }

  public int replaceChild(long n, ASTNode newChild) {
    int ret = libsbmlPINVOKE.ASTNode_replaceChild(swigCPtr, n, ASTNode.getCPtrAndDisown(newChild));
    return ret;
  }

  public int insertChild(long n, ASTNode newChild) {
    int ret = libsbmlPINVOKE.ASTNode_insertChild(swigCPtr, n, ASTNode.getCPtrAndDisown(newChild));
    return ret;
  }

  public ASTNode deepCopy() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_deepCopy(swigCPtr);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, true);
    return ret;
  }

  public ASTNode getChild(long n) {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getChild(swigCPtr, n);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  public ASTNode getLeftChild() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getLeftChild(swigCPtr);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  public ASTNode getRightChild() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getRightChild(swigCPtr);
    ASTNode ret = (cPtr == IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  public long getNumChildren() { return (long)libsbmlPINVOKE.ASTNode_getNumChildren(swigCPtr); }

  public int addSemanticsAnnotation(XMLNode sAnnotation) {
    int ret = libsbmlPINVOKE.ASTNode_addSemanticsAnnotation(swigCPtr, XMLNode.getCPtrAndDisown(sAnnotation));
    return ret;
  }

  public long getNumSemanticsAnnotations() { return (long)libsbmlPINVOKE.ASTNode_getNumSemanticsAnnotations(swigCPtr); }

  public XMLNode getSemanticsAnnotation(long n) {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getSemanticsAnnotation(swigCPtr, n);
    XMLNode ret = (cPtr == IntPtr.Zero) ? null : new XMLNode(cPtr, false);
    return ret;
  }

  public char getCharacter() {
    char ret = libsbmlPINVOKE.ASTNode_getCharacter(swigCPtr);
    return ret;
  }

  public int getInteger() {
    int ret = libsbmlPINVOKE.ASTNode_getInteger(swigCPtr);
    return ret;
  }

  public string getName() {
    string ret = libsbmlPINVOKE.ASTNode_getName(swigCPtr);
    return ret;
  }

  public int getNumerator() {
    int ret = libsbmlPINVOKE.ASTNode_getNumerator(swigCPtr);
    return ret;
  }

  public int getDenominator() {
    int ret = libsbmlPINVOKE.ASTNode_getDenominator(swigCPtr);
    return ret;
  }

  public double getReal() {
    double ret = libsbmlPINVOKE.ASTNode_getReal(swigCPtr);
    return ret;
  }

  public double getMantissa() {
    double ret = libsbmlPINVOKE.ASTNode_getMantissa(swigCPtr);
    return ret;
  }

  public int getExponent() {
    int ret = libsbmlPINVOKE.ASTNode_getExponent(swigCPtr);
    return ret;
  }

  public int getPrecedence() {
    int ret = libsbmlPINVOKE.ASTNode_getPrecedence(swigCPtr);
    return ret;
  }

  public int getType() {
    int ret = libsbmlPINVOKE.ASTNode_getType(swigCPtr);
    return ret;
  }

  public bool isBoolean() {
    bool ret = libsbmlPINVOKE.ASTNode_isBoolean(swigCPtr);
    return ret;
  }

  public bool isConstant() {
    bool ret = libsbmlPINVOKE.ASTNode_isConstant(swigCPtr);
    return ret;
  }

  public bool isFunction() {
    bool ret = libsbmlPINVOKE.ASTNode_isFunction(swigCPtr);
    return ret;
  }

  public bool isInfinity() {
    bool ret = libsbmlPINVOKE.ASTNode_isInfinity(swigCPtr);
    return ret;
  }

  public bool isInteger() {
    bool ret = libsbmlPINVOKE.ASTNode_isInteger(swigCPtr);
    return ret;
  }

  public bool isLambda() {
    bool ret = libsbmlPINVOKE.ASTNode_isLambda(swigCPtr);
    return ret;
  }

  public bool isLog10() {
    bool ret = libsbmlPINVOKE.ASTNode_isLog10(swigCPtr);
    return ret;
  }

  public bool isLogical() {
    bool ret = libsbmlPINVOKE.ASTNode_isLogical(swigCPtr);
    return ret;
  }

  public bool isName() {
    bool ret = libsbmlPINVOKE.ASTNode_isName(swigCPtr);
    return ret;
  }

  public bool isNaN() {
    bool ret = libsbmlPINVOKE.ASTNode_isNaN(swigCPtr);
    return ret;
  }

  public bool isNegInfinity() {
    bool ret = libsbmlPINVOKE.ASTNode_isNegInfinity(swigCPtr);
    return ret;
  }

  public bool isNumber() {
    bool ret = libsbmlPINVOKE.ASTNode_isNumber(swigCPtr);
    return ret;
  }

  public bool isOperator() {
    bool ret = libsbmlPINVOKE.ASTNode_isOperator(swigCPtr);
    return ret;
  }

  public bool isPiecewise() {
    bool ret = libsbmlPINVOKE.ASTNode_isPiecewise(swigCPtr);
    return ret;
  }

  public bool isRational() {
    bool ret = libsbmlPINVOKE.ASTNode_isRational(swigCPtr);
    return ret;
  }

  public bool isReal() {
    bool ret = libsbmlPINVOKE.ASTNode_isReal(swigCPtr);
    return ret;
  }

  public bool isRelational() {
    bool ret = libsbmlPINVOKE.ASTNode_isRelational(swigCPtr);
    return ret;
  }

  public bool isSqrt() {
    bool ret = libsbmlPINVOKE.ASTNode_isSqrt(swigCPtr);
    return ret;
  }

  public bool isUMinus() {
    bool ret = libsbmlPINVOKE.ASTNode_isUMinus(swigCPtr);
    return ret;
  }

  public bool isUnknown() {
    bool ret = libsbmlPINVOKE.ASTNode_isUnknown(swigCPtr);
    return ret;
  }

  public int setCharacter(char value) {
    int ret = libsbmlPINVOKE.ASTNode_setCharacter(swigCPtr, value);
    return ret;
  }

  public int setName(string name) {
    int ret = libsbmlPINVOKE.ASTNode_setName(swigCPtr, name);
    return ret;
  }

  public int setValue(int value) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_0(swigCPtr, value);
    return ret;
  }

  public int setValue(int numerator, int denominator) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_1(swigCPtr, numerator, denominator);
    return ret;
  }

  public int setValue(double value) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_2(swigCPtr, value);
    return ret;
  }

  public int setValue(double mantissa, int exponent) {
    int ret = libsbmlPINVOKE.ASTNode_setValue__SWIG_3(swigCPtr, mantissa, exponent);
    return ret;
  }

  public int setType(int type) {
    int ret = libsbmlPINVOKE.ASTNode_setType(swigCPtr, type);
    return ret;
  }

  public int swapChildren(ASTNode that) {
    int ret = libsbmlPINVOKE.ASTNode_swapChildren(swigCPtr, ASTNode.getCPtr(that));
    return ret;
  }

  public XMLAttributes getDefinitionURL() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getDefinitionURL(swigCPtr);
    XMLAttributes ret = (cPtr == IntPtr.Zero) ? null : new XMLAttributes(cPtr, false);
    return ret;
  }

  public void replaceArgument(string bvar, ASTNode arg) {
    libsbmlPINVOKE.ASTNode_replaceArgument(swigCPtr, bvar, ASTNode.getCPtr(arg));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  public SBase getParentSBMLObject() {
	return libsbml.DowncastSBase(libsbmlPINVOKE.ASTNode_getParentSBMLObject(swigCPtr), false);
}

  public void reduceToBinary() {
    libsbmlPINVOKE.ASTNode_reduceToBinary(swigCPtr);
  }

  public bool isWellFormedASTNode() {
    bool ret = libsbmlPINVOKE.ASTNode_isWellFormedASTNode(swigCPtr);
    return ret;
  }

  public bool hasCorrectNumberArguments() {
    bool ret = libsbmlPINVOKE.ASTNode_hasCorrectNumberArguments(swigCPtr);
    return ret;
  }

  public ASTNodeList getListOfNodes() {
    IntPtr cPtr = libsbmlPINVOKE.ASTNode_getListOfNodes(swigCPtr);
    ASTNodeList ret = (cPtr == IntPtr.Zero) ? null : new ASTNodeList(cPtr, true);
    return ret;
  }

}

}
