/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

public class libsbml implements libsbmlConstants {

  /**
   * Internal method.  This is not actually deprecated, but we
   * cheat and use @deprecated to hide this in the documentation
   * produced by Javadoc:
   *
   * @deprecated
   */
  public static SBase DowncastSBase(long cPtr, boolean owner)
  {
    if (cPtr == 0) return null;

    SBase sb = new SBase(cPtr,false);
    switch( sb.getTypeCode() )
    {
      case libsbmlConstants.SBML_COMPARTMENT:
        return new Compartment(cPtr, owner);

      case libsbmlConstants.SBML_COMPARTMENT_TYPE:
        return new CompartmentType(cPtr, owner);

      case libsbmlConstants.SBML_CONSTRAINT:
        return new Constraint(cPtr, owner);

      case libsbmlConstants.SBML_DOCUMENT:
        return new SBMLDocument(cPtr, owner);

      case libsbmlConstants.SBML_DELAY:
        return new Delay(cPtr, owner);

      case libsbmlConstants.SBML_EVENT:
        return new Event(cPtr, owner);

      case libsbmlConstants.SBML_EVENT_ASSIGNMENT:
        return new EventAssignment(cPtr, owner);

      case libsbmlConstants.SBML_FUNCTION_DEFINITION:
        return new FunctionDefinition(cPtr, owner);

      case libsbmlConstants.SBML_INITIAL_ASSIGNMENT:
        return new InitialAssignment(cPtr, owner);

      case libsbmlConstants.SBML_KINETIC_LAW:
        return new KineticLaw(cPtr, owner);

      case libsbmlConstants.SBML_LIST_OF:
	String name = sb.getElementName();
        if(name.equals("listOf")){
          return new ListOf(cPtr, owner);
        }
	else if(name.equals("listOfCompartments")){
          return new ListOfCompartments(cPtr, owner);
	}
	else if(name.equals("listOfCompartmentTypes")){
          return new ListOfCompartmentTypes(cPtr, owner);
	}
	else if(name.equals("listOfConstraints")){
          return new ListOfConstraints(cPtr, owner);
	}
        else if(name.equals("listOfEvents")){
          return new ListOfEvents(cPtr, owner);
        }
        else if(name.equals("listOfEventAssignments")){
          return new ListOfEventAssignments(cPtr, owner);
        }
        else if(name.equals("listOfFunctionDefinitions")){
          return new ListOfFunctionDefinitions(cPtr, owner);
        }
        else if(name.equals("listOfInitialAssignments")){
          return new ListOfInitialAssignments(cPtr, owner);
        }
        else if(name.equals("listOfParameters")){
          return new ListOfParameters(cPtr, owner);
        }
	else if(name.equals("listOfReactions")){
          return new ListOfReactions(cPtr, owner);
	}
        else if(name.equals("listOfRules")){
          return new ListOfRules(cPtr, owner);
        }
        else if(name.equals("listOfSpecies")){
          return new ListOfSpecies(cPtr, owner);
        }
        else if(name.equals("listOfUnknowns")){
          return new ListOfSpeciesReferences(cPtr, owner);
        }
        else if(name.equals("listOfReactants")){
          return new ListOfSpeciesReferences(cPtr, owner);
        }
        else if(name.equals("listOfProducts")){
          return new ListOfSpeciesReferences(cPtr, owner);
        }
        else if(name.equals("listOfModifiers")){
          return new ListOfSpeciesReferences(cPtr, owner);
        }
        else if(name.equals("listOfSpeciesTypes")){
          return new ListOfSpeciesTypes(cPtr, owner);
        }
        else if(name.equals("listOfUnits")){
          return new ListOfUnits(cPtr, owner);
        }
        else if(name.equals("listOfUnitDefinitions")){
          return new ListOfUnitDefinitions(cPtr, owner);
        }
        return new ListOf(cPtr, owner);

      case libsbmlConstants.SBML_MODEL:
        return new Model(cPtr, owner);

      case libsbmlConstants.SBML_PARAMETER:
        return new Parameter(cPtr, owner);

      case libsbmlConstants.SBML_REACTION:
        return new Reaction(cPtr, owner);

      case libsbmlConstants.SBML_SPECIES:
        return new Species(cPtr, owner);

      case libsbmlConstants.SBML_SPECIES_REFERENCE:
        return new SpeciesReference(cPtr, owner);

      case libsbmlConstants.SBML_MODIFIER_SPECIES_REFERENCE:
        return new ModifierSpeciesReference(cPtr, owner);

      case libsbmlConstants.SBML_SPECIES_TYPE:
        return new SpeciesType(cPtr, owner);

      case libsbmlConstants.SBML_TRIGGER:
        return new Trigger(cPtr, owner);

      case libsbmlConstants.SBML_UNIT_DEFINITION:
        return new UnitDefinition(cPtr, owner);

      case libsbmlConstants.SBML_UNIT:
        return new Unit(cPtr, owner);

      case libsbmlConstants.SBML_ALGEBRAIC_RULE:
        return new AlgebraicRule(cPtr, owner);

      case libsbmlConstants.SBML_ASSIGNMENT_RULE:
        return new AssignmentRule(cPtr, owner);

      case libsbmlConstants.SBML_RATE_RULE:
        return new RateRule(cPtr, owner);

      case libsbmlConstants.SBML_STOICHIOMETRY_MATH:
        return new StoichiometryMath(cPtr, owner);

      default:
        return new SBase(cPtr, owner);
    }
  }


   static String getAbsolutePath(String filename)
   {
     java.io.File file = new java.io.File(filename);
     return file.getAbsolutePath();
   }


  public final static OStream cout;
  public final static OStream cerr;
  public final static OStream clog;

  static {
    cout = new OStream(OStream.COUT); 
    cerr = new OStream(OStream.CERR); 
    clog = new OStream(OStream.CLOG); 
  }

  
/**
 * Returns the libSBML version as an integer: version 1.2.3 becomes 10203.
 * <p>
 * @return the libSBML version as an integer: version 1.2.3 becomes 10203.
 */
 public static int getLibSBMLVersion() {
    return libsbmlJNI.getLibSBMLVersion();
  }

  
/**
 * Returns the libSBML version as a string of the form '1.2.3'.
 * <p>
 * @return the libSBML version as a string of the form '1.2.3'.
 */
 public static String getLibSBMLDottedVersion() {
    return libsbmlJNI.getLibSBMLDottedVersion();
  }

  
/**
 * Returns the libSBML version as a string: version 1.2.3 becomes '10203'.
 * <p>
 * @return the libSBML version as a string: version 1.2.3 becomes '10203'.
 */
 public static String getLibSBMLVersionString() {
    return libsbmlJNI.getLibSBMLVersionString();
  }

  
/**
 * Reads an SBML document from the given file <code>filename</code>.
 * <p>
 * If <code>filename</code> does not exist, or it is not an SBML file, an error will
 * be logged in the error log of the {@link SBMLDocument} object returned by this
 * method.  Calling programs can inspect this error log to determine
 * the nature of the problem.  Please refer to the definition of
 * {@link SBMLDocument} for more information about the error reporting mechanism.
 * <p>
 * @return a pointer to the {@link SBMLDocument} read.
 */
 public static SBMLDocument readSBML(String filename) {
    long cPtr = libsbmlJNI.readSBML(libsbml.getAbsolutePath(filename));
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
 * Reads an SBML document from a string assumed to be in XML format.
 * <p>
 * If the string does not begin with XML declaration,
 *<div class='fragment'><pre>
&lt;?xml version='1.0' encoding='UTF-8'?&gt;
</pre></div>
 * <p>
 * an XML declaration string will be prepended.
 * <p>
 * This method will report an error if the given string <code>xml</code> is not SBML.
 * The error will be logged in the error log of the {@link SBMLDocument} object
 * returned by this method.  Calling programs can inspect this error log to
 * determine the nature of the problem.  Please refer to the definition of
 * {@link SBMLDocument} for more information about the error reporting mechanism.
 * <p>
 * @return a pointer to the {@link SBMLDocument} read.
 */
 public static SBMLDocument readSBMLFromString(String xml) {
    long cPtr = libsbmlJNI.readSBMLFromString(xml);
    return (cPtr == 0) ? null : new SBMLDocument(cPtr, true);
  }

  
/**
 * Writes the given SBML document to filename.  This convenience function
 * is functionally equivalent to:
 * <p>
 *   SBMLWriter_writeSBML(SBMLWriter_create(), d, filename);
 * <p>
 * @return non-zero on success and zero if the filename could not be opened
 * for writing.
 */
 public static int writeSBML(SBMLDocument d, String filename) {
    return libsbmlJNI.writeSBML(SBMLDocument.getCPtr(d), d, libsbml.getAbsolutePath(filename));
  }

  
/**
 * Writes the given SBML document to an in-memory string and returns a
 * pointer to it.  The string is owned by the caller and should be freed
 * (with free()) when no longer needed.  This convenience function is
 * functionally equivalent to:
 * <p>
 *   SBMLWriter_writeSBMLToString(SBMLWriter_create(), d);
 * <p>
 * @return the string on success and NULL if one of the underlying parser
 * components fail (rare).
 */
 public static String writeSBMLToString(SBMLDocument d) {
    return libsbmlJNI.writeSBMLToString(SBMLDocument.getCPtr(d), d);
  }

  
/**
 * @return a human readable name for the given #SBMLTypeCode_t.  The caller
 * does not own the returned string and is therefore not allowed to modify
 * it.
 */
 public static String SBMLTypeCode_toString(int tc) {
    return libsbmlJNI.SBMLTypeCode_toString(tc);
  }

  
/**
 * Tests for logical equality between two given UnitKind_t values.
 * <p>
 * This function behaves exactly like C's <tt>==</tt> operator, except for
 * the following two cases:
 * <p>
 * <li> UNIT_KIND_LITER <code>==</code> UNIT_KIND_LITRE
 * <li> UNIT_KIND_METER <code>==</code> UNIT_KIND_METRE
 * <p>
 * C equality comparison would yield false (because each of the above is a
 * distinct enumeration value), but UnitKind_equals() returns true.
 * <p>
 * @param uk1 a UnitKind_t enumeration value 
 * @param uk2 the UnitKind_t enumeration value to compare to <code>uk1</code>
 * <p>
 * @return nonzero (for true) if uk1 is logically equivalent to uk2,
 * zero (0) otherwise.
 * <p>
 * @note For more information about the UnitKind_t enumeration, please
 * refer to the class documentation for {@link Unit}.
 */
 public static int UnitKind_equals(int uk1, int uk2) {
    return libsbmlJNI.UnitKind_equals(uk1, uk2);
  }

  
/**
 * Converts a string to its corresponding UnitKind_t enumeration value.
 * <p>
 * @param name a string, the name of a predefined base unit in SBML
 * <p>
 * @return a value from UnitKind_t corresponding to the given name
 * (determined in a case-insensitive manner).
 * <p>
 * @note For more information about the UnitKind_t enumeration, please
 * refer to the class documentation for {@link Unit}.
 */
 public static int UnitKind_forName(String name) {
    return libsbmlJNI.UnitKind_forName(name);
  }

  
/**
 * Converts a UnitKind_t enumeration value to a text string equivalent.
 * <p>
 * @param uk the UnitKind_t value to convert
 * <p>
 * @return the name of the given UnitKind.
 * <p>
 * @note The string returned is a static data value.  The caller does not
 * own the returned string and is therefore not allowed to modify it.
 * <p>
 * @note For more information about the UnitKind_t enumeration, please
 * refer to the class documentation for {@link Unit}.
 */
 public static String UnitKind_toString(int uk) {
    return libsbmlJNI.UnitKind_toString(uk);
  }

  
/**
 * Predicate for testing whether a given string corresponds to a
 * predefined UnitKind_t enumeration value.
 * <p>
 * @return nonzero (for true) if string is the name of a valid
 * UnitKind_t enumeration value, zero (0) otherwise.
 * <p>
 * @note For more information about the UnitKind_t enumeration, please
 * refer to the class documentation for {@link Unit}.
 */
 public static int UnitKind_isValidUnitKindString(String string, long level, long version) {
    return libsbmlJNI.UnitKind_isValidUnitKindString(string, level, version);
  }

  
/**
 * Reads the MathML from the given XML string, constructs a corresponding
 * abstract syntax tree and returns a pointer to the root of the tree.
 */
 public static ASTNode readMathMLFromString(String xml) {
    long cPtr = libsbmlJNI.readMathMLFromString(xml);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Writes the given {@link ASTNode} (and its children) to the XMLOutputStream as
 * MathML.  The string is owned by the caller and should be freed
 * (with free()) when no longer needed.
 */
 public static String writeMathMLToString(ASTNode node) {
    return libsbmlJNI.writeMathMLToString(ASTNode.getCPtr(node), node);
  }

  
/**
 * Parses a text-string mathematical formula and returns a representation
 * as an Abstract Syntax Tree.
 * <p>
 * The text-string form of
 * mathematical formulas produced by <code><a
 * href='libsbml.html'>libsbml.formulaToString()</a></code> and read by
 * <code><a href='libsbml.html'>libsbml.parseFormula()</a></code> are
 * simple C-inspired infix notation taken from SBML Level&nbsp;1.  A
 * formula in this text-string form therefore can be handed to a program
 * that understands SBML Level&nbsp;1 mathematical expressions, or used as
 * part of a formula translation system.  The syntax is described in detail
 * in the documentation for {@link ASTNode}.   
 * <p>
 * @param formula the string containing the mathematical formula.
 * <p>
 * @return an {@link ASTNode} (the root of the expression tree).  If the formula
 * contains a grammatical error, NULL is returned.
 */
 public static ASTNode parseFormula(String formula) {
    long cPtr = libsbmlJNI.parseFormula(formula);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
/**
 * Converts an {@link ASTNode} formula to a text string using a specific
 * syntax for mathematical formulas.
 * <p>
 * The text-string form of
 * mathematical formulas produced by <code><a
 * href='libsbml.html'>libsbml.formulaToString()</a></code> and read by
 * <code><a href='libsbml.html'>libsbml.parseFormula()</a></code> are
 * simple C-inspired infix notation taken from SBML Level&nbsp;1.  A
 * formula in this text-string form therefore can be handed to a program
 * that understands SBML Level&nbsp;1 mathematical expressions, or used as
 * part of a formula translation system.  The syntax is described in detail
 * in the documentation for {@link ASTNode}.   
 * <p>
 * @param tree the root of the {@link ASTNode} formula expression tree
 * <p>
 * @return the formula from the given AST as an SBML Level 1 text-string
 * mathematical formula.  The caller owns the returned string and is
 * responsible for freeing it when it is no longer needed.
 */
 public static String formulaToString(ASTNode tree) {
    return libsbmlJNI.formulaToString(ASTNode.getCPtr(tree), tree);
  }

}
