/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * Representation of a token in an XML stream.
 * <p>
 * <em style='color: #555'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</em>

 * <p>
 */

public class XMLToken {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected XMLToken(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(XMLToken obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (XMLToken obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_XMLToken(swigCPtr);
    }
    swigCPtr = 0;
  }

  /**
   * Equality comparison method for XMLToken.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((XMLToken)(sb));
  }

  /**
   * Returns a hashcode for this XMLToken object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
  /**
   * Creates a new empty XMLToken.
   */
 public XMLToken() {
    this(libsbmlJNI.new_XMLToken__SWIG_0(), true);
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes and
   * namespace declarations.
   * <p>
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param namespaces XMLNamespaces, the namespaces to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, long line, long column) {
    this(libsbmlJNI.new_XMLToken__SWIG_1(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes, XMLNamespaces.getCPtr(namespaces), namespaces, line, column), true);
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes and
   * namespace declarations.
   * <p>
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param namespaces XMLNamespaces, the namespaces to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces, long line) {
    this(libsbmlJNI.new_XMLToken__SWIG_2(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes, XMLNamespaces.getCPtr(namespaces), namespaces, line), true);
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes and
   * namespace declarations.
   * <p>
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param namespaces XMLNamespaces, the namespaces to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLToken(XMLTriple triple, XMLAttributes attributes, XMLNamespaces namespaces) {
    this(libsbmlJNI.new_XMLToken__SWIG_3(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes, XMLNamespaces.getCPtr(namespaces), namespaces), true);
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes.
   * <p>
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
  */
 public XMLToken(XMLTriple triple, XMLAttributes attributes, long line, long column) {
    this(libsbmlJNI.new_XMLToken__SWIG_4(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes, line, column), true);
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes.
   * <p>
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
  */
 public XMLToken(XMLTriple triple, XMLAttributes attributes, long line) {
    this(libsbmlJNI.new_XMLToken__SWIG_5(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes, line), true);
  }

  
  /**
   * Creates a start element XMLToken with the given set of attributes.
   * <p>
   * @param triple XMLTriple.
   * @param attributes XMLAttributes, the attributes to set.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
  */
 public XMLToken(XMLTriple triple, XMLAttributes attributes) {
    this(libsbmlJNI.new_XMLToken__SWIG_6(XMLTriple.getCPtr(triple), triple, XMLAttributes.getCPtr(attributes), attributes), true);
  }

  
  /**
   * Creates an end element XMLToken.
   * <p>
   * @param triple XMLTriple.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLToken(XMLTriple triple, long line, long column) {
    this(libsbmlJNI.new_XMLToken__SWIG_7(XMLTriple.getCPtr(triple), triple, line, column), true);
  }

  
  /**
   * Creates an end element XMLToken.
   * <p>
   * @param triple XMLTriple.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLToken(XMLTriple triple, long line) {
    this(libsbmlJNI.new_XMLToken__SWIG_8(XMLTriple.getCPtr(triple), triple, line), true);
  }

  
  /**
   * Creates an end element XMLToken.
   * <p>
   * @param triple XMLTriple.
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLToken(XMLTriple triple) {
    this(libsbmlJNI.new_XMLToken__SWIG_9(XMLTriple.getCPtr(triple), triple), true);
  }

  
  /**
   * Creates a text XMLToken.
   * <p>
   * @param chars a string, the text to be added to the XMLToken
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLToken(String chars, long line, long column) {
    this(libsbmlJNI.new_XMLToken__SWIG_10(chars, line, column), true);
  }

  
  /**
   * Creates a text XMLToken.
   * <p>
   * @param chars a string, the text to be added to the XMLToken
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLToken(String chars, long line) {
    this(libsbmlJNI.new_XMLToken__SWIG_11(chars, line), true);
  }

  
  /**
   * Creates a text XMLToken.
   * <p>
   * @param chars a string, the text to be added to the XMLToken
   * @param line a long integer, the line number (default = 0).
   * @param column a long integer, the column number (default = 0).
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public XMLToken(String chars) {
    this(libsbmlJNI.new_XMLToken__SWIG_12(chars), true);
  }

  
  /**
   * Copy constructor; creates a copy of this XMLToken.
   */
 public XMLToken(XMLToken orig) {
    this(libsbmlJNI.new_XMLToken__SWIG_13(XMLToken.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this XMLToken.
   * <p>
   * @return a (deep) copy of this XMLToken set.
   */
 public XMLToken cloneObject() {
    long cPtr = libsbmlJNI.XMLToken_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLToken(cPtr, true);
  }

  
  /**
   * Returns the attributes of this element.
   * <p>
   * @return the XMLAttributes of this XML element.
   */
 public XMLAttributes getAttributes() {
    return new XMLAttributes(libsbmlJNI.XMLToken_getAttributes(swigCPtr, this), false);
  }

  
  /**
   * Sets an XMLAttributes to this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param attributes XMLAttributes to be set to this XMLToken.
   * <p>
   * @note This function replaces the existing XMLAttributes with the new one.
   */
 public void setAttributes(XMLAttributes attributes) {
    libsbmlJNI.XMLToken_setAttributes(swigCPtr, this, XMLAttributes.getCPtr(attributes), attributes);
  }

  
  /**
   * Adds an attribute to the attribute set in this XMLToken optionally 
   * with a prefix and URI defining a namespace.
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param name a string, the local name of the attribute.
   * @param value a string, the value of the attribute.
   * @param namespaceURI a string, the namespace URI of the attribute.
   * @param prefix a string, the prefix of the namespace
   * <p>
   * @note if local name with the same namespace URI already exists in the
   * attribute set, its value and prefix will be replaced.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public void addAttr(String name, String value, String namespaceURI, String prefix) {
    libsbmlJNI.XMLToken_addAttr__SWIG_0(swigCPtr, this, name, value, namespaceURI, prefix);
  }

  
  /**
   * Adds an attribute to the attribute set in this XMLToken optionally 
   * with a prefix and URI defining a namespace.
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param name a string, the local name of the attribute.
   * @param value a string, the value of the attribute.
   * @param namespaceURI a string, the namespace URI of the attribute.
   * @param prefix a string, the prefix of the namespace
   * <p>
   * @note if local name with the same namespace URI already exists in the
   * attribute set, its value and prefix will be replaced.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public void addAttr(String name, String value, String namespaceURI) {
    libsbmlJNI.XMLToken_addAttr__SWIG_1(swigCPtr, this, name, value, namespaceURI);
  }

  
  /**
   * Adds an attribute to the attribute set in this XMLToken optionally 
   * with a prefix and URI defining a namespace.
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param name a string, the local name of the attribute.
   * @param value a string, the value of the attribute.
   * @param namespaceURI a string, the namespace URI of the attribute.
   * @param prefix a string, the prefix of the namespace
   * <p>
   * @note if local name with the same namespace URI already exists in the
   * attribute set, its value and prefix will be replaced.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public void addAttr(String name, String value) {
    libsbmlJNI.XMLToken_addAttr__SWIG_2(swigCPtr, this, name, value);
  }

  
  /**
   * Adds an attribute with the given XMLTriple/value pair to the attribute set
   * in this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @note if local name with the same namespace URI already exists in the 
   * attribute set, its value and prefix will be replaced.
   * <p>
   * @param triple an XMLTriple, the XML triple of the attribute.
   * @param value a string, the value of the attribute.
   */
 public void addAttr(XMLTriple triple, String value) {
    libsbmlJNI.XMLToken_addAttr__SWIG_3(swigCPtr, this, XMLTriple.getCPtr(triple), triple, value);
  }

  
  /**
   * Removes an attribute with the given index from the attribute set in
   * this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param n an integer the index of the resource to be deleted
   */
 public void removeAttr(int n) {
    libsbmlJNI.XMLToken_removeAttr__SWIG_0(swigCPtr, this, n);
  }

  
  /**
   * Removes an attribute with the given local name and namespace URI from 
   * the attribute set in this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param name   a string, the local name of the attribute.
   * @param uri    a string, the namespace URI of the attribute.
   */
 public void removeAttr(String name, String uri) {
    libsbmlJNI.XMLToken_removeAttr__SWIG_1(swigCPtr, this, name, uri);
  }

  
  /**
   * Removes an attribute with the given local name and namespace URI from 
   * the attribute set in this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param name   a string, the local name of the attribute.
   * @param uri    a string, the namespace URI of the attribute.
   */
 public void removeAttr(String name) {
    libsbmlJNI.XMLToken_removeAttr__SWIG_2(swigCPtr, this, name);
  }

  
  /**
   * Removes an attribute with the given XMLTriple from the attribute set 
   * in this XMLToken.  
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param triple an XMLTriple, the XML triple of the attribute.
   */
 public void removeAttr(XMLTriple triple) {
    libsbmlJNI.XMLToken_removeAttr__SWIG_3(swigCPtr, this, XMLTriple.getCPtr(triple), triple);
  }

  
  /**
   * Clears (deletes) all attributes in this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   */
 public void clearAttributes() {
    libsbmlJNI.XMLToken_clearAttributes(swigCPtr, this);
  }

  
  /**
   * Return the index of an attribute with the given local name and namespace URI.
   * <p>
   * @param name a string, the local name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   * <p>
   * @return the index of an attribute with the given local name and namespace URI, 
   * or -1 if not present.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public int getAttrIndex(String name, String uri) {
    return libsbmlJNI.XMLToken_getAttrIndex__SWIG_0(swigCPtr, this, name, uri);
  }

  
  /**
   * Return the index of an attribute with the given local name and namespace URI.
   * <p>
   * @param name a string, the local name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   * <p>
   * @return the index of an attribute with the given local name and namespace URI, 
   * or -1 if not present.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public int getAttrIndex(String name) {
    return libsbmlJNI.XMLToken_getAttrIndex__SWIG_1(swigCPtr, this, name);
  }

  
  /**
   * Return the index of an attribute with the given XMLTriple.
   * <p>
   * @param triple an XMLTriple, the XML triple of the attribute for which 
   *        the index is required.
   * <p>
   * @return the index of an attribute with the given XMLTriple, or -1 if not present.
   */
 public int getAttrIndex(XMLTriple triple) {
    return libsbmlJNI.XMLToken_getAttrIndex__SWIG_2(swigCPtr, this, XMLTriple.getCPtr(triple), triple);
  }

  
  /**
   * Return the number of attributes in the attributes set.
   * <p>
   * @return the number of attributes in the attributes set in this XMLToken.
   */
 public int getAttributesLength() {
    return libsbmlJNI.XMLToken_getAttributesLength(swigCPtr, this);
  }

  
  /**
   * Return the local name of an attribute in the attributes set in this 
   * XMLToken (by position).
   * <p>
   * @param index an integer, the position of the attribute whose local name 
   * is required.
   * <p>
   * @return the local name of an attribute in this list (by position).  
   * <p>
   * @note If index
   * is out of range, an empty string will be returned.  Use hasAttr(index) 
   * to test for the attribute existence.
   */
 public String getAttrName(int index) {
    return libsbmlJNI.XMLToken_getAttrName(swigCPtr, this, index);
  }

  
  /**
   * Return the prefix of an attribute in the attribute set in this 
   * XMLToken (by position).
   * <p>
   * @param index an integer, the position of the attribute whose prefix is 
   * required.
   * <p>
   * @return the namespace prefix of an attribute in the attribute set
   * (by position).  
   * <p>
   * @note If index is out of range, an empty string will be
   * returned. Use hasAttr(index) to test for the attribute existence.
   */
 public String getAttrPrefix(int index) {
    return libsbmlJNI.XMLToken_getAttrPrefix(swigCPtr, this, index);
  }

  
  /**
   * Return the prefixed name of an attribute in the attribute set in this 
   * XMLToken (by position).
   * <p>
   * @param index an integer, the position of the attribute whose prefixed 
   * name is required.
   * <p>
   * @return the prefixed name of an attribute in the attribute set 
   * (by position).  
   * <p>
   * @note If index is out of range, an empty string will be
   * returned.  Use hasAttr(index) to test for attribute existence.
   */
 public String getAttrPrefixedName(int index) {
    return libsbmlJNI.XMLToken_getAttrPrefixedName(swigCPtr, this, index);
  }

  
  /**
   * Return the namespace URI of an attribute in the attribute set in this 
   * XMLToken (by position).
   * <p>
   * @param index an integer, the position of the attribute whose namespace 
   * URI is required.
   * <p>
   * @return the namespace URI of an attribute in the attribute set (by position).
   * <p>
   * @note If index is out of range, an empty string will be returned.  Use
   * hasAttr(index) to test for attribute existence.
   */
 public String getAttrURI(int index) {
    return libsbmlJNI.XMLToken_getAttrURI(swigCPtr, this, index);
  }

  
  /**
   * Return the value of an attribute in the attribute set in this XMLToken  
   * (by position).
   * <p>
   * @param index an integer, the position of the attribute whose value is 
   * required.
   * <p>
   * @return the value of an attribute in the attribute set (by position).  
   * <p>
   * @note If index
   * is out of range, an empty string will be returned. Use hasAttr(index)
   * to test for attribute existence.
   */
 public String getAttrValue(int index) {
    return libsbmlJNI.XMLToken_getAttrValue__SWIG_0(swigCPtr, this, index);
  }

  
  /**
   * Return a value of an attribute with the given local name and namespace URI.
   * <p>
   * @param name a string, the local name of the attribute whose value is required.
   * @param uri  a string, the namespace URI of the attribute.
   * <p>
   * @return The attribute value as a string.  
   * <p>
   * @note If an attribute with the 
   * given local name and namespace URI does not exist, an empty string will be 
   * returned.  
   * Use hasAttr(name, uri) to test for attribute existence.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public String getAttrValue(String name, String uri) {
    return libsbmlJNI.XMLToken_getAttrValue__SWIG_1(swigCPtr, this, name, uri);
  }

  
  /**
   * Return a value of an attribute with the given local name and namespace URI.
   * <p>
   * @param name a string, the local name of the attribute whose value is required.
   * @param uri  a string, the namespace URI of the attribute.
   * <p>
   * @return The attribute value as a string.  
   * <p>
   * @note If an attribute with the 
   * given local name and namespace URI does not exist, an empty string will be 
   * returned.  
   * Use hasAttr(name, uri) to test for attribute existence.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public String getAttrValue(String name) {
    return libsbmlJNI.XMLToken_getAttrValue__SWIG_2(swigCPtr, this, name);
  }

  
  /**
   * Return a value of an attribute with the given XMLTriple.
   * <p>
   * @param triple an XMLTriple, the XML triple of the attribute whose 
   *        value is required.
   * <p>
   * @return The attribute value as a string.  
   * <p>
   * @note If an attribute with the
   * given XMLTriple does not exist, an empty string will be returned.  
   * Use hasAttr(triple) to test for attribute existence.
   */
 public String getAttrValue(XMLTriple triple) {
    return libsbmlJNI.XMLToken_getAttrValue__SWIG_3(swigCPtr, this, XMLTriple.getCPtr(triple), triple);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether
   * an attribute with the given index exists in the attribute set in this 
   * XMLToken.
   * <p>
   * @param index an integer, the position of the attribute.
   * <p>
   * @return <code>true</code> if an attribute with the given index exists in the attribute 
   * set in this XMLToken, <code>false</code> otherwise.
   */
 public boolean hasAttr(int index) {
    return libsbmlJNI.XMLToken_hasAttr__SWIG_0(swigCPtr, this, index);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether
   * an attribute with the given local name and namespace URI exists 
   * in the attribute set in this XMLToken.
   * <p>
   * @param name a string, the local name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   * <p>
   * @return <code>true</code> if an attribute with the given local name and namespace 
   * URI exists in the attribute set in this XMLToken, <code>false</code> otherwise.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public boolean hasAttr(String name, String uri) {
    return libsbmlJNI.XMLToken_hasAttr__SWIG_1(swigCPtr, this, name, uri);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether
   * an attribute with the given local name and namespace URI exists 
   * in the attribute set in this XMLToken.
   * <p>
   * @param name a string, the local name of the attribute.
   * @param uri  a string, the namespace URI of the attribute.
   * <p>
   * @return <code>true</code> if an attribute with the given local name and namespace 
   * URI exists in the attribute set in this XMLToken, <code>false</code> otherwise.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public boolean hasAttr(String name) {
    return libsbmlJNI.XMLToken_hasAttr__SWIG_2(swigCPtr, this, name);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether
   * an attribute with the given XML triple exists in the attribute set in 
   * this XMLToken 
   * <p>
   * @param triple an XMLTriple, the XML triple of the attribute 
   * <p>
   * @return <code>true</code> if an attribute with the given XML triple exists
   * in the attribute set in this XMLToken, <code>false</code> otherwise.
   * <p>
   */
 public boolean hasAttr(XMLTriple triple) {
    return libsbmlJNI.XMLToken_hasAttr__SWIG_3(swigCPtr, this, XMLTriple.getCPtr(triple), triple);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * the attribute set in this XMLToken set is empty.
   * <p>
   * @return <code>true</code> if the attribute set in this XMLToken is empty, 
   * <code>false</code> otherwise.
   */
 public boolean isAttributesEmpty() {
    return libsbmlJNI.XMLToken_isAttributesEmpty(swigCPtr, this);
  }

  
  /**
   * Returns the XML namespace declarations for this XML element.
   * <p>
   * @return the XML namespace declarations for this XML element.
   */
 public XMLNamespaces getNamespaces() {
    return new XMLNamespaces(libsbmlJNI.XMLToken_getNamespaces(swigCPtr, this), false);
  }

  
  /**
   * Sets an XMLnamespaces to this XML element.
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param namespaces XMLNamespaces to be set to this XMLToken.
   * <p>
   * @note This function replaces the existing XMLNamespaces with the new one.
   */
 public void setNamespaces(XMLNamespaces namespaces) {
    libsbmlJNI.XMLToken_setNamespaces(swigCPtr, this, XMLNamespaces.getCPtr(namespaces), namespaces);
  }

  
  /**
   * Appends an XML namespace prefix and URI pair to this XMLToken.
   * If there is an XML namespace with the given prefix in this XMLToken, 
   * then the existing XML namespace will be overwritten by the new one.
   * <p>
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param uri a string, the uri for the namespace
   * @param prefix a string, the prefix for the namespace
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public void addNamespace(String uri, String prefix) {
    libsbmlJNI.XMLToken_addNamespace__SWIG_0(swigCPtr, this, uri, prefix);
  }

  
  /**
   * Appends an XML namespace prefix and URI pair to this XMLToken.
   * If there is an XML namespace with the given prefix in this XMLToken, 
   * then the existing XML namespace will be overwritten by the new one.
   * <p>
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param uri a string, the uri for the namespace
   * @param prefix a string, the prefix for the namespace
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public void addNamespace(String uri) {
    libsbmlJNI.XMLToken_addNamespace__SWIG_1(swigCPtr, this, uri);
  }

  
  /**
   * Removes an XML Namespace stored in the given position of the XMLNamespaces
   * of this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param index an integer, position of the removed namespace.
   */
 public void removeNamespace(int index) {
    libsbmlJNI.XMLToken_removeNamespace__SWIG_0(swigCPtr, this, index);
  }

  
  /**
   * Removes an XML Namespace with the given prefix.
   * Nothing will be done if this XMLToken is not a start element.
   * <p>
   * @param prefix a string, prefix of the required namespace.
   */
 public void removeNamespace(String prefix) {
    libsbmlJNI.XMLToken_removeNamespace__SWIG_1(swigCPtr, this, prefix);
  }

  
  /**
   * Clears (deletes) all XML namespace declarations in the XMLNamespaces of
   * this XMLToken.
   * Nothing will be done if this XMLToken is not a start element.
   */
 public void clearNamespaces() {
    libsbmlJNI.XMLToken_clearNamespaces(swigCPtr, this);
  }

  
  /**
   * Look up the index of an XML namespace declaration by URI.
   * <p>
   * @param uri a string, uri of the required namespace.
   * <p>
   * @return the index of the given declaration, or -1 if not present.
   */
 public int getNamespaceIndex(String uri) {
    return libsbmlJNI.XMLToken_getNamespaceIndex(swigCPtr, this, uri);
  }

  
  /**
   * Look up the index of an XML namespace declaration by prefix.
   * <p>
   * @param prefix a string, prefix of the required namespace.
   * <p>
   * @return the index of the given declaration, or -1 if not present.
   */
 public int getNamespaceIndexByPrefix(String prefix) {
    return libsbmlJNI.XMLToken_getNamespaceIndexByPrefix(swigCPtr, this, prefix);
  }

  
  /**
   * Returns the number of XML namespaces stored in the XMLNamespaces 
   * of this XMLToken.
   * <p>
   * @return the number of namespaces in this list.
   */
 public int getNamespacesLength() {
    return libsbmlJNI.XMLToken_getNamespacesLength(swigCPtr, this);
  }

  
  /**
   * Look up the prefix of an XML namespace declaration by position.
   * <p>
   * Callers should use getNamespacesLength() to find out how many 
   * namespaces are stored in the XMLNamespaces.
   * <p>
   * @param index an integer, position of the required prefix.
   * <p>
   * @return the prefix of an XML namespace declaration in the XMLNamespaces 
   * (by position).  
   * <p>
   * @note If index is out of range, an empty string will be
   * returned.
   * <p>
   * @see #getNamespacesLength()
   */
 public String getNamespacePrefix(int index) {
    return libsbmlJNI.XMLToken_getNamespacePrefix__SWIG_0(swigCPtr, this, index);
  }

  
  /**
   * Look up the prefix of an XML namespace declaration by its URI.
   * <p>
   * @param uri a string, the URI of the prefix being sought
   * <p>
   * @return the prefix of an XML namespace declaration given its URI.  
   * <p>
   * @note If <code>uri</code> does not exist, an empty string will be returned.
   */
 public String getNamespacePrefix(String uri) {
    return libsbmlJNI.XMLToken_getNamespacePrefix__SWIG_1(swigCPtr, this, uri);
  }

  
  /**
   * Look up the URI of an XML namespace declaration by its position.
   * <p>
   * @param index an integer, position of the required URI.
   * <p>
   * @return the URI of an XML namespace declaration in the XMLNamespaces
   * (by position).  
   * <p>
   * @note If <code>index</code> is out of range, an empty string will be
   * returned.
   * <p>
   * @see #getNamespacesLength()
   */
 public String getNamespaceURI(int index) {
    return libsbmlJNI.XMLToken_getNamespaceURI__SWIG_0(swigCPtr, this, index);
  }

  
  /**
   * Look up the URI of an XML namespace declaration by its prefix.
   * <p>
   * @param prefix a string, the prefix of the required URI
   * <p>
   * @return the URI of an XML namespace declaration given its prefix.  
   * <p>
   * @note If <code>prefix</code> does not exist, an empty string will be returned.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public String getNamespaceURI(String prefix) {
    return libsbmlJNI.XMLToken_getNamespaceURI__SWIG_1(swigCPtr, this, prefix);
  }

  
  /**
   * Look up the URI of an XML namespace declaration by its prefix.
   * <p>
   * @param prefix a string, the prefix of the required URI
   * <p>
   * @return the URI of an XML namespace declaration given its prefix.  
   * <p>
   * @note If <code>prefix</code> does not exist, an empty string will be returned.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public String getNamespaceURI() {
    return libsbmlJNI.XMLToken_getNamespaceURI__SWIG_2(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * the XMLNamespaces of this XMLToken is empty.
   * <p>
   * @return <code>true</code> if the XMLNamespaces of this XMLToken is empty, 
   * <code>false</code> otherwise.
   */
 public boolean isNamespacesEmpty() {
    return libsbmlJNI.XMLToken_isNamespacesEmpty(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * an XML Namespace with the given URI is contained in the XMLNamespaces of
   * this XMLToken.
   * <p>
   * @param uri a string, the uri for the namespace
   * <p>
   * @return <code>true</code> if an XML Namespace with the given URI is contained in the
   * XMLNamespaces of this XMLToken,  <code>false</code> otherwise.
   */
 public boolean hasNamespaceURI(String uri) {
    return libsbmlJNI.XMLToken_hasNamespaceURI(swigCPtr, this, uri);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * an XML Namespace with the given prefix is contained in the XMLNamespaces of
   * this XMLToken.
   * <p>
   * @param prefix a string, the prefix for the namespace
   * <p>
   * @return <code>true</code> if an XML Namespace with the given URI is contained in the
   * XMLNamespaces of this XMLToken, <code>false</code> otherwise.
   */
 public boolean hasNamespacePrefix(String prefix) {
    return libsbmlJNI.XMLToken_hasNamespacePrefix(swigCPtr, this, prefix);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * an XML Namespace with the given uri/prefix pair is contained in the 
   * XMLNamespaces ofthis XMLToken.
   * <p>
   * @param uri a string, the uri for the namespace
   * @param prefix a string, the prefix for the namespace
   * <p>
   * @return <code>true</code> if an XML Namespace with the given uri/prefix pair is 
   * contained in the XMLNamespaces of this XMLToken,  <code>false</code> otherwise.
   */
 public boolean hasNamespaceNS(String uri, String prefix) {
    return libsbmlJNI.XMLToken_hasNamespaceNS(swigCPtr, this, uri, prefix);
  }

  
  /**
   * Sets the XMLTripe (name, uri and prefix) of this XML element.
   * Nothing will be done if this XML element is a text node.
   * <p>
   * @param triple XMLTriple to be added to this XML element.
   */
 public void setTriple(XMLTriple triple) {
    libsbmlJNI.XMLToken_setTriple(swigCPtr, this, XMLTriple.getCPtr(triple), triple);
  }

  
  /**
   * Returns the (unqualified) name of this XML element.
   * <p>
   * @return the (unqualified) name of this XML element.
   */
 public String getName() {
    return libsbmlJNI.XMLToken_getName(swigCPtr, this);
  }

  
  /**
   * Returns the namespace prefix of this XML element.
   * <p>
   * @return the namespace prefix of this XML element.  
   * <p>
   * @note If no prefix
   * exists, an empty string will be return.
   */
 public String getPrefix() {
    return libsbmlJNI.XMLToken_getPrefix(swigCPtr, this);
  }

  
  /**
   * Returns the namespace URI of this XML element.
   * <p>
   * @return the namespace URI of this XML element.
   */
 public String getURI() {
    return libsbmlJNI.XMLToken_getURI(swigCPtr, this);
  }

  
  /**
   * Returns the text of this element.
   * <p>
   * @return the characters of this XML text.
   */
 public String getCharacters() {
    return libsbmlJNI.XMLToken_getCharacters(swigCPtr, this);
  }

  
  /**
   * Appends characters to this XML text content.
   * <p>
   * @param chars string, characters to append
   */
 public void append(String chars) {
    libsbmlJNI.XMLToken_append(swigCPtr, this, chars);
  }

  
  /**
   * Returns the column at which this XMLToken occurred in the input
   * document or data stream.
   * <p>
   * @return the column at which this XMLToken occurred.
   */
 public long getColumn() {
    return libsbmlJNI.XMLToken_getColumn(swigCPtr, this);
  }

  
  /**
   * Returns the line at which this XMLToken occurred in the input document
   * or data stream.
   * <p>
   * @return the line at which this XMLToken occurred.
   */
 public long getLine() {
    return libsbmlJNI.XMLToken_getLine(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * this XMLToken is an XML element.
   * <p>
   * @return <code>true</code> if this XMLToken is an XML element, <code>false</code> otherwise.
   */
 public boolean isElement() {
    return libsbmlJNI.XMLToken_isElement(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * this XMLToken is an XML end element.
   * <p>
   * @return <code>true</code> if this XMLToken is an XML end element, <code>false</code> otherwise.
   */
 public boolean isEnd() {
    return libsbmlJNI.XMLToken_isEnd(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * this XMLToken is an XML end element for the given start element.
   * <p>
   * @param element XMLToken, element for which query is made.
   * <p>
   * @return <code>true</code> if this XMLToken is an XML end element for the given
   * XMLToken start element, <code>false</code> otherwise.
   */
 public boolean isEndFor(XMLToken element) {
    return libsbmlJNI.XMLToken_isEndFor(swigCPtr, this, XMLToken.getCPtr(element), element);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * this XMLToken is an end of file marker.
   * <p>
   * @return <code>true</code> if this XMLToken is an end of file (input) marker, <code>false</code>
   * otherwise.
   */
 public boolean isEOF() {
    return libsbmlJNI.XMLToken_isEOF(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * this XMLToken is an XML start element.
   * <p>
   * @return <code>true</code> if this XMLToken is an XML start element, <code>false</code> otherwise.
   */
 public boolean isStart() {
    return libsbmlJNI.XMLToken_isStart(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * this XMLToken is an XML text element.
   * <p>
   * @return <code>true</code> if this XMLToken is an XML text element, <code>false</code> otherwise.
   */
 public boolean isText() {
    return libsbmlJNI.XMLToken_isText(swigCPtr, this);
  }

  
  /**
   * Declares this XML start element is also an end element.
   */
 public void setEnd() {
    libsbmlJNI.XMLToken_setEnd(swigCPtr, this);
  }

  
  /**
   * Declares this XMLToken is an end-of-file (input) marker.
   */
 public void setEOF() {
    libsbmlJNI.XMLToken_setEOF(swigCPtr, this);
  }

  
  /**
   * Declares this XML start/end element is no longer an end element.
   */
 public void unsetEnd() {
    libsbmlJNI.XMLToken_unsetEnd(swigCPtr, this);
  }

  
  /**
   * Writes this XMLToken to stream.
   * <p>
   * @param stream XMLOutputStream, stream to which this XMLToken
   * is to be written.
   <p>
 * @deprecated libSBML internal
 */
 public void write(XMLOutputStream stream) {
    libsbmlJNI.XMLToken_write(swigCPtr, this, XMLOutputStream.getCPtr(stream), stream);
  }

  
  /**
   * Prints a string representation of the underlying token stream, for
   * debugging purposes.
   */
 public String toString() {
    return libsbmlJNI.XMLToken_toString(swigCPtr, this);
  }

}
