/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's SimpleSpeciesReference construct.
 * <p>
 * As mentioned in the description of {@link Reaction}, every species that enters
 * into a given reaction must appear in that reaction's lists of reactants,
 * products and/or modifiers.  In an SBML model, all species that may
 * participate in any reaction are listed in the 'listOfSpecies' element of
 * the top-level {@link Model} object.  Lists of products, reactants and modifiers
 * in {@link Reaction} objects do not introduce new species, but rather, they refer
 * back to those listed in the model's top-level 'listOfSpecies'.  For
 * reactants and products, the connection is made using {@link SpeciesReference}
 * objects; for modifiers, it is made using {@link ModifierSpeciesReference}
 * objects.  {@link SimpleSpeciesReference} is an abstract type that serves as the
 * parent class of both {@link SpeciesReference} and {@link ModifierSpeciesReference}.  It
 * is used simply to hold the attributes and elements that are common to
 * the latter two structures.
 * <p>
 * The {@link SimpleSpeciesReference} structure has a mandatory attribute,
 * 'species', which must be a text string conforming to the identifer
 * syntax permitted in SBML.  This attribute is inherited by the
 * {@link SpeciesReference} and {@link ModifierSpeciesReference} subclasses derived from
 * {@link SimpleSpeciesReference}.  The value of the 'species' attribute must be
 * the identifier of a species defined in the enclosing {@link Model}.  The species
 * is thereby declared as participating in the reaction being defined.  The
 * precise role of that species as a reactant, product, or modifier in the
 * reaction is determined by the subclass of {@link SimpleSpeciesReference} (i.e.,
 * either {@link SpeciesReference} or {@link ModifierSpeciesReference}) in which the
 * identifier appears.
 * <p>
 * {@link SimpleSpeciesReference} also contains an optional attribute, 'id',
 * allowing instances to be referenced from other structures.  No SBML
 * structures currently do this; however, such structures are anticipated
 * in future SBML Levels.
 * <p>
 * <p>
 * <!---------------------------------------------------------------------- -->
 * <p>
 */

public class SimpleSpeciesReference extends SBase {
   private long swigCPtr;

   protected SimpleSpeciesReference(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGSimpleSpeciesReferenceUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(SimpleSpeciesReference obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (SimpleSpeciesReference obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_SimpleSpeciesReference(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Get the value of the 'species' attribute.
   * <p>
   * @return the value of the attribute 'species' for this
   * {@link SimpleSpeciesReference}.
   */
 public String getSpecies() {
    return libsbmlJNI.SimpleSpeciesReference_getSpecies(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link SimpleSpeciesReference}'s 'species' attribute has been set.
   * <p>
   * @return <code>true</code> if the 'species' attribute of this
   * {@link SimpleSpeciesReference} has been set, <code>false</code> otherwise.
   */
 public boolean isSetSpecies() {
    return libsbmlJNI.SimpleSpeciesReference_isSetSpecies(swigCPtr, this);
  }

  
  /**
   * Sets the 'species' attribute of this {@link SimpleSpeciesReference}.
   * <p>
   * The identifier string passed in <code>sid</code> is copied.
   * <p>
   * @param sid the identifier of a species defined in the enclosing
   * {@link Model}'s {@link ListOfSpecies}.
   */
 public void setSpecies(String sid) {
    libsbmlJNI.SimpleSpeciesReference_setSpecies(swigCPtr, this, sid);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * is a {@link ModifierSpeciesReference}.
   * <p>
   * @return <code>true</code> if this {@link SimpleSpeciesReference}'s subclass is
   * ModiferSpeciesReference, <code>false</code> if it is a plain {@link SpeciesReference}.
   */
 public boolean isModifier() {
    return libsbmlJNI.SimpleSpeciesReference_isModifier(swigCPtr, this);
  }

}
