/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Model construct.
 * <p>
 * In an SBML model definition, a single object of class {@link Model} serves as
 * the overall container for the lists of the various model components.
 * All of the lists are optional, but if a given list container is present
 * within the model, the list must not be empty; that is, it must have
 * length one or more.  The following are the components and lists
 * permitted in different Levels and Versions of SBML as of this version
 * of libSBML (3.3):
 * <ul>
 * <li> In SBML Level 1, the components are: {@link UnitDefinition}, {@link Compartment},
 * {@link Species}, {@link Parameter}, {@link Rule}, and {@link Reaction}.  Instances of the classes are
 * placed inside instances of classes {@link ListOfUnitDefinitions},
 * {@link ListOfCompartments}, {@link ListOfSpecies}, {@link ListOfParameters}, {@link ListOfRules}, and
 * {@link ListOfReactions}.
 * <p>
 * <li> In SBML Level 2 Version 1, the components are: {@link FunctionDefinition},
 * {@link UnitDefinition}, {@link Compartment}, {@link Species}, {@link Parameter}, {@link Rule}, {@link Reaction} and
 * {@link Event}.  Instances of the classes are placed inside instances of classes
 * {@link ListOfFunctionDefinitions}, {@link ListOfUnitDefinitions}, {@link ListOfCompartments},
 * {@link ListOfSpecies}, {@link ListOfParameters}, {@link ListOfRules}, {@link ListOfReactions}, and
 * {@link ListOfEvents}.
 * <p>
 * <li> In SBML Level 2 Versions 2, 3 and 4, the components are:
 * {@link FunctionDefinition}, {@link UnitDefinition}, {@link CompartmentType}, {@link SpeciesType},
 * {@link Compartment}, {@link Species}, {@link Parameter}, {@link InitialAssignment}, {@link Rule}, {@link Constraint},
 * {@link Reaction} and {@link Event}.  Instances of the classes are placed inside
 * instances of classes {@link ListOfFunctionDefinitions}, {@link ListOfUnitDefinitions},
 * {@link ListOfCompartmentTypes}, {@link ListOfSpeciesTypes}, {@link ListOfCompartments},
 * {@link ListOfSpecies}, {@link ListOfParameters}, {@link ListOfInitialAssignments}, {@link ListOfRules},
 * {@link ListOfConstraints}, {@link ListOfReactions}, and {@link ListOfEvents}.
 * </ul>
 * <p>
 * Although all the lists are optional, there are dependencies between SBML
 * components such that defining some components requires defining others.
 * An example is that defining a species requires defining a compartment,
 * and defining a reaction requires defining a species.  The dependencies
 * are explained in more detail in the SBML specifications.
 * <p>
 * <h2>Approaches to creating objects using the libSBML API</h2>
 * <p>
 * LibSBML provides two main mechanisms for creating objects: class
 * constructors (e.g., <a href='org/sbml/libsbml/{@link Species}.html'>{@link Species}()</a> ),
 * and <code>create<i>Object</i>()</code> methods (such as
 * {@link Model#createSpecies()}) provided by certain object classes such as
 * {@link Model}.  These multiple mechanisms are provided by libSBML for
 * flexibility and to support different use-cases, but they also have
 * different implications for the overall model structure.
 * <p>
 * In general, the recommended approach is to use the
 * <code>create<i>Object</i>()</code> methods.  These methods both create
 * an object <em>and</em> link it to the parent in one step.  Here is an
 * example:
 * <div class='fragment'><pre>
// Create an {@link SBMLDocument} object in Level 2 Version 4 format:

{@link SBMLDocument}* sbmlDoc = new {@link SBMLDocument}(2, 4);

// Create a {@link Model} object inside the {@link SBMLDocument} object and set
// its identifier.  The call returns a pointer to the {@link Model} object
// created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).

{@link Model}* model = sbmlDoc-&gt;createModel();
model-&gt;setId('MyModel');

// Create a {@link Species} object inside the {@link Model} and set its identifier.
// Similar to the lines above, this call returns a pointer to the {@link Species}
// object created, and methods called on that object affect the attributes
// of the object attached to the model (as expected).

{@link Species} *sp = model-&gt;createSpecies();
sp-&gt;setId('MySpecies');
</pre></div>
 * <p>
 * The <code>create<i>Object</i>()</code> methods return a pointer to the
 * object created, but they also add the object to the relevant list of
 * object instances contained in the parent.  (These lists become the
 * <code>&lt;listOf<i>Object</i>s&gt;</code> elements in the finished XML
 * rendition of SBML.)  In the example above, {@link Model#createSpecies()} adds
 * the created species directly to the <code>&lt;listOfSpecies&gt;</code>
 * list in the model.  Subsequently, methods called on the species change
 * the species in the model (which is what is expected in most situations).
 * <p>
 * By contrast, the other main way of creating an object and adding it to a
 * parent makes a <em>copy</em> of the object, and requires more care on the
 * part of the caller.  Here is an example of this alternative approach:
 * <div class='fragment'><pre>
// Create a {@link Species} object and add it to the model.
// This uses the {@link Species} class constructor:

{@link Species} *newsp = {@link Species}('MySpecies');
model-&gt;addSpecies(newsp); // Warning! This makes a COPY inside 'model'.

// addSpecies(...) copies the object, with the result that
// 'newsp' still refers to the original.  The following may not
// do what is expected:

newsp.setId('NewId');    // Warning -- doesn't change the species in 'model'!

// If 'newsp' object isn't going to be used further, it needs
// to be deleted to avoid a memory leak.

delete newsp;
</pre></div>
 * <p>
 * The key point of the example above is that, because the {@link Model#addSpecies(Species s)} 
 * call makes a copy of the object handed to it, care is needed both when
 * attempting to make changes to the object, and when the original object
 * is no longer needed.
 * <p>
 * <h2>Consistency and adherence to SBML specifications</h2>
 * <p>
 * To make it easier for applications to do whatever they need,
 * libSBML&nbsp;3.x is relatively lax when it comes to enforcing
 * correctness and completeness of models during model construction and
 * editing.  Essentially, libSBML <em>will</em> <em>not</em> in most cases check
 * automatically that a model's components have valid attribute values, or
 * that the overall model is consistent and free of errors&mdash;even
 * obvious errors such as duplication of identifiers.  This allows
 * applications great leeway in how they build their models, but it means
 * that software authors must take deliberate steps to ensure that the
 * model will be, in the end, valid SBML.  These steps include such things
 * as keeping track of the identifiers used in a model, manually performing
 * updates in certain situations where an entity is referenced in more than
 * one place (e.g., a species that is referenced by multiple
 * {@link SpeciesReference} objects), and so on.
 * <p>
 * That said, libSBML does provide powerful features for deliberately
 * performing validation of SBML when an application decides it is time to
 * do so.  The interfaces to these facilities are on the {@link SBMLDocument}
 * class, in the form of {@link SBMLDocument#checkInternalConsistency()} and
 * {@link SBMLDocument#checkConsistency()}.  Please refer to the documentation for
 * {@link SBMLDocument} for more information about this.
 * <p>
 * While applications may play fast and loose and live like free spirits
 * during the construction and editing of SBML models, they should always
 * make sure to call {@link SBMLDocument#checkInternalConsistency()} and/or
 * {@link SBMLDocument#checkConsistency()} before writing out the final version of
 * an SBML model.
 */

public class Model extends SBase {
   private long swigCPtr;

   protected Model(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGModelUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Model obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Model obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_Model(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link Model}, optionally with a given identifier and
   * name.
   * <p>
   * @param id a string, the optional identifier of this {@link Model}
   * @param name a string, the optional name of this {@link Model}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Model(String id, String name) {
    this(libsbmlJNI.new_Model__SWIG_0(id, name), true);
  }

  
  /**
   * Creates a new {@link Model}, optionally with a given identifier and
   * name.
   * <p>
   * @param id a string, the optional identifier of this {@link Model}
   * @param name a string, the optional name of this {@link Model}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Model(String id) {
    this(libsbmlJNI.new_Model__SWIG_1(id), true);
  }

  
  /**
   * Creates a new {@link Model}, optionally with a given identifier and
   * name.
   * <p>
   * @param id a string, the optional identifier of this {@link Model}
   * @param name a string, the optional name of this {@link Model}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Model() {
    this(libsbmlJNI.new_Model__SWIG_2(), true);
  }

  
  /**
   * Creates a new {@link Model} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Model}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Model}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link Model}
   * <p>
   * @note Once a {@link Model} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link Model}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public Model(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_Model__SWIG_3(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link Model} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Model}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Model}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link Model}
   * <p>
   * @note Once a {@link Model} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link Model}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public Model(long level, long version) {
    this(libsbmlJNI.new_Model__SWIG_4(level, version), true);
  }

  
  /**
  * Copy constructor; creates a (deep) copy of the given {@link Model} object.
  */
 public Model(Model orig) {
    this(libsbmlJNI.new_Model__SWIG_5(Model.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Model} object.
   * <p>
   * @return a (deep) copy of this {@link Model}.
   */
 public Model cloneObject() {
    long cPtr = libsbmlJNI.Model_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Model(cPtr, true);
  }

  
  /**
   * Returns the {@link ModelHistory} of this {@link Model}.
   * <p>
   * @return {@link ModelHistory} of this {@link Model}.
   */
 public ModelHistory getModelHistory() {
    long cPtr = libsbmlJNI.Model_getModelHistory__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ModelHistory(cPtr, false);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link Model}'s {@link ModelHistory} has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the {@link ModelHistory} of this {@link Model}
   * has been set, <code>false</code> otherwise.
   */
 public boolean isSetModelHistory() {
    return libsbmlJNI.Model_isSetModelHistory(swigCPtr, this);
  }

  
  /**
   * Sets the {@link ModelHistory} of this {@link Model}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param history {@link ModelHistory} of this {@link Model}.
   */
 public void setModelHistory(ModelHistory history) {
    libsbmlJNI.Model_setModelHistory(swigCPtr, this, ModelHistory.getCPtr(history), history);
  }

  
  /**
   * Unsets the {@link ModelHistory} of this {@link Model}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   */
 public void unsetModelHistory() {
    libsbmlJNI.Model_unsetModelHistory(swigCPtr, this);
  }

  
  /**
   * Adds a copy of the given {@link FunctionDefinition} object to this {@link Model}.
   * <p>
   * @param fd the {@link FunctionDefinition} to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createFunctionDefinition()}
   * for a method that does not lead to these issues.
   * <p>
   * @see #createFunctionDefinition()
   */
 public void addFunctionDefinition(FunctionDefinition fd) {
    libsbmlJNI.Model_addFunctionDefinition(swigCPtr, this, FunctionDefinition.getCPtr(fd), fd);
  }

  
  /**
   * Adds a copy of the given {@link UnitDefinition} object to this {@link Model}.
   * <p>
   * @param ud the {@link UnitDefinition} object to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createUnitDefinition()} for
   * a method that does not lead to these issues.
   * <p>
   * @see #createUnitDefinition()
   */
 public void addUnitDefinition(UnitDefinition ud) {
    libsbmlJNI.Model_addUnitDefinition(swigCPtr, this, UnitDefinition.getCPtr(ud), ud);
  }

  
  /**
   * Adds a copy of the given {@link CompartmentType} object to this {@link Model}.
   * <p>
   * @param ct the {@link CompartmentType} object to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createCompartmentType()}
   * for a method that does not lead to these issues.
   * <p>
   * @see #createCompartmentType()
   */
 public void addCompartmentType(CompartmentType ct) {
    libsbmlJNI.Model_addCompartmentType(swigCPtr, this, CompartmentType.getCPtr(ct), ct);
  }

  
  /**
   * Adds a copy of the given {@link SpeciesType} object to this {@link Model}.
   * <p>
   * @param st the {@link SpeciesType} object to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createSpeciesType()} for a
   * method that does not lead to these issues.
   * <p>
   * @see #createSpeciesType()
   */
 public void addSpeciesType(SpeciesType st) {
    libsbmlJNI.Model_addSpeciesType(swigCPtr, this, SpeciesType.getCPtr(st), st);
  }

  
  /**
   * Adds a copy of the given {@link Compartment} object to this {@link Model}.
   * <p>
   * @param c the {@link Compartment} object to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createCompartment()} for a
   * method that does not lead to these issues.
   * <p>
   * @see #createCompartment()
   */
 public void addCompartment(Compartment c) {
    libsbmlJNI.Model_addCompartment(swigCPtr, this, Compartment.getCPtr(c), c);
  }

  
  /**
   * Adds a copy of the given {@link Species} object to this {@link Model}.
   * <p>
   * @param s the {@link Species} object to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createSpecies()} for a
   * method that does not lead to these issues.
   * <p>
   * @see #createSpecies()
   */
 public void addSpecies(Species s) {
    libsbmlJNI.Model_addSpecies(swigCPtr, this, Species.getCPtr(s), s);
  }

  
  /**
   * Adds a copy of the given {@link Parameter} object to this {@link Model}.
   * <p>
   * @param p the {@link Parameter} object to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createParameter()} for a
   * method that does not lead to these issues.
   * <p>
   * @see #createParameter()
   */
 public void addParameter(Parameter p) {
    libsbmlJNI.Model_addParameter(swigCPtr, this, Parameter.getCPtr(p), p);
  }

  
  /**
   * Adds a copy of the given {@link InitialAssignment} object to this {@link Model}.
   * <p>
   * @param ia the {@link InitialAssignment} object to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createInitialAssignment()}
   * for a method that does not lead to these issues.
   * <p>
   * @see #createInitialAssignment()
   */
 public void addInitialAssignment(InitialAssignment ia) {
    libsbmlJNI.Model_addInitialAssignment(swigCPtr, this, InitialAssignment.getCPtr(ia), ia);
  }

  
  /**
   * Adds a copy of the given {@link Rule} object to this {@link Model}.
   * <p>
   * @param r the {@link Rule} object to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createRule()} for a method
   * that does not lead to these issues.
   * <p>
   * @see #createRule()
   */
 public void addRule(Rule r) {
    libsbmlJNI.Model_addRule(swigCPtr, this, Rule.getCPtr(r), r);
  }

  
  /**
   * Adds a copy of the given {@link Constraint} object to this {@link Model}.
   * <p>
   * @param c the {@link Constraint} object to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createConstraint()} for a
   * method that does not lead to these issues.
   * <p>
   * @see #createConstraint()
   */
 public void addConstraint(Constraint c) {
    libsbmlJNI.Model_addConstraint(swigCPtr, this, Constraint.getCPtr(c), c);
  }

  
  /**
   * Adds a copy of the given {@link Reaction} object to this {@link Model}.
   * <p>
   * @param r the {@link Reaction} object to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createReaction()} for a
   * method that does not lead to these issues.
   * <p>
   * @see #createReaction()
   */
 public void addReaction(Reaction r) {
    libsbmlJNI.Model_addReaction(swigCPtr, this, Reaction.getCPtr(r), r);
  }

  
  /**
   * Adds a copy of the given {@link Event} object to this {@link Model}.
   * <p>
   * @param e the {@link Event} object to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Model}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Model}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Model#createEvent()} for a method
   * that does not lead to these issues.
   * <p>
   * @see #createEvent()
   */
 public void addEvent(Event e) {
    libsbmlJNI.Model_addEvent(swigCPtr, this, Event.getCPtr(e), e);
  }

  
  /**
   * Creates a new {@link FunctionDefinition} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link FunctionDefinition} object created
   * <p>
   * @see #addFunctionDefinition()
   */
 public FunctionDefinition createFunctionDefinition() {
    long cPtr = libsbmlJNI.Model_createFunctionDefinition(swigCPtr, this);
    return (cPtr == 0) ? null : new FunctionDefinition(cPtr, false);
  }

  
  /**
   * Creates a new {@link UnitDefinition} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link UnitDefinition} object created
   * <p>
   * @see #addUnitDefinition()
   */
 public UnitDefinition createUnitDefinition() {
    long cPtr = libsbmlJNI.Model_createUnitDefinition(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
  /**
   * Creates a new {@link Unit} object within the last {@link UnitDefinition} object
   * created in this model and returns a pointer to it.
   * <p>
   * The mechanism by which the {@link UnitDefinition} was created is not
   * significant.  If a {@link UnitDefinition} object does not exist in this model,
   * a new {@link Unit} is <em>not</em> created and NULL is returned instead.
   * <p>
   * @return the {@link Unit} object created
   * <p>
   * @see #addUnit()
   */
 public Unit createUnit() {
    long cPtr = libsbmlJNI.Model_createUnit(swigCPtr, this);
    return (cPtr == 0) ? null : new Unit(cPtr, false);
  }

  
  /**
   * Creates a new {@link CompartmentType} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link CompartmentType} object created
   * <p>
   * @see #addCompartmentType()
   */
 public CompartmentType createCompartmentType() {
    long cPtr = libsbmlJNI.Model_createCompartmentType(swigCPtr, this);
    return (cPtr == 0) ? null : new CompartmentType(cPtr, false);
  }

  
  /**
   * Creates a new {@link SpeciesType} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link SpeciesType} object created
   * <p>
   * @see #addSpeciesType()
   */
 public SpeciesType createSpeciesType() {
    long cPtr = libsbmlJNI.Model_createSpeciesType(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesType(cPtr, false);
  }

  
  /**
   * Creates a new {@link Compartment} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link Compartment} object created
   * <p>
   * @see #addCompartment()
   */
 public Compartment createCompartment() {
    long cPtr = libsbmlJNI.Model_createCompartment(swigCPtr, this);
    return (cPtr == 0) ? null : new Compartment(cPtr, false);
  }

  
  /**
   * Creates a new {@link Species} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link Species} object created
   * <p>
   * @see #addSpecies()
   */
 public Species createSpecies() {
    long cPtr = libsbmlJNI.Model_createSpecies(swigCPtr, this);
    return (cPtr == 0) ? null : new Species(cPtr, false);
  }

  
  /**
   * Creates a new {@link Parameter} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link Parameter} object created
   * <p>
   * @see #addParameter()
   */
 public Parameter createParameter() {
    long cPtr = libsbmlJNI.Model_createParameter(swigCPtr, this);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
  /**
   * Creates a new {@link InitialAssignment} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link InitialAssignment} object created
   * <p>
   * @see #addInitialAssignment()
   */
 public InitialAssignment createInitialAssignment() {
    long cPtr = libsbmlJNI.Model_createInitialAssignment(swigCPtr, this);
    return (cPtr == 0) ? null : new InitialAssignment(cPtr, false);
  }

  
  /**
   * Creates a new {@link AlgebraicRule} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link AlgebraicRule} object created
   * <p>
   * @see #addRule()
   */
 public AlgebraicRule createAlgebraicRule() {
    long cPtr = libsbmlJNI.Model_createAlgebraicRule(swigCPtr, this);
    return (cPtr == 0) ? null : new AlgebraicRule(cPtr, false);
  }

  
  /**
   * Creates a new {@link AssignmentRule} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link AssignmentRule} object created
   * <p>
   * @see #addRule()
   */
 public AssignmentRule createAssignmentRule() {
    long cPtr = libsbmlJNI.Model_createAssignmentRule(swigCPtr, this);
    return (cPtr == 0) ? null : new AssignmentRule(cPtr, false);
  }

  
  /**
   * Creates a new {@link RateRule} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link RateRule} object created
   * <p>
   * @see #addRule()
   */
 public RateRule createRateRule() {
    long cPtr = libsbmlJNI.Model_createRateRule(swigCPtr, this);
    return (cPtr == 0) ? null : new RateRule(cPtr, false);
  }

  
  /**
   * Creates a new {@link Constraint} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link Constraint} object created
   * <p>
   * @see #addConstraint()
   */
 public Constraint createConstraint() {
    long cPtr = libsbmlJNI.Model_createConstraint(swigCPtr, this);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  
  /**
   * Creates a new {@link Reaction} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link Reaction} object created
   * <p>
   * @see #addReaction()
   */
 public Reaction createReaction() {
    long cPtr = libsbmlJNI.Model_createReaction(swigCPtr, this);
    return (cPtr == 0) ? null : new Reaction(cPtr, false);
  }

  
  /**
   * Creates a new {@link SpeciesReference} object for a reactant inside the last
   * {@link Reaction} object in this {@link Model}, and returns a pointer to it.
   * <p>
   * The mechanism by which the last {@link Reaction} object was created and added
   * to this {@link Model} is not significant.  It could have been created in a
   * variety of ways, for example using createReaction().  If a {@link Reaction}
   * does not exist for this model, a new {@link SpeciesReference} is <em>not</em>
   * created and NULL is returned instead.
   * <p>
   * @return the {@link SpeciesReference} object created
   */
 public SpeciesReference createReactant() {
    long cPtr = libsbmlJNI.Model_createReactant(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
  /**
   * Creates a new {@link SpeciesReference} object for a product inside the last
   * {@link Reaction} object in this {@link Model}, and returns a pointer to it.
   * <p>
   * The mechanism by which the last {@link Reaction} object was created and added
   * to this {@link Model} is not significant.  It could have been created in a
   * variety of ways, for example using createReaction().  If a {@link Reaction}
   * does not exist for this model, a new {@link SpeciesReference} is <em>not</em>
   * created and NULL is returned instead.
   * <p>
   * @return the {@link SpeciesReference} object created
   */
 public SpeciesReference createProduct() {
    long cPtr = libsbmlJNI.Model_createProduct(swigCPtr, this);
    return (cPtr == 0) ? null : new SpeciesReference(cPtr, false);
  }

  
  /**
   * Creates a new {@link ModifierSpeciesReference} object for a modifier species
   * inside the last {@link Reaction} object in this {@link Model}, and returns a pointer
   * to it.
   * <p>
   * The mechanism by which the last {@link Reaction} object was created and added
   * to this {@link Model} is not significant.  It could have been created in a
   * variety of ways, for example using createReaction().  If a {@link Reaction}
   * does not exist for this model, a new {@link ModifierSpeciesReference} is 
   * <em>not</em> created and NULL is returned instead.
   * <p>
   * @return the {@link SpeciesReference} object created
   */
 public ModifierSpeciesReference createModifier() {
    long cPtr = libsbmlJNI.Model_createModifier(swigCPtr, this);
    return (cPtr == 0) ? null : new ModifierSpeciesReference(cPtr, false);
  }

  
  /**
   * Creates a new {@link KineticLaw} inside the last {@link Reaction} object created in
   * this {@link Model}, and returns a pointer to it.
   * <p>
   * The mechanism by which the last {@link Reaction} object was created and added
   * to this {@link Model} is not significant.  It could have been created in a
   * variety of ways, for example using createReaction().  If a {@link Reaction}
   * does not exist for this model, or a {@link Reaction} exists but already has a
   * {@link KineticLaw}, a new {@link KineticLaw} is <em>not</em> created and NULL is returned
   * instead.
   * <p>
   * @return the {@link KineticLaw} object created
   */
 public KineticLaw createKineticLaw() {
    long cPtr = libsbmlJNI.Model_createKineticLaw(swigCPtr, this);
    return (cPtr == 0) ? null : new KineticLaw(cPtr, false);
  }

  
  /**
   * Creates a new local {@link Parameter} inside the {@link KineticLaw} object of the last
   * {@link Reaction} created inside this {@link Model}, and returns a pointer to it.
   * <p>
   * The last {@link KineticLaw} object in this {@link Model} could have been created in a
   * variety of ways.  For example, it could have been added using
   * createKineticLaw(), or it could be the result of using
   * {@link Reaction#createKineticLaw()} on the {@link Reaction} object created by a
   * createReaction().  If a {@link Reaction} does not exist for this model, or the
   * last {@link Reaction} does not contain a {@link KineticLaw} object, a new {@link Parameter} is
   * <em>not</em> created and NULL is returned instead.
   * <p>
   * @return the {@link Parameter} object created
   */
 public Parameter createKineticLawParameter() {
    long cPtr = libsbmlJNI.Model_createKineticLawParameter(swigCPtr, this);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
  /**
   * Creates a new {@link Event} inside this {@link Model} and returns it.
   * <p>
   * @return the {@link Event} object created
   */
 public Event createEvent() {
    long cPtr = libsbmlJNI.Model_createEvent(swigCPtr, this);
    return (cPtr == 0) ? null : new Event(cPtr, false);
  }

  
  /**
   * Creates a new {@link EventAssignment} inside the last {@link Event} object created in
   * this {@link Model}, and returns a pointer to it.
   * <p>
   * The mechanism by which the last {@link Event} object in this model was created
   * is not significant.  It could have been created in a variety of ways,
   * for example by using createEvent().  If no {@link Event} object exists in this
   * {@link Model} object, a new {@link EventAssignment} is <em>not</em> created and NULL is
   * returned instead.
   * <p>
   * @return the {@link EventAssignment} object created
   */
 public EventAssignment createEventAssignment() {
    long cPtr = libsbmlJNI.Model_createEventAssignment(swigCPtr, this);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, false);
  }

  
  /**
   * Sets the value of the 'annotation' subelement of this SBML object to a
   * copy of <code>annotation</code>.
   * <p>
   * Any existing content of the 'annotation' subelement is discarded.
   * Unless you have taken steps to first copy and reconstitute any
   * existing annotations into the <code>annotation</code> that is about to be
   * assigned, it is likely that performing such wholesale replacement is
   * unfriendly towards other software applications whose annotations are
   * discarded.  An alternative may be to use appendAnnotation().
   * <p>
   * @param annotation an XML structure that is to be used as the content
   * of the 'annotation' subelement of this object
   * <p>
   * @see #appendAnnotation(const XMLNode* annotation)
   */
 public void setAnnotation(XMLNode annotation) {
    libsbmlJNI.Model_setAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
  /**
   * Sets the value of the 'annotation' subelement of this SBML object to a
   * copy of <code>annotation</code>.
   * <p>
   * Any existing content of the 'annotation' subelement is discarded.
   * Unless you have taken steps to first copy and reconstitute any
   * existing annotations into the <code>annotation</code> that is about to be
   * assigned, it is likely that performing such wholesale replacement is
   * unfriendly towards other software applications whose annotations are
   * discarded.  An alternative may be to use appendAnnotation().
   * <p>
   * @param annotation an XML string that is to be used as the content
   * of the 'annotation' subelement of this object
   * <p>
   * @see #appendAnnotation(const {@link std#string& annotation)}
   */
 public void setAnnotation(String annotation) {
    libsbmlJNI.Model_setAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
  /**
   * Appends annotation content to any existing content in the 'annotation'
   * subelement of this object.
   * <p>
   * The content in <code>annotation</code> is copied.  Unlike setAnnotation(), this
   * method allows other annotations to be preserved when an application
   * adds its own data.
   * <p>
   * @param annotation an XML structure that is to be copied and appended
   * to the content of the 'annotation' subelement of this object
   * <p>
   * @see #setAnnotation(const XMLNode* annotation)
   */
 public void appendAnnotation(XMLNode annotation) {
    libsbmlJNI.Model_appendAnnotation__SWIG_0(swigCPtr, this, XMLNode.getCPtr(annotation), annotation);
  }

  
  /**
   * Appends annotation content to any existing content in the 'annotation'
   * subelement of this object.
   * <p>
   * The content in <code>annotation</code> is copied.  Unlike setAnnotation(), this 
   * method allows other annotations to be preserved when an application
   * adds its own data.
   * <p>
   * @param annotation an XML string that is to be copied and appended
   * to the content of the 'annotation' subelement of this object
   * <p>
   * @see #setAnnotation(const {@link std#string& annotation)}
   */
 public void appendAnnotation(String annotation) {
    libsbmlJNI.Model_appendAnnotation__SWIG_1(swigCPtr, this, annotation);
  }

  
  /**
   * Get the {@link ListOfFunctionDefinitions} object in this {@link Model}.
   * <p>
   * @return the list of FunctionDefinitions for this {@link Model}.
   */
 public ListOfFunctionDefinitions getListOfFunctionDefinitions() {
    long cPtr = libsbmlJNI.Model_getListOfFunctionDefinitions__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfFunctionDefinitions(cPtr, false);
  }

  
  /**
   * Get the {@link ListOfUnitDefinitions} object in this {@link Model}.
   * <p>
   * @return the list of UnitDefinitions for this {@link Model}.
   */
 public ListOfUnitDefinitions getListOfUnitDefinitions() {
    long cPtr = libsbmlJNI.Model_getListOfUnitDefinitions__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfUnitDefinitions(cPtr, false);
  }

  
  /**
   * Get the {@link ListOfCompartmentTypes} object in this {@link Model}.
   * <p>
   * @return the list of CompartmentTypes for this {@link Model}.
   */
 public ListOfCompartmentTypes getListOfCompartmentTypes() {
    long cPtr = libsbmlJNI.Model_getListOfCompartmentTypes__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfCompartmentTypes(cPtr, false);
  }

  
  /**
   * Get the {@link ListOfSpeciesTypes} object in this {@link Model}.
   * <p>
   * @return the list of SpeciesTypes for this {@link Model}.
   */
 public ListOfSpeciesTypes getListOfSpeciesTypes() {
    long cPtr = libsbmlJNI.Model_getListOfSpeciesTypes__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfSpeciesTypes(cPtr, false);
  }

  
  /**
   * Get the {@link ListOfCompartments} object in this {@link Model}.
   * <p>
   * @return the list of Compartments for this {@link Model}.
   */
 public ListOfCompartments getListOfCompartments() {
    long cPtr = libsbmlJNI.Model_getListOfCompartments__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfCompartments(cPtr, false);
  }

  
  /**
   * Get the {@link ListOfSpecies} object in this {@link Model}.
   * <p>
   * @return the list of {@link Species} for this {@link Model}.
   */
 public ListOfSpecies getListOfSpecies() {
    long cPtr = libsbmlJNI.Model_getListOfSpecies__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfSpecies(cPtr, false);
  }

  
  /**
   * Get the {@link ListOfParameters} object in this {@link Model}.
   * <p>
   * @return the list of Parameters for this {@link Model}.
   */
 public ListOfParameters getListOfParameters() {
    long cPtr = libsbmlJNI.Model_getListOfParameters__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfParameters(cPtr, false);
  }

  
  /**
   * Get the {@link ListOfInitialAssignments} object in this {@link Model}.
   * <p>
   * @return the list of InitialAssignments for this {@link Model}.
   */
 public ListOfInitialAssignments getListOfInitialAssignments() {
    long cPtr = libsbmlJNI.Model_getListOfInitialAssignments__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfInitialAssignments(cPtr, false);
  }

  
  /**
   * Get the {@link ListOfRules} object in this {@link Model}.
   * <p>
   * @return the list of Rules for this {@link Model}.
   */
 public ListOfRules getListOfRules() {
    long cPtr = libsbmlJNI.Model_getListOfRules__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfRules(cPtr, false);
  }

  
  /**
   * Get the {@link ListOfConstraints} object in this {@link Model}.
   * <p>
   * @return the list of Constraints for this {@link Model}.
   */
 public ListOfConstraints getListOfConstraints() {
    long cPtr = libsbmlJNI.Model_getListOfConstraints__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfConstraints(cPtr, false);
  }

  
  /**
   * Get the {@link ListOfReactions} object in this {@link Model}.
   * <p>
   * @return the list of Reactions for this {@link Model}.
   */
 public ListOfReactions getListOfReactions() {
    long cPtr = libsbmlJNI.Model_getListOfReactions__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfReactions(cPtr, false);
  }

  
  /**
   * Get the {@link ListOfEvents} object in this {@link Model}.
   * <p>
   * @return the list of Events for this {@link Model}.
   */
 public ListOfEvents getListOfEvents() {
    long cPtr = libsbmlJNI.Model_getListOfEvents__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfEvents(cPtr, false);
  }

  
  /**
   * Get the nth FunctionDefinitions object in this {@link Model}.
   * <p>
   * @return the nth {@link FunctionDefinition} of this {@link Model}.
   */
 public FunctionDefinition getFunctionDefinition(long n) {
    long cPtr = libsbmlJNI.Model_getFunctionDefinition__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new FunctionDefinition(cPtr, false);
  }

  
  /**
   * Get a {@link FunctionDefinition} object based on its identifier.
   * <p>
   * @return the {@link FunctionDefinition} in this {@link Model} with the identifier 
   * <code>sid</code> or NULL if no such {@link FunctionDefinition} exists.
   */
 public FunctionDefinition getFunctionDefinition(String sid) {
    long cPtr = libsbmlJNI.Model_getFunctionDefinition__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new FunctionDefinition(cPtr, false);
  }

  
  /**
   * Get the nth {@link UnitDefinition} object in this {@link Model}.
   * <p>
   * @return the nth {@link UnitDefinition} of this {@link Model}.
   */
 public UnitDefinition getUnitDefinition(long n) {
    long cPtr = libsbmlJNI.Model_getUnitDefinition__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
  /**
   * Get a {@link UnitDefinition} based on its identifier.
   * <p>
   * @return the {@link UnitDefinition} in this {@link Model} with the identifier <code>sid</code> or
   * NULL if no such {@link UnitDefinition} exists.
   */
 public UnitDefinition getUnitDefinition(String sid) {
    long cPtr = libsbmlJNI.Model_getUnitDefinition__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
  /**
   * Get the nth {@link CompartmentType} object in this {@link Model}.
   * <p>
   * @return the nth {@link CompartmentType} of this {@link Model}.
   */
 public CompartmentType getCompartmentType(long n) {
    long cPtr = libsbmlJNI.Model_getCompartmentType__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new CompartmentType(cPtr, false);
  }

  
  /**
   * Get a {@link CompartmentType} object based on its identifier.
   * <p>
   * @return the {@link CompartmentType} in this {@link Model} with the identifier <code>sid</code>
   * or NULL if no such {@link CompartmentType} exists.
   */
 public CompartmentType getCompartmentType(String sid) {
    long cPtr = libsbmlJNI.Model_getCompartmentType__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new CompartmentType(cPtr, false);
  }

  
  /**
   * Get the nth {@link SpeciesType} object in this {@link Model}.
   * <p>
   * @return the nth {@link SpeciesType} of this {@link Model}.
   */
 public SpeciesType getSpeciesType(long n) {
    long cPtr = libsbmlJNI.Model_getSpeciesType__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new SpeciesType(cPtr, false);
  }

  
  /**
   * Get a {@link SpeciesType} object based on its identifier.
   * <p>
   * @return the {@link SpeciesType} in this {@link Model} with the identifier <code>sid</code> or
   * NULL if no such {@link SpeciesType} exists.
   */
 public SpeciesType getSpeciesType(String sid) {
    long cPtr = libsbmlJNI.Model_getSpeciesType__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new SpeciesType(cPtr, false);
  }

  
  /**
   * Get the nth {@link Compartment} object in this {@link Model}.
   * <p>
   * @return the nth {@link Compartment} of this {@link Model}.
   */
 public Compartment getCompartment(long n) {
    long cPtr = libsbmlJNI.Model_getCompartment__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Compartment(cPtr, false);
  }

  
  /**
   * Get a {@link Compartment} object based on its identifier.
   * <p>
   * @return the {@link Compartment} in this {@link Model} with the identifier <code>sid</code> or
   * NULL if no such {@link Compartment} exists.
   */
 public Compartment getCompartment(String sid) {
    long cPtr = libsbmlJNI.Model_getCompartment__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Compartment(cPtr, false);
  }

  
  /**
   * Get the nth {@link Species} object in this {@link Model}.
   * <p>
   * @return the nth {@link Species} of this {@link Model}.
   */
 public Species getSpecies(long n) {
    long cPtr = libsbmlJNI.Model_getSpecies__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Species(cPtr, false);
  }

  
  /**
   * Get a {@link Species} object based on its identifier.
   * <p>
   * @return the {@link Species} in this {@link Model} with the identifier <code>sid</code> or NULL
   * if no such {@link Species} exists.
   */
 public Species getSpecies(String sid) {
    long cPtr = libsbmlJNI.Model_getSpecies__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Species(cPtr, false);
  }

  
  /**
   * Get the nth {@link Parameter} object in this {@link Model}.
   * <p>
   * @return the nth {@link Parameter} of this {@link Model}.
   */
 public Parameter getParameter(long n) {
    long cPtr = libsbmlJNI.Model_getParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
  /**
   * Get a {@link Parameter} object based on its identifier.
   * <p>
   * @return the {@link Parameter} in this {@link Model} with the identifier <code>sid</code> or NULL
   * if no such {@link Parameter} exists.
   */
 public Parameter getParameter(String sid) {
    long cPtr = libsbmlJNI.Model_getParameter__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
  /**
   * Get the nth {@link InitialAssignment} object in this {@link Model}.
   * <p>
   * @return the nth {@link InitialAssignment} of this {@link Model}.
   */
 public InitialAssignment getInitialAssignment(long n) {
    long cPtr = libsbmlJNI.Model_getInitialAssignment__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new InitialAssignment(cPtr, false);
  }

  
  /**
   * Get an {@link InitialAssignment} object based on the symbol to which it
   * assigns a value.
   * <p>
   * @return the {@link InitialAssignment} in this {@link Model} with the given 'symbol'
   * attribute value or NULL if no such {@link InitialAssignment} exists.
   */
 public InitialAssignment getInitialAssignment(String symbol) {
    long cPtr = libsbmlJNI.Model_getInitialAssignment__SWIG_2(swigCPtr, this, symbol);
    return (cPtr == 0) ? null : new InitialAssignment(cPtr, false);
  }

  
  /**
   * Get the nth {@link Rule} object in this {@link Model}.
   * <p>
   * @return the nth {@link Rule} of this {@link Model}.
   */
 public Rule getRule(long n) {
  return (Rule) libsbml.DowncastSBase(libsbmlJNI.Model_getRule__SWIG_0(swigCPtr, this, n), false);
}

  
  /**
   * Get a {@link Rule} object based on the variable to which it assigns a value.
   * <p>
   * @return the {@link Rule} in this {@link Model} with the given 'variable' attribute
   * value or NULL if no such {@link Rule} exists.
   */
 public Rule getRule(String variable) {
  return (Rule) libsbml.DowncastSBase(libsbmlJNI.Model_getRule__SWIG_2(swigCPtr, this, variable), false);
}

  
  /**
   * Get the nth {@link Constraint} object in this {@link Model}.
   * <p>
   * @return the nth {@link Constraint} of this {@link Model}.
   */
 public Constraint getConstraint(long n) {
    long cPtr = libsbmlJNI.Model_getConstraint__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Constraint(cPtr, false);
  }

  
  /**
   * Get the nth {@link Reaction} object in this {@link Model}.
   * <p>
   * @return the nth {@link Reaction} of this {@link Model}.
   */
 public Reaction getReaction(long n) {
    long cPtr = libsbmlJNI.Model_getReaction__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Reaction(cPtr, false);
  }

  
  /**
   * Get a {@link Reaction} object based on its identifier.
   * <p>
   * @return the {@link Reaction} in this {@link Model} with the identifier <code>sid</code> or NULL
   * if no such {@link Reaction} exists.
   */
 public Reaction getReaction(String sid) {
    long cPtr = libsbmlJNI.Model_getReaction__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Reaction(cPtr, false);
  }

  
  /**
   * Get the nth {@link Event} object in this {@link Model}.
   * <p>
   * @return the nth {@link Event} of this {@link Model}.
   */
 public Event getEvent(long n) {
    long cPtr = libsbmlJNI.Model_getEvent__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Event(cPtr, false);
  }

  
  /**
   * Get an {@link Event} object based on its identifier.
   * <p>
   * @return the {@link Event} in this {@link Model} with the identifier <code>sid</code> or NULL if
   * no such {@link Event} exists.
   */
 public Event getEvent(String sid) {
    long cPtr = libsbmlJNI.Model_getEvent__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Event(cPtr, false);
  }

  
  /**
   * Get the number of {@link FunctionDefinition} objects in this {@link Model}.
   * <p>
   * @return the number of FunctionDefinitions in this {@link Model}.
   */
 public long getNumFunctionDefinitions() {
    return libsbmlJNI.Model_getNumFunctionDefinitions(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link UnitDefinition} objects in this {@link Model}.
   * <p>
   * @return the number of UnitDefinitions in this {@link Model}.
   */
 public long getNumUnitDefinitions() {
    return libsbmlJNI.Model_getNumUnitDefinitions(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link CompartmentType} objects in this {@link Model}.
   * <p>
   * @return the number of CompartmentTypes in this {@link Model}.
   */
 public long getNumCompartmentTypes() {
    return libsbmlJNI.Model_getNumCompartmentTypes(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link SpeciesType} objects in this {@link Model}.
   * <p>
   * @return the number of SpeciesTypes in this {@link Model}.
   */
 public long getNumSpeciesTypes() {
    return libsbmlJNI.Model_getNumSpeciesTypes(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link Compartment} objects in this {@link Model}.
   * <p>
   * @return the number of Compartments in this {@link Model}.
   */
 public long getNumCompartments() {
    return libsbmlJNI.Model_getNumCompartments(swigCPtr, this);
  }

  
  /**
   * Get the number of Specie objects in this {@link Model}.
   * <p>
   * @return the number of {@link Species} in this {@link Model}.
   */
 public long getNumSpecies() {
    return libsbmlJNI.Model_getNumSpecies(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link Species} in this {@link Model} having their
   * 'boundaryCondition' attribute value set to <code>true</code>.
   * <p>
   * @return the number of {@link Species} in this {@link Model} with boundaryCondition set
   * to true.
   */
 public long getNumSpeciesWithBoundaryCondition() {
    return libsbmlJNI.Model_getNumSpeciesWithBoundaryCondition(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link Parameter} objects in this {@link Model}.
   * <p>
   * @return the number of Parameters in this {@link Model}.  Parameters defined in
   * KineticLaws are not included.
   */
 public long getNumParameters() {
    return libsbmlJNI.Model_getNumParameters(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link InitialAssignment} objects in this {@link Model}.
   * <p>
   * @return the number of InitialAssignments in this {@link Model}.
   */
 public long getNumInitialAssignments() {
    return libsbmlJNI.Model_getNumInitialAssignments(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link Rule} objects in this {@link Model}.
   * <p>
   * @return the number of Rules in this {@link Model}.
   */
 public long getNumRules() {
    return libsbmlJNI.Model_getNumRules(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link Constraint} objects in this {@link Model}.
   * <p>
   * @return the number of Constraints in this {@link Model}.
   */
 public long getNumConstraints() {
    return libsbmlJNI.Model_getNumConstraints(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link Reaction} objects in this {@link Model}.
   * <p>
   * @return the number of Reactions in this {@link Model}.
   */
 public long getNumReactions() {
    return libsbmlJNI.Model_getNumReactions(swigCPtr, this);
  }

  
  /**
   * Get the number of {@link Event} objects in this {@link Model}.
   * <p>
   * @return the number of Events in this {@link Model}.
   */
 public long getNumEvents() {
    return libsbmlJNI.Model_getNumEvents(swigCPtr, this);
  }

  
  /**
   * Converts the model to a from SBML Level 2 to Level 1.
   * <p>
   * Most of the necessary changes occur during the various
   * writeAttributes() methods, however there are some difference between
   * L1 and L2 that require the underlying {@link Model} to be changed.
   */
 public void convertToL1() {
    libsbmlJNI.Model_convertToL1(swigCPtr, this);
  }

  
  /**
   * Converts the model to a from SBML Level 1 to Level 2.
   * <p>
   * Most of the necessary changes occur during the various
   * writeAttributes() methods, however there are some difference between
   * L1 and L2 that require the underlying {@link Model} to be changed.
   */
 public void convertToL2() {
    libsbmlJNI.Model_convertToL2(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether the
   * given {@link ASTNode} is a boolean.
   * <p>
   * Often times, this question can be answered with the {@link ASTNode}'s own
   * isBoolean() method, but if the AST is an expression that calls a
   * function defined in the {@link Model}'s {@link ListOfFunctionDefinitions}, the model
   * is needed for lookup context.
   * <p>
   * @return true if the given {@link ASTNode} is a boolean.
   */
 public boolean isBoolean(ASTNode node) {
    return libsbmlJNI.Model_isBoolean(swigCPtr, this, ASTNode.getCPtr(node), node);
  }

  
  /**
   * Sets the parent {@link SBMLDocument} of this SBML object.
   * <p>
   * @param d the {@link SBMLDocument} object to set
   <p>
 * @deprecated libSBML internal
 */
 public void setSBMLDocument(SBMLDocument d) {
    libsbmlJNI.Model_setSBMLDocument(swigCPtr, this, SBMLDocument.getCPtr(d), d);
  }

  
  /**
   * Sets the parent SBML object of this SBML object.
   * <p>
   * @param sb the SBML object to use
   <p>
 * @deprecated libSBML internal
 */
 public void setParentSBMLObject(SBase sb) {
    libsbmlJNI.Model_setParentSBMLObject(swigCPtr, this, SBase.getCPtr(sb), sb);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Model_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Model}, is
   * always <code>'model'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'model'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.Model_getElementName(swigCPtr, this);
  }

  
  /**
   * Populates the list of FormulaDataUnits with the units derived 
   * for the model. The list contains elements of class
   * FormulaUnitsData. 
   * <p>
   * The first element of the list refers to the default units
   * of 'substance per time' derived from the model and has the
   * unitReferenceId 'subs_per_time'. This facilitates the comparison of units
   * derived from mathematical formula with the expected units.
   * <p>
   * The next elements of the list record the units of the 
   * compartments and species established from either explicitly
   * declared or default units.
   * <p>
   * The next elements record the units of any parameters.
   * <p>
   * Subsequent elements of the list record the units derived for
   * each mathematical expression encountered within the model.
   * <p>
   * @note This function is utilised by the {@link Unit} Consistency Validator.
   * The List is populated prior to running the validation and thus
   * the consistency of units can be checked by accessing the members
   * of the list and comparing the appropriate data.
   */
 public void populateListFormulaUnitsData() {
    libsbmlJNI.Model_populateListFormulaUnitsData(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * the list of FormulaUnitsData has been populated.
   * <p>
   * @return <code>true</code> if the list of FormulaUnitsData has been populated, 
   * <code>false</code> otherwise.
   */
 public boolean isPopulatedListFormulaUnitsData() {
    return libsbmlJNI.Model_isPopulatedListFormulaUnitsData(swigCPtr, this);
  }

}
