/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's KineticLaw construct.
 * <p>
 * An object of class {@link KineticLaw} is used to describe the rate at which the
 * process defined by a given {@link Reaction} takes place.  {@link KineticLaw} has
 * subelements called 'math' (for MathML content) and 'listOfParameters'
 * (of class {@link ListOfParameters}), in addition to the attributes and
 * subelements it inherits from {@link SBase}.
 * <p>
 * {@link KineticLaw}'s 'math' subelement for holding a MathML formula defines the
 * rate of the reaction.  The formula may refer to other entities in a
 * model (Compartment, {@link Species}, {@link Parameter}, {@link FunctionDefinition}, {@link Reaction}),
 * but the only {@link Species} identifiers that can be used in this formula are
 * those declared in the lists of reactants, products and modifiers in the
 * {@link Reaction} structure.  {@link Parameter} identifiers may be taken from either the
 * {@link KineticLaw}'s list of local parameters (discussed below) or the
 * parameters defined globally on the {@link Model} instance.
 * <p>
 * {@link KineticLaw}'s 'listOfParameters' subelement can contain a list of one or
 * more {@link Parameter} objects defining new parameters whose identifiers can be
 * used in the 'math' formula of that {@link KineticLaw} instance.  The {@link Parameter}
 * objects so defined are only visible within the {@link KineticLaw}; they cannot
 * be accessed outside.  Moreover, if a {@link Parameter} has the same identifier
 * as a global {@link Parameter} object defined in the enclosing {@link Model}, the
 * definition inside the {@link KineticLaw} takes precedence (i.e., it shadows the
 * global definition).
 * <p>
 * The type of structure used to define a parameter inside {@link KineticLaw} is
 * the same {@link Parameter} structure used to define global parameters.  This
 * simplifies the SBML language and reduces the number of unique types of
 * data objects.  However, there is a difference between local and global
 * parameters: in the case of parameters defined locally to a {@link KineticLaw},
 * there is no means by which the parameter values can be changed.
 * Consequently, such parameters' values are always constant, and the
 * 'constant' attribute in their definitions must always have a value of 
 * <code>true</code> (either explicitly or left to its default value).  See the
 * definition of {@link Parameter} for more information about the 'constant'
 * attribute.
 * <p>
 * <h2>Units of rate expressions in {@link KineticLaw}</h2>
 * <p>
 * It is important to make clear that a so-called kinetic law in SBML is
 * <em>not</em> identical to a traditional rate law.  The reason is that SBML
 * must support multicompartment models, and the units normally used in
 * traditional rate laws as well as some conventional single-compartment
 * modeling packages are problematic when used for defining reactions
 * between multiple compartments.  When modeling species as continuous
 * amounts (e.g., concentrations), the rate laws used are traditionally
 * expressed in terms of <em>amount of substance concentration per
 * time</em>, embodying a tacit assumption that reactants and products are
 * all located in a single, constant volume.  Attempting to describe
 * reactions between multiple volumes using
 * <em>concentration</em>/<em>time</em> (which is to say,
 * <em>substance</em>/<em>volume</em>/<em>time</em>) quickly leads to
 * difficulties, as explained in the SBML Level&nbsp;2 Version&nbsp;2, 3
 * and&nbsp;4 specifications.
 * <p>
 * The need to support multicompartment models requires that the reaction
 * rates in SBML to be expressed in terms of
 * <em>substance</em>/<em>time</em>, rather than the more typical
 * <em>substance</em>/<em>size</em>/<em>time</em>.  As a result, modelers
 * and software tools in general cannot insert textbook rate laws
 * unmodified as the rate expression in the 'math' subelement of a
 * {@link KineticLaw}.  The unusual term 'kinetic law' was chosen to alert users to
 * this difference.
 * <p>
 * Please consult the SBML specification document for more information
 * about the definition reaction rates in SBML.
 * <p>
 * @note Before SBML Level&nbsp;2 Version&nbsp;2, the SBML specification
 * included two additional attributes on {@link KineticLaw} called 'substanceUnits'
 * and 'timeUnits'.  They were removed beginning with SBML Level&nbsp;2
 * Version&nbsp;2 because further research determined they introduced many
 * problems.  The most significant problem was that their use could easily
 * lead to the creation of valid models whose reactions nevertheless could
 * not be integrated into a system of equations without outside knowledge
 * for converting the quantities used.  Examination of real-life models
 * revealed that a common reason for using 'substanceUnits' on {@link KineticLaw}
 * was to set the units of all reactions to the same set of substance
 * units, something that is better achieved by using {@link UnitDefinition} to
 * redefine <code>'substance'</code> for the whole {@link Model}.
 */

public class KineticLaw extends SBase {
   private long swigCPtr;

   protected KineticLaw(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGKineticLawUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(KineticLaw obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (KineticLaw obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_KineticLaw(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link KineticLaw} object, optionally with values for its 'formula',
   * 'timeUnits' and/or 'substanceUnits' attributes.
   * <p>
   * This will copy the strings handed in <code>formula</code>, <code>timeUnits</code> and 
   * <code>substanceUnits</code>.  This method is functionally equivalent to the following:
   * <div class='fragment'><pre>
   *   {@link KineticLaw} k = new {@link KineticLaw}();
   *   k.setFormula(formula);
   *   k.setTimeUnits(timeUnits);
   *   k.setSubstanceUnits(substanceUnits);</pre></div>
   * <p>
   * @param formula a mathematical expression in text-string form
   * representing the rate of the reaction.
   * <p>
   * @param timeUnits the identifier of the time units
   * <p>
   * @param substanceUnits the identifier of the substance units
   * <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical
   * formulas.  SBML Level&nbsp;2 uses MathML, an XML format for representing
   * mathematical expressions.  LibSBML provides an Abstract Syntax Tree
   * API for working with mathematical expressions; this API is more
   * powerful than working with formulas directly in text form, and ASTs
   * can be translated into either MathML or the text-string syntax.  The
   * libSBML methods that accept text-string formulas directly (such as
   * this constructor) are provided for SBML Level&nbsp;1 compatibility, but
   * developers are encouraged to use the AST mechanisms.  See the other
   * {@link KineticLaw} constructor for a version that takes an {@link ASTNode}.
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public KineticLaw(String formula, String timeUnits, String substanceUnits) {
    this(libsbmlJNI.new_KineticLaw__SWIG_0(formula, timeUnits, substanceUnits), true);
  }

  
  /**
   * Creates a new {@link KineticLaw} object, optionally with values for its 'formula',
   * 'timeUnits' and/or 'substanceUnits' attributes.
   * <p>
   * This will copy the strings handed in <code>formula</code>, <code>timeUnits</code> and 
   * <code>substanceUnits</code>.  This method is functionally equivalent to the following:
   * <div class='fragment'><pre>
   *   {@link KineticLaw} k = new {@link KineticLaw}();
   *   k.setFormula(formula);
   *   k.setTimeUnits(timeUnits);
   *   k.setSubstanceUnits(substanceUnits);</pre></div>
   * <p>
   * @param formula a mathematical expression in text-string form
   * representing the rate of the reaction.
   * <p>
   * @param timeUnits the identifier of the time units
   * <p>
   * @param substanceUnits the identifier of the substance units
   * <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical
   * formulas.  SBML Level&nbsp;2 uses MathML, an XML format for representing
   * mathematical expressions.  LibSBML provides an Abstract Syntax Tree
   * API for working with mathematical expressions; this API is more
   * powerful than working with formulas directly in text form, and ASTs
   * can be translated into either MathML or the text-string syntax.  The
   * libSBML methods that accept text-string formulas directly (such as
   * this constructor) are provided for SBML Level&nbsp;1 compatibility, but
   * developers are encouraged to use the AST mechanisms.  See the other
   * {@link KineticLaw} constructor for a version that takes an {@link ASTNode}.
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public KineticLaw(String formula, String timeUnits) {
    this(libsbmlJNI.new_KineticLaw__SWIG_1(formula, timeUnits), true);
  }

  
  /**
   * Creates a new {@link KineticLaw} object, optionally with values for its 'formula',
   * 'timeUnits' and/or 'substanceUnits' attributes.
   * <p>
   * This will copy the strings handed in <code>formula</code>, <code>timeUnits</code> and 
   * <code>substanceUnits</code>.  This method is functionally equivalent to the following:
   * <div class='fragment'><pre>
   *   {@link KineticLaw} k = new {@link KineticLaw}();
   *   k.setFormula(formula);
   *   k.setTimeUnits(timeUnits);
   *   k.setSubstanceUnits(substanceUnits);</pre></div>
   * <p>
   * @param formula a mathematical expression in text-string form
   * representing the rate of the reaction.
   * <p>
   * @param timeUnits the identifier of the time units
   * <p>
   * @param substanceUnits the identifier of the substance units
   * <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical
   * formulas.  SBML Level&nbsp;2 uses MathML, an XML format for representing
   * mathematical expressions.  LibSBML provides an Abstract Syntax Tree
   * API for working with mathematical expressions; this API is more
   * powerful than working with formulas directly in text form, and ASTs
   * can be translated into either MathML or the text-string syntax.  The
   * libSBML methods that accept text-string formulas directly (such as
   * this constructor) are provided for SBML Level&nbsp;1 compatibility, but
   * developers are encouraged to use the AST mechanisms.  See the other
   * {@link KineticLaw} constructor for a version that takes an {@link ASTNode}.
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public KineticLaw(String formula) {
    this(libsbmlJNI.new_KineticLaw__SWIG_2(formula), true);
  }

  
  /**
   * Creates a new {@link KineticLaw} object, optionally with values for its 'formula',
   * 'timeUnits' and/or 'substanceUnits' attributes.
   * <p>
   * This will copy the strings handed in <code>formula</code>, <code>timeUnits</code> and 
   * <code>substanceUnits</code>.  This method is functionally equivalent to the following:
   * <div class='fragment'><pre>
   *   {@link KineticLaw} k = new {@link KineticLaw}();
   *   k.setFormula(formula);
   *   k.setTimeUnits(timeUnits);
   *   k.setSubstanceUnits(substanceUnits);</pre></div>
   * <p>
   * @param formula a mathematical expression in text-string form
   * representing the rate of the reaction.
   * <p>
   * @param timeUnits the identifier of the time units
   * <p>
   * @param substanceUnits the identifier of the substance units
   * <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical
   * formulas.  SBML Level&nbsp;2 uses MathML, an XML format for representing
   * mathematical expressions.  LibSBML provides an Abstract Syntax Tree
   * API for working with mathematical expressions; this API is more
   * powerful than working with formulas directly in text form, and ASTs
   * can be translated into either MathML or the text-string syntax.  The
   * libSBML methods that accept text-string formulas directly (such as
   * this constructor) are provided for SBML Level&nbsp;1 compatibility, but
   * developers are encouraged to use the AST mechanisms.  See the other
   * {@link KineticLaw} constructor for a version that takes an {@link ASTNode}.
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public KineticLaw() {
    this(libsbmlJNI.new_KineticLaw__SWIG_3(), true);
  }

  
  /**
   * Creates a new {@link KineticLaw} object, optionally with values for the 'math'
   * subelement and the 'timeUnits' and/or 'substanceUnits' attributes.
   * <p>
   * This will copy the strings handed in <code>timeUnits</code> and 
   * <code>substanceUnits</code>.  This method is functionally equivalent to the following:
   * <div class='fragment'><pre>
   *   {@link KineticLaw} k = new {@link KineticLaw}();
   *   k.setMath(math);
   *   k.setTimeUnits(timeUnits);
   *   k.setSubstanceUnits(substanceUnits);</pre></div>
   * <p>
   * @param math an {@link ASTNode} representing the rate of the reaction.
   * <p>
   * @param timeUnits the identifier of the time units
   * <p>
   * @param substanceUnits the identifier of the substance units
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public KineticLaw(ASTNode math, String timeUnits, String substanceUnits) {
    this(libsbmlJNI.new_KineticLaw__SWIG_4(ASTNode.getCPtr(math), math, timeUnits, substanceUnits), true);
  }

  
  /**
   * Creates a new {@link KineticLaw} object, optionally with values for the 'math'
   * subelement and the 'timeUnits' and/or 'substanceUnits' attributes.
   * <p>
   * This will copy the strings handed in <code>timeUnits</code> and 
   * <code>substanceUnits</code>.  This method is functionally equivalent to the following:
   * <div class='fragment'><pre>
   *   {@link KineticLaw} k = new {@link KineticLaw}();
   *   k.setMath(math);
   *   k.setTimeUnits(timeUnits);
   *   k.setSubstanceUnits(substanceUnits);</pre></div>
   * <p>
   * @param math an {@link ASTNode} representing the rate of the reaction.
   * <p>
   * @param timeUnits the identifier of the time units
   * <p>
   * @param substanceUnits the identifier of the substance units
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public KineticLaw(ASTNode math, String timeUnits) {
    this(libsbmlJNI.new_KineticLaw__SWIG_5(ASTNode.getCPtr(math), math, timeUnits), true);
  }

  
  /**
   * Creates a new {@link KineticLaw} object, optionally with values for the 'math'
   * subelement and the 'timeUnits' and/or 'substanceUnits' attributes.
   * <p>
   * This will copy the strings handed in <code>timeUnits</code> and 
   * <code>substanceUnits</code>.  This method is functionally equivalent to the following:
   * <div class='fragment'><pre>
   *   {@link KineticLaw} k = new {@link KineticLaw}();
   *   k.setMath(math);
   *   k.setTimeUnits(timeUnits);
   *   k.setSubstanceUnits(substanceUnits);</pre></div>
   * <p>
   * @param math an {@link ASTNode} representing the rate of the reaction.
   * <p>
   * @param timeUnits the identifier of the time units
   * <p>
   * @param substanceUnits the identifier of the substance units
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public KineticLaw(ASTNode math) {
    this(libsbmlJNI.new_KineticLaw__SWIG_6(ASTNode.getCPtr(math), math), true);
  }

  
  /**
   * Creates a new {@link KineticLaw} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link KineticLaw}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link KineticLaw}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link KineticLaw}
   * <p>
   * @note Once a {@link KineticLaw} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link KineticLaw}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public KineticLaw(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_KineticLaw__SWIG_7(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link KineticLaw} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link KineticLaw}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link KineticLaw}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link KineticLaw}
   * <p>
   * @note Once a {@link KineticLaw} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link KineticLaw}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public KineticLaw(long level, long version) {
    this(libsbmlJNI.new_KineticLaw__SWIG_8(level, version), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link KineticLaw}.
   */
 public KineticLaw(KineticLaw orig) {
    this(libsbmlJNI.new_KineticLaw__SWIG_9(KineticLaw.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link KineticLaw} object.
   * <p>
   * @return a (deep) copy of this {@link KineticLaw}.
   */
 public KineticLaw cloneObject() {
    long cPtr = libsbmlJNI.KineticLaw_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new KineticLaw(cPtr, true);
  }

  
  /**
   * Returns the mathematical formula for this {@link KineticLaw} object and return
   * it as as a text string.
   * <p>
   * This is fundamentally equivalent to getMath().  This variant is
   * provided principally for compatibility compatibility with SBML Level
   * 1.
   * <p>
   * @return a string representing the formula of this {@link KineticLaw}.
   * <p>
   * @see #getMath()
   * <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical
   * formulas.  SBML Level&nbsp;2 uses MathML, an XML format for
   * representing mathematical expressions.  LibSBML provides an Abstract
   * Syntax Tree API for working with mathematical expressions; this API is
   * more powerful than working with formulas directly in text form, and
   * ASTs can be translated into either MathML or the text-string syntax.
   * The libSBML methods that accept text-string formulas directly (such as
   * this constructor) are provided for SBML Level&nbsp;1 compatibility,
   * but developers are encouraged to use the AST mechanisms.
   */
 public String getFormula() {
    return libsbmlJNI.KineticLaw_getFormula(swigCPtr, this);
  }

  
  /**
   * Returns the mathematical formula for this {@link KineticLaw} object and return
   * it as as an AST.
   * <p>
   * This is fundamentally equivalent to getFormula().  The latter is
   * provided principally for compatibility compatibility with SBML Level
   * 1, which represented mathematical formulas in text-string form.
   * <p>
   * @return the {@link ASTNode} representation of the mathematical formula.
   * <p>
   * @see #getFormula()
   */
 public ASTNode getMath() {
    long cPtr = libsbmlJNI.KineticLaw_getMath(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Returns the value of the 'timeUnits' attribute of this {@link KineticLaw}
   * object.
   * <p>
   * @return the 'timeUnits' attribute value
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   */
 public String getTimeUnits() {
    return libsbmlJNI.KineticLaw_getTimeUnits(swigCPtr, this);
  }

  
  /**
   * Returns the value of the 'substanceUnits' attribute of this {@link KineticLaw}
   * object.
   * <p>
   * @return the 'substanceUnits' attribute value
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   */
 public String getSubstanceUnits() {
    return libsbmlJNI.KineticLaw_getSubstanceUnits(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link KineticLaw}'s 'formula' attribute has been set
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * This is functionally identical to the method isSetMath().  It is
   * provided in order to mirror the parallel between getFormula() and
   * getMath().
   * <p>
   * @return <code>true</code> if the formula (meaning the <code>math</code> subelement) of
   * this {@link KineticLaw} has been set, <code>false</code> otherwise.
   * <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical
   * formulas.  SBML Level&nbsp;2 uses MathML, an XML format for
   * representing mathematical expressions.  LibSBML provides an Abstract
   * Syntax Tree API for working with mathematical expressions; this API is
   * more powerful than working with formulas directly in text form, and
   * ASTs can be translated into either MathML or the text-string syntax.
   * The libSBML methods that accept text-string formulas directly (such as
   * this constructor) are provided for SBML Level&nbsp;1 compatibility,
   * but developers are encouraged to use the AST mechanisms.
   */
 public boolean isSetFormula() {
    return libsbmlJNI.KineticLaw_isSetFormula(swigCPtr, this);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * Kinetic's 'math' subelement has been set
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * This is identical to the method isSetFormula().  It is provided
   * in order to mirror the parallel between getFormula() and getMath().
   * <p>
   * @return <code>true</code> if the formula (meaning the <code>math</code> subelement) of
   * this {@link KineticLaw} has been set, <code>false</code> otherwise.
   */
 public boolean isSetMath() {
    return libsbmlJNI.KineticLaw_isSetMath(swigCPtr, this);
  }

  
 /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link SpeciesReference}'s 'timeUnits' attribute has been set
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'timeUnits' attribute of this {@link KineticLaw} object
   * has been set, <code>false</code> otherwise.
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   */
 public boolean isSetTimeUnits() {
    return libsbmlJNI.KineticLaw_isSetTimeUnits(swigCPtr, this);
  }

  
 /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link SpeciesReference}'s 'substanceUnits' attribute has been set
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'substanceUnits' attribute of this {@link KineticLaw}
   * object has been set, <code>false</code> otherwise.
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   */
 public boolean isSetSubstanceUnits() {
    return libsbmlJNI.KineticLaw_isSetSubstanceUnits(swigCPtr, this);
  }

  
  /**
   * Sets the mathematical expression of this {@link KineticLaw} instance to the
   * given <code>formula</code>.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * The given <code>formula</code> string is copied.  Internally, libSBML stores the
   * mathematical expression as an {@link ASTNode}.
   * <p>
   * @param formula the mathematical expression to use, represented in
   * text-string form.
   * <p>
   * @note SBML Level&nbsp;1 uses a text-string format for mathematical
   * formulas.  SBML Level&nbsp;2 uses MathML, an XML format for representing
   * mathematical expressions.  LibSBML provides an Abstract Syntax Tree
   * API for working with mathematical expressions; this API is more
   * powerful than working with formulas directly in text form, and ASTs
   * can be translated into either MathML or the text-string syntax.  The
   * libSBML methods that accept text-string formulas directly (such as
   * this constructor) are provided for SBML Level&nbsp;1 compatibility, but
   * developers are encouraged to use the AST mechanisms.
   */
 public void setFormula(String formula) {
    libsbmlJNI.KineticLaw_setFormula(swigCPtr, this, formula);
  }

  
  /**
   * Sets the mathematical expression of this {@link KineticLaw} instance to a copy
   * of the given {@link ASTNode}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * This is fundamentally identical to setFormula().  The latter is
   * provided principally for compatibility compatibility with SBML Level
   * 1, which represented mathematical formulas in text-string form.
   * <p>
   * @param math an {@link ASTNode} representing a formula tree.
   */
 public void setMath(ASTNode math) {
    libsbmlJNI.KineticLaw_setMath(swigCPtr, this, ASTNode.getCPtr(math), math);
  }

  
  /**
   * Sets the 'timeUnits' attribute of this {@link KineticLaw} object to a copy of
   * the identifier in <code>sid</code>.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the identifier of the units to use.
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   */
 public void setTimeUnits(String sid) {
    libsbmlJNI.KineticLaw_setTimeUnits(swigCPtr, this, sid);
  }

  
  /**
   * Sets the 'substanceUnits' attribute of this {@link KineticLaw} object to a copy
   * of the identifier given in <code>sid</code>.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the identifier of the units to use.
   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   */
 public void setSubstanceUnits(String sid) {
    libsbmlJNI.KineticLaw_setSubstanceUnits(swigCPtr, this, sid);
  }

  
  /**
   * Unsets the 'timeUnits' attribugte of this {@link KineticLaw} object.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   */
 public void unsetTimeUnits() {
    libsbmlJNI.KineticLaw_unsetTimeUnits(swigCPtr, this);
  }

  
  /**
   * Unsets the 'substanceUnits' attribute of this {@link KineticLaw} object.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @warning In SBML Level&nbsp;2 Version&nbsp;2, the 'timeUnits' and
   * 'substanceUnits' attributes were removed.  For compatibility with new
   * versions of SBML, users are cautioned to avoid these attributes.
   */
 public void unsetSubstanceUnits() {
    libsbmlJNI.KineticLaw_unsetSubstanceUnits(swigCPtr, this);
  }

  
  /**
   * Adds a copy of the given {@link Parameter} object to the list of local
   * parameters in this {@link KineticLaw}.
   * <p>
   * @param p the {@link Parameter} to add
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link KineticLaw}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link KineticLaw}</em>.  In addition, the caller should make
   * sure to free the original object if it is no longer being used, or
   * else a memory leak will result.  Please see
   * {@link KineticLaw#createParameter()} for ab method that does not lead to
   * these issues.
   * <p>
   * @see #createParameter()
   */
 public void addParameter(Parameter p) {
    libsbmlJNI.KineticLaw_addParameter(swigCPtr, this, Parameter.getCPtr(p), p);
  }

  
  /**
   * Creates a new {@link Parameter} object, adds it to this {@link KineticLaw}'s list of
   * local parameters, and returns the {@link Parameter} object created.
   * <p>
   * @return a new {@link Parameter} object instance
   * <p>
   * @see #addParameter()
   */
 public Parameter createParameter() {
    long cPtr = libsbmlJNI.KineticLaw_createParameter(swigCPtr, this);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
  /**
   * Returns the list of local parameters in this {@link KineticLaw} object.
   * <p>
   * @return the list of Parameters for this {@link KineticLaw}.
   */
 public ListOfParameters getListOfParameters() {
    long cPtr = libsbmlJNI.KineticLaw_getListOfParameters__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfParameters(cPtr, false);
  }

  
  /**
   * Returns the nth {@link Parameter} object in the list of local parameters in
   * this {@link KineticLaw} instance.
   * <p>
   * @param n the index of the {@link Parameter} object sought
   * <p>
   * @return the nth {@link Parameter} of this {@link KineticLaw}.
   */
 public Parameter getParameter(long n) {
    long cPtr = libsbmlJNI.KineticLaw_getParameter__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
  /**
   * Returns a local parameter based on its identifier.
   * <p>
   * @param sid the identifier of the {@link Parameter} being sought.
   * <p>
   * @return the {@link Parameter} object in this {@link KineticLaw} instace having the
   * given 'id', or <code>NULL</code> if no such {@link Parameter} exists.
   */
 public Parameter getParameter(String sid) {
    long cPtr = libsbmlJNI.KineticLaw_getParameter__SWIG_2(swigCPtr, this, sid);
    return (cPtr == 0) ? null : new Parameter(cPtr, false);
  }

  
  /**
   * Returns the number of local parameters in this {@link KineticLaw} instance.
   * <p>
   * @return the number of Parameters in this {@link KineticLaw}.
   */
 public long getNumParameters() {
    return libsbmlJNI.KineticLaw_getNumParameters(swigCPtr, this);
  }

  
  /**
   * Calculates and returns a {@link UnitDefinition} that expresses the units
   * of measurement assumed for the 'math' expression of this
   * {@link KineticLaw}.
   * <p>
   * The units are calculated based on the mathematical expression in the
   * {@link KineticLaw} and the model quantities referenced by
   * <code>&lt;ci&gt;</code> elements used within that expression.  The
   * getDerivedUnitDefinition() method returns the calculated units.
   * <p>
   * @warning Note that it is possible the 'math' expression in the
   * {@link KineticLaw} contains pure numbers or parameters with undeclared
   * units.  In those cases, it is not possible to calculate the units of
   * the overall expression without making assumptions.  LibSBML does not
   * make assumptions about the units, and getDerivedUnitDefinition() only
   * returns the units as far as it is able to determine them.  For
   * example, in an expression <em>X + Y</em>, if <em>X</em> has
   * unambiguously-defined units and <em>Y</em> does not, it will return
   * the units of <em>X</em>.  <strong>It is important that callers also
   * invoke the method</strong> containsUndeclaredUnits() <strong>to
   * determine whether this situation holds</strong>.  Callers may wish to
   * take suitable actions in those scenarios.
   * <p>
   * @return a {@link UnitDefinition} that expresses the units of the math 
   * expression of this {@link KineticLaw}.
   * <p>
   * @see #containsUndeclaredUnits()
   */
 public UnitDefinition getDerivedUnitDefinition() {
    long cPtr = libsbmlJNI.KineticLaw_getDerivedUnitDefinition(swigCPtr, this);
    return (cPtr == 0) ? null : new UnitDefinition(cPtr, false);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether 
   * the math expression of this {@link KineticLaw} contains
   * parameters/numbers with undeclared units.
   * <p>
   * @return <code>true</code> if the math expression of this {@link KineticLaw}
   * includes parameters/numbers 
   * with undeclared units, <code>false</code> otherwise.
   * <p>
   * @note A return value of <code>true</code> indicates that the {@link UnitDefinition}
   * returned by getDerivedUnitDefinition() may not accurately represent
   * the units of the expression.
   * <p>
   * @see #getDerivedUnitDefinition()
   */
 public boolean containsUndeclaredUnits() {
    return libsbmlJNI.KineticLaw_containsUndeclaredUnits(swigCPtr, this);
  }

  
  /**
   * Sets the parent {@link SBMLDocument} of this SBML object.
   * <p>
   * @param d the {@link SBMLDocument} to use.
   <p>
 * @deprecated libSBML internal
 */
 public void setSBMLDocument(SBMLDocument d) {
    libsbmlJNI.KineticLaw_setSBMLDocument(swigCPtr, this, SBMLDocument.getCPtr(d), d);
  }

  
  /**
   * Sets the parent SBML object of this SBML object.
   * <p>
   * @param sb the SBML object to use
   <p>
 * @deprecated libSBML internal
 */
 public void setParentSBMLObject(SBase sb) {
    libsbmlJNI.KineticLaw_setParentSBMLObject(swigCPtr, this, SBase.getCPtr(sb), sb);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.KineticLaw_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Species}, is
   * always <code>'kineticLaw'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'kineticLaw'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.KineticLaw_getElementName(swigCPtr, this);
  }

}
