/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's FunctionDefinition construct.
 * <p>
 * The {@link FunctionDefinition} structure associates an identifier with a
 * function definition.  This identifier can then be used as the function
 * called in subsequent MathML content elsewhere in an SBML model.
 * <p>
 * {@link FunctionDefinition} has one required attribute, 'id', to give the
 * function a unique identifier by which other parts of an SBML model
 * definition can refer to it.  A {@link FunctionDefinition} instance can also have
 * an optional 'name' attribute of type <code>string</code>.  Identifiers and names
 * must be used according to the guidelines described in the SBML
 * specification (e.g., Section 3.3 in the Level 2 Version 4
 * specification).
 * <p>
 * {@link FunctionDefinition} has a required 'math' subelement containing a MathML
 * expression defining the function body.  The content of this element can
 * only be a MathML 'lambda' element.  The 'lambda' element must begin with
 * zero or more 'bvar' elements, followed by any other of the elements in
 * the MathML subset allowed in SBML Level 2 <em>except</em> 'lambda' (i.e., a
 * 'lambda' element cannot contain another 'lambda' element).  This is the
 * only place in SBML where a 'lambda' element can be used.  The function
 * defined by a {@link FunctionDefinition} is only available for use in other
 * MathML elements that <em>follow</em> the {@link FunctionDefinition} definition in the
 * model.  (These restrictions prevent recursive and mutually-recursive
 * functions from being expressed.)
 * <p>
 * A further restriction on the content of 'math' is that it cannot contain
 * references to variables other than the variables declared to the
 * 'lambda' itself.  That is, the contents of MathML 'ci' elements inside
 * the body of the 'lambda' can only be the variables declared by its
 * 'bvar' elements, or the identifiers of other {@link FunctionDefinition}
 * instances earlier in the model.  This means must be written so that all
 * variables or parameters used in the MathML content are passed to them
 * via their function parameters.
 * <p>
 * @note Function definitions (also informally known as user-defined
 * functions) were introduced in SBML Level 2.  They have purposefully
 * limited capabilities.  A function cannot reference parameters or other
 * model quantities outside of itself; values must be passed as parameters
 * to the function.  Moreover, recursive and mutually-recursive functions
 * are not permitted.  The purpose of these limitations is to balance power
 * against complexity of implementation.  With the restrictions as they
 * are, function definitions could be implemented as textual
 * substitutions&mdash;they are simply macros.  Software implementations
 * therefore do not need the full function-definition machinery typically
 * associated with programming languages.
 * <p>
 * @note Another important point to note is {@link FunctionDefinition} does not
 * have a separate attribute for defining the units of the value returned
 * by the function.  The units associated with the function's return value,
 * when the function is called from within MathML expressions elsewhere in
 * SBML, are simply the overall units of the expression in
 * {@link FunctionDefinition}'s 'math' subelement when applied to the arguments
 * supplied in the call to the function.  Ascertaining these units requires
 * performing dimensional analysis on the expression.  (Readers may wonder
 * why there is no attribute.  The reason is that having a separate
 * attribute for declaring the units would not only be redundant, but also
 * lead to the potential for having conflicting information.  In the case
 * of a conflict between the declared units and those of the value actually
 * returned by the function, the only logical resolution rule would be to
 * assume that the correct units are those of the expression anyway.)
 * <p>
 * <!---------------------------------------------------------------------- -->
 * <p>
 */

public class FunctionDefinition extends SBase {
   private long swigCPtr;

   protected FunctionDefinition(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGFunctionDefinitionUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(FunctionDefinition obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (FunctionDefinition obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_FunctionDefinition(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link FunctionDefinition}, optionally with a given identifier
   * and mathematical formula.
   * <p>
   * @param id a string, the identifier of this {@link FunctionDefinition} instance
   * @param formula the formula of the function definition expressed as a
   * string in infix notation 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public FunctionDefinition(String id, String formula) {
    this(libsbmlJNI.new_FunctionDefinition__SWIG_0(id, formula), true);
  }

  
  /**
   * Creates a new {@link FunctionDefinition}, optionally with a given identifier
   * and mathematical formula.
   * <p>
   * @param id a string, the identifier of this {@link FunctionDefinition} instance
   * @param formula the formula of the function definition expressed as a
   * string in infix notation 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public FunctionDefinition(String id) {
    this(libsbmlJNI.new_FunctionDefinition__SWIG_1(id), true);
  }

  
  /**
   * Creates a new {@link FunctionDefinition}, optionally with a given identifier
   * and mathematical formula.
   * <p>
   * @param id a string, the identifier of this {@link FunctionDefinition} instance
   * @param formula the formula of the function definition expressed as a
   * string in infix notation 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public FunctionDefinition() {
    this(libsbmlJNI.new_FunctionDefinition__SWIG_2(), true);
  }

  
  /**
   * Creates a new {@link FunctionDefinition} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link FunctionDefinition}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link FunctionDefinition}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link FunctionDefinition}
   * <p>
   * @note Once a {@link FunctionDefinition} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link FunctionDefinition}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public FunctionDefinition(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_FunctionDefinition__SWIG_3(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link FunctionDefinition} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link FunctionDefinition}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link FunctionDefinition}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link FunctionDefinition}
   * <p>
   * @note Once a {@link FunctionDefinition} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link FunctionDefinition}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public FunctionDefinition(long level, long version) {
    this(libsbmlJNI.new_FunctionDefinition__SWIG_4(level, version), true);
  }

  
  /**
   * Creates a new {@link FunctionDefinition}, optionally with a given identifier
   * and mathematical formula.
   * <p>
   * @param id a string, the identifier of this {@link FunctionDefinition} instance
   * <p>
   * @param math the formula of the function definition expressed as an
   * AST.
   */
 public FunctionDefinition(String id, ASTNode math) {
    this(libsbmlJNI.new_FunctionDefinition__SWIG_5(id, ASTNode.getCPtr(math), math), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link FunctionDefinition}.
   */
 public FunctionDefinition(FunctionDefinition orig) {
    this(libsbmlJNI.new_FunctionDefinition__SWIG_6(FunctionDefinition.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link FunctionDefinition}.
   * <p>
   * @return a (deep) copy of this {@link FunctionDefinition}.
   */
 public FunctionDefinition cloneObject() {
    long cPtr = libsbmlJNI.FunctionDefinition_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new FunctionDefinition(cPtr, true);
  }

  
  /**
   * Get the mathematical formula of this {@link FunctionDefinition}.
   * <p>
   * @return an {@link ASTNode}, the value of the 'math' subelement of this
   * {@link FunctionDefinition}
   */
 public ASTNode getMath() {
    long cPtr = libsbmlJNI.FunctionDefinition_getMath(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Predicate returning <code>true</code> or <code>false</code> depending on whether this
   * {@link FunctionDefinition}'s 'math' subelement contains a value.
   * <p>
   * @return <code>true</code> if the 'math' for this {@link FunctionDefinition} has been set,
   * <code>false</code> otherwise.
   */
 public boolean isSetMath() {
    return libsbmlJNI.FunctionDefinition_isSetMath(swigCPtr, this);
  }

  
  /**
   * Sets the 'math' subelement of this {@link FunctionDefinition} to the Abstract
   * Syntax Tree given in <code>math</code>.
   * <p>
   * @param math an AST containing the mathematical expression to
   * be used as the formula for this {@link FunctionDefinition}.
   */
 public void setMath(ASTNode math) {
    libsbmlJNI.FunctionDefinition_setMath(swigCPtr, this, ASTNode.getCPtr(math), math);
  }

  
  /**
   * Get the <code>n</code>th argument to this function.
   * <p>
   * Callers should first find out the number of arguments to the function
   * by calling getNumArguments().
   * <p>
   * @param n an integer index for the argument sought.
   * <p>
   * @return the nth argument (bound variable) passed to this
   * {@link FunctionDefinition}.
   * <p>
   * @see #getNumArguments()
   */
 public ASTNode getArgument(long n) {
    long cPtr = libsbmlJNI.FunctionDefinition_getArgument__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Get the argument named <code>name</code> to this {@link FunctionDefinition}.
   * <p>
   * @param name the exact name (case-sensitive) of the sought-after
   * argument
   * <p>
   * @return the argument (bound variable) having the given name, or NULL if
   * no such argument exists.
   */
 public ASTNode getArgument(String name) {
    long cPtr = libsbmlJNI.FunctionDefinition_getArgument__SWIG_1(swigCPtr, this, name);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Get the mathematical expression that is the body of this
   * {@link FunctionDefinition} object.
   * <p>
   * @return the body of this {@link FunctionDefinition} as an Abstract Syntax
   * Tree, or NULL if no body is defined.
   */
 public ASTNode getBody() {
    long cPtr = libsbmlJNI.FunctionDefinition_getBody__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Get the number of arguments (bound variables) taken by this
   * {@link FunctionDefinition}.
   * <p>
   * @return the number of arguments (bound variables) that must be passed
   * to this {@link FunctionDefinition}.
   */
 public long getNumArguments() {
    return libsbmlJNI.FunctionDefinition_getNumArguments(swigCPtr, this);
  }

  
  /**
   * Returns the libSBML type code for this SBML object.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.FunctionDefinition_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for
   * {@link FunctionDefinition}, is always <code>'functionDefinition'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'functionDefinition'</code>.
   */
 public String getElementName() {
    return libsbmlJNI.FunctionDefinition_getElementName(swigCPtr, this);
  }

}
