/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * LibSBML implementation of SBML's Event construct.
 * <p>
 * An {@link Event} object defines when the event can occur, the variables that are
 * affected by the event, and how the variables are affected.
 * <p>
 * An {@link Event} definition has several parts: an optional identifier (defined
 * by the attribute 'id'), an optional name (defined by the attribute
 * 'name'), a required trigger condition (defined by an object of class
 * {@link Trigger}), and at least one {@link EventAssignment}.  In addition, an event can
 * include an optional delay (defined by an object of class {@link Delay}).
 * <p>
 * The operation of {@link Event} is divided into two phases (even when the event
 * is not delayed): one when the event is <em>fired</em>, and the other when the
 * event is <em>executed</em>.  {@link Trigger} objects define the conditions for firing
 * an event, {@link Delay} objects define when the event is actually executed, and
 * {@link EventAssignment} objects define the effects of executing the event.
 * Please consult the descriptions of {@link Trigger}, {@link Delay} and {@link EventAssignment}
 * for more information.
 * <p>
 * The optional {@link Delay} on {@link Event} means there are two times to consider when
 * computing the results of an event: the time at which the event
 * <em>fires</em>, and the time at which assignments are <em>executed</em>.
 * It is also possible to distinguish between the time at which the
 * {@link EventAssignment}'s expression is calculated, and the time at which the
 * assignment is made: the expression could be evaluated at the same time
 * the assignments are performed, i.e., when the event is
 * <em>executed</em>, but it could also be defined to be evaluated at the
 * time the event <em>fired</em>.
 * <p>
 * In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics of
 * {@link Event} time delays were defined such that the expressions in the event's
 * assignments were always evaluated at the time the event was
 * <em>fired</em>.  This definition made it difficult to define an event
 * whose assignment formulas were meant to be evaluated at the time the
 * event was <em>executed</em> (i.e., after the time period defined by the
 * value of the {@link Delay} element).  In SBML Level&nbsp;2 Version&nbsp;4, the
 * attribute 'useValuesFromTriggerTime' on {@link Event} allows a model to indicate
 * the time at which the event's assignments are intended to be evaluated.
 * The default value is <code>true</code>, which corresponds to the interpretation of
 * event assignments prior to Version&nbsp;4: the values of the assignment
 * formulas are computed at the moment the event fired, not after the
 * delay.  If 'useValuesFromTriggerTime'=<code>false</code>, it means that the
 * formulas in the event's assignments are to be computed after the delay,
 * at the time the event is executed.
 * <p>
 * <h2>SBML version differences</h2>
 * <p>
 * Definitions of {@link Event} in SBML Level&nbsp;2 Versions 1 and 2 included an
 * additional attribute called 'timeUnits', which allowed the time units of
 * the {@link Delay} to be set explicitly.  Versions&nbsp;3 and&nbsp;4 do not
 * define this attribute.  The LibSBML supports this attribute for
 * compatibility with previous versions of SBML Level&nbsp;2; however, if a
 * Version&nbsp;3 or&nbsp;4 model sets the attribute, the
 * consistency-checking method {@link SBMLDocument#checkConsistency()} will report
 * an error.
 * <p>
 * The attribute 'useValuesFromTriggerTime' was introduced in SBML
 * Level&nbsp;2 Version&nbsp;4.  Models defined in prior Versions of SBML
 * Level&nbsp;2 cannot use this attribute, and
 * {@link SBMLDocument#checkConsistency()} will report an error if they do.
 * <p>
 * <p>
 */

public class Event extends SBase {
   private long swigCPtr;

   protected Event(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.SWIGEventUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Event obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Event obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_Event(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  
  /**
   * Creates a new {@link Event}, optionally with specific values of <code>id</code> and 
   * <code>name</code> attributes.
   * <p>
   * @param id a string, the identifier to assign to this {@link Event}
   * @param name a string, the name to be assigned to this {@link Event}
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Event(String id, String name) {
    this(libsbmlJNI.new_Event__SWIG_0(id, name), true);
  }

  
  /**
   * Creates a new {@link Event}, optionally with specific values of <code>id</code> and 
   * <code>name</code> attributes.
   * <p>
   * @param id a string, the identifier to assign to this {@link Event}
   * @param name a string, the name to be assigned to this {@link Event}
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Event(String id) {
    this(libsbmlJNI.new_Event__SWIG_1(id), true);
  }

  
  /**
   * Creates a new {@link Event}, optionally with specific values of <code>id</code> and 
   * <code>name</code> attributes.
   * <p>
   * @param id a string, the identifier to assign to this {@link Event}
   * @param name a string, the name to be assigned to this {@link Event}
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public Event() {
    this(libsbmlJNI.new_Event__SWIG_2(), true);
  }

  
  /**
   * Creates a new {@link Event} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Event}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Event}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link Event}
   * <p>
   * @note Once a {@link Event} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link Event}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public Event(long level, long version, XMLNamespaces xmlns) {
    this(libsbmlJNI.new_Event__SWIG_3(level, version, XMLNamespaces.getCPtr(xmlns), xmlns), true);
  }

  
  /**
   * Creates a new {@link Event} using the given SBML <code>level</code> and <code>version</code>
   * values and optionally a set of XMLNamespaces.
   * <p>
   * @param level a long integer, the SBML Level to assign to this {@link Event}
   * <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Event}
   * <p>
   * @param xmlns XMLNamespaces, a pointer to an array of XMLNamespaces to
   * assign to this {@link Event}
   * <p>
   * @note Once a {@link Event} has been added to an {@link SBMLDocument}, the <code>level</code>,
   * <code>version</code> and <code>xmlns</code> namespaces for the document <em>override</em> those used
   * to create the {@link Event}.  Despite this, the ability to supply the values
   * at creation time is an important aid to creating valid SBML.  Knowledge of
   * the intented SBML Level and Version determine whether it is valid to
   * assign a particular value to an attribute, or whether it is valid to add
   * an object to an existing {@link SBMLDocument}.
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   <p>
 * @deprecated libSBML internal
 */
 public Event(long level, long version) {
    this(libsbmlJNI.new_Event__SWIG_4(level, version), true);
  }

  
  /**
   * Copy constructor; creates a copy of this {@link Event}.
   */
 public Event(Event orig) {
    this(libsbmlJNI.new_Event__SWIG_5(Event.getCPtr(orig), orig), true);
  }

  
  /**
   * Creates and returns a deep copy of this {@link Event}.
   * <p>
   * @return a (deep) copy of this {@link Event}.
   */
 public Event cloneObject() {
    long cPtr = libsbmlJNI.Event_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Event(cPtr, true);
  }

  
  /**
   * Get the event trigger portion of this {@link Event}.
   * <p>
   * @return the {@link Trigger} object of this {@link Event}.
   */
 public Trigger getTrigger() {
    long cPtr = libsbmlJNI.Event_getTrigger__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Trigger(cPtr, false);
  }

  
  /**
   * Get the assignment delay portion of this {@link Event}, if there is one.
   * <p>
   * @return the delay of this {@link Event} if one is defined, or <code>NULL</code> if none
   * is defined.
   */
 public Delay getDelay() {
    long cPtr = libsbmlJNI.Event_getDelay__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Delay(cPtr, false);
  }

  
  /**
   * Get the value of the 'timeUnits' attribute of this {@link Event}, if it has one.
   * <p>
   * @return the value of the attribute 'timeUnits' as a string.
   * <p>
   * @warning Definitions of {@link Event} in SBML Level 2 Versions&nbsp;1
   * and&nbsp;2 included the additional attribute called 'timeUnits', but
   * it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
   * this attribute for compatibility with previous versions of SBML
   * Level&nbsp;2, but its use is discouraged since models in Level 2
   * Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
   * or&nbsp;4 model sets the attribute, the consistency-checking method
   * {@link SBMLDocument#checkConsistency()} will report an error.
   */
 public String getTimeUnits() {
    return libsbmlJNI.Event_getTimeUnits(swigCPtr, this);
  }

  
  /**
   * Get the value of the 'useValuesFromTriggerTime' attribute of this {@link Event}.
   * <p>
   * The optional {@link Delay} on {@link Event} means there are two times to consider when
   * computing the results of an event: the time at which the event
   * <em>fires</em>, and the time at which assignments are <em>executed</em>.
   * It is also possible to distinguish between the time at which the
   * {@link EventAssignment}'s expression is calculated, and the time at which the
   * assignment is made: the expression could be evaluated at the same time
   * the assignments are performed, i.e., when the event is
   * <em>executed</em>, but it could also be defined to be evaluated at the
   * time the event <em>fired</em>.
   * <p>
   * In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics of
   * {@link Event} time delays were defined such that the expressions in the event's
   * assignments were always evaluated at the time the event was
   * <em>fired</em>.  This definition made it difficult to define an event
   * whose assignment formulas were meant to be evaluated at the time the
   * event was <em>executed</em> (i.e., after the time period defined by the
   * value of the {@link Delay} element).  In SBML Level&nbsp;2 Version&nbsp;4, the
   * attribute 'useValuesFromTriggerTime' on {@link Event} allows a model to indicate
   * the time at which the event's assignments are intended to be evaluated.
   * The default value is <code>true</code>, which corresponds to the interpretation of
   * event assignments prior to Version&nbsp;4: the values of the assignment
   * formulas are computed at the moment the event fired, not after the
   * delay.  If 'useValuesFromTriggerTime'=<code>false</code>, it means that the
   * formulas in the event's assignments are to be computed after the delay,
   * at the time the event is executed.
   * <p>
   * @return the value of the attribute 'useValuesFromTriggerTime' as a boolean.
   * <p>
   * @warning The attribute 'useValuesFromTriggerTime' was introduced in
   * SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in models defined
   * using SBML Level&nbsp;2 versions prior to Version&nbsp;4.  If a
   * Version&nbsp;1&ndash;&nbsp;3 model sets the attribute, the
   * consistency-checking method {@link SBMLDocument#checkConsistency()} will
   * report an error.
   */
 public boolean getUseValuesFromTriggerTime() {
    return libsbmlJNI.Event_getUseValuesFromTriggerTime(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether the trigger for this {@link Event} has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the trigger of this {@link Event} has been set, <code>false</code>
   * otherwise.
   */
 public boolean isSetTrigger() {
    return libsbmlJNI.Event_isSetTrigger(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether the delay for this {@link Event} has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the delay of this {@link Event} has been set, <code>false</code>
   * otherwise.
   */
 public boolean isSetDelay() {
    return libsbmlJNI.Event_isSetDelay(swigCPtr, this);
  }

  
  /**
   * Predicate for testing whether the 'timeUnits' attribute of this {@link Event}
   * has been set.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @return <code>true</code> if the 'timeUnits' attribute of this {@link Event} has been
   * set, <code>false</code> otherwise.
   * <p>
   * @warning Definitions of {@link Event} in SBML Level 2 Versions&nbsp;1
   * and&nbsp;2 included the additional attribute called 'timeUnits', but
   * it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
   * this attribute for compatibility with previous versions of SBML
   * Level&nbsp;2, but its use is discouraged since models in Level 2
   * Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
   * or&nbsp;4 model sets the attribute, the consistency-checking method
   * {@link SBMLDocument#checkConsistency()} will report an error.
   */
 public boolean isSetTimeUnits() {
    return libsbmlJNI.Event_isSetTimeUnits(swigCPtr, this);
  }

  
  /**
   * Sets the trigger definition of this {@link Event} to a copy of the given
   * {@link Trigger} object instance.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param trigger the {@link Trigger} object instance to use.
   */
 public void setTrigger(Trigger trigger) {
    libsbmlJNI.Event_setTrigger(swigCPtr, this, Trigger.getCPtr(trigger), trigger);
  }

  
  /**
   * Sets the delay definition of this {@link Event} to a copy of the given {@link Delay}
   * object instance.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param delay the {@link Delay} object instance to use
   */
 public void setDelay(Delay delay) {
    libsbmlJNI.Event_setDelay(swigCPtr, this, Delay.getCPtr(delay), delay);
  }

  
  /**
   * Sets the 'timeUnits' attribute of this {@link Event} to a copy of <code>sid</code>.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @param sid the identifier of the time units to use.
   * <p>
   * @warning Definitions of {@link Event} in SBML Level 2 Versions&nbsp;1
   * and&nbsp;2 included the additional attribute called 'timeUnits', but
   * it was removed in SBML Level&nbsp;2 Version&nbsp;3.  LibSBML supports
   * this attribute for compatibility with previous versions of SBML
   * Level&nbsp;2, but its use is discouraged since models in Level 2
   * Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a Version&nbsp;3
   * or&nbsp;4 model sets the attribute, the consistency-checking method
   * {@link SBMLDocument#checkConsistency()} will report an error.
   */
 public void setTimeUnits(String sid) {
    libsbmlJNI.Event_setTimeUnits(swigCPtr, this, sid);
  }

  
  /**
   * Sets the 'useValuesFromTriggerTime' attribute of this {@link Event} to a <code>value</code>.
   * <p>
   * The optional {@link Delay} on {@link Event} means there are two times to consider when
   * computing the results of an event: the time at which the event
   * <em>fires</em>, and the time at which assignments are <em>executed</em>.
   * It is also possible to distinguish between the time at which the
   * {@link EventAssignment}'s expression is calculated, and the time at which the
   * assignment is made: the expression could be evaluated at the same time
   * the assignments are performed, i.e., when the event is
   * <em>executed</em>, but it could also be defined to be evaluated at the
   * time the event <em>fired</em>.
   * <p>
   * In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics of
   * {@link Event} time delays were defined such that the expressions in the event's
   * assignments were always evaluated at the time the event was
   * <em>fired</em>.  This definition made it difficult to define an event
   * whose assignment formulas were meant to be evaluated at the time the
   * event was <em>executed</em> (i.e., after the time period defined by the
   * value of the {@link Delay} element).  In SBML Level&nbsp;2 Version&nbsp;4, the
   * attribute 'useValuesFromTriggerTime' on {@link Event} allows a model to indicate
   * the time at which the event's assignments are intended to be evaluated.
   * The default value is <code>true</code>, which corresponds to the interpretation of
   * event assignments prior to Version&nbsp;4: the values of the assignment
   * formulas are computed at the moment the event fired, not after the
   * delay.  If 'useValuesFromTriggerTime'=<code>false</code>, it means that the
   * formulas in the event's assignments are to be computed after the delay,
   * at the time the event is executed.
   * <p>
   * @param value the value of useValuesFromTriggerTime to use.
   * <p>
   * @warning The attribute 'useValuesFromTriggerTime' was introduced in
   * SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in models defined
   * using SBML Level&nbsp;2 versions prior to Version&nbsp;4.  If a
   * Version&nbsp;1&ndash;&nbsp;3 model sets the attribute, the
   * consistency-checking method {@link SBMLDocument#checkConsistency()} will
   * report an error.
   */
 public void setUseValuesFromTriggerTime(boolean value) {
    libsbmlJNI.Event_setUseValuesFromTriggerTime(swigCPtr, this, value);
  }

  
  /**
   * Unsets the {@link Delay} of this {@link Event}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   */
 public void unsetDelay() {
    libsbmlJNI.Event_unsetDelay(swigCPtr, this);
  }

  
  /**
   * Unsets the 'timeUnits' attribute of this {@link Event}.
   * <p>
   * <em>Some words of explanation about the</em>
<code>set</code>/<code>unset</code>/<code>isSet</code> <em>methods</em>:
SBML Levels 1 and 2 define certain attributes on some classes of objects as
optional.  This requires an application to be careful about the distinction
between two cases: (1) a given attribute has <em>never</em> been set to a
value, and therefore should be assumed to have the SBML-defined default
value, and (2) a given attribute has been set to a value, but the value
happens to be an empty string.  LibSBML supports these distinctions by
providing methods to set, unset, and query the status of attributes that
are optional.  The methods have names of the form
<code>set</code><i>Attribute</i><code>(...)</code>,
<code>unset</code><i>Attribute</i><code>()</code>, and
<code>isSet</code><i>Attribute</i><code>()</code>, where <i>Attribute</i>
is the the name of the optional attribute in question.

   * <p>
   * @warning Definitions of {@link Event} in SBML Level&nbsp;2 Versions 1 and 2
   * included the attribute called 'timeUnits', but it was removed in SBML
   * Level&nbsp;2 Version&nbsp;3.  LibSBML supports this attribute for
   * compatibility with previous versions of SBML Level&nbsp;2, but its use
   * is discouraged since models in Level&nbsp;2 Version&nbsp;3 and
   * Version&nbsp;4 cannot contain it.  If a Version&nbsp;3 or&nbsp;4 model
   * sets this attribute, the consistency-checking method
   * {@link SBMLDocument#checkConsistency()} will report an error.
   */
 public void unsetTimeUnits() {
    libsbmlJNI.Event_unsetTimeUnits(swigCPtr, this);
  }

  
  /**
   * Appends a copy of the given {@link EventAssignment} to this {@link Event}.
   * <p>
   * @param ea the {@link EventAssignment} object to add.
   * <p>
   * @note This method should be used with some caution.  The fact that
   * this method <em>copies</em> the object passed to it means that the caller
   * will be left holding a physically different object instance than the
   * one contained in this {@link Event}.  Changes made to the original object
   * instance (such as resetting attribute values) will <em>not affect the
   * instance in the {@link Event}</em>.  In addition, the caller should make sure
   * to free the original object if it is no longer being used, or else a
   * memory leak will result.  Please see {@link Event#createEventAssignment()}
   * for a method that does not lead to these issues.
   * <p>
   * @see #createEventAssignment()
   */
 public void addEventAssignment(EventAssignment ea) {
    libsbmlJNI.Event_addEventAssignment(swigCPtr, this, EventAssignment.getCPtr(ea), ea);
  }

  
  /**
   * Creates a new, empty {@link EventAssignment}, adds it to this {@link Event}'s list of
   * event assignments and returns the {@link EventAssignment}.
   * <p>
   * @return the newly created {@link EventAssignment} object instance
   * <p>
   * @see #addEvent()
   */
 public EventAssignment createEventAssignment() {
    long cPtr = libsbmlJNI.Event_createEventAssignment(swigCPtr, this);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, false);
  }

  
  /**
   * Returns the list of event assignments for this {@link Event}.
   * <p>
   * @return the list of EventAssignments for this {@link Event}.
   */
 public ListOfEventAssignments getListOfEventAssignments() {
    long cPtr = libsbmlJNI.Event_getListOfEventAssignments__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfEventAssignments(cPtr, false);
  }

  
  /**
   * Return a specific {@link EventAssignment} object of this {@link Event}.
   * <p>
   * @param n an integer, the index of the {@link EventAssignment} object to return
   * <p>
   * @return the <code>n</code>th {@link EventAssignment} of this {@link Event}.
   */
 public EventAssignment getEventAssignment(long n) {
    long cPtr = libsbmlJNI.Event_getEventAssignment__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, false);
  }

  
  /**
   * Return the event assignment indicated by the given <code>variable</code>.
   * <p>
   * @param variable a string, the identifier of the variable whose
   * {@link EventAssignment} is being sought.
   * <p>
   * @return the {@link EventAssignment} for the given <code>variable</code>, or <code>NULL</code> if
   * no such {@link EventAssignment} exits.
   */
 public EventAssignment getEventAssignment(String variable) {
    long cPtr = libsbmlJNI.Event_getEventAssignment__SWIG_2(swigCPtr, this, variable);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, false);
  }

  
  /**
   * Returns the number of {@link EventAssignment} objects attached to this
   * {@link Event}.
   * <p>
   * @return the number of EventAssignments in this {@link Event}.
   */
 public long getNumEventAssignments() {
    return libsbmlJNI.Event_getNumEventAssignments(swigCPtr, this);
  }

  
  /**
   * Sets the parent {@link SBMLDocument} of this SBML object.
   * <p>
   * @param d the {@link SBMLDocument} to use
   <p>
 * @deprecated libSBML internal
 */
 public void setSBMLDocument(SBMLDocument d) {
    libsbmlJNI.Event_setSBMLDocument(swigCPtr, this, SBMLDocument.getCPtr(d), d);
  }

  
  /**
   * Sets the parent SBML object of this SBML object.
   * <p>
   * @param sb the SBML object to use
   <p>
 * @deprecated libSBML internal
 */
 public void setParentSBMLObject(SBase sb) {
    libsbmlJNI.Event_setParentSBMLObject(swigCPtr, this, SBase.getCPtr(sb), sb);
  }

  
  /**
   * Returns the libSBML type code of this object instance.
   * <p>
   * LibSBML attaches an
   * identifying code to every kind of SBML object.  These are known as
   * <em>SBML type codes</em>.  In other languages, the set of type codes
   * is stored in an enumeration; in the Java language interface for
   * libSBML, the type codes are defined as static integer constants in
   * interface class {@link libsbmlConstants}.  The names of the type codes
   * all begin with the characters <code>SBML_</code>. 
   * <p>
   * @return the SBML type code for this object, or <code>SBML_UNKNOWN</code> (default).
   * <p>
   * @see #getElementName()
   */
 public int getTypeCode() {
    return libsbmlJNI.Event_getTypeCode(swigCPtr, this);
  }

  
  /**
   * Returns the XML element name of this object, which for {@link Event}, is
   * always <code>'event'</code>.
   * <p>
   * @return the name of this element, i.e., <code>'event'</code>. 
   */
 public String getElementName() {
    return libsbmlJNI.Event_getElementName(swigCPtr, this);
  }

  
  /**
   * sets the mInternalIdOnly flag
   <p>
 * @deprecated libSBML internal
 */
 public void setInternalIdOnly() {
    libsbmlJNI.Event_setInternalIdOnly(swigCPtr, this);
  }

}
