/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 * A node in the Abstract Syntax Tree (AST) representation of a
 * mathematical expression.
 * <p>
 * <em style='color: #555'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</em>

 * <p>
 * Abstract Syntax Trees (ASTs) are a simple kind of data structure used in
 * libSBML for storing mathematical expressions.  The {@link ASTNode} is the
 * cornerstone of libSBML's AST representation.  ASTNodes represent the
 * most basic, indivisible part of a mathematical formula and come in many
 * types.  For instance, there are node types to represent numbers (with
 * subtypes to distinguish integer, real, and rational numbers), names
 * (e.g., constants or variables), simple mathematical operators, logical
 * or relational operators and functions. LibSBML ASTs provide a canonical,
 * in-memory representation for all mathematical formulas regardless of
 * their original format (which might be MathML or might be text strings).
 * <p>
 * An AST <em>node</em> in libSBML is a recursive structure containing a pointer
 * to the node's value (which might be, for example, a number or a symbol)
 * and a list of children nodes.  Each {@link ASTNode} node may have none, one,
 * two, or more child depending on its type. The following diagram
 * illustrates an example of how the mathematical expression <code>'1 +
 * 2'</code> is represented as an AST with one <em>plus</em> node having two 
 * <em>integer</em> children nodes for the numbers <code>1</code> and
 * <code>2</code>.  The figure also shows the corresponding MathML
 * representation:
 * <p>
 * <center><img src='astnode-illustration.jpg'></center><br>
 * 
 * <p>
 * The following are other noteworthy points about the AST representation
 * in libSBML:
 * <ul>
 * <li> A numerical value represented in MathML as a real number with an
 * exponent is preserved as such in the AST node representation, even if
 * the number could be stored in a <code>double</code> data type.  This is done
 * so that when an SBML model is read in and then written out again, the
 * amount of change introduced by libSBML to the SBML during the round-trip
 * activity is minimized.
 * <p>
 * <li> Rational numbers are represented in an AST node using separate
 * numerator and denominator values.  These can be retrieved using the
 * methods {@link ASTNode#getNumerator()} and {@link ASTNode#getDenominator()}.
 * <p>
 * <li> The children of an {@link ASTNode} are other {@link ASTNode} objects.  The list of
 * children is empty for nodes that are leaf elements, such as numbers.
 * For nodes that are actually roots of expression subtrees, the list of
 * children points to the parsed objects that make up the rest of the
 * expression.
 * </ul>
 * <p>
 * <p>
 * <h3><a class='anchor'
 * name='ASTNodeType_t'>The set of possible ASTNode types</a></h3> 
 * <p>
 * Every {@link ASTNode} has an associated
 * type code to indicate, for example, whether it holds a number or stands for
 * an arithmetic operator.  The type is recorded as a value drawn from a
 * set of static integer constants defined in the class {@link
 * libsbmlConstants}.  Their names begin with the characters <code>AST_</code>.  The
 * list of possible types is quite long, because it covers all the
 * mathematical functions that are permitted in SBML.  The values are shown
 * in the following table; their names hopefully evoke the construct that
 * they represent: 
 * <p>
 * <center>
<table cellspacing='5' border='0' class='small-font'>
 <tr><td><code></code></td><td><code></code></td><td><code></code></td></tr>
 <tr><td><code>AST_UNKNOWN</code></td><td><code>AST_FUNCTION_ARCCOTH</code></td><td><code>AST_FUNCTION_POWER</code></td></tr>
 <tr><td><code>AST_PLUS</code></td><td><code>AST_FUNCTION_ARCCSC</code></td><td><code>AST_FUNCTION_ROOT</code></td></tr>
 <tr><td><code>AST_MINUS</code></td><td><code>AST_FUNCTION_ARCCSCH</code></td><td><code>AST_FUNCTION_SEC</code></td></tr>
 <tr><td><code>AST_TIMES</code></td><td><code>AST_FUNCTION_ARCSEC</code></td><td><code>AST_FUNCTION_SECH</code></td></tr>
 <tr><td><code>AST_DIVIDE</code></td><td><code>AST_FUNCTION_ARCSECH</code></td><td><code>AST_FUNCTION_SIN</code></td></tr>
 <tr><td><code>AST_POWER</code></td><td><code>AST_FUNCTION_ARCSIN</code></td><td><code>AST_FUNCTION_SINH</code></td></tr>
 <tr><td><code>AST_INTEGER</code></td><td><code>AST_FUNCTION_ARCSINH</code></td><td><code>AST_FUNCTION_TAN</code></td></tr>
 <tr><td><code>AST_REAL</code></td><td><code>AST_FUNCTION_ARCTAN</code></td><td><code>AST_FUNCTION_TANH</code></td></tr>
 <tr><td><code>AST_REAL_E</code></td><td><code>AST_FUNCTION_ARCTANH</code></td><td><code>AST_LOGICAL_AND</code></td></tr>
 <tr><td><code>AST_RATIONAL</code></td><td><code>AST_FUNCTION_CEILING</code></td><td><code>AST_LOGICAL_NOT</code></td></tr>
 <tr><td><code>AST_NAME</code></td><td><code>AST_FUNCTION_COS</code></td><td><code>AST_LOGICAL_OR</code></td></tr>
 <tr><td><code>AST_NAME_TIME</code></td><td><code>AST_FUNCTION_COSH</code></td><td><code>AST_LOGICAL_XOR</code></td></tr>
 <tr><td><code>AST_CONSTANT_E</code></td><td><code>AST_FUNCTION_COT</code></td><td><code>AST_RELATIONAL_EQ</code></td></tr>
 <tr><td><code>AST_CONSTANT_FALSE</code></td><td><code>AST_FUNCTION_COTH</code></td><td><code>AST_RELATIONAL_GEQ</code></td></tr>
 <tr><td><code>AST_CONSTANT_PI</code></td><td><code>AST_FUNCTION_CSC</code></td><td><code>AST_RELATIONAL_GT</code></td></tr>
 <tr><td><code>AST_CONSTANT_TRUE</code></td><td><code>AST_FUNCTION_CSCH</code></td><td><code>AST_RELATIONAL_LEQ</code></td></tr>
 <tr><td><code>AST_LAMBDA</code></td><td><code>AST_FUNCTION_EXP</code></td><td><code>AST_RELATIONAL_LT</code></td></tr>
 <tr><td><code>AST_FUNCTION</code></td><td><code>AST_FUNCTION_FACTORIAL</code></td><td><code>AST_RELATIONAL_NEQ</code></td></tr>
 <tr><td><code>AST_FUNCTION_ABS</code></td><td><code>AST_FUNCTION_FLOOR</code></td><td><code></code></td></tr>
 <tr><td><code>AST_FUNCTION_ARCCOS</code></td><td><code>AST_FUNCTION_LN</code></td></tr>
 <tr><td><code>AST_FUNCTION_ARCCOSH</code></td><td><code>AST_FUNCTION_LOG</code></td></tr>
 <tr><td><code>AST_FUNCTION_ARCCOT</code></td><td><code>AST_FUNCTION_PIECEWISE</code></td></tr>
</table>
</center>

 * <p>
 * The types have the following meanings:
 * <ul>
 * <li> If the node is basic mathematical operator (e.g., <code>'+'</code>), then the
 * node's type will be <code>AST_PLUS</code>, <code>AST_MINUS</code>, <code>AST_TIMES</code>, <code>AST_DIVIDE</code>,
 * or <code>AST_POWER</code>, as appropriate.
 * <p>
 * <li> If the node is a predefined function or operator from SBML Level 1
 * (in the string-based formula syntax used in Level 1) or SBML Level 2
 * (in the subset of MathML used in SBML Level 2), then the node's type
 * will be either <code>AST_FUNCTION_</code><em>x</em>,
 * <code>AST_LOGICAL_</code><em>x</em>, or
 * <code>AST_RELATIONAL_</code><em>x</em>, as appropriate.  (Examples: 
 * <code>AST_FUNCTION_LOG</code>, <code>AST_RELATIONAL_LEQ</code>.)
 * <p>
 * <li> If the node refers to a user-defined function, the node's type will
 * be <code>AST_NAME</code> (because it holds the name of the function).
 * <p>
 * <li> If the node is a lambda expression, its type will be <code>AST_LAMBDA</code>.
 * <p>
 * <li> If the node is a predefined constant (<code>'ExponentialE'</code>, <code>'Pi'</code>, 
 * <code>'True'</code> or <code>'False'</code>), then the node's type will be <code>AST_CONSTANT_E</code>,
 * <code>AST_CONSTANT_PI</code>, <code>AST_CONSTANT_TRUE</code>, or <code>AST_CONSTANT_FALSE</code>.
 * <p>
 * <li> (Level 2 only) If the node is the special MathML csymbol <code>time</code>,
 * the value of the node will be <code>AST_NAME_TIME</code>.  (Note, however, that the
 * MathML csymbol <code>delay</code> is translated into a node of type
 * <code>AST_FUNCTION_DELAY</code>.  The difference is due to the fact that <code>time</code> is a
 * single variable, whereas <code>delay</code> is actually a function taking
 * arguments.)
 * <p>
 * <li> If the node contains a numerical value, its type will be
 * <code>AST_INTEGER</code>, <code>AST_REAL</code>, <code>AST_REAL_E</code>, or <code>AST_RATIONAL</code>,
 * as appropriate.
 * </ul>
 * <p>
 * <p>
 * <h3><a class='anchor' name='math-convert'>Converting between ASTs and text strings</a></h3>
 * <p>
 * * The text-string form of mathematical formulas produced by <code><a
 * href='libsbml.html'>libsbml.formulaToString()</a></code> and read by <code><a
 * href='libsbml.html'>libsbml.parseFormula()</a></code> are simple C-inspired
 * infix notation taken from SBML Level&nbsp;1.  A formula in this
 * text-string form can be handed to a program that understands SBML
 * Level&nbsp;1 mathematical expressions, or used as part of a translation
 * system.  The libSBML distribution comes with an example program in the
 * <code>'examples'</code> subdirectory called <code>translateMath</code> that implements an
 * interactive command-line demonstration of translating infix formulas
 * into MathML and vice-versa.
 * <p>
 * The formula strings may contain operators, function calls, symbols, and
 * white space characters.  The allowable white space characters are tab
 * and space.  The following are illustrative examples of formulas
 * expressed in the syntax:
 * <p>
 * <div class='fragment'><pre>
0.10 * k4^2
</pre></div>
 * <div class='fragment'><pre>
(vm * s1)/(km + s1)
</pre></div>
 * <p>
 * The following table shows the precedence rules in this syntax.  In the
 * Class column, <em>operand</em> implies the construct is an operand, 
 * <em>prefix</em> implies the operation is applied to the following arguments, 
 * <em>unary</em> implies there is one argument, and <em>binary</em> implies there are
 * two arguments.  The values in the Precedence column show how the order
 * of different types of operation are determined.  For example, the
 * expression <em>a * b + c</em> is evaluated as <em>(a * b) + c</em>
 * because the <code>*</code> operator has higher precedence.  The
 * Associates column shows how the order of similar precedence operations
 * is determined; for example, <em>a - b + c</em> is evaluated as <em>(a -
 * b) + c</em> because the <code>+</code> and <code>-</code> operators are
 * left-associative.  The precedence and associativity rules are taken from
 * the C programming language, except for the symbol <code>^</code>, which
 * is used in C for a different purpose.  (Exponentiation can be invoked
 * using either <code>^</code> or the function <code>power</code>.)
 * <p>
 * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr style='background: lightgray; font-size: 14px;'>
     <th align='left'>Token</th>
     <th align='left'>Operation</th>
     <th align='left'>Class</th>
     <th>Precedence</th>
     <th align='left'>Associates</th>
 </tr>
<tr><td><em>name</em></td><td>symbol reference</td><td>operand</td><td align='center'>6</td><td>n/a</td></tr>
<tr><td><code>(</code><em>expression</em><code>)</code></td><td>expression grouping</td><td>operand</td><td align='center'>6</td><td>n/a</td></tr>
<tr><td><code>f(</code><em>...</em><code>)</code></td><td>function call</td><td>prefix</td><td align='center'>6</td><td>left</td></tr>
<tr><td><code>-</code></td><td>negation</td><td>unary</td><td align='center'>5</td><td>right</td></tr>
<tr><td><code>^</code></td><td>power</td><td>binary</td><td align='center'>4</td><td>left</td></tr>
<tr><td><code>*</code></td><td>multiplication</td><td>binary</td><td align='center'>3</td><td>left</td></tr>
<tr><td><code>/</code></td><td>divison</td><td>binary</td><td align='center'>3</td><td>left</td></tr>
<tr><td><code>+</code></td><td>addition</td><td>binary</td><td align='center'>2</td><td>left</td></tr>
<tr><td><code>-</code></td><td>subtraction</td><td>binary</td><td align='center'>2</td><td>left</td></tr>
<tr><td><code>,</code></td><td>argument delimiter</td><td>binary</td><td align='center'>1</td><td>left</td></tr>
<caption class='top-caption'>A table of the expression operators and their precedence in the
text-string format for mathematical expressions used by SBML_parseFormula().
</caption>
</table>
</center>

 * <p>
 * A program parsing a formula in an SBML model should assume that names
 * appearing in the formula are the identifiers of {@link Species}, {@link Parameter},
 * {@link Compartment}, {@link FunctionDefinition}, or {@link Reaction} objects defined in a model.
 * When a function call is involved, the syntax consists of a function
 * identifier, followed by optional white space, followed by an opening
 * parenthesis, followed by a sequence of zero or more arguments separated
 * by commas (with each comma optionally preceded and/or followed by zero
 * or more white space characters), followed by a closing parenthesis.
 * There is an almost one-to-one mapping between the list of predefined
 * functions available, and those defined in MathML.  All of the MathML
 * functions are recognized; this set is larger than the functions defined
 * in SBML Level&nbsp;1.  In the subset of functions that overlap between
 * MathML and SBML Level&nbsp;1, there exist a few differences.  The
 * following table summarizes the differences between the predefined
 * functions in SBML Level&nbsp;1 and the MathML equivalents in SBML
 * Level&nbsp;2:
 * <p>
 * <center>
<table border='0' class='text-table width80 normal-font alt-row-colors'>
 <tr style='background: lightgray; font-size: 14px;'>
     <th align='left'>Text string formula functions</th>
     <th align='left'>MathML equivalents in SBML Level 2</th>
 </tr>
 <tr><td><code>acos</code></td><td><code>arccos</code></td></tr>
 <tr><td><code>asin</code></td><td><code>arcsin</code></td></tr>
 <tr><td><code>atan</code></td><td><code>arctan</code></td></tr>
 <tr><td><code>ceil</code></td><td><code>ceiling</code></td></tr>
 <tr><td><code>log</code></td><td><code>ln</code></td></tr>
 <tr><td><code>log10(x)</code></td><td><code>log(10, x)</code></td></tr>
 <tr><td><code>pow(x, y)</code></td><td><code>power(x, y)</code></td></tr>
 <tr><td><code>sqr(x)</code></td><td><code>power(x, 2)</code></td></tr>
 <tr><td><code>sqrt(x)</code></td><td><code>root(2, x)</code></td></tr>
<caption class='top-caption'>Table comparing the names of certain
functions in the SBML text-string formula syntax and MathML.  The left
column shows the names of functions recognized by SBML_parseFormula(); the
right column shows their equivalent function names in MathML&nbsp;2.0, used
in SBML Level&nbsp;2.</caption>
</table>
</center>

 */

public class ASTNode {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected ASTNode(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(ASTNode obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (ASTNode obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      libsbmlJNI.delete_ASTNode(swigCPtr);
    }
    swigCPtr = 0;
  }

  /**
   * Equality comparison method for ASTNode.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((ASTNode)(sb));
  }

  /**
   * Returns a hashcode for this ASTNode object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
  /**
   * Creates and returns a new {@link ASTNode}.
   * <p>
   * By default, the returned node will have a type of <code>AST_UNKNOWN</code>.  The
   * calling code should set the node type to something else as soon as
   * possible using {@link ASTNode#setType(int)} 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public ASTNode(int type) {
    this(libsbmlJNI.new_ASTNode__SWIG_0(type), true);
  }

  
  /**
   * Creates and returns a new {@link ASTNode}.
   * <p>
   * By default, the returned node will have a type of <code>AST_UNKNOWN</code>.  The
   * calling code should set the node type to something else as soon as
   * possible using {@link ASTNode#setType(int)} 
   * <p>
   * @docnote The native C++ implementation of this method defines a
   * default argument value.  In the documentation generated for different
   * libSBML language bindings, you may or may not see corresponding
   * arguments in the method declarations.  For example, in Java, a default
   * argument is handled by declaring two separate methods, with one of
   * them having the argument and the other one lacking the argument.
   * However, the libSBML documentation will be <em>identical</em> for both
   * methods.  Consequently, if you are reading this and do not see an
   * argument even though one is described, please look for descriptions of
   * other variants of this method near where this one appears in the
   * documentation.
   */
 public ASTNode() {
    this(libsbmlJNI.new_ASTNode__SWIG_1(), true);
  }

  
  /**
   * Copy constructor; Creates a deep copy of the given {@link ASTNode}.
   * <p>
   * @param orig the {@link ASTNode} to be copied.
   */
 public ASTNode(ASTNode orig) {
    this(libsbmlJNI.new_ASTNode__SWIG_2(ASTNode.getCPtr(orig), orig), true);
  }

  
  /**
   * Converts this {@link ASTNode} to a canonical form and returns true (non-zero)
   * if successful, false (zero) otherwise.
   * <p>
   * The rules determining the canonical form conversion are as follows:
   * <ul>
   * <p>
   * <li> If the node type is <code>AST_NAME</code> and the node name matches 
   * <code>'ExponentialE'</code>, <code>'Pi'</code>, <code>'True'</code> or <code>'False'</code> the node type is
   * converted to the corresponding <code>AST_CONSTANT_</code><em>x</em> type.
   * <p>
   * <li> If the node type is an <code>AST_FUNCTION</code> and the node name matches
   * an SBML Level&nbsp;1 or Level&nbsp;2 (MathML) function name, logical
   * operator name, or relational operator name, the node is converted to
   * the correspnding <code>AST_FUNCTION_</code><em>x</em> or
   * <code>AST_LOGICAL_</code><em>x</em> type.
   * <p>
   * </ul>
   * <p>
   * SBML Level&nbsp;1 function names are searched first; thus, for
   * example, canonicalizing <code>log</code> will result in a node type of 
   * <code>AST_FUNCTION_LN</code>.  (See the SBML Level&nbsp;1 Specification, Appendix
   * C.)
   * <p>
   * Sometimes canonicalization of a node results in a structural converion
   * of the node as a result of adding a child.  For example, a node with
   * the SBML Level&nbsp;1 function name <code>sqr</code> and a single child node
   * (the argument) will be transformed to a node of type
   * <code>AST_FUNCTION_POWER</code> with two children.  The first child will remain
   * unchanged, but the second child will be an {@link ASTNode} of type
   * <code>AST_INTEGER</code> and a value of 2.  The function names that result in
   * structural changes are: <code>log10</code>, <code>sqr</code>, and <code>sqrt</code>.
   * <p>
   * See the SBML Level&nbsp;1 and Level&nbsp;2 (all versions)
   * specification documents for more information.
   */
 public boolean canonicalize() {
    return libsbmlJNI.ASTNode_canonicalize(swigCPtr, this);
  }

  
  /**
   * Adds the given node as a child of this {@link ASTNode}.  Child nodes are added
   * in-order from left to right.
   * <p>
   * @param child the {@link ASTNode} instance to add
   */
 public void addChild(ASTNode child) {
    libsbmlJNI.ASTNode_addChild(swigCPtr, this, ASTNode.getCPtrAndDisown(child), child);
  }

  
  /**
   * Adds the given node as a child of this {@link ASTNode}.  This method adds
   * child nodes from right to left.
   * <p>
   * @param child the {@link ASTNode} instance to add
   */
 public void prependChild(ASTNode child) {
    libsbmlJNI.ASTNode_prependChild(swigCPtr, this, ASTNode.getCPtrAndDisown(child), child);
  }

  
  /**
   * Removes child n of this {@link ASTNode}. 
   * <p>
   * @param n long the index of the child to remove
   * <p>
   * @return int indicating the success or failure of the operation
   * <p>
   * @note removing a child from an {@link ASTNode} may result in an
   * inaccurate representation.
   */
 public int removeChild(long n) {
    return libsbmlJNI.ASTNode_removeChild(swigCPtr, this, n);
  }

  
  /**
   * Replaces the nth child of this {@link ASTNode} with the given {@link ASTNode}.
   * <p>
   * @param n long the index of the child to replace
   * @param newChild {@link ASTNode} to replace the nth child
   * <p>
   * @return int indicating the success or failure of the operation
   * <p>
   * @note replacing a child within an {@link ASTNode} may result in an
   * inaccurate representation.
   */
 public int replaceChild(long n, ASTNode newChild) {
    return libsbmlJNI.ASTNode_replaceChild(swigCPtr, this, n, ASTNode.getCPtrAndDisown(newChild), newChild);
  }

  
  /**
   * Insert the given {@link ASTNode} at point n in the list of children
   * of this {@link ASTNode}.
   * <p>
   * @param n long the index of the {@link ASTNode} being added
   * @param newChild {@link ASTNode} to insert as the nth child
   * <p>
   * @return int indicating the success or failure of the operation
   * <p>
   * @note inserting a child within an {@link ASTNode} may result in an
   * inaccurate representation.
   */
 public int insertChild(long n, ASTNode newChild) {
    return libsbmlJNI.ASTNode_insertChild(swigCPtr, this, n, ASTNode.getCPtrAndDisown(newChild), newChild);
  }

  
  /**
   * Creates a recursive copy of this node and all its children.
   * <p>
   * @return a copy of this {@link ASTNode} and all its children.  The caller owns
   * the returned {@link ASTNode} and is reponsible for deleting it.
   */
 public ASTNode deepCopy() {
    long cPtr = libsbmlJNI.ASTNode_deepCopy(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, true);
  }

  
  /**
   * Get a child of this node according to an index number.
   * <p>
   * @param n the index of the child to get
   * <p>
   * @return the nth child of this {@link ASTNode} or NULL if this node has no nth
   * child (<code>n &gt; getNumChildren() - 1</code>).
   */
 public ASTNode getChild(long n) {
    long cPtr = libsbmlJNI.ASTNode_getChild(swigCPtr, this, n);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Get the left child of this node.
   * <p>
   * @return the left child of this {@link ASTNode}.  This is equivalent to
   * <code>getChild(0)</code>;
   */
 public ASTNode getLeftChild() {
    long cPtr = libsbmlJNI.ASTNode_getLeftChild(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Get the right child of this node.
   * <p>
   * @return the right child of this {@link ASTNode}, or NULL if this node has no
   * right child.  If <code>getNumChildren() &gt; 1</code>, then
   * this is equivalent to:
   * <div class='fragment'><pre>
   * getChild( getNumChildren() - 1 );</pre></div>
   */
 public ASTNode getRightChild() {
    long cPtr = libsbmlJNI.ASTNode_getRightChild(swigCPtr, this);
    return (cPtr == 0) ? null : new ASTNode(cPtr, false);
  }

  
  /**
   * Get the number of children that this node has.
   * <p>
   * @return the number of children of this {@link ASTNode}, or 0 is this node has
   * no children.
   */
 public long getNumChildren() {
    return libsbmlJNI.ASTNode_getNumChildren(swigCPtr, this);
  }

  
  /**
   * Adds the given XMLNode as a semantic annotation of this {@link ASTNode}.
   * <p>
   * @param sAnnotation the annotation to add.
   */
 public void addSemanticsAnnotation(XMLNode sAnnotation) {
    libsbmlJNI.ASTNode_addSemanticsAnnotation(swigCPtr, this, XMLNode.getCPtrAndDisown(sAnnotation), sAnnotation);
  }

  
  /**
   * Get the number of semantic annotation elements inside this node.
   * <p>
   * @return the number of annotations of this {@link ASTNode}.  
   */
 public long getNumSemanticsAnnotations() {
    return libsbmlJNI.ASTNode_getNumSemanticsAnnotations(swigCPtr, this);
  }

  
  /**
   * Get the nth semantic annotation of this node.
   * <p>
   * @return the nth annotation of this {@link ASTNode}, or NULL if this node has no nth
   * annotation (<code>n &gt; getNumChildren() - 1</code>).
   */
 public XMLNode getSemanticsAnnotation(long n) {
    long cPtr = libsbmlJNI.ASTNode_getSemanticsAnnotation(swigCPtr, this, n);
    return (cPtr == 0) ? null : new XMLNode(cPtr, false);
  }

  
  /**
   * Get the value of this node as a single character.  This function
   * should be called only when {@link ASTNode#getType()} is one of <code>AST_PLUS</code>,
   * <code>AST_MINUS</code>, <code>AST_TIMES</code>, <code>AST_DIVIDE</code> or <code>AST_POWER</code>.
   * <p>
   * @return the value of this {@link ASTNode} as a single character
   */
 public char getCharacter() {
    return libsbmlJNI.ASTNode_getCharacter(swigCPtr, this);
  }

  
  /**
   * Get the value of this node as an integer. This function should be
   * called only when <code>getType() == AST_INTEGER</code>.
   * <p>
   * @return the value of this {@link ASTNode} as a (<code>long</code>) integer. 
   */
 public int getInteger() {
    return libsbmlJNI.ASTNode_getInteger(swigCPtr, this);
  }

  
  /**
   * Get the value of this node as a string.  This function may be called
   * on nodes that are not operators (<code>isOperator() == false</code>)
   * or numbers (<code>isNumber() == false</code>).
   * <p>
   * @return the value of this {@link ASTNode} as a string.
   */
 public String getName() {
    return libsbmlJNI.ASTNode_getName(swigCPtr, this);
  }

  
  /**
   * Get the value of the numerator of this node.  This function
   * should be called only when <code>getType() == AST_RATIONAL</code>.
   * <p>
   * @return the value of the numerator of this {@link ASTNode}.  
   */
 public int getNumerator() {
    return libsbmlJNI.ASTNode_getNumerator(swigCPtr, this);
  }

  
  /**
   * Get the value of the denominator of this node.  This function
   * should be called only when <code>getType() == AST_RATIONAL</code>.
   * <p>
   * @return the value of the denominator of this {@link ASTNode}.
   */
 public int getDenominator() {
    return libsbmlJNI.ASTNode_getDenominator(swigCPtr, this);
  }

  
  /**
   * Get the real-numbered value of this node.  This function
   * should be called only when <code>isReal() == true</code>.
   * <p>
   * This function performs the necessary arithmetic if the node type is 
   * <code>AST_REAL_E</code> (<em>mantissa * 10<sup> exponent</sup></em>) or 
   * <code>AST_RATIONAL</code> (<em>numerator / denominator</em>).
   * <p>
   * @return the value of this {@link ASTNode} as a real (double).
   */
 public double getReal() {
    return libsbmlJNI.ASTNode_getReal(swigCPtr, this);
  }

  
  /**
   * Get the mantissa value of this node.  This function should be called
   * only when getType() returns <code>AST_REAL_E</code> or <code>AST_REAL</code>.  If
   * getType() returns <code>AST_REAL</code>, this method is identical to getReal().
   * <p>
   * @return the value of the mantissa of this {@link ASTNode}. 
   */
 public double getMantissa() {
    return libsbmlJNI.ASTNode_getMantissa(swigCPtr, this);
  }

  
  /**
   * Get the exponent value of this {@link ASTNode}.  This function should be
   * called only when getType() returns <code>AST_REAL_E</code> or <code>AST_REAL</code>.
   * <p>
   * @return the value of the exponent of this {@link ASTNode}.
   */
 public int getExponent() {
    return libsbmlJNI.ASTNode_getExponent(swigCPtr, this);
  }

  
  /**
   * Get the precedence of this node in the infix math syntax of SBML
   * Level&nbsp;1.  For more information about the infix syntax, see the
   * discussion about <a href='#math-convert'>text string formulas</a> at
   * the top of the documentation for {@link ASTNode}.
   * <p>
   * @return an integer indicating the precedence of this {@link ASTNode}
   */
 public int getPrecedence() {
    return libsbmlJNI.ASTNode_getPrecedence(swigCPtr, this);
  }

  
  /**
   * Get the type of this {@link ASTNode}.  The value returned is one of the
   * enumeration values such as <code>AST_LAMBDA</code>, <code>AST_PLUS</code>, etc.
   * <p>
   * @return the type of this {@link ASTNode}.
   */
 public int getType() {
    return libsbmlJNI.ASTNode_getType(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node has a boolean type (a
   * logical operator, a relational operator, or the constants <code>true</code> or
   * <code>false</code>).
   * <p>
   * @return true if this {@link ASTNode} is a boolean, false otherwise.
   */
 public boolean isBoolean() {
    return libsbmlJNI.ASTNode_isBoolean(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node represents a MathML
   * constant (e.g., <code>true</code>, <code>Pi</code>).
   * <p>
   * @return true if this {@link ASTNode} is a MathML constant, false otherwise.
   */
 public boolean isConstant() {
    return libsbmlJNI.ASTNode_isConstant(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node represents a MathML
   * function (e.g., <code>abs()</code>), or an SBML Level&nbsp;1
   * function, or a user-defined function.
   * <p>
   * @return true if this {@link ASTNode} is a function, false otherwise.
   */
 public boolean isFunction() {
    return libsbmlJNI.ASTNode_isFunction(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node represents
   * the special IEEE 754 value infinity, false (zero) otherwise.
   * <p>
   * @return true if this {@link ASTNode} is the special IEEE 754 value infinity,
   * false otherwise.
   */
 public boolean isInfinity() {
    return libsbmlJNI.ASTNode_isInfinity(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node contains an integer
   * value, false (zero) otherwise.
   * <p>
   * @return true if this {@link ASTNode} is of type AST_INTEGER, false otherwise.
   */
 public boolean isInteger() {
    return libsbmlJNI.ASTNode_isInteger(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node is a MathML
   * <code>&lt;lambda&gt;</code>, false (zero) otherwise.
   * <p>
   * @return true if this {@link ASTNode} is of type AST_LAMBDA, false otherwise.
   */
 public boolean isLambda() {
    return libsbmlJNI.ASTNode_isLambda(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node represents a 
   * <code>log10</code>() function, false (zero) otherwise.  More precisely, this
   * predicate returns true if the node type is <code>AST_FUNCTION_LOG</code> with
   * two children, the first of which is an <code>AST_INTEGER</code> equal to 10.
   * <p>
   * @return true if the given {@link ASTNode} represents a log10() function, false
   * otherwise.
   */
 public boolean isLog10() {
    return libsbmlJNI.ASTNode_isLog10(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node is a MathML logical
   * operator (i.e., <code>and</code>, <code>or</code>, <code>not</code>, <code>xor</code>).
   * <p>
   * @return true if this {@link ASTNode} is a MathML logical operator
   */
 public boolean isLogical() {
    return libsbmlJNI.ASTNode_isLogical(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node is a user-defined
   * variable name in SBML L1, L2 (MathML), or the special symbols <code>delay</code>
   * or <code>time</code>.  The predicate returns false (zero) otherwise.
   * <p>
   * @return true if this {@link ASTNode} is a user-defined variable name in SBML
   * L1, L2 (MathML) or the special symbols delay or time.
   */
 public boolean isName() {
    return libsbmlJNI.ASTNode_isName(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node represents the
   * special IEEE 754 value 'not a number' (NaN), false (zero) otherwise.
   * <p>
   * @return true if this {@link ASTNode} is the special IEEE 754 NaN
   */
 public boolean isNaN() {
    return libsbmlJNI.ASTNode_isNaN(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node represents the
   * special IEEE 754 value 'negative infinity', false (zero) otherwise.
   * <p>
   * @return true if this {@link ASTNode} is the special IEEE 754 value negative
   * infinity, false otherwise.
   */
 public boolean isNegInfinity() {
    return libsbmlJNI.ASTNode_isNegInfinity(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node contains a number,
   * false (zero) otherwise.  This is functionally equivalent to the
   * following code:
   * <div class='fragment'><pre>
   *   isInteger() || isReal()</pre></div>
   * <p>
   * @return true if this {@link ASTNode} is a number, false otherwise.
   */
 public boolean isNumber() {
    return libsbmlJNI.ASTNode_isNumber(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node is a mathematical
 * operator, meaning, <code>+</code>, <code>-</code>, <code>*</code>,
 * <code>/</code> or <code>^</code> (power).
   * <p>
   * @return true if this {@link ASTNode} is an operator.
   */
 public boolean isOperator() {
    return libsbmlJNI.ASTNode_isOperator(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node is the MathML
   * <code>&lt;piecewise&gt;</code> construct, false (zero) otherwise.
   * <p>
   * @return true if this {@link ASTNode} is a MathML <code>piecewise</code> function
   */
 public boolean isPiecewise() {
    return libsbmlJNI.ASTNode_isPiecewise(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node represents a rational
   * number, false (zero) otherwise.
   * <p>
   * @return true if this {@link ASTNode} is of type <code>AST_RATIONAL</code>.
   */
 public boolean isRational() {
    return libsbmlJNI.ASTNode_isRational(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node can represent a real
   * number, false (zero) otherwise.  More precisely, this node must be of
   * one of the following types: <code>AST_REAL</code>, <code>AST_REAL_E</code> or 
   * <code>AST_RATIONAL</code>.
   * <p>
   * @return true if the value of this {@link ASTNode} can represented as a real
   * number, false otherwise.
   */
 public boolean isReal() {
    return libsbmlJNI.ASTNode_isReal(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node is a MathML
   * relational operator, meaning <code>==</code>, <code>&gt;=</code>, 
   * <code>&gt;</code>, <code>&lt;</code>, and <code>!=</code>.
   * <p>
   * @return true if this {@link ASTNode} is a MathML relational operator, false
   * otherwise
   */
 public boolean isRelational() {
    return libsbmlJNI.ASTNode_isRelational(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node represents a square
   * root function, false (zero) otherwise.  More precisely, the node type
   * must be <code>AST_FUNCTION_ROOT</code> with two children, the first of which is
   * an <code>AST_INTEGER</code> node having value equal to 2.
   * <p>
   * @return true if the given {@link ASTNode} represents a sqrt() function, false
   * otherwise.
   */
 public boolean isSqrt() {
    return libsbmlJNI.ASTNode_isSqrt(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node is a unary minus
   * operator, false (zero) otherwise.  A node is defined as a unary minus
   * node if it is of type <code>AST_MINUS</code> and has exactly one child.
   * <p>
   * For numbers, unary minus nodes can be 'collapsed' by negating the
   * number.  In fact, SBML_parseFormula() does this during its parse.
   * However, unary minus nodes for symbols (<code>AST_NAMES</code>) cannot be
   * 'collapsed', so this predicate function is necessary.
   * <p>
   * @return true if this {@link ASTNode} is a unary minus, false otherwise.
   */
 public boolean isUMinus() {
    return libsbmlJNI.ASTNode_isUMinus(swigCPtr, this);
  }

  
  /**
   * Predicate returning true (non-zero) if this node has an unknown type.
   * <p>
   * 'Unknown' nodes have the type <code>AST_UNKNOWN</code>.  Nodes with unknown
   * types will not appear in an {@link ASTNode} tree returned by libSBML based
   * upon valid SBML input; the only situation in which a node with type 
   * <code>AST_UNKNOWN</code> may appear is immediately after having create a new,
   * untyped node using the {@link ASTNode} constructor.  Callers creating nodes
   * should endeavor to set the type to a valid node type as soon as
   * possible after creating new nodes.
   * <p>
   * @return true if this {@link ASTNode} is of type <code>AST_UNKNOWN</code>, false otherwise.
   */
 public boolean isUnknown() {
    return libsbmlJNI.ASTNode_isUnknown(swigCPtr, this);
  }

  
  /**
   * Sets the value of this {@link ASTNode} to the given character.  If character
   * is one of <code>+</code>, <code>-</code>, @c *, @c / or <code>^</code>, the node type will be set
   * accordingly.  For all other characters, the node type will be set to
   * <code>AST_UNKNOWN</code>.
   * <p>
   * @param value the character value to which the node's value should be
   * set.
   */
 public void setCharacter(char value) {
    libsbmlJNI.ASTNode_setCharacter(swigCPtr, this, value);
  }

  
  /**
   * Sets the value of this {@link ASTNode} to the given name.
   * <p>
   * The node type will be set (to <code>AST_NAME</code>) <em>only if</em> the
   * {@link ASTNode} was previously an operator (<code>isOperator(node) ==
   * true</code>) or number (<code>isNumber(node) == true</code>).  This
   * allows names to be set for <code>AST_FUNCTIONs</code> and the like.
   * <p>
   * @param name the string containing the name to which this node's value
   * should be set
   */
 public void setName(String name) {
    libsbmlJNI.ASTNode_setName(swigCPtr, this, name);
  }

  
  /**
   * Sets the value of this {@link ASTNode} to the given (<code>long</code>) integer and sets
   * the node type to <code>AST_INTEGER</code>.
   * <p>
   * @param value the integer to which this node's value should be set
   */
 public void setValue(int value) {
    libsbmlJNI.ASTNode_setValue__SWIG_0(swigCPtr, this, value);
  }

  
  /**
   * Sets the value of this {@link ASTNode} to the given rational in two parts: the
   * numerator and denominator.  The node type is set to <code>AST_RATIONAL</code>.
   * <p>
   * @param numerator the numerator value of the rational
   * @param denominator the denominator value of the rational
   */
 public void setValue(int numerator, int denominator) {
    libsbmlJNI.ASTNode_setValue__SWIG_1(swigCPtr, this, numerator, denominator);
  }

  
  /**
   * Sets the value of this {@link ASTNode} to the given real (<code>double</code>) and sets
   * the node type to <code>AST_REAL</code>.
   * <p>
   * This is functionally equivalent to:
   * <div class='fragment'><pre>
   * setValue(value, 0);</pre></div>
   * <p>
   * @param value the <code>double</code> format number to which this node's value
   * should be set
   */
 public void setValue(double value) {
    libsbmlJNI.ASTNode_setValue__SWIG_2(swigCPtr, this, value);
  }

  
  /**
   * Sets the value of this {@link ASTNode} to the given real (<code>double</code>) in two
   * parts: the mantissa and the exponent.  The node type is set to
   * <code>AST_REAL_E</code>.
   * <p>
   * @param mantissa the mantissa of this node's real-numbered value
   * @param exponent the exponent of this node's real-numbered value
   */
 public void setValue(double mantissa, int exponent) {
    libsbmlJNI.ASTNode_setValue__SWIG_3(swigCPtr, this, mantissa, exponent);
  }

  
  /**
   * Sets the type of this {@link ASTNode} to the given <a class='el'
   * href='#ASTNodeType_t'>ASTNodeType_t</a>.  A side-effect of doing this
   * is that any numerical values previously stored in this node are reset
   * to zero.
   * <p>
   * @param type the type to which this node should be set
   */
 public void setType(int type) {
    libsbmlJNI.ASTNode_setType(swigCPtr, this, type);
  }

  
  /**
   * Swap the children of this {@link ASTNode} with the children of <code>that</code>
     {@link ASTNode}.
   * <p>
   * @param that the other node whose children should be used to replace
   * <em>this</em> node's children
   */
 public void swapChildren(ASTNode that) {
    libsbmlJNI.ASTNode_swapChildren(swigCPtr, this, ASTNode.getCPtr(that), that);
  }

  
  /**
   * Gets the MathML <code>definitionURL</code> attribute value.
   */
 public XMLAttributes getDefinitionURL() {
    long cPtr = libsbmlJNI.ASTNode_getDefinitionURL(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLAttributes(cPtr, false);
  }

  
  /**
   * Replaces occurences of a name within this {@link ASTNode} with the name/value/formula
   * represented by the second argument {@link ASTNode}
   * e.g. if the formula in this {@link ASTNode} is x + y; bvar is x and arg is an 
   * {@link ASTNode} representing the real value 3 ReplaceArgument substitutes 3 for
   * x within this {@link ASTNode}
   * <p>
   * @param bvar a string representing the variable name to be substituted
   * @param arg an {@link ASTNode} representing the name/value/formula to substitute
   */
 public void replaceArgument(String bvar, ASTNode arg) {
    libsbmlJNI.ASTNode_replaceArgument(swigCPtr, this, bvar, ASTNode.getCPtr(arg), arg);
  }

  
  /**
   * Replaces occurences of a name within this {@link ASTNode} with the name/value/formula
   * represented by the second argument {@link ASTNode}
   * e.g. if the formula in this {@link ASTNode} is x + y; bvar is x and arg is an 
   * {@link ASTNode} representing the real value 3 ReplaceArgument substitutes 3 for
   * x within this {@link ASTNode}
   * <p>
   * @param bvar a string representing the variable name to be substituted
   * @param arg an {@link ASTNode} representing the name/value/formula to substitute
   <p>
 * @deprecated libSBML internal
 */
 public void ReplaceArgument(String bvar, ASTNode arg) {
    libsbmlJNI.ASTNode_ReplaceArgument(swigCPtr, this, bvar, ASTNode.getCPtr(arg), arg);
  }

  
  /**
   * Sets the parent SBML object.
   * <p>
   * @param sb the parent SBML object of this {@link ASTNode}.
   <p>
 * @deprecated libSBML internal
 */
 public void setParentSBMLObject(SBase sb) {
    libsbmlJNI.ASTNode_setParentSBMLObject(swigCPtr, this, SBase.getCPtr(sb), sb);
  }

  
  /**
   * Returns the parent SBML object.
   * <p>
   * @return the parent SBML object of this {@link ASTNode}.
   */
 public SBase getParentSBMLObject() {
  return libsbml.DowncastSBase(libsbmlJNI.ASTNode_getParentSBMLObject(swigCPtr, this), false);
}

  
  /**
   * Returns the parent SBML object.
   * <p>
   * @return the parent SBML object of this {@link ASTNode}.
   <p>
 * @deprecated libSBML internal
 */
 public void ReduceToBinary() {
    libsbmlJNI.ASTNode_ReduceToBinary(swigCPtr, this);
  }

  
 /**
  * Reduces this {@link ASTNode} to a binary tree
  * e.g. if the formula in this {@link ASTNode} is and(x, y, z) then the 
  * formula of the reduced node would be and(and(x, y), z)
  */
 public void reduceToBinary() {
    libsbmlJNI.ASTNode_reduceToBinary(swigCPtr, this);
  }

}
