/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.38
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbml {

using System;
using System.Runtime.InteropServices;

class libsbmlPINVOKE {

  protected class SWIGExceptionHelper {

    public delegate void ExceptionDelegate(string message);
    public delegate void ExceptionArgumentDelegate(string message, string paramName);

    static ExceptionDelegate applicationDelegate = new ExceptionDelegate(SetPendingApplicationException);
    static ExceptionDelegate arithmeticDelegate = new ExceptionDelegate(SetPendingArithmeticException);
    static ExceptionDelegate divideByZeroDelegate = new ExceptionDelegate(SetPendingDivideByZeroException);
    static ExceptionDelegate indexOutOfRangeDelegate = new ExceptionDelegate(SetPendingIndexOutOfRangeException);
    static ExceptionDelegate invalidCastDelegate = new ExceptionDelegate(SetPendingInvalidCastException);
    static ExceptionDelegate invalidOperationDelegate = new ExceptionDelegate(SetPendingInvalidOperationException);
    static ExceptionDelegate ioDelegate = new ExceptionDelegate(SetPendingIOException);
    static ExceptionDelegate nullReferenceDelegate = new ExceptionDelegate(SetPendingNullReferenceException);
    static ExceptionDelegate outOfMemoryDelegate = new ExceptionDelegate(SetPendingOutOfMemoryException);
    static ExceptionDelegate overflowDelegate = new ExceptionDelegate(SetPendingOverflowException);
    static ExceptionDelegate systemDelegate = new ExceptionDelegate(SetPendingSystemException);

    static ExceptionArgumentDelegate argumentDelegate = new ExceptionArgumentDelegate(SetPendingArgumentException);
    static ExceptionArgumentDelegate argumentNullDelegate = new ExceptionArgumentDelegate(SetPendingArgumentNullException);
    static ExceptionArgumentDelegate argumentOutOfRangeDelegate = new ExceptionArgumentDelegate(SetPendingArgumentOutOfRangeException);

    [DllImport("libsbmlcs", EntryPoint="SWIGRegisterExceptionCallbacks_libsbml")]
    public static extern void SWIGRegisterExceptionCallbacks_libsbml(
                                ExceptionDelegate applicationDelegate,
                                ExceptionDelegate arithmeticDelegate,
                                ExceptionDelegate divideByZeroDelegate, 
                                ExceptionDelegate indexOutOfRangeDelegate, 
                                ExceptionDelegate invalidCastDelegate,
                                ExceptionDelegate invalidOperationDelegate,
                                ExceptionDelegate ioDelegate,
                                ExceptionDelegate nullReferenceDelegate,
                                ExceptionDelegate outOfMemoryDelegate, 
                                ExceptionDelegate overflowDelegate, 
                                ExceptionDelegate systemExceptionDelegate);

    [DllImport("libsbmlcs", EntryPoint="SWIGRegisterExceptionArgumentCallbacks_libsbml")]
    public static extern void SWIGRegisterExceptionCallbacksArgument_libsbml(
                                ExceptionArgumentDelegate argumentDelegate,
                                ExceptionArgumentDelegate argumentNullDelegate,
                                ExceptionArgumentDelegate argumentOutOfRangeDelegate);

    static void SetPendingApplicationException(string message) {
      SWIGPendingException.Set(new System.ApplicationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArithmeticException(string message) {
      SWIGPendingException.Set(new System.ArithmeticException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingDivideByZeroException(string message) {
      SWIGPendingException.Set(new System.DivideByZeroException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIndexOutOfRangeException(string message) {
      SWIGPendingException.Set(new System.IndexOutOfRangeException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidCastException(string message) {
      SWIGPendingException.Set(new System.InvalidCastException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingInvalidOperationException(string message) {
      SWIGPendingException.Set(new System.InvalidOperationException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingIOException(string message) {
      SWIGPendingException.Set(new System.IO.IOException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingNullReferenceException(string message) {
      SWIGPendingException.Set(new System.NullReferenceException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOutOfMemoryException(string message) {
      SWIGPendingException.Set(new System.OutOfMemoryException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingOverflowException(string message) {
      SWIGPendingException.Set(new System.OverflowException(message, SWIGPendingException.Retrieve()));
    }
    static void SetPendingSystemException(string message) {
      SWIGPendingException.Set(new System.SystemException(message, SWIGPendingException.Retrieve()));
    }

    static void SetPendingArgumentException(string message, string paramName) {
      SWIGPendingException.Set(new System.ArgumentException(message, paramName, SWIGPendingException.Retrieve()));
    }
    static void SetPendingArgumentNullException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentNullException(paramName, message));
    }
    static void SetPendingArgumentOutOfRangeException(string message, string paramName) {
      Exception e = SWIGPendingException.Retrieve();
      if (e != null) message = message + " Inner Exception: " + e.Message;
      SWIGPendingException.Set(new System.ArgumentOutOfRangeException(paramName, message));
    }

    static SWIGExceptionHelper() {
      SWIGRegisterExceptionCallbacks_libsbml(
                                applicationDelegate,
                                arithmeticDelegate,
                                divideByZeroDelegate,
                                indexOutOfRangeDelegate,
                                invalidCastDelegate,
                                invalidOperationDelegate,
                                ioDelegate,
                                nullReferenceDelegate,
                                outOfMemoryDelegate,
                                overflowDelegate,
                                systemDelegate);

      SWIGRegisterExceptionCallbacksArgument_libsbml(
                                argumentDelegate,
                                argumentNullDelegate,
                                argumentOutOfRangeDelegate);
    }
  }

  protected static SWIGExceptionHelper swigExceptionHelper = new SWIGExceptionHelper();

  public class SWIGPendingException {
    [ThreadStatic]
    private static Exception pendingException = null;
    private static int numExceptionsPending = 0;

    public static bool Pending {
      get {
        bool pending = false;
        if (numExceptionsPending > 0)
          if (pendingException != null)
            pending = true;
        return pending;
      } 
    }

    public static void Set(Exception e) {
      if (pendingException != null)
        throw new ApplicationException("FATAL: An earlier pending exception from unmanaged code was missed and thus not thrown (" + pendingException.ToString() + ")", e);
      pendingException = e;
      lock(typeof(libsbmlPINVOKE)) {
        numExceptionsPending++;
      }
    }

    public static Exception Retrieve() {
      Exception e = null;
      if (numExceptionsPending > 0) {
        if (pendingException != null) {
          e = pendingException;
          pendingException = null;
          lock(typeof(libsbmlPINVOKE)) {
            numExceptionsPending--;
          }
        }
      }
      return e;
    }
  }


  protected class SWIGStringHelper {

    public delegate string SWIGStringDelegate(string message);
    static SWIGStringDelegate stringDelegate = new SWIGStringDelegate(CreateString);

    [DllImport("libsbmlcs", EntryPoint="SWIGRegisterStringCallback_libsbml")]
    public static extern void SWIGRegisterStringCallback_libsbml(SWIGStringDelegate stringDelegate);

    static string CreateString(string cString) {
      return cString;
    }

    static SWIGStringHelper() {
      SWIGRegisterStringCallback_libsbml(stringDelegate);
    }
  }

  static protected SWIGStringHelper swigStringHelper = new SWIGStringHelper();


  protected class SWIGWStringHelper {

    public delegate string SWIGWStringDelegate(IntPtr message);
    static SWIGWStringDelegate wstringDelegate = new SWIGWStringDelegate(CreateWString);

    [DllImport("libsbmlcs", EntryPoint="SWIGRegisterWStringCallback_libsbml")]
    public static extern void SWIGRegisterWStringCallback_libsbml(SWIGWStringDelegate wstringDelegate);

    static string CreateWString([MarshalAs(UnmanagedType.LPWStr)]IntPtr cString) {
      return System.Runtime.InteropServices.Marshal.PtrToStringUni(cString);
    }

    static SWIGWStringHelper() {
      SWIGRegisterWStringCallback_libsbml(wstringDelegate);
    }
  }

  static protected SWIGWStringHelper swigWStringHelper = new SWIGWStringHelper();


  [DllImport("libsbmlcs", EntryPoint="CSharp_new_OStream__SWIG_0")]
  public static extern IntPtr new_OStream__SWIG_0(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_OStream__SWIG_1")]
  public static extern IntPtr new_OStream__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_OStream")]
  public static extern void delete_OStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OStream_get_ostream")]
  public static extern IntPtr OStream_get_ostream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OStream_endl")]
  public static extern void OStream_endl(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_OFStream__SWIG_0")]
  public static extern IntPtr new_OFStream__SWIG_0(string jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_OFStream__SWIG_1")]
  public static extern IntPtr new_OFStream__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OFStream_open__SWIG_0")]
  public static extern void OFStream_open__SWIG_0(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OFStream_open__SWIG_1")]
  public static extern void OFStream_open__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OFStream_close")]
  public static extern void OFStream_close(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OFStream_is_open")]
  public static extern bool OFStream_is_open(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_OFStream")]
  public static extern void delete_OFStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_OStringStream")]
  public static extern IntPtr new_OStringStream();

  [DllImport("libsbmlcs", EntryPoint="CSharp_OStringStream_str__SWIG_0")]
  public static extern string OStringStream_str__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OStringStream_str__SWIG_1")]
  public static extern void OStringStream_str__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_OStringStream")]
  public static extern void delete_OStringStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_getLibSBMLVersion")]
  public static extern int getLibSBMLVersion();

  [DllImport("libsbmlcs", EntryPoint="CSharp_getLibSBMLDottedVersion")]
  public static extern string getLibSBMLDottedVersion();

  [DllImport("libsbmlcs", EntryPoint="CSharp_getLibSBMLVersionString")]
  public static extern string getLibSBMLVersionString();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLReader")]
  public static extern IntPtr new_SBMLReader();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLReader")]
  public static extern void delete_SBMLReader(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReader_readSBML")]
  public static extern IntPtr SBMLReader_readSBML(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReader_readSBMLFromString")]
  public static extern IntPtr SBMLReader_readSBMLFromString(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReader_hasZlib")]
  public static extern bool SBMLReader_hasZlib();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLReader_hasBzip2")]
  public static extern bool SBMLReader_hasBzip2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_readSBML")]
  public static extern IntPtr readSBML(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_readSBMLFromString")]
  public static extern IntPtr readSBMLFromString(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLWriter")]
  public static extern IntPtr new_SBMLWriter();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLWriter")]
  public static extern void delete_SBMLWriter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_setProgramName")]
  public static extern void SBMLWriter_setProgramName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_setProgramVersion")]
  public static extern void SBMLWriter_setProgramVersion(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_writeSBML__SWIG_0")]
  public static extern bool SBMLWriter_writeSBML__SWIG_0(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_writeSBML__SWIG_1")]
  public static extern bool SBMLWriter_writeSBML__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_writeToString")]
  public static extern string SBMLWriter_writeToString(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_hasZlib")]
  public static extern bool SBMLWriter_hasZlib();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLWriter_hasBzip2")]
  public static extern bool SBMLWriter_hasBzip2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_writeSBML")]
  public static extern int writeSBML(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_writeSBMLToString")]
  public static extern string writeSBMLToString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLTypeCode_toString")]
  public static extern string SBMLTypeCode_toString(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBase")]
  public static extern void delete_SBase(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_clone")]
  public static extern IntPtr SBase_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getMetaId")]
  public static extern string SBase_getMetaId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getId")]
  public static extern string SBase_getId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getName")]
  public static extern string SBase_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getNotes")]
  public static extern IntPtr SBase_getNotes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getNotesString")]
  public static extern string SBase_getNotesString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getAnnotation")]
  public static extern IntPtr SBase_getAnnotation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getAnnotationString")]
  public static extern string SBase_getAnnotationString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getNamespaces")]
  public static extern IntPtr SBase_getNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getSBMLDocument__SWIG_0")]
  public static extern IntPtr SBase_getSBMLDocument__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getParentSBMLObject")]
  public static extern IntPtr SBase_getParentSBMLObject(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getAncestorOfType")]
  public static extern IntPtr SBase_getAncestorOfType(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getSBOTerm")]
  public static extern int SBase_getSBOTerm(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getSBOTermID")]
  public static extern string SBase_getSBOTermID(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getLine")]
  public static extern uint SBase_getLine(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getColumn")]
  public static extern uint SBase_getColumn(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetMetaId")]
  public static extern bool SBase_isSetMetaId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetId")]
  public static extern bool SBase_isSetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetName")]
  public static extern bool SBase_isSetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetNotes")]
  public static extern bool SBase_isSetNotes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetAnnotation")]
  public static extern bool SBase_isSetAnnotation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_isSetSBOTerm")]
  public static extern bool SBase_isSetSBOTerm(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setMetaId")]
  public static extern void SBase_setMetaId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setId")]
  public static extern void SBase_setId(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setName")]
  public static extern void SBase_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setAnnotation__SWIG_0")]
  public static extern void SBase_setAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setAnnotation__SWIG_1")]
  public static extern void SBase_setAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_appendAnnotation__SWIG_0")]
  public static extern void SBase_appendAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_appendAnnotation__SWIG_1")]
  public static extern void SBase_appendAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setNotes__SWIG_0")]
  public static extern void SBase_setNotes__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setNotes__SWIG_1")]
  public static extern void SBase_setNotes__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_appendNotes__SWIG_0")]
  public static extern void SBase_appendNotes__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_appendNotes__SWIG_1")]
  public static extern void SBase_appendNotes__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setSBMLDocument")]
  public static extern void SBase_setSBMLDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setParentSBMLObject")]
  public static extern void SBase_setParentSBMLObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setSBOTerm")]
  public static extern void SBase_setSBOTerm(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_setNamespaces")]
  public static extern void SBase_setNamespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetMetaId")]
  public static extern void SBase_unsetMetaId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetId")]
  public static extern void SBase_unsetId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetName")]
  public static extern void SBase_unsetName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetNotes")]
  public static extern void SBase_unsetNotes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetAnnotation")]
  public static extern void SBase_unsetAnnotation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetSBOTerm")]
  public static extern void SBase_unsetSBOTerm(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_addCVTerm")]
  public static extern void SBase_addCVTerm(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getNumCVTerms")]
  public static extern uint SBase_getNumCVTerms(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getCVTerm")]
  public static extern IntPtr SBase_getCVTerm(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_unsetCVTerms")]
  public static extern void SBase_unsetCVTerms(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getResourceBiologicalQualifier")]
  public static extern int SBase_getResourceBiologicalQualifier(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getResourceModelQualifier")]
  public static extern int SBase_getResourceModelQualifier(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getModel")]
  public static extern IntPtr SBase_getModel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getLevel")]
  public static extern uint SBase_getLevel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getVersion")]
  public static extern uint SBase_getVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getTypeCode")]
  public static extern int SBase_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_getElementName")]
  public static extern string SBase_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_toSBML")]
  public static extern string SBase_toSBML(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_read")]
  public static extern void SBase_read(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBase_write")]
  public static extern void SBase_write(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOf__SWIG_0")]
  public static extern IntPtr new_ListOf__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOf")]
  public static extern void delete_ListOf(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOf__SWIG_1")]
  public static extern IntPtr new_ListOf__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_clone")]
  public static extern IntPtr ListOf_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_append")]
  public static extern void ListOf_append(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_appendAndOwn")]
  public static extern void ListOf_appendAndOwn(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_get__SWIG_0")]
  public static extern IntPtr ListOf_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_get__SWIG_2")]
  public static extern IntPtr ListOf_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_clear__SWIG_0")]
  public static extern void ListOf_clear__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_clear__SWIG_1")]
  public static extern void ListOf_clear__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_remove__SWIG_0")]
  public static extern IntPtr ListOf_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_remove__SWIG_1")]
  public static extern IntPtr ListOf_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_size")]
  public static extern uint ListOf_size(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_setSBMLDocument")]
  public static extern void ListOf_setSBMLDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_setParentSBMLObject")]
  public static extern void ListOf_setParentSBMLObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_getTypeCode")]
  public static extern int ListOf_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_getItemTypeCode")]
  public static extern int ListOf_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOf_getElementName")]
  public static extern string ListOf_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Model__SWIG_0")]
  public static extern IntPtr new_Model__SWIG_0(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Model__SWIG_1")]
  public static extern IntPtr new_Model__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Model__SWIG_2")]
  public static extern IntPtr new_Model__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Model__SWIG_3")]
  public static extern IntPtr new_Model__SWIG_3(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Model__SWIG_4")]
  public static extern IntPtr new_Model__SWIG_4(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Model")]
  public static extern void delete_Model(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Model__SWIG_5")]
  public static extern IntPtr new_Model__SWIG_5(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_clone")]
  public static extern IntPtr Model_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getModelHistory__SWIG_0")]
  public static extern IntPtr Model_getModelHistory__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isSetModelHistory")]
  public static extern bool Model_isSetModelHistory(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setModelHistory")]
  public static extern void Model_setModelHistory(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_unsetModelHistory")]
  public static extern void Model_unsetModelHistory(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addFunctionDefinition")]
  public static extern void Model_addFunctionDefinition(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addUnitDefinition")]
  public static extern void Model_addUnitDefinition(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addCompartmentType")]
  public static extern void Model_addCompartmentType(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addSpeciesType")]
  public static extern void Model_addSpeciesType(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addCompartment")]
  public static extern void Model_addCompartment(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addSpecies")]
  public static extern void Model_addSpecies(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addParameter")]
  public static extern void Model_addParameter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addInitialAssignment")]
  public static extern void Model_addInitialAssignment(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addRule")]
  public static extern void Model_addRule(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addConstraint")]
  public static extern void Model_addConstraint(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addReaction")]
  public static extern void Model_addReaction(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_addEvent")]
  public static extern void Model_addEvent(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createFunctionDefinition")]
  public static extern IntPtr Model_createFunctionDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createUnitDefinition")]
  public static extern IntPtr Model_createUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createUnit")]
  public static extern IntPtr Model_createUnit(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createCompartmentType")]
  public static extern IntPtr Model_createCompartmentType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createSpeciesType")]
  public static extern IntPtr Model_createSpeciesType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createCompartment")]
  public static extern IntPtr Model_createCompartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createSpecies")]
  public static extern IntPtr Model_createSpecies(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createParameter")]
  public static extern IntPtr Model_createParameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createInitialAssignment")]
  public static extern IntPtr Model_createInitialAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createAlgebraicRule")]
  public static extern IntPtr Model_createAlgebraicRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createAssignmentRule")]
  public static extern IntPtr Model_createAssignmentRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createRateRule")]
  public static extern IntPtr Model_createRateRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createConstraint")]
  public static extern IntPtr Model_createConstraint(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createReaction")]
  public static extern IntPtr Model_createReaction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createReactant")]
  public static extern IntPtr Model_createReactant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createProduct")]
  public static extern IntPtr Model_createProduct(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createModifier")]
  public static extern IntPtr Model_createModifier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createKineticLaw")]
  public static extern IntPtr Model_createKineticLaw(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createKineticLawParameter")]
  public static extern IntPtr Model_createKineticLawParameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createEvent")]
  public static extern IntPtr Model_createEvent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_createEventAssignment")]
  public static extern IntPtr Model_createEventAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setAnnotation__SWIG_0")]
  public static extern void Model_setAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setAnnotation__SWIG_1")]
  public static extern void Model_setAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_appendAnnotation__SWIG_0")]
  public static extern void Model_appendAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_appendAnnotation__SWIG_1")]
  public static extern void Model_appendAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfFunctionDefinitions__SWIG_0")]
  public static extern IntPtr Model_getListOfFunctionDefinitions__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfUnitDefinitions__SWIG_0")]
  public static extern IntPtr Model_getListOfUnitDefinitions__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfCompartmentTypes__SWIG_0")]
  public static extern IntPtr Model_getListOfCompartmentTypes__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfSpeciesTypes__SWIG_0")]
  public static extern IntPtr Model_getListOfSpeciesTypes__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfCompartments__SWIG_0")]
  public static extern IntPtr Model_getListOfCompartments__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfSpecies__SWIG_0")]
  public static extern IntPtr Model_getListOfSpecies__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfParameters__SWIG_0")]
  public static extern IntPtr Model_getListOfParameters__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfInitialAssignments__SWIG_0")]
  public static extern IntPtr Model_getListOfInitialAssignments__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfRules__SWIG_0")]
  public static extern IntPtr Model_getListOfRules__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfConstraints__SWIG_0")]
  public static extern IntPtr Model_getListOfConstraints__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfReactions__SWIG_0")]
  public static extern IntPtr Model_getListOfReactions__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getListOfEvents__SWIG_0")]
  public static extern IntPtr Model_getListOfEvents__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getFunctionDefinition__SWIG_0")]
  public static extern IntPtr Model_getFunctionDefinition__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getFunctionDefinition__SWIG_2")]
  public static extern IntPtr Model_getFunctionDefinition__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getUnitDefinition__SWIG_0")]
  public static extern IntPtr Model_getUnitDefinition__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getUnitDefinition__SWIG_2")]
  public static extern IntPtr Model_getUnitDefinition__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getCompartmentType__SWIG_0")]
  public static extern IntPtr Model_getCompartmentType__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getCompartmentType__SWIG_2")]
  public static extern IntPtr Model_getCompartmentType__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getSpeciesType__SWIG_0")]
  public static extern IntPtr Model_getSpeciesType__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getSpeciesType__SWIG_2")]
  public static extern IntPtr Model_getSpeciesType__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getCompartment__SWIG_0")]
  public static extern IntPtr Model_getCompartment__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getCompartment__SWIG_2")]
  public static extern IntPtr Model_getCompartment__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getSpecies__SWIG_0")]
  public static extern IntPtr Model_getSpecies__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getSpecies__SWIG_2")]
  public static extern IntPtr Model_getSpecies__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getParameter__SWIG_0")]
  public static extern IntPtr Model_getParameter__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getParameter__SWIG_2")]
  public static extern IntPtr Model_getParameter__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getInitialAssignment__SWIG_0")]
  public static extern IntPtr Model_getInitialAssignment__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getInitialAssignment__SWIG_2")]
  public static extern IntPtr Model_getInitialAssignment__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getRule__SWIG_0")]
  public static extern IntPtr Model_getRule__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getRule__SWIG_2")]
  public static extern IntPtr Model_getRule__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getConstraint__SWIG_0")]
  public static extern IntPtr Model_getConstraint__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getReaction__SWIG_0")]
  public static extern IntPtr Model_getReaction__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getReaction__SWIG_2")]
  public static extern IntPtr Model_getReaction__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getEvent__SWIG_0")]
  public static extern IntPtr Model_getEvent__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getEvent__SWIG_2")]
  public static extern IntPtr Model_getEvent__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumFunctionDefinitions")]
  public static extern uint Model_getNumFunctionDefinitions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumUnitDefinitions")]
  public static extern uint Model_getNumUnitDefinitions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumCompartmentTypes")]
  public static extern uint Model_getNumCompartmentTypes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumSpeciesTypes")]
  public static extern uint Model_getNumSpeciesTypes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumCompartments")]
  public static extern uint Model_getNumCompartments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumSpecies")]
  public static extern uint Model_getNumSpecies(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumSpeciesWithBoundaryCondition")]
  public static extern uint Model_getNumSpeciesWithBoundaryCondition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumParameters")]
  public static extern uint Model_getNumParameters(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumInitialAssignments")]
  public static extern uint Model_getNumInitialAssignments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumRules")]
  public static extern uint Model_getNumRules(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumConstraints")]
  public static extern uint Model_getNumConstraints(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumReactions")]
  public static extern uint Model_getNumReactions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getNumEvents")]
  public static extern uint Model_getNumEvents(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertToL1")]
  public static extern void Model_convertToL1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_convertToL2")]
  public static extern void Model_convertToL2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isBoolean")]
  public static extern bool Model_isBoolean(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setSBMLDocument")]
  public static extern void Model_setSBMLDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_setParentSBMLObject")]
  public static extern void Model_setParentSBMLObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getTypeCode")]
  public static extern int Model_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_getElementName")]
  public static extern string Model_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_populateListFormulaUnitsData")]
  public static extern void Model_populateListFormulaUnitsData(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Model_isPopulatedListFormulaUnitsData")]
  public static extern bool Model_isPopulatedListFormulaUnitsData(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getDefaultLevel")]
  public static extern uint SBMLDocument_getDefaultLevel();

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getDefaultVersion")]
  public static extern uint SBMLDocument_getDefaultVersion();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLDocument__SWIG_0")]
  public static extern IntPtr new_SBMLDocument__SWIG_0(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLDocument__SWIG_1")]
  public static extern IntPtr new_SBMLDocument__SWIG_1(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLDocument__SWIG_2")]
  public static extern IntPtr new_SBMLDocument__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLDocument")]
  public static extern void delete_SBMLDocument(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLDocument__SWIG_3")]
  public static extern IntPtr new_SBMLDocument__SWIG_3(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_clone")]
  public static extern IntPtr SBMLDocument_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getModel__SWIG_0")]
  public static extern IntPtr SBMLDocument_getModel__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setLevelAndVersion")]
  public static extern bool SBMLDocument_setLevelAndVersion(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setModel")]
  public static extern void SBMLDocument_setModel(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_createModel__SWIG_0")]
  public static extern IntPtr SBMLDocument_createModel__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_createModel__SWIG_1")]
  public static extern IntPtr SBMLDocument_createModel__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setConsistencyChecks")]
  public static extern void SBMLDocument_setConsistencyChecks(HandleRef jarg1, int jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkConsistency")]
  public static extern uint SBMLDocument_checkConsistency(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkInternalConsistency")]
  public static extern uint SBMLDocument_checkInternalConsistency(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL1Compatibility")]
  public static extern uint SBMLDocument_checkL1Compatibility(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL2v1Compatibility")]
  public static extern uint SBMLDocument_checkL2v1Compatibility(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL2v2Compatibility")]
  public static extern uint SBMLDocument_checkL2v2Compatibility(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL2v3Compatibility")]
  public static extern uint SBMLDocument_checkL2v3Compatibility(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_checkL2v4Compatibility")]
  public static extern uint SBMLDocument_checkL2v4Compatibility(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getError")]
  public static extern IntPtr SBMLDocument_getError(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getNumErrors")]
  public static extern uint SBMLDocument_getNumErrors(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_printErrors__SWIG_0")]
  public static extern void SBMLDocument_printErrors__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_printErrors__SWIG_1")]
  public static extern void SBMLDocument_printErrors__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_setSBMLDocument")]
  public static extern void SBMLDocument_setSBMLDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getTypeCode")]
  public static extern int SBMLDocument_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getElementName")]
  public static extern string SBMLDocument_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getErrorLog")]
  public static extern IntPtr SBMLDocument_getErrorLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocument_getNamespaces")]
  public static extern IntPtr SBMLDocument_getNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_FunctionDefinition__SWIG_0")]
  public static extern IntPtr new_FunctionDefinition__SWIG_0(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_FunctionDefinition__SWIG_1")]
  public static extern IntPtr new_FunctionDefinition__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_FunctionDefinition__SWIG_2")]
  public static extern IntPtr new_FunctionDefinition__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_FunctionDefinition__SWIG_3")]
  public static extern IntPtr new_FunctionDefinition__SWIG_3(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_FunctionDefinition__SWIG_4")]
  public static extern IntPtr new_FunctionDefinition__SWIG_4(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_FunctionDefinition__SWIG_5")]
  public static extern IntPtr new_FunctionDefinition__SWIG_5(string jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_FunctionDefinition")]
  public static extern void delete_FunctionDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_FunctionDefinition__SWIG_6")]
  public static extern IntPtr new_FunctionDefinition__SWIG_6(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_clone")]
  public static extern IntPtr FunctionDefinition_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getMath")]
  public static extern IntPtr FunctionDefinition_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_isSetMath")]
  public static extern bool FunctionDefinition_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_setMath")]
  public static extern void FunctionDefinition_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getArgument__SWIG_0")]
  public static extern IntPtr FunctionDefinition_getArgument__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getArgument__SWIG_1")]
  public static extern IntPtr FunctionDefinition_getArgument__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getBody__SWIG_0")]
  public static extern IntPtr FunctionDefinition_getBody__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getNumArguments")]
  public static extern uint FunctionDefinition_getNumArguments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getTypeCode")]
  public static extern int FunctionDefinition_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinition_getElementName")]
  public static extern string FunctionDefinition_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_clone")]
  public static extern IntPtr ListOfFunctionDefinitions_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_getTypeCode")]
  public static extern int ListOfFunctionDefinitions_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_getItemTypeCode")]
  public static extern int ListOfFunctionDefinitions_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_getElementName")]
  public static extern string ListOfFunctionDefinitions_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_get__SWIG_0")]
  public static extern IntPtr ListOfFunctionDefinitions_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_get__SWIG_2")]
  public static extern IntPtr ListOfFunctionDefinitions_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_remove__SWIG_0")]
  public static extern IntPtr ListOfFunctionDefinitions_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitions_remove__SWIG_1")]
  public static extern IntPtr ListOfFunctionDefinitions_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfFunctionDefinitions")]
  public static extern IntPtr new_ListOfFunctionDefinitions();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfFunctionDefinitions")]
  public static extern void delete_ListOfFunctionDefinitions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitKind_equals")]
  public static extern int UnitKind_equals(int jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitKind_forName")]
  public static extern int UnitKind_forName(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitKind_toString")]
  public static extern string UnitKind_toString(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitKind_isValidUnitKindString")]
  public static extern int UnitKind_isValidUnitKindString(string jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_0")]
  public static extern IntPtr new_Unit__SWIG_0(int jarg1, int jarg2, int jarg3, double jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_1")]
  public static extern IntPtr new_Unit__SWIG_1(int jarg1, int jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_2")]
  public static extern IntPtr new_Unit__SWIG_2(int jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_3")]
  public static extern IntPtr new_Unit__SWIG_3(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_4")]
  public static extern IntPtr new_Unit__SWIG_4();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_5")]
  public static extern IntPtr new_Unit__SWIG_5(string jarg1, int jarg2, int jarg3, double jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_6")]
  public static extern IntPtr new_Unit__SWIG_6(string jarg1, int jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_7")]
  public static extern IntPtr new_Unit__SWIG_7(string jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_8")]
  public static extern IntPtr new_Unit__SWIG_8(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_9")]
  public static extern IntPtr new_Unit__SWIG_9(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_10")]
  public static extern IntPtr new_Unit__SWIG_10(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Unit")]
  public static extern void delete_Unit(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Unit__SWIG_11")]
  public static extern IntPtr new_Unit__SWIG_11(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_clone")]
  public static extern IntPtr Unit_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_initDefaults")]
  public static extern void Unit_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getKind")]
  public static extern int Unit_getKind(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getExponent")]
  public static extern int Unit_getExponent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getScale")]
  public static extern int Unit_getScale(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getMultiplier")]
  public static extern double Unit_getMultiplier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getOffset")]
  public static extern double Unit_getOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isAmpere")]
  public static extern bool Unit_isAmpere(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isBecquerel")]
  public static extern bool Unit_isBecquerel(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isCandela")]
  public static extern bool Unit_isCandela(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isCelsius")]
  public static extern bool Unit_isCelsius(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isCoulomb")]
  public static extern bool Unit_isCoulomb(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isDimensionless")]
  public static extern bool Unit_isDimensionless(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isFarad")]
  public static extern bool Unit_isFarad(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isGram")]
  public static extern bool Unit_isGram(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isGray")]
  public static extern bool Unit_isGray(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isHenry")]
  public static extern bool Unit_isHenry(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isHertz")]
  public static extern bool Unit_isHertz(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isItem")]
  public static extern bool Unit_isItem(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isJoule")]
  public static extern bool Unit_isJoule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isKatal")]
  public static extern bool Unit_isKatal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isKelvin")]
  public static extern bool Unit_isKelvin(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isKilogram")]
  public static extern bool Unit_isKilogram(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isLitre")]
  public static extern bool Unit_isLitre(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isLumen")]
  public static extern bool Unit_isLumen(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isLux")]
  public static extern bool Unit_isLux(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isMetre")]
  public static extern bool Unit_isMetre(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isMole")]
  public static extern bool Unit_isMole(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isNewton")]
  public static extern bool Unit_isNewton(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isOhm")]
  public static extern bool Unit_isOhm(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isPascal")]
  public static extern bool Unit_isPascal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isRadian")]
  public static extern bool Unit_isRadian(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSecond")]
  public static extern bool Unit_isSecond(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSiemens")]
  public static extern bool Unit_isSiemens(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSievert")]
  public static extern bool Unit_isSievert(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSteradian")]
  public static extern bool Unit_isSteradian(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isTesla")]
  public static extern bool Unit_isTesla(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isVolt")]
  public static extern bool Unit_isVolt(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isWatt")]
  public static extern bool Unit_isWatt(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isWeber")]
  public static extern bool Unit_isWeber(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isSetKind")]
  public static extern bool Unit_isSetKind(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_setKind")]
  public static extern void Unit_setKind(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_setExponent")]
  public static extern void Unit_setExponent(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_setScale")]
  public static extern void Unit_setScale(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_setMultiplier")]
  public static extern void Unit_setMultiplier(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_setOffset")]
  public static extern void Unit_setOffset(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getTypeCode")]
  public static extern int Unit_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_getElementName")]
  public static extern string Unit_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isBuiltIn")]
  public static extern bool Unit_isBuiltIn(string jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_isUnitKind")]
  public static extern bool Unit_isUnitKind(string jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_areIdentical")]
  public static extern bool Unit_areIdentical(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_areEquivalent")]
  public static extern bool Unit_areEquivalent(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_removeScale")]
  public static extern void Unit_removeScale(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_merge")]
  public static extern void Unit_merge(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Unit_convertToSI")]
  public static extern IntPtr Unit_convertToSI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_clone")]
  public static extern IntPtr ListOfUnits_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_getTypeCode")]
  public static extern int ListOfUnits_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_getItemTypeCode")]
  public static extern int ListOfUnits_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_getElementName")]
  public static extern string ListOfUnits_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_get__SWIG_0")]
  public static extern IntPtr ListOfUnits_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnits_remove")]
  public static extern IntPtr ListOfUnits_remove(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfUnits")]
  public static extern IntPtr new_ListOfUnits();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfUnits")]
  public static extern void delete_ListOfUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_UnitDefinition__SWIG_0")]
  public static extern IntPtr new_UnitDefinition__SWIG_0(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_UnitDefinition__SWIG_1")]
  public static extern IntPtr new_UnitDefinition__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_UnitDefinition__SWIG_2")]
  public static extern IntPtr new_UnitDefinition__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_UnitDefinition__SWIG_3")]
  public static extern IntPtr new_UnitDefinition__SWIG_3(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_UnitDefinition__SWIG_4")]
  public static extern IntPtr new_UnitDefinition__SWIG_4(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_UnitDefinition")]
  public static extern void delete_UnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_UnitDefinition__SWIG_5")]
  public static extern IntPtr new_UnitDefinition__SWIG_5(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_clone")]
  public static extern IntPtr UnitDefinition_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfArea")]
  public static extern bool UnitDefinition_isVariantOfArea(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfLength")]
  public static extern bool UnitDefinition_isVariantOfLength(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfSubstance")]
  public static extern bool UnitDefinition_isVariantOfSubstance(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfTime")]
  public static extern bool UnitDefinition_isVariantOfTime(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfVolume")]
  public static extern bool UnitDefinition_isVariantOfVolume(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfDimensionless")]
  public static extern bool UnitDefinition_isVariantOfDimensionless(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfMass")]
  public static extern bool UnitDefinition_isVariantOfMass(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_isVariantOfSubstancePerTime")]
  public static extern bool UnitDefinition_isVariantOfSubstancePerTime(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_addUnit")]
  public static extern void UnitDefinition_addUnit(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_createUnit")]
  public static extern IntPtr UnitDefinition_createUnit(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getListOfUnits__SWIG_0")]
  public static extern IntPtr UnitDefinition_getListOfUnits__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getUnit__SWIG_0")]
  public static extern IntPtr UnitDefinition_getUnit__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getNumUnits")]
  public static extern uint UnitDefinition_getNumUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_setSBMLDocument")]
  public static extern void UnitDefinition_setSBMLDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_setParentSBMLObject")]
  public static extern void UnitDefinition_setParentSBMLObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getTypeCode")]
  public static extern int UnitDefinition_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_getElementName")]
  public static extern string UnitDefinition_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_simplify")]
  public static extern void UnitDefinition_simplify(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_reorder")]
  public static extern void UnitDefinition_reorder(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_convertToSI")]
  public static extern IntPtr UnitDefinition_convertToSI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_areIdentical")]
  public static extern bool UnitDefinition_areIdentical(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_areEquivalent")]
  public static extern bool UnitDefinition_areEquivalent(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_combine")]
  public static extern IntPtr UnitDefinition_combine(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_printUnits__SWIG_0")]
  public static extern string UnitDefinition_printUnits__SWIG_0(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinition_printUnits__SWIG_1")]
  public static extern string UnitDefinition_printUnits__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_clone")]
  public static extern IntPtr ListOfUnitDefinitions_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_getTypeCode")]
  public static extern int ListOfUnitDefinitions_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_getItemTypeCode")]
  public static extern int ListOfUnitDefinitions_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_getElementName")]
  public static extern string ListOfUnitDefinitions_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_get__SWIG_0")]
  public static extern IntPtr ListOfUnitDefinitions_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_get__SWIG_2")]
  public static extern IntPtr ListOfUnitDefinitions_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_remove__SWIG_0")]
  public static extern IntPtr ListOfUnitDefinitions_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitions_remove__SWIG_1")]
  public static extern IntPtr ListOfUnitDefinitions_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfUnitDefinitions")]
  public static extern IntPtr new_ListOfUnitDefinitions();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfUnitDefinitions")]
  public static extern void delete_ListOfUnitDefinitions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CompartmentType__SWIG_0")]
  public static extern IntPtr new_CompartmentType__SWIG_0(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CompartmentType__SWIG_1")]
  public static extern IntPtr new_CompartmentType__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CompartmentType__SWIG_2")]
  public static extern IntPtr new_CompartmentType__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CompartmentType__SWIG_3")]
  public static extern IntPtr new_CompartmentType__SWIG_3(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CompartmentType__SWIG_4")]
  public static extern IntPtr new_CompartmentType__SWIG_4(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_CompartmentType")]
  public static extern void delete_CompartmentType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CompartmentType__SWIG_5")]
  public static extern IntPtr new_CompartmentType__SWIG_5(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_clone")]
  public static extern IntPtr CompartmentType_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_getTypeCode")]
  public static extern int CompartmentType_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentType_getElementName")]
  public static extern string CompartmentType_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_clone")]
  public static extern IntPtr ListOfCompartmentTypes_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_getTypeCode")]
  public static extern int ListOfCompartmentTypes_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_getItemTypeCode")]
  public static extern int ListOfCompartmentTypes_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_getElementName")]
  public static extern string ListOfCompartmentTypes_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_get__SWIG_0")]
  public static extern IntPtr ListOfCompartmentTypes_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_get__SWIG_2")]
  public static extern IntPtr ListOfCompartmentTypes_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_remove__SWIG_0")]
  public static extern IntPtr ListOfCompartmentTypes_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypes_remove__SWIG_1")]
  public static extern IntPtr ListOfCompartmentTypes_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfCompartmentTypes")]
  public static extern IntPtr new_ListOfCompartmentTypes();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfCompartmentTypes")]
  public static extern void delete_ListOfCompartmentTypes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesType__SWIG_0")]
  public static extern IntPtr new_SpeciesType__SWIG_0(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesType__SWIG_1")]
  public static extern IntPtr new_SpeciesType__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesType__SWIG_2")]
  public static extern IntPtr new_SpeciesType__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesType__SWIG_3")]
  public static extern IntPtr new_SpeciesType__SWIG_3(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesType__SWIG_4")]
  public static extern IntPtr new_SpeciesType__SWIG_4(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SpeciesType")]
  public static extern void delete_SpeciesType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesType__SWIG_5")]
  public static extern IntPtr new_SpeciesType__SWIG_5(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_clone")]
  public static extern IntPtr SpeciesType_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_getTypeCode")]
  public static extern int SpeciesType_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesType_getElementName")]
  public static extern string SpeciesType_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_clone")]
  public static extern IntPtr ListOfSpeciesTypes_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_getTypeCode")]
  public static extern int ListOfSpeciesTypes_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_getItemTypeCode")]
  public static extern int ListOfSpeciesTypes_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_getElementName")]
  public static extern string ListOfSpeciesTypes_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_get__SWIG_0")]
  public static extern IntPtr ListOfSpeciesTypes_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_get__SWIG_2")]
  public static extern IntPtr ListOfSpeciesTypes_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_remove__SWIG_0")]
  public static extern IntPtr ListOfSpeciesTypes_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypes_remove__SWIG_1")]
  public static extern IntPtr ListOfSpeciesTypes_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfSpeciesTypes")]
  public static extern IntPtr new_ListOfSpeciesTypes();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfSpeciesTypes")]
  public static extern void delete_ListOfSpeciesTypes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Compartment__SWIG_0")]
  public static extern IntPtr new_Compartment__SWIG_0(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Compartment__SWIG_1")]
  public static extern IntPtr new_Compartment__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Compartment__SWIG_2")]
  public static extern IntPtr new_Compartment__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Compartment__SWIG_3")]
  public static extern IntPtr new_Compartment__SWIG_3(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Compartment__SWIG_4")]
  public static extern IntPtr new_Compartment__SWIG_4(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Compartment")]
  public static extern void delete_Compartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Compartment__SWIG_5")]
  public static extern IntPtr new_Compartment__SWIG_5(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_clone")]
  public static extern IntPtr Compartment_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_initDefaults")]
  public static extern void Compartment_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getCompartmentType")]
  public static extern string Compartment_getCompartmentType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getSpatialDimensions")]
  public static extern uint Compartment_getSpatialDimensions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getSize")]
  public static extern double Compartment_getSize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getVolume")]
  public static extern double Compartment_getVolume(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getUnits")]
  public static extern string Compartment_getUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getOutside")]
  public static extern string Compartment_getOutside(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getConstant")]
  public static extern bool Compartment_getConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetCompartmentType")]
  public static extern bool Compartment_isSetCompartmentType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetSize")]
  public static extern bool Compartment_isSetSize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetVolume")]
  public static extern bool Compartment_isSetVolume(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetUnits")]
  public static extern bool Compartment_isSetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_isSetOutside")]
  public static extern bool Compartment_isSetOutside(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setCompartmentType")]
  public static extern void Compartment_setCompartmentType(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setSpatialDimensions")]
  public static extern void Compartment_setSpatialDimensions(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setSize")]
  public static extern void Compartment_setSize(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setVolume")]
  public static extern void Compartment_setVolume(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setUnits")]
  public static extern void Compartment_setUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setOutside")]
  public static extern void Compartment_setOutside(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_setConstant")]
  public static extern void Compartment_setConstant(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetCompartmentType")]
  public static extern void Compartment_unsetCompartmentType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetSize")]
  public static extern void Compartment_unsetSize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetVolume")]
  public static extern void Compartment_unsetVolume(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetUnits")]
  public static extern void Compartment_unsetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_unsetOutside")]
  public static extern void Compartment_unsetOutside(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getDerivedUnitDefinition")]
  public static extern IntPtr Compartment_getDerivedUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getTypeCode")]
  public static extern int Compartment_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Compartment_getElementName")]
  public static extern string Compartment_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_clone")]
  public static extern IntPtr ListOfCompartments_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_getTypeCode")]
  public static extern int ListOfCompartments_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_getItemTypeCode")]
  public static extern int ListOfCompartments_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_getElementName")]
  public static extern string ListOfCompartments_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_get__SWIG_0")]
  public static extern IntPtr ListOfCompartments_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_get__SWIG_2")]
  public static extern IntPtr ListOfCompartments_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_remove__SWIG_0")]
  public static extern IntPtr ListOfCompartments_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartments_remove__SWIG_1")]
  public static extern IntPtr ListOfCompartments_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfCompartments")]
  public static extern IntPtr new_ListOfCompartments();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfCompartments")]
  public static extern void delete_ListOfCompartments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Species__SWIG_0")]
  public static extern IntPtr new_Species__SWIG_0(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Species__SWIG_1")]
  public static extern IntPtr new_Species__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Species__SWIG_2")]
  public static extern IntPtr new_Species__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Species__SWIG_3")]
  public static extern IntPtr new_Species__SWIG_3(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Species__SWIG_4")]
  public static extern IntPtr new_Species__SWIG_4(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Species")]
  public static extern void delete_Species(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Species__SWIG_5")]
  public static extern IntPtr new_Species__SWIG_5(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_clone")]
  public static extern IntPtr Species_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_initDefaults")]
  public static extern void Species_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getSpeciesType")]
  public static extern string Species_getSpeciesType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getCompartment")]
  public static extern string Species_getCompartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getInitialAmount")]
  public static extern double Species_getInitialAmount(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getInitialConcentration")]
  public static extern double Species_getInitialConcentration(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getSubstanceUnits")]
  public static extern string Species_getSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getSpatialSizeUnits")]
  public static extern string Species_getSpatialSizeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getUnits")]
  public static extern string Species_getUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getHasOnlySubstanceUnits")]
  public static extern bool Species_getHasOnlySubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getBoundaryCondition")]
  public static extern bool Species_getBoundaryCondition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getCharge")]
  public static extern int Species_getCharge(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getConstant")]
  public static extern bool Species_getConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetSpeciesType")]
  public static extern bool Species_isSetSpeciesType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetCompartment")]
  public static extern bool Species_isSetCompartment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetInitialAmount")]
  public static extern bool Species_isSetInitialAmount(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetInitialConcentration")]
  public static extern bool Species_isSetInitialConcentration(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetSubstanceUnits")]
  public static extern bool Species_isSetSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetSpatialSizeUnits")]
  public static extern bool Species_isSetSpatialSizeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetUnits")]
  public static extern bool Species_isSetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_isSetCharge")]
  public static extern bool Species_isSetCharge(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setSpeciesType")]
  public static extern void Species_setSpeciesType(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setCompartment")]
  public static extern void Species_setCompartment(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setInitialAmount")]
  public static extern void Species_setInitialAmount(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setInitialConcentration")]
  public static extern void Species_setInitialConcentration(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setSubstanceUnits")]
  public static extern void Species_setSubstanceUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setSpatialSizeUnits")]
  public static extern void Species_setSpatialSizeUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setUnits")]
  public static extern void Species_setUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setHasOnlySubstanceUnits")]
  public static extern void Species_setHasOnlySubstanceUnits(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setBoundaryCondition")]
  public static extern void Species_setBoundaryCondition(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setCharge")]
  public static extern void Species_setCharge(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_setConstant")]
  public static extern void Species_setConstant(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetSpeciesType")]
  public static extern void Species_unsetSpeciesType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetInitialAmount")]
  public static extern void Species_unsetInitialAmount(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetInitialConcentration")]
  public static extern void Species_unsetInitialConcentration(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetSubstanceUnits")]
  public static extern void Species_unsetSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetSpatialSizeUnits")]
  public static extern void Species_unsetSpatialSizeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetUnits")]
  public static extern void Species_unsetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_unsetCharge")]
  public static extern void Species_unsetCharge(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getDerivedUnitDefinition")]
  public static extern IntPtr Species_getDerivedUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getTypeCode")]
  public static extern int Species_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Species_getElementName")]
  public static extern string Species_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_clone")]
  public static extern IntPtr ListOfSpecies_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_getTypeCode")]
  public static extern int ListOfSpecies_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_getItemTypeCode")]
  public static extern int ListOfSpecies_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_getElementName")]
  public static extern string ListOfSpecies_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_get__SWIG_0")]
  public static extern IntPtr ListOfSpecies_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_get__SWIG_2")]
  public static extern IntPtr ListOfSpecies_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_remove__SWIG_0")]
  public static extern IntPtr ListOfSpecies_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpecies_remove__SWIG_1")]
  public static extern IntPtr ListOfSpecies_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfSpecies")]
  public static extern IntPtr new_ListOfSpecies();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfSpecies")]
  public static extern void delete_ListOfSpecies(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_0")]
  public static extern IntPtr new_Parameter__SWIG_0(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_1")]
  public static extern IntPtr new_Parameter__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_2")]
  public static extern IntPtr new_Parameter__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_3")]
  public static extern IntPtr new_Parameter__SWIG_3(string jarg1, double jarg2, string jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_4")]
  public static extern IntPtr new_Parameter__SWIG_4(string jarg1, double jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_5")]
  public static extern IntPtr new_Parameter__SWIG_5(string jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_6")]
  public static extern IntPtr new_Parameter__SWIG_6(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_7")]
  public static extern IntPtr new_Parameter__SWIG_7(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Parameter")]
  public static extern void delete_Parameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Parameter__SWIG_8")]
  public static extern IntPtr new_Parameter__SWIG_8(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_clone")]
  public static extern IntPtr Parameter_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_initDefaults")]
  public static extern void Parameter_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getValue")]
  public static extern double Parameter_getValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getUnits")]
  public static extern string Parameter_getUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getConstant")]
  public static extern bool Parameter_getConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_isSetValue")]
  public static extern bool Parameter_isSetValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_isSetUnits")]
  public static extern bool Parameter_isSetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_setValue")]
  public static extern void Parameter_setValue(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_setUnits")]
  public static extern void Parameter_setUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_setConstant")]
  public static extern void Parameter_setConstant(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_unsetValue")]
  public static extern void Parameter_unsetValue(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_unsetUnits")]
  public static extern void Parameter_unsetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getDerivedUnitDefinition")]
  public static extern IntPtr Parameter_getDerivedUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getTypeCode")]
  public static extern int Parameter_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Parameter_getElementName")]
  public static extern string Parameter_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_clone")]
  public static extern IntPtr ListOfParameters_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_getTypeCode")]
  public static extern int ListOfParameters_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_getItemTypeCode")]
  public static extern int ListOfParameters_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_getElementName")]
  public static extern string ListOfParameters_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_get__SWIG_0")]
  public static extern IntPtr ListOfParameters_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_get__SWIG_2")]
  public static extern IntPtr ListOfParameters_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_remove__SWIG_0")]
  public static extern IntPtr ListOfParameters_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParameters_remove__SWIG_1")]
  public static extern IntPtr ListOfParameters_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfParameters")]
  public static extern IntPtr new_ListOfParameters();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfParameters")]
  public static extern void delete_ListOfParameters(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_InitialAssignment__SWIG_0")]
  public static extern IntPtr new_InitialAssignment__SWIG_0(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_InitialAssignment__SWIG_1")]
  public static extern IntPtr new_InitialAssignment__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_InitialAssignment__SWIG_2")]
  public static extern IntPtr new_InitialAssignment__SWIG_2(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_InitialAssignment__SWIG_3")]
  public static extern IntPtr new_InitialAssignment__SWIG_3(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_InitialAssignment")]
  public static extern void delete_InitialAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_InitialAssignment__SWIG_4")]
  public static extern IntPtr new_InitialAssignment__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_clone")]
  public static extern IntPtr InitialAssignment_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_getSymbol")]
  public static extern string InitialAssignment_getSymbol(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_getMath")]
  public static extern IntPtr InitialAssignment_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_isSetSymbol")]
  public static extern bool InitialAssignment_isSetSymbol(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_isSetMath")]
  public static extern bool InitialAssignment_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_setSymbol")]
  public static extern void InitialAssignment_setSymbol(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_setMath")]
  public static extern void InitialAssignment_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_getDerivedUnitDefinition")]
  public static extern IntPtr InitialAssignment_getDerivedUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_containsUndeclaredUnits")]
  public static extern bool InitialAssignment_containsUndeclaredUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_getTypeCode")]
  public static extern int InitialAssignment_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignment_getElementName")]
  public static extern string InitialAssignment_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_clone")]
  public static extern IntPtr ListOfInitialAssignments_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_getTypeCode")]
  public static extern int ListOfInitialAssignments_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_getItemTypeCode")]
  public static extern int ListOfInitialAssignments_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_getElementName")]
  public static extern string ListOfInitialAssignments_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_get__SWIG_0")]
  public static extern IntPtr ListOfInitialAssignments_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_get__SWIG_2")]
  public static extern IntPtr ListOfInitialAssignments_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_remove__SWIG_0")]
  public static extern IntPtr ListOfInitialAssignments_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignments_remove__SWIG_1")]
  public static extern IntPtr ListOfInitialAssignments_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfInitialAssignments")]
  public static extern IntPtr new_ListOfInitialAssignments();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfInitialAssignments")]
  public static extern void delete_ListOfInitialAssignments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Rule")]
  public static extern void delete_Rule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Rule")]
  public static extern IntPtr new_Rule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_clone")]
  public static extern IntPtr Rule_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getFormula")]
  public static extern string Rule_getFormula(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getMath")]
  public static extern IntPtr Rule_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getVariable")]
  public static extern string Rule_getVariable(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getUnits")]
  public static extern string Rule_getUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isSetFormula")]
  public static extern bool Rule_isSetFormula(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isSetMath")]
  public static extern bool Rule_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isSetVariable")]
  public static extern bool Rule_isSetVariable(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isSetUnits")]
  public static extern bool Rule_isSetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_setFormula")]
  public static extern void Rule_setFormula(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_setMath")]
  public static extern void Rule_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_setVariable")]
  public static extern void Rule_setVariable(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_setUnits")]
  public static extern void Rule_setUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_unsetUnits")]
  public static extern void Rule_unsetUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getDerivedUnitDefinition")]
  public static extern IntPtr Rule_getDerivedUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_containsUndeclaredUnits")]
  public static extern bool Rule_containsUndeclaredUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getType")]
  public static extern int Rule_getType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isAlgebraic")]
  public static extern bool Rule_isAlgebraic(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isAssignment")]
  public static extern bool Rule_isAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isCompartmentVolume")]
  public static extern bool Rule_isCompartmentVolume(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isParameter")]
  public static extern bool Rule_isParameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isRate")]
  public static extern bool Rule_isRate(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isScalar")]
  public static extern bool Rule_isScalar(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_isSpeciesConcentration")]
  public static extern bool Rule_isSpeciesConcentration(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getTypeCode")]
  public static extern int Rule_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getL1TypeCode")]
  public static extern int Rule_getL1TypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_getElementName")]
  public static extern string Rule_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Rule_setL1TypeCode")]
  public static extern void Rule_setL1TypeCode(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AlgebraicRule__SWIG_0")]
  public static extern IntPtr new_AlgebraicRule__SWIG_0(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AlgebraicRule__SWIG_1")]
  public static extern IntPtr new_AlgebraicRule__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AlgebraicRule__SWIG_2")]
  public static extern IntPtr new_AlgebraicRule__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AlgebraicRule__SWIG_3")]
  public static extern IntPtr new_AlgebraicRule__SWIG_3(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AlgebraicRule__SWIG_4")]
  public static extern IntPtr new_AlgebraicRule__SWIG_4(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_AlgebraicRule")]
  public static extern void delete_AlgebraicRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AlgebraicRule_clone")]
  public static extern IntPtr AlgebraicRule_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AlgebraicRule_setInternalIdOnly")]
  public static extern void AlgebraicRule_setInternalIdOnly(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AlgebraicRule_getInternalIdOnly")]
  public static extern bool AlgebraicRule_getInternalIdOnly(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AssignmentRule__SWIG_0")]
  public static extern IntPtr new_AssignmentRule__SWIG_0(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AssignmentRule__SWIG_1")]
  public static extern IntPtr new_AssignmentRule__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AssignmentRule__SWIG_2")]
  public static extern IntPtr new_AssignmentRule__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AssignmentRule__SWIG_3")]
  public static extern IntPtr new_AssignmentRule__SWIG_3(string jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AssignmentRule__SWIG_4")]
  public static extern IntPtr new_AssignmentRule__SWIG_4(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_AssignmentRule__SWIG_5")]
  public static extern IntPtr new_AssignmentRule__SWIG_5(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_AssignmentRule")]
  public static extern void delete_AssignmentRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AssignmentRule_clone")]
  public static extern IntPtr AssignmentRule_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_RateRule__SWIG_0")]
  public static extern IntPtr new_RateRule__SWIG_0(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_RateRule__SWIG_1")]
  public static extern IntPtr new_RateRule__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_RateRule__SWIG_2")]
  public static extern IntPtr new_RateRule__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_RateRule__SWIG_3")]
  public static extern IntPtr new_RateRule__SWIG_3(string jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_RateRule__SWIG_4")]
  public static extern IntPtr new_RateRule__SWIG_4(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_RateRule__SWIG_5")]
  public static extern IntPtr new_RateRule__SWIG_5(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_RateRule")]
  public static extern void delete_RateRule(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RateRule_clone")]
  public static extern IntPtr RateRule_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_clone")]
  public static extern IntPtr ListOfRules_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_getTypeCode")]
  public static extern int ListOfRules_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_getItemTypeCode")]
  public static extern int ListOfRules_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_getElementName")]
  public static extern string ListOfRules_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_get__SWIG_0")]
  public static extern IntPtr ListOfRules_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_get__SWIG_2")]
  public static extern IntPtr ListOfRules_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_remove__SWIG_0")]
  public static extern IntPtr ListOfRules_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRules_remove__SWIG_1")]
  public static extern IntPtr ListOfRules_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfRules")]
  public static extern IntPtr new_ListOfRules();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfRules")]
  public static extern void delete_ListOfRules(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Constraint__SWIG_0")]
  public static extern IntPtr new_Constraint__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Constraint__SWIG_1")]
  public static extern IntPtr new_Constraint__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Constraint__SWIG_2")]
  public static extern IntPtr new_Constraint__SWIG_2(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Constraint__SWIG_3")]
  public static extern IntPtr new_Constraint__SWIG_3(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Constraint")]
  public static extern void delete_Constraint(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Constraint__SWIG_4")]
  public static extern IntPtr new_Constraint__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_clone")]
  public static extern IntPtr Constraint_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_getMessage")]
  public static extern IntPtr Constraint_getMessage(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_getMessageString")]
  public static extern string Constraint_getMessageString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_getMath")]
  public static extern IntPtr Constraint_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_isSetMessage")]
  public static extern bool Constraint_isSetMessage(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_isSetMath")]
  public static extern bool Constraint_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_setMessage")]
  public static extern void Constraint_setMessage(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_setMath")]
  public static extern void Constraint_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_unsetMessage")]
  public static extern void Constraint_unsetMessage(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_getTypeCode")]
  public static extern int Constraint_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Constraint_getElementName")]
  public static extern string Constraint_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_clone")]
  public static extern IntPtr ListOfConstraints_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_getTypeCode")]
  public static extern int ListOfConstraints_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_getItemTypeCode")]
  public static extern int ListOfConstraints_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_getElementName")]
  public static extern string ListOfConstraints_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_get__SWIG_0")]
  public static extern IntPtr ListOfConstraints_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraints_remove")]
  public static extern IntPtr ListOfConstraints_remove(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfConstraints")]
  public static extern IntPtr new_ListOfConstraints();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfConstraints")]
  public static extern void delete_ListOfConstraints(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Reaction__SWIG_0")]
  public static extern IntPtr new_Reaction__SWIG_0(string jarg1, string jarg2, HandleRef jarg3, bool jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Reaction__SWIG_1")]
  public static extern IntPtr new_Reaction__SWIG_1(string jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Reaction__SWIG_2")]
  public static extern IntPtr new_Reaction__SWIG_2(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Reaction__SWIG_3")]
  public static extern IntPtr new_Reaction__SWIG_3(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Reaction__SWIG_4")]
  public static extern IntPtr new_Reaction__SWIG_4();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Reaction__SWIG_5")]
  public static extern IntPtr new_Reaction__SWIG_5(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Reaction__SWIG_6")]
  public static extern IntPtr new_Reaction__SWIG_6(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Reaction")]
  public static extern void delete_Reaction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Reaction__SWIG_7")]
  public static extern IntPtr new_Reaction__SWIG_7(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_clone")]
  public static extern IntPtr Reaction_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_initDefaults")]
  public static extern void Reaction_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getKineticLaw__SWIG_0")]
  public static extern IntPtr Reaction_getKineticLaw__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getReversible")]
  public static extern bool Reaction_getReversible(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getFast")]
  public static extern bool Reaction_getFast(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_isSetKineticLaw")]
  public static extern bool Reaction_isSetKineticLaw(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_isSetFast")]
  public static extern bool Reaction_isSetFast(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_setKineticLaw")]
  public static extern void Reaction_setKineticLaw(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_setReversible")]
  public static extern void Reaction_setReversible(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_setFast")]
  public static extern void Reaction_setFast(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_unsetKineticLaw")]
  public static extern void Reaction_unsetKineticLaw(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_unsetFast")]
  public static extern void Reaction_unsetFast(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addReactant")]
  public static extern void Reaction_addReactant(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addProduct")]
  public static extern void Reaction_addProduct(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_addModifier")]
  public static extern void Reaction_addModifier(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_createReactant")]
  public static extern IntPtr Reaction_createReactant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_createProduct")]
  public static extern IntPtr Reaction_createProduct(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_createModifier")]
  public static extern IntPtr Reaction_createModifier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_createKineticLaw")]
  public static extern IntPtr Reaction_createKineticLaw(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getListOfReactants__SWIG_0")]
  public static extern IntPtr Reaction_getListOfReactants__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getListOfProducts__SWIG_0")]
  public static extern IntPtr Reaction_getListOfProducts__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getListOfModifiers__SWIG_0")]
  public static extern IntPtr Reaction_getListOfModifiers__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getReactant__SWIG_0")]
  public static extern IntPtr Reaction_getReactant__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getReactant__SWIG_2")]
  public static extern IntPtr Reaction_getReactant__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getProduct__SWIG_0")]
  public static extern IntPtr Reaction_getProduct__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getProduct__SWIG_2")]
  public static extern IntPtr Reaction_getProduct__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getModifier__SWIG_0")]
  public static extern IntPtr Reaction_getModifier__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getModifier__SWIG_2")]
  public static extern IntPtr Reaction_getModifier__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getNumReactants")]
  public static extern uint Reaction_getNumReactants(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getNumProducts")]
  public static extern uint Reaction_getNumProducts(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getNumModifiers")]
  public static extern uint Reaction_getNumModifiers(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_setSBMLDocument")]
  public static extern void Reaction_setSBMLDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_setParentSBMLObject")]
  public static extern void Reaction_setParentSBMLObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getTypeCode")]
  public static extern int Reaction_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Reaction_getElementName")]
  public static extern string Reaction_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_clone")]
  public static extern IntPtr ListOfReactions_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_getTypeCode")]
  public static extern int ListOfReactions_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_getItemTypeCode")]
  public static extern int ListOfReactions_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_getElementName")]
  public static extern string ListOfReactions_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_get__SWIG_0")]
  public static extern IntPtr ListOfReactions_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_get__SWIG_2")]
  public static extern IntPtr ListOfReactions_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_remove__SWIG_0")]
  public static extern IntPtr ListOfReactions_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactions_remove__SWIG_1")]
  public static extern IntPtr ListOfReactions_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfReactions")]
  public static extern IntPtr new_ListOfReactions();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfReactions")]
  public static extern void delete_ListOfReactions(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_0")]
  public static extern IntPtr new_KineticLaw__SWIG_0(string jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_1")]
  public static extern IntPtr new_KineticLaw__SWIG_1(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_2")]
  public static extern IntPtr new_KineticLaw__SWIG_2(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_3")]
  public static extern IntPtr new_KineticLaw__SWIG_3();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_4")]
  public static extern IntPtr new_KineticLaw__SWIG_4(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_5")]
  public static extern IntPtr new_KineticLaw__SWIG_5(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_6")]
  public static extern IntPtr new_KineticLaw__SWIG_6(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_7")]
  public static extern IntPtr new_KineticLaw__SWIG_7(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_8")]
  public static extern IntPtr new_KineticLaw__SWIG_8(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_KineticLaw")]
  public static extern void delete_KineticLaw(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_KineticLaw__SWIG_9")]
  public static extern IntPtr new_KineticLaw__SWIG_9(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_clone")]
  public static extern IntPtr KineticLaw_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getFormula")]
  public static extern string KineticLaw_getFormula(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getMath")]
  public static extern IntPtr KineticLaw_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getTimeUnits")]
  public static extern string KineticLaw_getTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getSubstanceUnits")]
  public static extern string KineticLaw_getSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_isSetFormula")]
  public static extern bool KineticLaw_isSetFormula(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_isSetMath")]
  public static extern bool KineticLaw_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_isSetTimeUnits")]
  public static extern bool KineticLaw_isSetTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_isSetSubstanceUnits")]
  public static extern bool KineticLaw_isSetSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_setFormula")]
  public static extern void KineticLaw_setFormula(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_setMath")]
  public static extern void KineticLaw_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_setTimeUnits")]
  public static extern void KineticLaw_setTimeUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_setSubstanceUnits")]
  public static extern void KineticLaw_setSubstanceUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_unsetTimeUnits")]
  public static extern void KineticLaw_unsetTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_unsetSubstanceUnits")]
  public static extern void KineticLaw_unsetSubstanceUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_addParameter")]
  public static extern void KineticLaw_addParameter(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_createParameter")]
  public static extern IntPtr KineticLaw_createParameter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getListOfParameters__SWIG_0")]
  public static extern IntPtr KineticLaw_getListOfParameters__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getParameter__SWIG_0")]
  public static extern IntPtr KineticLaw_getParameter__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getParameter__SWIG_2")]
  public static extern IntPtr KineticLaw_getParameter__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getNumParameters")]
  public static extern uint KineticLaw_getNumParameters(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getDerivedUnitDefinition")]
  public static extern IntPtr KineticLaw_getDerivedUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_containsUndeclaredUnits")]
  public static extern bool KineticLaw_containsUndeclaredUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_setSBMLDocument")]
  public static extern void KineticLaw_setSBMLDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_setParentSBMLObject")]
  public static extern void KineticLaw_setParentSBMLObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getTypeCode")]
  public static extern int KineticLaw_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLaw_getElementName")]
  public static extern string KineticLaw_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SimpleSpeciesReference")]
  public static extern void delete_SimpleSpeciesReference(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_getSpecies")]
  public static extern string SimpleSpeciesReference_getSpecies(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_isSetSpecies")]
  public static extern bool SimpleSpeciesReference_isSetSpecies(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_setSpecies")]
  public static extern void SimpleSpeciesReference_setSpecies(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReference_isModifier")]
  public static extern bool SimpleSpeciesReference_isModifier(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesReference__SWIG_0")]
  public static extern IntPtr new_SpeciesReference__SWIG_0(string jarg1, double jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesReference__SWIG_1")]
  public static extern IntPtr new_SpeciesReference__SWIG_1(string jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesReference__SWIG_2")]
  public static extern IntPtr new_SpeciesReference__SWIG_2(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesReference__SWIG_3")]
  public static extern IntPtr new_SpeciesReference__SWIG_3();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesReference__SWIG_4")]
  public static extern IntPtr new_SpeciesReference__SWIG_4(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesReference__SWIG_5")]
  public static extern IntPtr new_SpeciesReference__SWIG_5(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SpeciesReference")]
  public static extern void delete_SpeciesReference(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SpeciesReference__SWIG_6")]
  public static extern IntPtr new_SpeciesReference__SWIG_6(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_clone")]
  public static extern IntPtr SpeciesReference_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_initDefaults")]
  public static extern void SpeciesReference_initDefaults(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_getStoichiometry")]
  public static extern double SpeciesReference_getStoichiometry(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_getStoichiometryMath__SWIG_0")]
  public static extern IntPtr SpeciesReference_getStoichiometryMath__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_getDenominator")]
  public static extern int SpeciesReference_getDenominator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_isSetStoichiometryMath")]
  public static extern bool SpeciesReference_isSetStoichiometryMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_setStoichiometry")]
  public static extern void SpeciesReference_setStoichiometry(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_setStoichiometryMath")]
  public static extern void SpeciesReference_setStoichiometryMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_setDenominator")]
  public static extern void SpeciesReference_setDenominator(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_unsetStoichiometryMath")]
  public static extern void SpeciesReference_unsetStoichiometryMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_setAnnotation__SWIG_0")]
  public static extern void SpeciesReference_setAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_setAnnotation__SWIG_1")]
  public static extern void SpeciesReference_setAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_appendAnnotation__SWIG_0")]
  public static extern void SpeciesReference_appendAnnotation__SWIG_0(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_appendAnnotation__SWIG_1")]
  public static extern void SpeciesReference_appendAnnotation__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_getTypeCode")]
  public static extern int SpeciesReference_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_getElementName")]
  public static extern string SpeciesReference_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReference_sortMath")]
  public static extern void SpeciesReference_sortMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModifierSpeciesReference__SWIG_0")]
  public static extern IntPtr new_ModifierSpeciesReference__SWIG_0(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModifierSpeciesReference__SWIG_1")]
  public static extern IntPtr new_ModifierSpeciesReference__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModifierSpeciesReference__SWIG_2")]
  public static extern IntPtr new_ModifierSpeciesReference__SWIG_2(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModifierSpeciesReference__SWIG_3")]
  public static extern IntPtr new_ModifierSpeciesReference__SWIG_3(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ModifierSpeciesReference")]
  public static extern void delete_ModifierSpeciesReference(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModifierSpeciesReference_clone")]
  public static extern IntPtr ModifierSpeciesReference_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModifierSpeciesReference_getTypeCode")]
  public static extern int ModifierSpeciesReference_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModifierSpeciesReference_getElementName")]
  public static extern string ModifierSpeciesReference_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfSpeciesReferences")]
  public static extern IntPtr new_ListOfSpeciesReferences();

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_clone")]
  public static extern IntPtr ListOfSpeciesReferences_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_getTypeCode")]
  public static extern int ListOfSpeciesReferences_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_getItemTypeCode")]
  public static extern int ListOfSpeciesReferences_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_getElementName")]
  public static extern string ListOfSpeciesReferences_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_get__SWIG_0")]
  public static extern IntPtr ListOfSpeciesReferences_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_get__SWIG_2")]
  public static extern IntPtr ListOfSpeciesReferences_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_remove__SWIG_0")]
  public static extern IntPtr ListOfSpeciesReferences_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferences_remove__SWIG_1")]
  public static extern IntPtr ListOfSpeciesReferences_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfSpeciesReferences")]
  public static extern void delete_ListOfSpeciesReferences(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Event__SWIG_0")]
  public static extern IntPtr new_Event__SWIG_0(string jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Event__SWIG_1")]
  public static extern IntPtr new_Event__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Event__SWIG_2")]
  public static extern IntPtr new_Event__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Event__SWIG_3")]
  public static extern IntPtr new_Event__SWIG_3(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Event__SWIG_4")]
  public static extern IntPtr new_Event__SWIG_4(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Event")]
  public static extern void delete_Event(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Event__SWIG_5")]
  public static extern IntPtr new_Event__SWIG_5(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_clone")]
  public static extern IntPtr Event_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getTrigger__SWIG_0")]
  public static extern IntPtr Event_getTrigger__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getDelay__SWIG_0")]
  public static extern IntPtr Event_getDelay__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getTimeUnits")]
  public static extern string Event_getTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getUseValuesFromTriggerTime")]
  public static extern bool Event_getUseValuesFromTriggerTime(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_isSetTrigger")]
  public static extern bool Event_isSetTrigger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_isSetDelay")]
  public static extern bool Event_isSetDelay(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_isSetTimeUnits")]
  public static extern bool Event_isSetTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setTrigger")]
  public static extern void Event_setTrigger(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setDelay")]
  public static extern void Event_setDelay(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setTimeUnits")]
  public static extern void Event_setTimeUnits(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setUseValuesFromTriggerTime")]
  public static extern void Event_setUseValuesFromTriggerTime(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_unsetDelay")]
  public static extern void Event_unsetDelay(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_unsetTimeUnits")]
  public static extern void Event_unsetTimeUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_addEventAssignment")]
  public static extern void Event_addEventAssignment(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_createEventAssignment")]
  public static extern IntPtr Event_createEventAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getListOfEventAssignments__SWIG_0")]
  public static extern IntPtr Event_getListOfEventAssignments__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getEventAssignment__SWIG_0")]
  public static extern IntPtr Event_getEventAssignment__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getEventAssignment__SWIG_2")]
  public static extern IntPtr Event_getEventAssignment__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getNumEventAssignments")]
  public static extern uint Event_getNumEventAssignments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setSBMLDocument")]
  public static extern void Event_setSBMLDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setParentSBMLObject")]
  public static extern void Event_setParentSBMLObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getTypeCode")]
  public static extern int Event_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_getElementName")]
  public static extern string Event_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Event_setInternalIdOnly")]
  public static extern void Event_setInternalIdOnly(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_clone")]
  public static extern IntPtr ListOfEvents_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_getTypeCode")]
  public static extern int ListOfEvents_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_getItemTypeCode")]
  public static extern int ListOfEvents_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_getElementName")]
  public static extern string ListOfEvents_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_get__SWIG_0")]
  public static extern IntPtr ListOfEvents_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_get__SWIG_2")]
  public static extern IntPtr ListOfEvents_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_remove__SWIG_0")]
  public static extern IntPtr ListOfEvents_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEvents_remove__SWIG_1")]
  public static extern IntPtr ListOfEvents_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfEvents")]
  public static extern IntPtr new_ListOfEvents();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfEvents")]
  public static extern void delete_ListOfEvents(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_EventAssignment__SWIG_0")]
  public static extern IntPtr new_EventAssignment__SWIG_0(string jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_EventAssignment__SWIG_1")]
  public static extern IntPtr new_EventAssignment__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_EventAssignment__SWIG_2")]
  public static extern IntPtr new_EventAssignment__SWIG_2();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_EventAssignment__SWIG_3")]
  public static extern IntPtr new_EventAssignment__SWIG_3(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_EventAssignment__SWIG_4")]
  public static extern IntPtr new_EventAssignment__SWIG_4(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_EventAssignment")]
  public static extern void delete_EventAssignment(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_EventAssignment__SWIG_5")]
  public static extern IntPtr new_EventAssignment__SWIG_5(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_clone")]
  public static extern IntPtr EventAssignment_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_getVariable")]
  public static extern string EventAssignment_getVariable(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_getMath")]
  public static extern IntPtr EventAssignment_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_isSetVariable")]
  public static extern bool EventAssignment_isSetVariable(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_isSetMath")]
  public static extern bool EventAssignment_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_setVariable")]
  public static extern void EventAssignment_setVariable(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_setMath")]
  public static extern void EventAssignment_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_getDerivedUnitDefinition")]
  public static extern IntPtr EventAssignment_getDerivedUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_containsUndeclaredUnits")]
  public static extern bool EventAssignment_containsUndeclaredUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_getTypeCode")]
  public static extern int EventAssignment_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignment_getElementName")]
  public static extern string EventAssignment_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_clone")]
  public static extern IntPtr ListOfEventAssignments_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_getTypeCode")]
  public static extern int ListOfEventAssignments_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_getItemTypeCode")]
  public static extern int ListOfEventAssignments_getItemTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_getElementName")]
  public static extern string ListOfEventAssignments_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_get__SWIG_0")]
  public static extern IntPtr ListOfEventAssignments_get__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_get__SWIG_2")]
  public static extern IntPtr ListOfEventAssignments_get__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_remove__SWIG_0")]
  public static extern IntPtr ListOfEventAssignments_remove__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignments_remove__SWIG_1")]
  public static extern IntPtr ListOfEventAssignments_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ListOfEventAssignments")]
  public static extern IntPtr new_ListOfEventAssignments();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ListOfEventAssignments")]
  public static extern void delete_ListOfEventAssignments(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Trigger__SWIG_0")]
  public static extern IntPtr new_Trigger__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Trigger__SWIG_1")]
  public static extern IntPtr new_Trigger__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Trigger__SWIG_2")]
  public static extern IntPtr new_Trigger__SWIG_2(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Trigger__SWIG_3")]
  public static extern IntPtr new_Trigger__SWIG_3(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Trigger")]
  public static extern void delete_Trigger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Trigger__SWIG_4")]
  public static extern IntPtr new_Trigger__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_clone")]
  public static extern IntPtr Trigger_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_getMath")]
  public static extern IntPtr Trigger_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_isSetMath")]
  public static extern bool Trigger_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_setMath")]
  public static extern void Trigger_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_setSBMLDocument")]
  public static extern void Trigger_setSBMLDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_setParentSBMLObject")]
  public static extern void Trigger_setParentSBMLObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_getTypeCode")]
  public static extern int Trigger_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Trigger_getElementName")]
  public static extern string Trigger_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Delay__SWIG_0")]
  public static extern IntPtr new_Delay__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Delay__SWIG_1")]
  public static extern IntPtr new_Delay__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Delay__SWIG_2")]
  public static extern IntPtr new_Delay__SWIG_2(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Delay__SWIG_3")]
  public static extern IntPtr new_Delay__SWIG_3(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Delay")]
  public static extern void delete_Delay(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Delay__SWIG_4")]
  public static extern IntPtr new_Delay__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_clone")]
  public static extern IntPtr Delay_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_getMath")]
  public static extern IntPtr Delay_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_isSetMath")]
  public static extern bool Delay_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_setMath")]
  public static extern void Delay_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_getDerivedUnitDefinition")]
  public static extern IntPtr Delay_getDerivedUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_containsUndeclaredUnits")]
  public static extern bool Delay_containsUndeclaredUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_setSBMLDocument")]
  public static extern void Delay_setSBMLDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_setParentSBMLObject")]
  public static extern void Delay_setParentSBMLObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_getTypeCode")]
  public static extern int Delay_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Delay_getElementName")]
  public static extern string Delay_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_readTerm")]
  public static extern int SBO_readTerm(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_writeTerm")]
  public static extern void SBO_writeTerm(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isQuantitativeParameter")]
  public static extern bool SBO_isQuantitativeParameter(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isParticipantRole")]
  public static extern bool SBO_isParticipantRole(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isModellingFramework")]
  public static extern bool SBO_isModellingFramework(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isMathematicalExpression")]
  public static extern bool SBO_isMathematicalExpression(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isKineticConstant")]
  public static extern bool SBO_isKineticConstant(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isReactant")]
  public static extern bool SBO_isReactant(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isProduct")]
  public static extern bool SBO_isProduct(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isModifier")]
  public static extern bool SBO_isModifier(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isRateLaw")]
  public static extern bool SBO_isRateLaw(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isEvent")]
  public static extern bool SBO_isEvent(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isPhysicalParticipant")]
  public static extern bool SBO_isPhysicalParticipant(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isParticipant")]
  public static extern bool SBO_isParticipant(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isInteraction")]
  public static extern bool SBO_isInteraction(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isEntity")]
  public static extern bool SBO_isEntity(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isFunctionalEntity")]
  public static extern bool SBO_isFunctionalEntity(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isMaterialEntity")]
  public static extern bool SBO_isMaterialEntity(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isConservationLaw")]
  public static extern bool SBO_isConservationLaw(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isSteadyStateExpression")]
  public static extern bool SBO_isSteadyStateExpression(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isFunctionalCompartment")]
  public static extern bool SBO_isFunctionalCompartment(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isContinuousFramework")]
  public static extern bool SBO_isContinuousFramework(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isDiscreteFramework")]
  public static extern bool SBO_isDiscreteFramework(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isLogicalFramework")]
  public static extern bool SBO_isLogicalFramework(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_isObselete")]
  public static extern bool SBO_isObselete(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBO_intToString")]
  public static extern string SBO_intToString(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBO")]
  public static extern IntPtr new_SBO();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBO")]
  public static extern void delete_SBO(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_StoichiometryMath__SWIG_0")]
  public static extern IntPtr new_StoichiometryMath__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_StoichiometryMath__SWIG_1")]
  public static extern IntPtr new_StoichiometryMath__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_StoichiometryMath__SWIG_2")]
  public static extern IntPtr new_StoichiometryMath__SWIG_2(long jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_StoichiometryMath__SWIG_3")]
  public static extern IntPtr new_StoichiometryMath__SWIG_3(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_StoichiometryMath")]
  public static extern void delete_StoichiometryMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_StoichiometryMath__SWIG_4")]
  public static extern IntPtr new_StoichiometryMath__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_clone")]
  public static extern IntPtr StoichiometryMath_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_getMath")]
  public static extern IntPtr StoichiometryMath_getMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_isSetMath")]
  public static extern bool StoichiometryMath_isSetMath(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_setMath")]
  public static extern void StoichiometryMath_setMath(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_getDerivedUnitDefinition")]
  public static extern IntPtr StoichiometryMath_getDerivedUnitDefinition(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_containsUndeclaredUnits")]
  public static extern bool StoichiometryMath_containsUndeclaredUnits(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_setSBMLDocument")]
  public static extern void StoichiometryMath_setSBMLDocument(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_setParentSBMLObject")]
  public static extern void StoichiometryMath_setParentSBMLObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_getTypeCode")]
  public static extern int StoichiometryMath_getTypeCode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMath_getElementName")]
  public static extern string StoichiometryMath_getElementName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_readMathMLFromString")]
  public static extern IntPtr readMathMLFromString(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_writeMathMLToString")]
  public static extern string writeMathMLToString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ASTNode__SWIG_0")]
  public static extern IntPtr new_ASTNode__SWIG_0(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ASTNode__SWIG_1")]
  public static extern IntPtr new_ASTNode__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ASTNode__SWIG_2")]
  public static extern IntPtr new_ASTNode__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ASTNode")]
  public static extern void delete_ASTNode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_canonicalize")]
  public static extern bool ASTNode_canonicalize(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_addChild")]
  public static extern void ASTNode_addChild(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_prependChild")]
  public static extern void ASTNode_prependChild(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_removeChild")]
  public static extern int ASTNode_removeChild(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_replaceChild")]
  public static extern int ASTNode_replaceChild(HandleRef jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_insertChild")]
  public static extern int ASTNode_insertChild(HandleRef jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_deepCopy")]
  public static extern IntPtr ASTNode_deepCopy(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getChild")]
  public static extern IntPtr ASTNode_getChild(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getLeftChild")]
  public static extern IntPtr ASTNode_getLeftChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getRightChild")]
  public static extern IntPtr ASTNode_getRightChild(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getNumChildren")]
  public static extern uint ASTNode_getNumChildren(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_addSemanticsAnnotation")]
  public static extern void ASTNode_addSemanticsAnnotation(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getNumSemanticsAnnotations")]
  public static extern uint ASTNode_getNumSemanticsAnnotations(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getSemanticsAnnotation")]
  public static extern IntPtr ASTNode_getSemanticsAnnotation(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getCharacter")]
  public static extern char ASTNode_getCharacter(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getInteger")]
  public static extern int ASTNode_getInteger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getName")]
  public static extern string ASTNode_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getNumerator")]
  public static extern int ASTNode_getNumerator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getDenominator")]
  public static extern int ASTNode_getDenominator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getReal")]
  public static extern double ASTNode_getReal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getMantissa")]
  public static extern double ASTNode_getMantissa(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getExponent")]
  public static extern int ASTNode_getExponent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getPrecedence")]
  public static extern int ASTNode_getPrecedence(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getType")]
  public static extern int ASTNode_getType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isBoolean")]
  public static extern bool ASTNode_isBoolean(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isConstant")]
  public static extern bool ASTNode_isConstant(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isFunction")]
  public static extern bool ASTNode_isFunction(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isInfinity")]
  public static extern bool ASTNode_isInfinity(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isInteger")]
  public static extern bool ASTNode_isInteger(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isLambda")]
  public static extern bool ASTNode_isLambda(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isLog10")]
  public static extern bool ASTNode_isLog10(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isLogical")]
  public static extern bool ASTNode_isLogical(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isName")]
  public static extern bool ASTNode_isName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isNaN")]
  public static extern bool ASTNode_isNaN(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isNegInfinity")]
  public static extern bool ASTNode_isNegInfinity(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isNumber")]
  public static extern bool ASTNode_isNumber(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isOperator")]
  public static extern bool ASTNode_isOperator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isPiecewise")]
  public static extern bool ASTNode_isPiecewise(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isRational")]
  public static extern bool ASTNode_isRational(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isReal")]
  public static extern bool ASTNode_isReal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isRelational")]
  public static extern bool ASTNode_isRelational(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isSqrt")]
  public static extern bool ASTNode_isSqrt(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isUMinus")]
  public static extern bool ASTNode_isUMinus(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_isUnknown")]
  public static extern bool ASTNode_isUnknown(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setCharacter")]
  public static extern void ASTNode_setCharacter(HandleRef jarg1, char jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setName")]
  public static extern void ASTNode_setName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setValue__SWIG_0")]
  public static extern void ASTNode_setValue__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setValue__SWIG_1")]
  public static extern void ASTNode_setValue__SWIG_1(HandleRef jarg1, int jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setValue__SWIG_2")]
  public static extern void ASTNode_setValue__SWIG_2(HandleRef jarg1, double jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setValue__SWIG_3")]
  public static extern void ASTNode_setValue__SWIG_3(HandleRef jarg1, double jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setType")]
  public static extern void ASTNode_setType(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_swapChildren")]
  public static extern void ASTNode_swapChildren(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getDefinitionURL")]
  public static extern IntPtr ASTNode_getDefinitionURL(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_replaceArgument")]
  public static extern void ASTNode_replaceArgument(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_ReplaceArgument")]
  public static extern void ASTNode_ReplaceArgument(HandleRef jarg1, string jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_setParentSBMLObject")]
  public static extern void ASTNode_setParentSBMLObject(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_getParentSBMLObject")]
  public static extern IntPtr ASTNode_getParentSBMLObject(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_ReduceToBinary")]
  public static extern void ASTNode_ReduceToBinary(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ASTNode_reduceToBinary")]
  public static extern void ASTNode_reduceToBinary(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_parseFormula")]
  public static extern IntPtr parseFormula(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_formulaToString")]
  public static extern string formulaToString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLAttributes__SWIG_0")]
  public static extern IntPtr new_XMLAttributes__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLAttributes")]
  public static extern void delete_XMLAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLAttributes__SWIG_1")]
  public static extern IntPtr new_XMLAttributes__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_clone")]
  public static extern IntPtr XMLAttributes_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_add__SWIG_0")]
  public static extern void XMLAttributes_add__SWIG_0(HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_add__SWIG_1")]
  public static extern void XMLAttributes_add__SWIG_1(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_add__SWIG_2")]
  public static extern void XMLAttributes_add__SWIG_2(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_add__SWIG_3")]
  public static extern void XMLAttributes_add__SWIG_3(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_addResource")]
  public static extern void XMLAttributes_addResource(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_removeResource")]
  public static extern void XMLAttributes_removeResource(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_remove__SWIG_0")]
  public static extern void XMLAttributes_remove__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_remove__SWIG_1")]
  public static extern void XMLAttributes_remove__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_remove__SWIG_2")]
  public static extern void XMLAttributes_remove__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_remove__SWIG_3")]
  public static extern void XMLAttributes_remove__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_clear")]
  public static extern void XMLAttributes_clear(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getIndex__SWIG_0")]
  public static extern int XMLAttributes_getIndex__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getIndex__SWIG_1")]
  public static extern int XMLAttributes_getIndex__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getIndex__SWIG_2")]
  public static extern int XMLAttributes_getIndex__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getLength")]
  public static extern int XMLAttributes_getLength(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getName")]
  public static extern string XMLAttributes_getName(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getPrefix")]
  public static extern string XMLAttributes_getPrefix(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getPrefixedName")]
  public static extern string XMLAttributes_getPrefixedName(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getURI")]
  public static extern string XMLAttributes_getURI(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getValue__SWIG_0")]
  public static extern string XMLAttributes_getValue__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getValue__SWIG_1")]
  public static extern string XMLAttributes_getValue__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getValue__SWIG_2")]
  public static extern string XMLAttributes_getValue__SWIG_2(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_getValue__SWIG_3")]
  public static extern string XMLAttributes_getValue__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_hasAttribute__SWIG_0")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_hasAttribute__SWIG_1")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_hasAttribute__SWIG_2")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_hasAttribute__SWIG_3")]
  public static extern bool XMLAttributes_hasAttribute__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_isEmpty")]
  public static extern bool XMLAttributes_isEmpty(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_write")]
  public static extern void XMLAttributes_write(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLAttributes_setErrorLog")]
  public static extern void XMLAttributes_setErrorLog(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNamespaces__SWIG_0")]
  public static extern IntPtr new_XMLNamespaces__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLNamespaces")]
  public static extern void delete_XMLNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNamespaces__SWIG_1")]
  public static extern IntPtr new_XMLNamespaces__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_clone")]
  public static extern IntPtr XMLNamespaces_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_add__SWIG_0")]
  public static extern void XMLNamespaces_add__SWIG_0(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_add__SWIG_1")]
  public static extern void XMLNamespaces_add__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_remove__SWIG_0")]
  public static extern void XMLNamespaces_remove__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_remove__SWIG_1")]
  public static extern void XMLNamespaces_remove__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_clear")]
  public static extern void XMLNamespaces_clear(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getIndex")]
  public static extern int XMLNamespaces_getIndex(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getIndexByPrefix")]
  public static extern int XMLNamespaces_getIndexByPrefix(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getLength")]
  public static extern int XMLNamespaces_getLength(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getPrefix__SWIG_0")]
  public static extern string XMLNamespaces_getPrefix__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getPrefix__SWIG_1")]
  public static extern string XMLNamespaces_getPrefix__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getURI__SWIG_0")]
  public static extern string XMLNamespaces_getURI__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getURI__SWIG_1")]
  public static extern string XMLNamespaces_getURI__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_getURI__SWIG_2")]
  public static extern string XMLNamespaces_getURI__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_isEmpty")]
  public static extern bool XMLNamespaces_isEmpty(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_hasURI")]
  public static extern bool XMLNamespaces_hasURI(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_hasPrefix")]
  public static extern bool XMLNamespaces_hasPrefix(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNamespaces_hasNS")]
  public static extern bool XMLNamespaces_hasNS(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_0")]
  public static extern IntPtr new_XMLToken__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_1")]
  public static extern IntPtr new_XMLToken__SWIG_1(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, long jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_2")]
  public static extern IntPtr new_XMLToken__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_3")]
  public static extern IntPtr new_XMLToken__SWIG_3(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_4")]
  public static extern IntPtr new_XMLToken__SWIG_4(HandleRef jarg1, HandleRef jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_5")]
  public static extern IntPtr new_XMLToken__SWIG_5(HandleRef jarg1, HandleRef jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_6")]
  public static extern IntPtr new_XMLToken__SWIG_6(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_7")]
  public static extern IntPtr new_XMLToken__SWIG_7(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_8")]
  public static extern IntPtr new_XMLToken__SWIG_8(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_9")]
  public static extern IntPtr new_XMLToken__SWIG_9(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_10")]
  public static extern IntPtr new_XMLToken__SWIG_10(string jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_11")]
  public static extern IntPtr new_XMLToken__SWIG_11(string jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_12")]
  public static extern IntPtr new_XMLToken__SWIG_12(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLToken")]
  public static extern void delete_XMLToken(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLToken__SWIG_13")]
  public static extern IntPtr new_XMLToken__SWIG_13(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_clone")]
  public static extern IntPtr XMLToken_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttributes")]
  public static extern IntPtr XMLToken_getAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_setAttributes")]
  public static extern void XMLToken_setAttributes(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addAttr__SWIG_0")]
  public static extern void XMLToken_addAttr__SWIG_0(HandleRef jarg1, string jarg2, string jarg3, string jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addAttr__SWIG_1")]
  public static extern void XMLToken_addAttr__SWIG_1(HandleRef jarg1, string jarg2, string jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addAttr__SWIG_2")]
  public static extern void XMLToken_addAttr__SWIG_2(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addAttr__SWIG_3")]
  public static extern void XMLToken_addAttr__SWIG_3(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeAttr__SWIG_0")]
  public static extern void XMLToken_removeAttr__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeAttr__SWIG_1")]
  public static extern void XMLToken_removeAttr__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeAttr__SWIG_2")]
  public static extern void XMLToken_removeAttr__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeAttr__SWIG_3")]
  public static extern void XMLToken_removeAttr__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_clearAttributes")]
  public static extern void XMLToken_clearAttributes(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrIndex__SWIG_0")]
  public static extern int XMLToken_getAttrIndex__SWIG_0(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrIndex__SWIG_1")]
  public static extern int XMLToken_getAttrIndex__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrIndex__SWIG_2")]
  public static extern int XMLToken_getAttrIndex__SWIG_2(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttributesLength")]
  public static extern int XMLToken_getAttributesLength(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrName")]
  public static extern string XMLToken_getAttrName(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrPrefix")]
  public static extern string XMLToken_getAttrPrefix(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrPrefixedName")]
  public static extern string XMLToken_getAttrPrefixedName(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrURI")]
  public static extern string XMLToken_getAttrURI(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrValue__SWIG_0")]
  public static extern string XMLToken_getAttrValue__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrValue__SWIG_1")]
  public static extern string XMLToken_getAttrValue__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrValue__SWIG_2")]
  public static extern string XMLToken_getAttrValue__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getAttrValue__SWIG_3")]
  public static extern string XMLToken_getAttrValue__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasAttr__SWIG_0")]
  public static extern bool XMLToken_hasAttr__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasAttr__SWIG_1")]
  public static extern bool XMLToken_hasAttr__SWIG_1(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasAttr__SWIG_2")]
  public static extern bool XMLToken_hasAttr__SWIG_2(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasAttr__SWIG_3")]
  public static extern bool XMLToken_hasAttr__SWIG_3(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isAttributesEmpty")]
  public static extern bool XMLToken_isAttributesEmpty(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaces")]
  public static extern IntPtr XMLToken_getNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_setNamespaces")]
  public static extern void XMLToken_setNamespaces(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addNamespace__SWIG_0")]
  public static extern void XMLToken_addNamespace__SWIG_0(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_addNamespace__SWIG_1")]
  public static extern void XMLToken_addNamespace__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeNamespace__SWIG_0")]
  public static extern void XMLToken_removeNamespace__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_removeNamespace__SWIG_1")]
  public static extern void XMLToken_removeNamespace__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_clearNamespaces")]
  public static extern void XMLToken_clearNamespaces(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaceIndex")]
  public static extern int XMLToken_getNamespaceIndex(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaceIndexByPrefix")]
  public static extern int XMLToken_getNamespaceIndexByPrefix(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespacesLength")]
  public static extern int XMLToken_getNamespacesLength(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespacePrefix__SWIG_0")]
  public static extern string XMLToken_getNamespacePrefix__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespacePrefix__SWIG_1")]
  public static extern string XMLToken_getNamespacePrefix__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaceURI__SWIG_0")]
  public static extern string XMLToken_getNamespaceURI__SWIG_0(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaceURI__SWIG_1")]
  public static extern string XMLToken_getNamespaceURI__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getNamespaceURI__SWIG_2")]
  public static extern string XMLToken_getNamespaceURI__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isNamespacesEmpty")]
  public static extern bool XMLToken_isNamespacesEmpty(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasNamespaceURI")]
  public static extern bool XMLToken_hasNamespaceURI(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasNamespacePrefix")]
  public static extern bool XMLToken_hasNamespacePrefix(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_hasNamespaceNS")]
  public static extern bool XMLToken_hasNamespaceNS(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_setTriple")]
  public static extern void XMLToken_setTriple(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getName")]
  public static extern string XMLToken_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getPrefix")]
  public static extern string XMLToken_getPrefix(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getURI")]
  public static extern string XMLToken_getURI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getCharacters")]
  public static extern string XMLToken_getCharacters(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_append")]
  public static extern void XMLToken_append(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getColumn")]
  public static extern uint XMLToken_getColumn(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_getLine")]
  public static extern uint XMLToken_getLine(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isElement")]
  public static extern bool XMLToken_isElement(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isEnd")]
  public static extern bool XMLToken_isEnd(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isEndFor")]
  public static extern bool XMLToken_isEndFor(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isEOF")]
  public static extern bool XMLToken_isEOF(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isStart")]
  public static extern bool XMLToken_isStart(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_isText")]
  public static extern bool XMLToken_isText(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_setEnd")]
  public static extern void XMLToken_setEnd(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_setEOF")]
  public static extern void XMLToken_setEOF(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_unsetEnd")]
  public static extern void XMLToken_unsetEnd(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_write")]
  public static extern void XMLToken_write(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLToken_toString")]
  public static extern string XMLToken_toString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_0")]
  public static extern IntPtr new_XMLNode__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_1")]
  public static extern IntPtr new_XMLNode__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_2")]
  public static extern IntPtr new_XMLNode__SWIG_2(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, long jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_3")]
  public static extern IntPtr new_XMLNode__SWIG_3(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_4")]
  public static extern IntPtr new_XMLNode__SWIG_4(HandleRef jarg1, HandleRef jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_5")]
  public static extern IntPtr new_XMLNode__SWIG_5(HandleRef jarg1, HandleRef jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_6")]
  public static extern IntPtr new_XMLNode__SWIG_6(HandleRef jarg1, HandleRef jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_7")]
  public static extern IntPtr new_XMLNode__SWIG_7(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_8")]
  public static extern IntPtr new_XMLNode__SWIG_8(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_9")]
  public static extern IntPtr new_XMLNode__SWIG_9(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_10")]
  public static extern IntPtr new_XMLNode__SWIG_10(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_11")]
  public static extern IntPtr new_XMLNode__SWIG_11(string jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_12")]
  public static extern IntPtr new_XMLNode__SWIG_12(string jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_13")]
  public static extern IntPtr new_XMLNode__SWIG_13(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_14")]
  public static extern IntPtr new_XMLNode__SWIG_14(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLNode")]
  public static extern void delete_XMLNode(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLNode__SWIG_15")]
  public static extern IntPtr new_XMLNode__SWIG_15(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_clone")]
  public static extern IntPtr XMLNode_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_addChild")]
  public static extern void XMLNode_addChild(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_insertChild")]
  public static extern IntPtr XMLNode_insertChild(HandleRef jarg1, long jarg2, HandleRef jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_removeChild")]
  public static extern IntPtr XMLNode_removeChild(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_removeChildren")]
  public static extern void XMLNode_removeChildren(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_getChild__SWIG_0")]
  public static extern IntPtr XMLNode_getChild__SWIG_0(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_getNumChildren")]
  public static extern uint XMLNode_getNumChildren(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_write")]
  public static extern void XMLNode_write(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_toXMLString")]
  public static extern string XMLNode_toXMLString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_convertXMLNodeToString")]
  public static extern string XMLNode_convertXMLNodeToString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_convertStringToXMLNode__SWIG_0")]
  public static extern IntPtr XMLNode_convertStringToXMLNode__SWIG_0(string jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNode_convertStringToXMLNode__SWIG_1")]
  public static extern IntPtr XMLNode_convertStringToXMLNode__SWIG_1(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLTriple__SWIG_0")]
  public static extern IntPtr new_XMLTriple__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLTriple__SWIG_1")]
  public static extern IntPtr new_XMLTriple__SWIG_1(string jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLTriple__SWIG_2")]
  public static extern IntPtr new_XMLTriple__SWIG_2(string jarg1, char jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLTriple__SWIG_3")]
  public static extern IntPtr new_XMLTriple__SWIG_3(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLTriple__SWIG_4")]
  public static extern IntPtr new_XMLTriple__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_clone")]
  public static extern IntPtr XMLTriple_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_getName")]
  public static extern string XMLTriple_getName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_getPrefix")]
  public static extern string XMLTriple_getPrefix(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_getURI")]
  public static extern string XMLTriple_getURI(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_getPrefixedName")]
  public static extern string XMLTriple_getPrefixedName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTriple_isEmpty")]
  public static extern bool XMLTriple_isEmpty(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLTriple")]
  public static extern void delete_XMLTriple(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLInputStream__SWIG_0")]
  public static extern IntPtr new_XMLInputStream__SWIG_0(string jarg1, bool jarg2, string jarg3, HandleRef jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLInputStream__SWIG_1")]
  public static extern IntPtr new_XMLInputStream__SWIG_1(string jarg1, bool jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLInputStream__SWIG_2")]
  public static extern IntPtr new_XMLInputStream__SWIG_2(string jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLInputStream__SWIG_3")]
  public static extern IntPtr new_XMLInputStream__SWIG_3(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLInputStream")]
  public static extern void delete_XMLInputStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_getEncoding")]
  public static extern string XMLInputStream_getEncoding(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_getVersion")]
  public static extern string XMLInputStream_getVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_getErrorLog")]
  public static extern IntPtr XMLInputStream_getErrorLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_isEOF")]
  public static extern bool XMLInputStream_isEOF(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_isError")]
  public static extern bool XMLInputStream_isError(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_isGood")]
  public static extern bool XMLInputStream_isGood(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_next")]
  public static extern IntPtr XMLInputStream_next(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_peek")]
  public static extern IntPtr XMLInputStream_peek(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_skipPastEnd")]
  public static extern void XMLInputStream_skipPastEnd(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_skipText")]
  public static extern void XMLInputStream_skipText(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_setErrorLog")]
  public static extern void XMLInputStream_setErrorLog(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLInputStream_toString")]
  public static extern string XMLInputStream_toString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOutputStream__SWIG_0")]
  public static extern IntPtr new_XMLOutputStream__SWIG_0(HandleRef jarg1, string jarg2, bool jarg3, string jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOutputStream__SWIG_1")]
  public static extern IntPtr new_XMLOutputStream__SWIG_1(HandleRef jarg1, string jarg2, bool jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOutputStream__SWIG_2")]
  public static extern IntPtr new_XMLOutputStream__SWIG_2(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOutputStream__SWIG_3")]
  public static extern IntPtr new_XMLOutputStream__SWIG_3(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLOutputStream__SWIG_4")]
  public static extern IntPtr new_XMLOutputStream__SWIG_4(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_endElement__SWIG_0")]
  public static extern void XMLOutputStream_endElement__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_endElement__SWIG_1")]
  public static extern void XMLOutputStream_endElement__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_setAutoIndent")]
  public static extern void XMLOutputStream_setAutoIndent(HandleRef jarg1, bool jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_startElement__SWIG_0")]
  public static extern void XMLOutputStream_startElement__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_startElement__SWIG_1")]
  public static extern void XMLOutputStream_startElement__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_startEndElement__SWIG_0")]
  public static extern void XMLOutputStream_startEndElement__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_startEndElement__SWIG_1")]
  public static extern void XMLOutputStream_startEndElement__SWIG_1(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_0")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_0(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_1")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_1(HandleRef jarg1, HandleRef jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_2")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_2(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_3")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_3(HandleRef jarg1, HandleRef jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_4")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_4(HandleRef jarg1, string jarg2, double jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_5")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_5(HandleRef jarg1, HandleRef jarg2, double jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_6")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_6(HandleRef jarg1, string jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeAttribute__SWIG_7")]
  public static extern void XMLOutputStream_writeAttribute__SWIG_7(HandleRef jarg1, HandleRef jarg2, int jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeXMLDecl")]
  public static extern void XMLOutputStream_writeXMLDecl(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_writeComment")]
  public static extern void XMLOutputStream_writeComment(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_downIndent")]
  public static extern void XMLOutputStream_downIndent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_upIndent")]
  public static extern void XMLOutputStream_upIndent(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLOutputStream_getStringStream")]
  public static extern bool XMLOutputStream_getStringStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLOutputStream")]
  public static extern void delete_XMLOutputStream(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_0")]
  public static extern IntPtr new_XMLError__SWIG_0(int jarg1, string jarg2, long jarg3, long jarg4, long jarg5, long jarg6);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_1")]
  public static extern IntPtr new_XMLError__SWIG_1(int jarg1, string jarg2, long jarg3, long jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_2")]
  public static extern IntPtr new_XMLError__SWIG_2(int jarg1, string jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_3")]
  public static extern IntPtr new_XMLError__SWIG_3(int jarg1, string jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_4")]
  public static extern IntPtr new_XMLError__SWIG_4(int jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_5")]
  public static extern IntPtr new_XMLError__SWIG_5(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_6")]
  public static extern IntPtr new_XMLError__SWIG_6();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLError__SWIG_7")]
  public static extern IntPtr new_XMLError__SWIG_7(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLError")]
  public static extern void delete_XMLError(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getErrorId")]
  public static extern uint XMLError_getErrorId(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getMessage")]
  public static extern string XMLError_getMessage(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getShortMessage")]
  public static extern string XMLError_getShortMessage(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getLine")]
  public static extern uint XMLError_getLine(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getColumn")]
  public static extern uint XMLError_getColumn(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getSeverity")]
  public static extern uint XMLError_getSeverity(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getSeverityAsString")]
  public static extern string XMLError_getSeverityAsString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getCategory")]
  public static extern uint XMLError_getCategory(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getCategoryAsString")]
  public static extern string XMLError_getCategoryAsString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isInfo")]
  public static extern bool XMLError_isInfo(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isWarning")]
  public static extern bool XMLError_isWarning(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isError")]
  public static extern bool XMLError_isError(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isFatal")]
  public static extern bool XMLError_isFatal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isInternal")]
  public static extern bool XMLError_isInternal(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isSystem")]
  public static extern bool XMLError_isSystem(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_isXML")]
  public static extern bool XMLError_isXML(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_setLine")]
  public static extern void XMLError_setLine(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_setColumn")]
  public static extern void XMLError_setColumn(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLError_getStandardMessage")]
  public static extern string XMLError_getStandardMessage(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_getNumErrors")]
  public static extern uint XMLErrorLog_getNumErrors(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_getError")]
  public static extern IntPtr XMLErrorLog_getError(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_clearLog")]
  public static extern void XMLErrorLog_clearLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLErrorLog")]
  public static extern IntPtr new_XMLErrorLog();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLErrorLog")]
  public static extern void delete_XMLErrorLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_add")]
  public static extern void XMLErrorLog_add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLErrorLog_setParser")]
  public static extern void XMLErrorLog_setParser(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLHandler")]
  public static extern IntPtr new_XMLHandler();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLHandler")]
  public static extern void delete_XMLHandler(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLHandler_startDocument")]
  public static extern void XMLHandler_startDocument(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLHandler_XML")]
  public static extern void XMLHandler_XML(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLHandler_startElement")]
  public static extern void XMLHandler_startElement(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLHandler_endDocument")]
  public static extern void XMLHandler_endDocument(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLHandler_endElement")]
  public static extern void XMLHandler_endElement(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLHandler_characters")]
  public static extern void XMLHandler_characters(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_create__SWIG_0")]
  public static extern IntPtr XMLParser_create__SWIG_0(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_create__SWIG_1")]
  public static extern IntPtr XMLParser_create__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLParser")]
  public static extern void delete_XMLParser(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_parse__SWIG_0")]
  public static extern bool XMLParser_parse__SWIG_0(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_parse__SWIG_1")]
  public static extern bool XMLParser_parse__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_parseFirst__SWIG_0")]
  public static extern bool XMLParser_parseFirst__SWIG_0(HandleRef jarg1, string jarg2, bool jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_parseFirst__SWIG_1")]
  public static extern bool XMLParser_parseFirst__SWIG_1(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_parseNext")]
  public static extern bool XMLParser_parseNext(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_parseReset")]
  public static extern void XMLParser_parseReset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_getColumn")]
  public static extern uint XMLParser_getColumn(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_getLine")]
  public static extern uint XMLParser_getLine(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_getErrorLog")]
  public static extern IntPtr XMLParser_getErrorLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLParser_setErrorLog")]
  public static extern void XMLParser_setErrorLog(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_XMLTokenizer")]
  public static extern IntPtr new_XMLTokenizer();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_XMLTokenizer")]
  public static extern void delete_XMLTokenizer(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_getEncoding")]
  public static extern string XMLTokenizer_getEncoding(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_getVersion")]
  public static extern string XMLTokenizer_getVersion(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_hasNext")]
  public static extern bool XMLTokenizer_hasNext(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_isEOF")]
  public static extern bool XMLTokenizer_isEOF(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_next")]
  public static extern IntPtr XMLTokenizer_next(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_peek")]
  public static extern IntPtr XMLTokenizer_peek(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_toString")]
  public static extern string XMLTokenizer_toString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_XML")]
  public static extern void XMLTokenizer_XML(HandleRef jarg1, string jarg2, string jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_startElement")]
  public static extern void XMLTokenizer_startElement(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_endDocument")]
  public static extern void XMLTokenizer_endDocument(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_endElement")]
  public static extern void XMLTokenizer_endElement(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizer_characters")]
  public static extern void XMLTokenizer_characters(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_getError")]
  public static extern IntPtr SBMLErrorLog_getError(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_getNumFailsWithSeverity")]
  public static extern uint SBMLErrorLog_getNumFailsWithSeverity(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLErrorLog")]
  public static extern IntPtr new_SBMLErrorLog();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLErrorLog")]
  public static extern void delete_SBMLErrorLog(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_0")]
  public static extern void SBMLErrorLog_logError__SWIG_0(HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6, long jarg7, long jarg8, long jarg9);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_1")]
  public static extern void SBMLErrorLog_logError__SWIG_1(HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6, long jarg7, long jarg8);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_2")]
  public static extern void SBMLErrorLog_logError__SWIG_2(HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6, long jarg7);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_3")]
  public static extern void SBMLErrorLog_logError__SWIG_3(HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5, long jarg6);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_4")]
  public static extern void SBMLErrorLog_logError__SWIG_4(HandleRef jarg1, long jarg2, long jarg3, long jarg4, string jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_5")]
  public static extern void SBMLErrorLog_logError__SWIG_5(HandleRef jarg1, long jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_6")]
  public static extern void SBMLErrorLog_logError__SWIG_6(HandleRef jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_7")]
  public static extern void SBMLErrorLog_logError__SWIG_7(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_logError__SWIG_8")]
  public static extern void SBMLErrorLog_logError__SWIG_8(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_add")]
  public static extern void SBMLErrorLog_add(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLog_remove")]
  public static extern void SBMLErrorLog_remove(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_0")]
  public static extern IntPtr new_SBMLError__SWIG_0(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6, long jarg7, long jarg8);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_1")]
  public static extern IntPtr new_SBMLError__SWIG_1(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6, long jarg7);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_2")]
  public static extern IntPtr new_SBMLError__SWIG_2(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5, long jarg6);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_3")]
  public static extern IntPtr new_SBMLError__SWIG_3(long jarg1, long jarg2, long jarg3, string jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_4")]
  public static extern IntPtr new_SBMLError__SWIG_4(long jarg1, long jarg2, long jarg3, string jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_5")]
  public static extern IntPtr new_SBMLError__SWIG_5(long jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_6")]
  public static extern IntPtr new_SBMLError__SWIG_6(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_7")]
  public static extern IntPtr new_SBMLError__SWIG_7(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_8")]
  public static extern IntPtr new_SBMLError__SWIG_8();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_SBMLError__SWIG_9")]
  public static extern IntPtr new_SBMLError__SWIG_9(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_SBMLError")]
  public static extern void delete_SBMLError(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CVTerm__SWIG_0")]
  public static extern IntPtr new_CVTerm__SWIG_0(int jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CVTerm__SWIG_1")]
  public static extern IntPtr new_CVTerm__SWIG_1();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CVTerm__SWIG_2")]
  public static extern IntPtr new_CVTerm__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_CVTerm")]
  public static extern void delete_CVTerm(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_CVTerm__SWIG_3")]
  public static extern IntPtr new_CVTerm__SWIG_3(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_clone")]
  public static extern IntPtr CVTerm_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getQualifierType")]
  public static extern int CVTerm_getQualifierType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getModelQualifierType")]
  public static extern int CVTerm_getModelQualifierType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getBiologicalQualifierType")]
  public static extern int CVTerm_getBiologicalQualifierType(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getResources__SWIG_0")]
  public static extern IntPtr CVTerm_getResources__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getNumResources")]
  public static extern uint CVTerm_getNumResources(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_getResourceURI")]
  public static extern string CVTerm_getResourceURI(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_setQualifierType")]
  public static extern void CVTerm_setQualifierType(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_setModelQualifierType")]
  public static extern void CVTerm_setModelQualifierType(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_setBiologicalQualifierType")]
  public static extern void CVTerm_setBiologicalQualifierType(HandleRef jarg1, int jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_addResource")]
  public static extern void CVTerm_addResource(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CVTerm_removeResource")]
  public static extern void CVTerm_removeResource(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_0")]
  public static extern IntPtr new_Date__SWIG_0(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6, long jarg7, long jarg8, long jarg9);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_1")]
  public static extern IntPtr new_Date__SWIG_1(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6, long jarg7, long jarg8);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_2")]
  public static extern IntPtr new_Date__SWIG_2(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6, long jarg7);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_3")]
  public static extern IntPtr new_Date__SWIG_3(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5, long jarg6);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_4")]
  public static extern IntPtr new_Date__SWIG_4(long jarg1, long jarg2, long jarg3, long jarg4, long jarg5);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_5")]
  public static extern IntPtr new_Date__SWIG_5(long jarg1, long jarg2, long jarg3, long jarg4);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_6")]
  public static extern IntPtr new_Date__SWIG_6(long jarg1, long jarg2, long jarg3);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_7")]
  public static extern IntPtr new_Date__SWIG_7(long jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_8")]
  public static extern IntPtr new_Date__SWIG_8(long jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_9")]
  public static extern IntPtr new_Date__SWIG_9();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_10")]
  public static extern IntPtr new_Date__SWIG_10(string jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_Date")]
  public static extern void delete_Date(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_Date__SWIG_11")]
  public static extern IntPtr new_Date__SWIG_11(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_clone")]
  public static extern IntPtr Date_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getYear")]
  public static extern uint Date_getYear(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getMonth")]
  public static extern uint Date_getMonth(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getDay")]
  public static extern uint Date_getDay(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getHour")]
  public static extern uint Date_getHour(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getMinute")]
  public static extern uint Date_getMinute(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getSecond")]
  public static extern uint Date_getSecond(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getSignOffset")]
  public static extern uint Date_getSignOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getHoursOffset")]
  public static extern uint Date_getHoursOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getMinutesOffset")]
  public static extern uint Date_getMinutesOffset(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_getDateAsString")]
  public static extern string Date_getDateAsString(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setYear")]
  public static extern void Date_setYear(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setMonth")]
  public static extern void Date_setMonth(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setDay")]
  public static extern void Date_setDay(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setHour")]
  public static extern void Date_setHour(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setMinute")]
  public static extern void Date_setMinute(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setSecond")]
  public static extern void Date_setSecond(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setSignOffset")]
  public static extern void Date_setSignOffset(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setHoursOffset")]
  public static extern void Date_setHoursOffset(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setMinutesOffset")]
  public static extern void Date_setMinutesOffset(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_Date_setDateAsString")]
  public static extern void Date_setDateAsString(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModelCreator__SWIG_0")]
  public static extern IntPtr new_ModelCreator__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModelCreator__SWIG_1")]
  public static extern IntPtr new_ModelCreator__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ModelCreator")]
  public static extern void delete_ModelCreator(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModelCreator__SWIG_2")]
  public static extern IntPtr new_ModelCreator__SWIG_2(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_clone")]
  public static extern IntPtr ModelCreator_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_getFamilyName")]
  public static extern string ModelCreator_getFamilyName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_getGivenName")]
  public static extern string ModelCreator_getGivenName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_getEmail")]
  public static extern string ModelCreator_getEmail(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_getOrganization")]
  public static extern string ModelCreator_getOrganization(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_getOrganisation")]
  public static extern string ModelCreator_getOrganisation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_isSetFamilyName")]
  public static extern bool ModelCreator_isSetFamilyName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_isSetGivenName")]
  public static extern bool ModelCreator_isSetGivenName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_isSetEmail")]
  public static extern bool ModelCreator_isSetEmail(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_isSetOrganization")]
  public static extern bool ModelCreator_isSetOrganization(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_isSetOrganisation")]
  public static extern bool ModelCreator_isSetOrganisation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_setFamilyName")]
  public static extern void ModelCreator_setFamilyName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_setGivenName")]
  public static extern void ModelCreator_setGivenName(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_setEmail")]
  public static extern void ModelCreator_setEmail(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_setOrganization")]
  public static extern void ModelCreator_setOrganization(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_setOrganisation")]
  public static extern void ModelCreator_setOrganisation(HandleRef jarg1, string jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_unsetFamilyName")]
  public static extern void ModelCreator_unsetFamilyName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_unsetGivenName")]
  public static extern void ModelCreator_unsetGivenName(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_unsetEmail")]
  public static extern void ModelCreator_unsetEmail(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_unsetOrganization")]
  public static extern void ModelCreator_unsetOrganization(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelCreator_unsetOrganisation")]
  public static extern void ModelCreator_unsetOrganisation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModelHistory__SWIG_0")]
  public static extern IntPtr new_ModelHistory__SWIG_0();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_ModelHistory")]
  public static extern void delete_ModelHistory(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_ModelHistory__SWIG_1")]
  public static extern IntPtr new_ModelHistory__SWIG_1(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_clone")]
  public static extern IntPtr ModelHistory_clone(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getCreatedDate")]
  public static extern IntPtr ModelHistory_getCreatedDate(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getModifiedDate__SWIG_0")]
  public static extern IntPtr ModelHistory_getModifiedDate__SWIG_0(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_isSetCreatedDate")]
  public static extern bool ModelHistory_isSetCreatedDate(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_isSetModifiedDate")]
  public static extern bool ModelHistory_isSetModifiedDate(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_setCreatedDate")]
  public static extern void ModelHistory_setCreatedDate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_setModifiedDate")]
  public static extern void ModelHistory_setModifiedDate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_addModifiedDate")]
  public static extern void ModelHistory_addModifiedDate(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getModifiedDate__SWIG_1")]
  public static extern IntPtr ModelHistory_getModifiedDate__SWIG_1(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getNumModifiedDates")]
  public static extern uint ModelHistory_getNumModifiedDates(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_addCreator")]
  public static extern void ModelHistory_addCreator(HandleRef jarg1, HandleRef jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getCreator")]
  public static extern IntPtr ModelHistory_getCreator(HandleRef jarg1, long jarg2);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelHistory_getNumCreators")]
  public static extern uint ModelHistory_getNumCreators(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseRDFAnnotation")]
  public static extern IntPtr RDFAnnotationParser_parseRDFAnnotation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_createAnnotation")]
  public static extern IntPtr RDFAnnotationParser_createAnnotation();

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_createRDFAnnotation")]
  public static extern IntPtr RDFAnnotationParser_createRDFAnnotation();

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_deleteRDFAnnotation")]
  public static extern IntPtr RDFAnnotationParser_deleteRDFAnnotation(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_createRDFDescription")]
  public static extern IntPtr RDFAnnotationParser_createRDFDescription(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_createCVTerms")]
  public static extern IntPtr RDFAnnotationParser_createCVTerms(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseCVTerms")]
  public static extern IntPtr RDFAnnotationParser_parseCVTerms(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RDFAnnotationParser_parseModelHistory")]
  public static extern IntPtr RDFAnnotationParser_parseModelHistory(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_new_RDFAnnotationParser")]
  public static extern IntPtr new_RDFAnnotationParser();

  [DllImport("libsbmlcs", EntryPoint="CSharp_delete_RDFAnnotationParser")]
  public static extern void delete_RDFAnnotationParser(HandleRef jarg1);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OFStreamUpcast")]
  public static extern IntPtr OFStreamUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_OStringStreamUpcast")]
  public static extern IntPtr OStringStreamUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUpcast")]
  public static extern IntPtr ListOfUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModelUpcast")]
  public static extern IntPtr ModelUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLDocumentUpcast")]
  public static extern IntPtr SBMLDocumentUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_FunctionDefinitionUpcast")]
  public static extern IntPtr FunctionDefinitionUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfFunctionDefinitionsUpcast")]
  public static extern IntPtr ListOfFunctionDefinitionsUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitUpcast")]
  public static extern IntPtr UnitUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitsUpcast")]
  public static extern IntPtr ListOfUnitsUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_UnitDefinitionUpcast")]
  public static extern IntPtr UnitDefinitionUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfUnitDefinitionsUpcast")]
  public static extern IntPtr ListOfUnitDefinitionsUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentTypeUpcast")]
  public static extern IntPtr CompartmentTypeUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentTypesUpcast")]
  public static extern IntPtr ListOfCompartmentTypesUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesTypeUpcast")]
  public static extern IntPtr SpeciesTypeUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesTypesUpcast")]
  public static extern IntPtr ListOfSpeciesTypesUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_CompartmentUpcast")]
  public static extern IntPtr CompartmentUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfCompartmentsUpcast")]
  public static extern IntPtr ListOfCompartmentsUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesUpcast")]
  public static extern IntPtr SpeciesUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesUpcast")]
  public static extern IntPtr ListOfSpeciesUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ParameterUpcast")]
  public static extern IntPtr ParameterUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfParametersUpcast")]
  public static extern IntPtr ListOfParametersUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_InitialAssignmentUpcast")]
  public static extern IntPtr InitialAssignmentUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfInitialAssignmentsUpcast")]
  public static extern IntPtr ListOfInitialAssignmentsUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RuleUpcast")]
  public static extern IntPtr RuleUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AlgebraicRuleUpcast")]
  public static extern IntPtr AlgebraicRuleUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_AssignmentRuleUpcast")]
  public static extern IntPtr AssignmentRuleUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_RateRuleUpcast")]
  public static extern IntPtr RateRuleUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfRulesUpcast")]
  public static extern IntPtr ListOfRulesUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ConstraintUpcast")]
  public static extern IntPtr ConstraintUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfConstraintsUpcast")]
  public static extern IntPtr ListOfConstraintsUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ReactionUpcast")]
  public static extern IntPtr ReactionUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfReactionsUpcast")]
  public static extern IntPtr ListOfReactionsUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_KineticLawUpcast")]
  public static extern IntPtr KineticLawUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SimpleSpeciesReferenceUpcast")]
  public static extern IntPtr SimpleSpeciesReferenceUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SpeciesReferenceUpcast")]
  public static extern IntPtr SpeciesReferenceUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ModifierSpeciesReferenceUpcast")]
  public static extern IntPtr ModifierSpeciesReferenceUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfSpeciesReferencesUpcast")]
  public static extern IntPtr ListOfSpeciesReferencesUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventUpcast")]
  public static extern IntPtr EventUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventsUpcast")]
  public static extern IntPtr ListOfEventsUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_EventAssignmentUpcast")]
  public static extern IntPtr EventAssignmentUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_ListOfEventAssignmentsUpcast")]
  public static extern IntPtr ListOfEventAssignmentsUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_TriggerUpcast")]
  public static extern IntPtr TriggerUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_DelayUpcast")]
  public static extern IntPtr DelayUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_StoichiometryMathUpcast")]
  public static extern IntPtr StoichiometryMathUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLNodeUpcast")]
  public static extern IntPtr XMLNodeUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_XMLTokenizerUpcast")]
  public static extern IntPtr XMLTokenizerUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorLogUpcast")]
  public static extern IntPtr SBMLErrorLogUpcast(IntPtr objectRef);

  [DllImport("libsbmlcs", EntryPoint="CSharp_SBMLErrorUpcast")]
  public static extern IntPtr SBMLErrorUpcast(IntPtr objectRef);
}

}
