/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "shortkey.h"
#include <QPixmap>
#include <QPainter>

int shortKey::getShortkeyKey(QString shortkey){
int i=shortkey.indexOf("+",1);
QString s=shortkey;
if (i>0) {
  s=s.mid(i+1).trimmed().left(1);
} else
s=s.trimmed().left(1);
if (s=="1") return Qt::Key_1;
if (s=="2") return Qt::Key_2;
if (s=="3") return Qt::Key_3;
if (s=="4") return Qt::Key_4;
if (s=="5") return Qt::Key_5;
if (s=="6") return Qt::Key_6;
if (s=="7") return Qt::Key_7;
if (s=="8") return Qt::Key_8;
if (s=="9") return Qt::Key_9;
if (s=="0") return Qt::Key_0;
if (s=="a") return Qt::Key_A;
if (s=="b") return Qt::Key_B;
if (s=="c") return Qt::Key_C;
if (s=="d") return Qt::Key_D;
if (s=="e") return Qt::Key_E;
if (s=="f") return Qt::Key_F;
if (s=="g") return Qt::Key_G;
if (s=="h") return Qt::Key_H;
if (s=="i") return Qt::Key_I;
if (s=="j") return Qt::Key_J;
if (s=="k") return Qt::Key_K;
if (s=="l") return Qt::Key_L;
if (s=="m") return Qt::Key_M;
if (s=="n") return Qt::Key_N;
if (s=="o") return Qt::Key_O;
if (s=="p") return Qt::Key_P;
if (s=="q") return Qt::Key_Q;
if (s=="r") return Qt::Key_R;
if (s=="s") return Qt::Key_S;
if (s=="t") return Qt::Key_T;
if (s=="u") return Qt::Key_U;
if (s=="v") return Qt::Key_V;
if (s=="w") return Qt::Key_W;
if (s=="x") return Qt::Key_X;
if (s=="y") return Qt::Key_Y;
if (s=="z") return Qt::Key_Z;
if (s=="+") return Qt::Key_Plus;
if (s=="-") return Qt::Key_Minus;
if (s==",") return Qt::Key_Comma;
if (s=="*") return Qt::Key_Asterisk;
if (s=="F1") return Qt::Key_F1;
if (s=="F2") return Qt::Key_F2;
if (s=="F3") return Qt::Key_F3;
if (s=="F4") return Qt::Key_F4;
if (s=="F5") return Qt::Key_F5;
if (s=="F6") return Qt::Key_F6;
if (s=="F7") return Qt::Key_F7;
if (s=="F8") return Qt::Key_F8;
if (s=="F9") return Qt::Key_F9;
if (s=="F10") return Qt::Key_F10;
if (s=="F11") return Qt::Key_F11;
if (s=="F12") return Qt::Key_F12;
if (s=="Insert") return Qt::Key_Insert;
if (s=="Delete") return Qt::Key_Delete;
if (s=="Clear") return Qt::Key_Clear;
if (s=="Home") return Qt::Key_Home;
if (s=="End") return Qt::Key_End;
if (s=="Left") return Qt::Key_Left;
if (s=="Up") return Qt::Key_Up;
if (s=="Right") return Qt::Key_Right;
if (s=="Down") return Qt::Key_Down;
if (s=="PageUp") return Qt::Key_PageUp;
if (s=="PageDown") return Qt::Key_PageDown;
if (s=="Space") return Qt::Key_Space;
if (s=="\"") return Qt::Key_QuoteDbl;
if (s=="#") return Qt::Key_NumberSign;
if (s=="$") return Qt::Key_Dollar;
if (s=="%") return Qt::Key_Percent;
if (s=="&") return Qt::Key_Ampersand;
if (s=="'") return Qt::Key_Apostrophe;
if (s=="(") return Qt::Key_ParenLeft;
if (s==")") return Qt::Key_ParenRight;
if (s==":") return Qt::Key_Colon;
if (s==";") return Qt::Key_Semicolon;
if (s=="?") return Qt::Key_Question;
if (s=="<") return Qt::Key_Less;
if (s=="=") return Qt::Key_Equal;
if (s==">") return Qt::Key_Greater;
if (s=="@") return Qt::Key_At;
return 0;
}
 
QString shortKey::getKey(int i){
	switch (i){
		case Qt::Key_1: return QString("1");
		case Qt::Key_2: return QString("2");
		case Qt::Key_3: return QString("3");
		case Qt::Key_4: return QString("4");
		case Qt::Key_5: return QString("5");
		case Qt::Key_6: return QString("6");
		case Qt::Key_7: return QString("7");
		case Qt::Key_8: return QString("8");
		case Qt::Key_9: return QString("9");
		case Qt::Key_0: return QString("0");
		case Qt::Key_A: return QString("a");
		case Qt::Key_B: return QString("b");
		case Qt::Key_C: return QString("c");
		case Qt::Key_D: return QString("d");
		case Qt::Key_E: return QString("e");
		case Qt::Key_F: return QString("f");
		case Qt::Key_G: return QString("g");
		case Qt::Key_H: return QString("h");
		case Qt::Key_I: return QString("i");
		case Qt::Key_J: return QString("j");
		case Qt::Key_K: return QString("k");
		case Qt::Key_L: return QString("l");
		case Qt::Key_M: return QString("m");
		case Qt::Key_N: return QString("n");
		case Qt::Key_O: return QString("o");
		case Qt::Key_P: return QString("p");
		case Qt::Key_Q: return QString("q");
		case Qt::Key_R: return QString("r");
		case Qt::Key_S: return QString("s");
		case Qt::Key_T: return QString("t");
		case Qt::Key_U: return QString("u");
		case Qt::Key_V: return QString("v");
		case Qt::Key_W: return QString("w");
		case Qt::Key_X: return QString("x");
		case Qt::Key_Y: return QString("y");
		case Qt::Key_Z: return QString("z");
		case Qt::Key_Plus: return QString("+");
		case Qt::Key_Comma: return QString(",");
		case Qt::Key_Asterisk: return QString("*");
		case Qt::Key_Minus: return QString("-");
		case Qt::Key_F1: return QString("F1");
		case Qt::Key_F2: return QString("F2");
		case Qt::Key_F3: return QString("F3");
		case Qt::Key_F4: return QString("F4");
		case Qt::Key_F5: return QString("F5");
		case Qt::Key_F6: return QString("F6");
		case Qt::Key_F7: return QString("F7");
		case Qt::Key_F8: return QString("F8");
		case Qt::Key_F9: return QString("F9");
		case Qt::Key_F10: return QString("F10");
		case Qt::Key_F11: return QString("F11");
		case Qt::Key_F12: return QString("F12");
		case Qt::Key_Insert: return QString("Insert");
		case Qt::Key_Delete: return QString("Delete");
		case Qt::Key_Clear: return QString("Clear");
		case Qt::Key_Home: return QString("Home");	
		case Qt::Key_End: return QString("End");
		case Qt::Key_Left: return QString("Left");
		case Qt::Key_Up: return QString("Up");
		case Qt::Key_Right: return QString("Right");
		case Qt::Key_Down: return QString("Down");
		case Qt::Key_PageUp: return QString("PageUp");
		case Qt::Key_PageDown: return QString("PageDown");
		case Qt::Key_Space: return QString("Space");
		case Qt::Key_QuoteDbl: return QString("\"");
		case Qt::Key_NumberSign: return QString("#");
		case Qt::Key_Dollar: return QString("$");
		case Qt::Key_Percent: return QString("%");
		case Qt::Key_Ampersand: return QString("&");
		case Qt::Key_Apostrophe: return QString("'");
		case Qt::Key_ParenLeft: return QString("(");
		case Qt::Key_ParenRight: return QString(")");
		case Qt::Key_Colon: return QString(":");
		case Qt::Key_Semicolon: return QString(";");
		case Qt::Key_Question: return QString("?");
		case Qt::Key_Less: return QString("<");
		case Qt::Key_Equal: return QString("=");
		case Qt::Key_Greater: return QString(">");
		case Qt::Key_At: return QString("@");
		default:
			return QString("none");
	}
return QString("none");
}


Qt::KeyboardModifiers shortKey::getShortkeyModifiers(QString shortkey){
int i=shortkey.indexOf("+");
QString s=shortkey;
if (i>=0) {
  s=s.left(i).trimmed();
} else
 return Qt::NoModifier;
//printf("%s\n",s.toAscii().data());
if (s== "shift")return Qt::ShiftModifier;
if (s== "Shift")return Qt::ShiftModifier;
if (s== "SHIFT")return Qt::ShiftModifier;
if (s== "ctrl")return Qt::ControlModifier;
if (s== "Ctrl")return Qt::ControlModifier;
if (s== "CTRL")return Qt::ControlModifier;
if (s== "alt")return Qt::AltModifier;
if (s== "ALT")return Qt::AltModifier;
if (s== "Alt")return Qt::AltModifier;
if (s== "Meta")return Qt::MetaModifier ;
if (s== "META")return Qt::MetaModifier ;

return Qt::NoModifier;

}

QString shortKey::getModifiers(Qt::KeyboardModifiers m){
if (m==Qt::ShiftModifier) return QString("Shift+");
if (m==Qt::ControlModifier) return QString("Ctrl+");
if (m==Qt::AltModifier) return QString("Alt+");
if (m==Qt::MetaModifier) return QString("Meta+");
return QString("");
}

void shortKey::paint(QWidget *w,QString key){
if (key=="") return;
  QString s=key;
  int i=s.indexOf("+",1);
  if (i>0) {
  	s=s.mid(i+1).trimmed();
	} 
  else
  s=s.trimmed();
  bool top=true;
   QPainter paint(w); 
  //paint.drawText(0,0,width(),height(),Qt::AlignLeft|Qt::AlignBottom,"ctrl");
  switch (getShortkeyModifiers(key)){
  case Qt::ShiftModifier:
	{
	QPixmap p(":/icons/shifticon.png");
	paint.drawPixmap(0,w->height()-p.height(),p);
	}
	break;
       //paint.drawText(0,0,w->width(),w->height(),Qt::AlignLeft|Qt::AlignBottom,"shift");; break;
  case Qt::ControlModifier: 
	{
	QPixmap p(":/icons/ctlicon.png");
	paint.drawPixmap(0,w->height()-p.height(),p);
	}
	break;
	//paint.drawText(0,0,w->width(),w->height(),Qt::AlignLeft|Qt::AlignBottom,"ctrl"); break;
  case Qt::AltModifier:
	{
	QPixmap p(":/icons/alticon.png");
	paint.drawPixmap(0,w->height()-p.height(),p);
	}
	break;
	//paint.drawText(0,0,w->width(),w->height(),Qt::AlignLeft|Qt::AlignBottom,"alt");break ;
  case Qt::MetaModifier:
	{
	QPixmap p(":/icons/metaicon.png");
	paint.drawPixmap(0,w->height()-p.height(),p);
	}
	break;
        //paint.drawText(0,0,w->width(),w->height(),Qt::AlignLeft|Qt::AlignBottom,"meta");break ;;break;
 default: top=false;
  }
  QPen pen(QColor(255,255,255));

  paint.setPen(pen);
  QFont f;
  if (s.length()>4)
    f=QFont("Arial", 5);
  else if (s.length()>3)
    f=QFont("Arial", 6);
  else if (s.length()>1)
    f=QFont("Arial", 8);
  else
    f=QFont("Arial", 10);
  f.setBold(true);
  paint.setFont(f);
  if (s=="Backspace") s="BSp";
  else if (s=="PgDown") s="PgDn";
//if (s.length()>5)
 //printf("%s\n",s.toAscii().data());
  if (!top) {
	paint.drawText(0,0,w->width()-2,w->height(),Qt::AlignCenter|Qt::TextWordWrap|Qt::TextDontClip,s);
	paint.drawText(0,0,w->width(),w->height()-2,Qt::AlignCenter|Qt::TextWordWrap|Qt::TextDontClip,s);
	paint.drawText(0+2,0,w->width(),w->height(),Qt::AlignCenter|Qt::TextWordWrap|Qt::TextDontClip,s);
	paint.drawText(0,0+2,w->width(),w->height(),Qt::AlignCenter|Qt::TextWordWrap|Qt::TextDontClip,s);
	QPen pen(QColor(0,0,0));
  	paint.setPen(pen);
	paint.drawText(0,0,w->width(),w->height(),Qt::AlignCenter|Qt::TextWordWrap|Qt::TextDontClip,s);
	}
	else {
	paint.drawText(0,0,w->width()-2,w->height()-4,Qt::AlignCenter|Qt::TextWordWrap|Qt::TextDontClip,s);
	paint.drawText(0,0,w->width(),w->height()-6,Qt::AlignCenter|Qt::TextWordWrap|Qt::TextDontClip,s);
	paint.drawText(0+2,0,w->width(),w->height()-4,Qt::AlignCenter|Qt::TextWordWrap|Qt::TextDontClip,s);
	paint.drawText(0,0+2,w->width(),w->height()-4,Qt::AlignCenter|Qt::TextWordWrap|Qt::TextDontClip,s);
	QPen pen(QColor(0,0,0));
  	paint.setPen(pen);
	paint.drawText(0,0,w->width(),w->height()-4,Qt::AlignCenter|Qt::TextWordWrap|Qt::TextDontClip,s);
	}
	  //  paint.drawText(0,0,w->width(),w->height()-4,Qt::AlignCenter,s);
  paint.end();
}
