/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "gridwidget.h"

#include <qimage.h>
#include <qstatusbar.h>
#include <qpainter.h>
//#include <q3paintdevicemetrics.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qstring.h>
//#include <q3whatsthis.h>
#include "icons/gridautoicon.xpm"
#include "icons/selectgridicon.xpm"
#include "dialog/helpwindow.h"
#include <QMenu>


gridwidget::gridwidget(QWidget *la ,QWidget *parent, const char *)
 : QWidget(parent)
{
  l=la;
QString s="This bar indicates mode and value of the grid.";
gridIcon=new QLabel(this);
gridIcon->setWhatsThis(s);
gridNumber=new QLabel(this);
gridNumber->setWhatsThis(s);
autoIcon = QPixmap(gridautoicon);
manualIcon = QPixmap(selectgridicon);
gridIcon->setPixmap(autoIcon);
gridNumber->setText("Auto");
setNormal();
}

void gridwidget::setSmall(){
setFixedSize(46,17);
gridIcon->setGeometry(0,0,20,17);
gridNumber->setGeometry(20,0,28,17);
}

void gridwidget::setNormal(){
setFixedSize(71,17);
gridIcon->setGeometry(0,0,20,17);
gridNumber->setGeometry(20,0,53,17);
}
    
gridwidget::~gridwidget()
{
delete gridIcon;
delete gridNumber;
}


void gridwidget::setGrid( QString s){
  gridNumber->setText(s);
}

void gridwidget::setAutoMode(bool b){
  if (b) {
	gridIcon->setPixmap(autoIcon);
  } else {
	gridIcon->setPixmap(manualIcon);
  }
}

void gridwidget::contextMenuEvent ( QContextMenuEvent * event) {
  if (QApplication::keyboardModifiers ()!=Qt::NoModifier) {event->ignore();return;}
  //printf("content menu requested\n");
#ifdef FULL_VERSION
QMenu menu;
menu.addAction(helpWindow::getIcon(setGridHelp),helpWindow::getMenuname(setGridHelp),l,SLOT(setGrid()));
menu.addAction(helpWindow::getIcon(increaseGridHelp),helpWindow::getMenuname(increaseGridHelp),l,SLOT(gridPlus()));
menu.addAction(helpWindow::getIcon(reduceGridHelp),helpWindow::getMenuname(reduceGridHelp),l,SLOT(gridMinus()));
menu.addAction(helpWindow::getIcon(autoGridHelp),helpWindow::getMenuname(autoGridHelp),l,SLOT(gridAuto()));
menu.addAction(helpWindow::getIcon(showGridHelp),helpWindow::getMenuname(showGridHelp),l,SLOT(showGridToggle()));
//menu.addSeparator();
// menu.addAction(helpWindow::getIcon(layerManagerHelp),helpWindow::getMenuname(layerManagerHelp),parent(),SLOT(openLayerManager()));
// reset layer
// restore layer
// store layer as
// menu.addSeparator();
//menu.addAction(helpWindow::getIcon(layerManagerHelp),helpWindow::getMenuname(layerManagerHelp),parent(),SLOT(openLayerManager()));
// layer setup ???
menu.exec(QCursor::pos());
#endif
}
