/***************************************************************************
 *   Copyright (C) 2007 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef STYLE_H
#define STYLE_H

#include <QStyleFactory>
#include <QCDEStyle>
#ifdef layout_style
#include "style/layoutstyle.h"
#endif

class mystyles {
public:
static QStringList existingStyles(){
QStringList l=QStyleFactory::keys ();
#ifdef layout_style
l<<"layout";
#endif
return l;
}
static QStyle* createStyle( const QString& key )
	{
#ifdef layout_style
		if ( key == "layout" )
	
			return new layoutStyle;
#endif
		QStyle *s=QStyleFactory::create(key);
		if (s!=NULL) return s;
		return new QCDEStyle;
	}

};
#endif
