/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "string.h"

/**
@author Juergen Thies
*/
string::string(): QString ()
{
	
}
string::string(const QString&s): QString (s)
{
	
}


string::~string()
{
}


QString string::parameter(QString s){
int i=indexOf(s+"=");
if (i<0) return QString("");
QString s2;
s2=mid(i+s.length()+1);
if (s2.length()==0) return QString("");
if (s2[0]=='\"') {
	s2=s2.mid(1);
	i=s2.indexOf("\"");
	s2=s2.left(i).trimmed();
	
	}
else { 
	i=s2.indexOf(" ");
	if (i>0) s2=s2.left(i).trimmed();
}
//printf("%s %d\n",s2.toAscii().data(),i);
return s2;
}

int string::matchParenthesis(int start){
  int end=indexOf(")",start);
  int open=indexOf("(",start+1);
  if (open<0) return end;
  if (end<0) return end;
  if (open>end) return end;
  int end2=matchParenthesis(open);
  return indexOf(")",end2+1);
}

double string::toEngDouble(){
  bool ok;
  double d=toDouble(&ok);
  if (ok) return d;
  string s= *this;
  double correct=1;
  if (s.contains("Y")){s.remove("Y");correct*=1E24;}
  if (s.contains("Z")){s.remove("Z");correct*=1E21;}
  if (s.contains("E")){s.remove("E");correct*=1E18;}
  if (s.contains("P")){s.remove("P");correct*=1E15;}
  if (s.contains("T")){s.remove("T");correct*=1E12;}
  if (s.contains("G")){s.remove("G");correct*=1E9;}
  if (s.contains("Meg")){s.remove("Meg");correct*=1E6;}
  if (s.contains("meg")){s.remove("meg");correct*=1E6;}
  if (s.contains("MEG")){s.remove("MEG");correct*=1E6;}
  if (s.contains("X")){s.remove("X");correct*=1E6;}
  if (s.contains("M")){s.remove("M");correct*=1E6;}
  if (s.contains("k")){s.remove("k");correct*=1E3;}
  if (s.contains("K")){s.remove("K");correct*=1E3;}
  if (s.contains("h")){s.remove("h");correct*=1E2;}
  if (s.contains("da")){s.remove("da");correct*=1E1;}
  if (s.contains("d")){s.remove("d");correct*=1E-1;}
  if (s.contains("c")){s.remove("c");correct*=1E-2;}
  if (s.contains("m")){s.remove("m");correct*=1E-3;}
  if (s.contains("")){s.remove("");correct*=1E-6;}
  if (s.contains("u")){s.remove("u");correct*=1E-6;}
  if (s.contains("n")){s.remove("n");correct*=1E-9;}
  if (s.contains("p")){s.remove("p");correct*=1E-12;}
  if (s.contains("f")){s.remove("f");correct*=1E-15;}
  if (s.contains("a")){s.remove("a");correct*=1E-18;}
  if (s.contains("z")){s.remove("z");correct*=1E-21;}
  if (s.contains("y")){s.remove("y");correct*=1E-24;}
  d=s.toDouble();
  d=d*correct;
  return d;
}
