/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "general/setup.h"
#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"

#include "elements/text.h"




void macro::setupHandler_registerKeywords(keywords **keyword_){
 *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="setup";
 (*keyword_)->type=intClass;
 (*keyword_)->r=new returnValue();
 (*keyword_)->classHandler=&macro::setupHandler_classHandler;
}

returnValue macro::setupHandler_classHandler(int *counter, keywords *keyword_,returnValue* ,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (!checkStaticClass(counter)) throw 19;
 p=next(counter);
 // methods
 if (((p.type==keyword)&&(p.value=="setBackgroundColor"))) {
 	testParenOpen(counter);
	variant p1=calculate(counter,keyword_);
    	testComma(counter);
	variant p2=calculate(counter,keyword_);
	testComma(counter);
	variant p3=calculate(counter,keyword_);
	testParenClose(counter);
	setup::setBackgroundColor(p1.getInt(),p2.getInt(), p3.getInt());
  	}
 else {
  error->addItem(tr("Class setup has no member ")+p.value,1,message((*counter)));
  throw 1;
 }
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}
