/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SVG_H
#define SVG_H
#include "general/layers.h"
#include <qobject.h>
#include "general/errorreport.h"
#include "filegeneral.h"
#include <QXmlStreamReader>
/**
@author Juergen Thies
*/
class drawingField;
class cell;
class element;
class cellList;
class svg : public QObject
{
Q_OBJECT
public:
    svg(QObject *parent = 0, const char *name = 0);

    ~svg();
static void open(QString filename,drawingField *);
static void import(QString filename,drawingField *);
static void update(QString filename,drawingField *);
static void save(QString filename,drawingField *);
QTextStream *str;
drawingField *df;
void savePos(QString,int);
void saveNum(QString,double);
QString convertNum(double);
QString convertPos(int);
void saveValue(QString,QString);
errorreport *error;
QString endOfLine;
private:
QTime svgTimer;
int counter;
errorreport report;
void load(QString filename,drawingField *,  fileOpenType type);
void read(QIODevice *device);
void readSvg();
void readEnd(bool ignore=false);
int getLayer();
int getColor(QString);
int getInt(QStringRef);
void processTransform(element *,QString);
pointArray getPoints(QString);
void setWidth(element *);
void setCap(element *);
element * getElement();
cell *c;
cell *mainCell;
cellList *cl;
void save(drawingField *,QTextStream *);
QXmlStreamReader *xml;
};

#endif
