/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CELLREFARRAY_H
#define CELLREFARRAY_H

#include "elements/element.h"
#include "elements/cell.h"
#include <qstring.h>
//Added by qt3to4:
#include "pointarray.h"
#include <QTextStream>
#include "strans.h"
/**
@author Juergen Thies
*/
class oasis;

class cellrefArray : public element {
public:
    QPoint point;
    int anz_x,anz_y;
    QPoint space_x,space_y;
    cell *cell_ref;
    QString name;
    strans trans;

    cellrefArray(cell *c,pointArray array,int anzx,int anzy);
    cellrefArray(cell *c,QPoint pos1, QPoint pos2,int anzx,int anzy);
    cellrefArray(cell *c,QPoint pos1, QPoint pos2,int anzx,int anzy,strans trans);
    cellrefArray(cellrefArray *c) {
        layerNum=c->layerNum;
        select=c->select;
        cell_ref=c->cell_ref;
        point=c->point;
        trans=c->trans;
        anz_x=c->anz_x;
        anz_y=c->anz_y;
        space_x=c->space_x;
        space_y=c->space_y;
		property=c->property;
		datatype=c->datatype;
    };
    cellrefArray();

    ~cellrefArray();


    virtual void paint(layoutImagePainter * e);
    virtual void paintSelect(layoutImagePainter * e);
    virtual void paintSelected(layoutImagePainter * e);
	virtual void paintNode(int node, layoutImagePainter *e);
    virtual void paintHighlighted(QPainter *,strans  ) ;
    virtual void paintHighlighted(QPainter *,strans ,QPoint ) ;
    virtual void paintInfo(QPoint *,QPoint *,uint *)const;
    virtual void cSelect(QRect select);
    virtual void cDeselect(QRect select);
    virtual void setCellRef(cell *cell_);
    virtual void setPos(QPoint pos);
    virtual void minimum(QPoint *pos);
    virtual void maximum(QPoint *pos);
    virtual void minimumSelect(QPoint *pos);
    virtual void maximumSelect(QPoint *pos);
/*    virtual int minSize() {return (int)trans.mag*cell_ref->minSize();}*/
    virtual cell* depend();
    virtual void saveSOURCE( source *);
    virtual void saveGDS(gds *);
    virtual void saveDXF(dxf *);
#ifdef USE_3d
virtual void saveDXF3d(dxf3d*);
#endif
    virtual void saveSVG(svg *);
    virtual void saveOASIS( oasis *);
    virtual void saveCIF( cif *);
    virtual void saveEPS(eps *);
    virtual int saveEPSCount();
    virtual void saveSelect(QDataStream *);
    virtual void save(QDataStream *);
    virtual void setMirrorx() {
        trans.setMirror_x();
    };
    virtual void clearMirrorx() {
        trans.clearMirror_x();
    };
    virtual void toggleMirrorx() {
        trans.toggleMirror_x();
    };
    virtual void setTrans(strans t){trans=t;}
    virtual void moveSelect(QPoint pos);
    virtual void move(QPoint pos);
    virtual void moveOrigin(QPoint pos);
    virtual void map(strans m);
    virtual void mapSelect(strans m);
    virtual void rotate(double ang ) {
        trans.rotate(-ang);
    };
    virtual void scale(double s) {
        trans.scale(s);
    };
    virtual void resize(double size);
    virtual bool isCellrefArray()const {
        return true;
    }
    virtual cellrefArray* getCellrefArray() {
        return this;
    };
    virtual elementList* flatSelect();
    virtual void setName(QString s) {
        name=s;
    };
    virtual QString getName() {
        return name;
    };
    virtual double areaSelect() {
        if (select) {
            return areaSelected();
        } else
            return 0;
    }
    virtual double areaSelected();
    virtual double nearestDistance(QPoint);
    virtual double nearestDistance(const QPoint,QPoint *)const;
    virtual double nearestDistancePoint(const QPoint p1, QPoint *p2)const;
    virtual double nearestLine(QPoint,QPoint *,int) ;
    virtual double nearestMiddle(QPoint,QPoint *,int) ;
    virtual double nearestCenter(QPoint,QPoint *,int);
    virtual bool showProperties(elementList *, drawingField *,bool basicEditing);
    virtual void countSelect(elementCount *c){if (select) {c->cellrefarray++;} }
    virtual pointArray getPoints(){pointArray p; p.resize(3); p.setPoint(0,point); p.setPoint(1,point+space_x); p.setPoint(2,point+space_y); return p;}
// no daatype for cellrefs
    virtual int getDatatype(){ return -1;}
    virtual void selectDatatype( int ) {}
   virtual bool identical(element *);
   virtual bool identicalStructure(element *);
   virtual void findEdge(QPoint p1, QPoint p2,int layer,char dir,int *result);
   virtual void lineDistanceLayer(QPoint p1,QPoint p2, int *left,int *right,int layer, QPoint min, QPoint max);
   virtual bool pointOnLayer(QPoint p,int layer);
   virtual void clean();
   friend bool operator% (const cellrefArray &r1,const cellrefArray &r2);
   friend bool operator== (const cellrefArray &r1,const cellrefArray &r2);
};

#endif
