/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "setuserunit.h"


setUserunit::setUserunit(QString s)
: setUserunitDialog()
{
    setupUi(this);
   result="";
   unused->hide();
   userunits->setText("");
   userunits->setValidator(new QDoubleValidator(0.0000000001,1000000000,10,userunits));
   userunits->setEnabled(false);
    if (s=="m") unitM->setChecked(true);
    else if (s=="dm") unitDm->setChecked(true);
    else if (s=="cm") unitCm->setChecked(true);
    else if (s=="mm") unitMm->setChecked(true);
    else if (s=="inch") unitInch->setChecked(true);
    else if (s=="m") unitUm->setChecked(true);
    else if (s=="mils") unitMils->setChecked(true);
    else if (s=="nm") unitNm->setChecked(true);
    else if (s=="inch") unitUinch->setChecked(true);
    else if (s=="A") unitA->setChecked(true);
    else {
      unitOther->setChecked(true);
      s.remove("m");
      userunits->setText(s);
      userunits->setEnabled(true);
      //d=s.toDouble();
    }

  connect (unitOther,SIGNAL(toggled(bool)),this,SLOT(otherUnits(bool)));
}


void setUserunit::otherUnits(bool b){
  if (b) userunits->setEnabled(true);
  else userunits->setEnabled(false);
}


setUserunit::~setUserunit()
{

}

void setUserunit::accept()
{ 
  if (unitM->isChecked()) result= "m";
  else if ( unitDm->isChecked()) result= "dm";
  else if ( unitCm->isChecked()) result= "cm";
  else if ( unitMm->isChecked()) result= "mm";
  else if ( unitInch->isChecked()) result= "inch";
  else if ( unitUm->isChecked()) result= "m";
  else if ( unitMils->isChecked()) result= "mils";
  else if ( unitNm->isChecked()) result= "nm";
  else if ( unitUinch->isChecked()) result= "inch";
  else if ( unitA->isChecked()) result= "A";
  else result=userunits->text()+"m";
  //printf("%s\n",result.ascii());
  QDialog::accept();
}


