/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SETUPWINDOW_H
#define SETUPWINDOW_H

class layout;
class QWidget;
struct layout_ {
 union {
 layout *l;
 QWidget *p;
 };
};

#include "ui_setupwindowdialog.h"
#include "dialog/helpwindow.h"
#include "layermanager.h"
#include <QDialog>
class setupWindow : public QDialog, private Ui::setupWindowDialog
{
  Q_OBJECT
  layout_ layoutPtr;
public:
  setupWindow(QWidget* parent = 0);
  ~setupWindow();
  /*$PUBLIC_FUNCTIONS$*/
  static layerManager *layerManagerWindow;
public slots:
  /*$PUBLIC_SLOTS$*/
  void open();
  void openFont();
  void openLayerManager();
  void setHelpWindow(helpWindow *w);
  void checkInput(const QString &);
  void chooseFont();
  void setMouseColor();
  void setGridColor();
  void setZeroColor();
  void setSelectColor();
  void setHighlightColor();
  void setBackgroundColor();
  void setWireColor();
  void setBusColor();
  void setPinColor();
  void setTextColor();
  void setDeviceColor();
  void setInstanceColor();
private slots:
  void chooseDocumentationDirectory();
  void chooseMacroDirectory();
  void netlistAdd();
  void netlistSet(int);
  void netlistSet(QString);
  void netlistSet();
  void netlistStore();
  void netlistSubAdd();
  void netlistSubSet(int);
  void netlistSubSet(QString);
  void netlistSubSet();
  void netlistSubStore();
protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
  virtual void          reject();
  virtual void          accept();
private:
 
 QString netlistDisplayed;
 QString netlistSubDisplayed;
 QMap<QString,QVariant> netlistFormat;
 QMap<QString,QVariant> netlistSubFormat;
 QMap<QString,QVariant> netlistSubModelFormat;
};

#endif

