/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qlineedit.h>
#include <qvalidator.h>
#include "drclayercombination.h"
#include "general/userunitsvalidator.h"
#include "elements/element.h"

drcLayerCombination::drcLayerCombination()
: drcLayerCombinationDialog()
{
setupUi(this);

setWindowTitle(tr("DRC Layer Combination"));
layerNr1->setMaximum(layersMax-1);
layerNr2->setMaximum(layersMax-1);
layerNr3->setMaximum(layersMax-1);
layerNr4->setMaximum(layersMax-1);
layerNr5->setMaximum(layersMax-1);
connect(layerNr1,SIGNAL(valueChanged(int)),this,SLOT(setLayerName1(int)));
connect(layerNr2,SIGNAL(valueChanged(int)),this,SLOT(setLayerName2(int)));
connect(layerNr3,SIGNAL(valueChanged(int)),this,SLOT(setLayerName3(int)));
connect(layerNr4,SIGNAL(valueChanged(int)),this,SLOT(setLayerName4(int)));
connect(layerNr5,SIGNAL(valueChanged(int)),this,SLOT(setLayerName5(int)));
layerNr1->setValue(1);
layerNr2->setValue(2);
layerNr3->setValue(-1);
layerNr4->setValue(-1);
layerNr5->setValue(-1);
setModal(true);
}

void drcLayerCombination::setLayerName1(int i){
if (i>=0) layerName1->setText(layers::num[i].name);
else layerName1->setText("not used");
}
void drcLayerCombination::setLayerName2(int i){
if (i>=0) layerName2->setText(layers::num[i].name);
else layerName2->setText("not used");
}
void drcLayerCombination::setLayerName3(int i){
if (i>=0) layerName3->setText(layers::num[i].name);
else layerName3->setText("not used");
}
void drcLayerCombination::setLayerName4(int i){
if (i>=0) layerName4->setText(layers::num[i].name);
else layerName4->setText("not used");
}
void drcLayerCombination::setLayerName5(int i){
if (i>=0) layerName5->setText(layers::num[i].name);
else layerName5->setText("not used");
}


drcLayerCombination::~drcLayerCombination()
{
}

/*$SPECIALIZATION$*/
bool drcLayerCombination::dialog(int *layer1, int *layer2,int *layer3,int *layer4,int *layer5){
   drcLayerCombination d;
    d.show();
    int i=d.exec();
    d.hide();
    switch (i) {
    case QDialog::Rejected :
    	return false;
    case QDialog::Accepted :
	*layer1=d.layerNr1->value();
	*layer2=d.layerNr2->value();
	*layer3=d.layerNr3->value();
	*layer4=d.layerNr4->value();
	*layer5=d.layerNr5->value();
	return true;
   }
  return false;
}

