/*
 * ##########################################################################
 * #  Dies ist der PHP Modul Code fr konto_check. Das Modul wurde nach der #
 * #  (sehr guten) Anleitung von Sara Golemon (Extension Writing) aus       #
 * #  http://devzone.zend.com/node/view/id/1021 (...1024) geschrieben.      #
 * #                                                                        #
 * #  Copyright (C) 2008 Michael Plugge <m.plugge@hs-mannheim.de>           #
 * ##########################################################################
 *
 * ##########################################################################
 * #  Dieses Programm ist freie Software; Sie drfen es unter den           #
 * #  Bedingungen der GNU Lesser General Public License, wie von der Free   #
 * #  Software Foundation verffentlicht, weiterverteilen und/oder          #
 * #  modifizieren; entweder gem Version 2.1 der Lizenz oder (nach Ihrer  #
 * #  Option) jeder spteren Version.                                       #
 * #                                                                        #
 * #  Dieses Programm wird in der Hoffnung weiterverbreitet, da es         #
 * #  ntzlich sein wird, jedoch OHNE IRGENDEINE GARANTIE, auch ohne die    #
 * #  implizierte Garantie der MARKTREIFE oder der VERWENDBARKEIT FR       #
 * #  EINEN BESTIMMTEN ZWECK. Mehr Details finden Sie in der GNU Lesser     #
 * #  General Public License.                                               #
 * #                                                                        #
 * #  Sie sollten eine Kopie der GNU Lesser General Public License          #
 * #  zusammen mit diesem Programm erhalten haben; falls nicht,             #
 * #  schreiben Sie an die Free Software Foundation, Inc., 59 Temple        #
 * #  Place, Suite 330, Boston, MA 02111-1307, USA. Sie knnen sie auch     #
 * #  von                                                                   #
 * #                                                                        #
 * #       http://www.gnu.org/licenses/lgpl.html                            #
 * #                                                                        #
 * # im Internet herunterladen.                                             #
 * #                                                                        #
 * ##########################################################################
 */

#ifndef PHP_KONTO_CHECK_H
#define PHP_KONTO_CHECK_H 1

#define PHP_KONTO_CHECK_VERSION "2.98 (3.0 Beta 7)"
#define PHP_KONTO_CHECK_EXTNAME "konto_check"

#define USE_RINIT       0  /* bei 1: (optional) request init benutzen */
#define USE_RSHUTDOWN   1  /* bei 1: (optional) request shutdown benutzen */
#define USE_RET         1  /* bei 1: numerischen Rckgabewert mit add_assoc_long hinzufgen */
#define USE_RET1        1  /* bei 1: Klartext-Rckgabewert mit add_assoc_string hinzufgen */
#define USE_RET2        1  /* bei 1: kurzen Klartext-Rckgabewert mit add_assoc_string hinzufgen */
#define USE_RET3        1  /* bei 1: HTML-Rckgabewert mit add_assoc_string hinzufgen */
#define USE_ARGS        0  /* bei 1: einige Parameter (BLZ, Zweigstelle etc.) im Rckgabewert hinzufgen */
#define LUT_NAME_BUFFER 256

PHP_MINIT_FUNCTION(konto_check);
PHP_MSHUTDOWN_FUNCTION(konto_check);
PHP_MINFO_FUNCTION(konto_check);

#if USE_RINIT
PHP_RINIT_FUNCTION(konto_check);
#endif

#if USE_RSHUTDOWN
PHP_RSHUTDOWN_FUNCTION(konto_check);
#endif

PHP_FUNCTION(kto_check);
PHP_FUNCTION(kto_check_str);
PHP_FUNCTION(lut_init);
PHP_FUNCTION(kto_check_init);
PHP_FUNCTION(generate_lut2);
PHP_FUNCTION(read_lut_block);
PHP_FUNCTION(write_lut_block);
PHP_FUNCTION(copy_lutfile);
PHP_FUNCTION(kto_check_pz);
PHP_FUNCTION(kto_check_blz);
PHP_FUNCTION(kto_check_pz_dbg);
PHP_FUNCTION(kto_check_blz_dbg);
PHP_FUNCTION(kto_check_retval2txt);
PHP_FUNCTION(kto_check_retval2html);
PHP_FUNCTION(kto_check_retval2txt_short);
PHP_FUNCTION(kto_check_retval2dos);
PHP_FUNCTION(kto_check_retval2utf8);
PHP_FUNCTION(get_kto_check_version);
PHP_FUNCTION(iban_check);
PHP_FUNCTION(iban2bic);
PHP_FUNCTION(ipi_gen);
PHP_FUNCTION(ipi_check);
PHP_FUNCTION(lut_cleanup);
PHP_FUNCTION(lut_filialen);
PHP_FUNCTION(lut2_status);
PHP_FUNCTION(lut_valid);
PHP_FUNCTION(lut_multiple);
PHP_FUNCTION(lut_info);
PHP_FUNCTION(lut_name);
PHP_FUNCTION(lut_name_kurz);
PHP_FUNCTION(lut_plz);
PHP_FUNCTION(lut_ort);
PHP_FUNCTION(lut_pan);
PHP_FUNCTION(lut_bic);
PHP_FUNCTION(lut_nr);
PHP_FUNCTION(lut_pz);
PHP_FUNCTION(lut_aenderung);
PHP_FUNCTION(lut_loeschung);
PHP_FUNCTION(lut_nachfolge_blz);

extern zend_module_entry konto_check_module_entry;
#define phpext_konto_check_ptr &konto_check_module_entry

#endif
