/***************************************************************************
							 ObjectNotebook.h
                             -------------------
    begin                : Wed April 9, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#ifndef _OBJECTNOTEBOOK_H_
#define _OBJECTNOTEBOOK_H_

#include "CodeObjects.h"
#include <wx/notebook.h>
#include <wx/listctrl.h>
#include <wx/textctrl.h>

enum ObjectNotebookType { TClass, TMethod, TVariable };

class CCodeObjectsDlg;
class CKlassModelerDoc;

class CObjectNotebook : public wxNotebook
{
public:
	CObjectNotebook( CCodeObjectsDlg *pParent, CKlassModelerDoc *pDoc, wxWindowID ID, const wxPoint &Pos, const wxSize &Size );
	virtual				~CObjectNotebook();
	void				BuildForClass( CClass *pClass );
	void				BuildForMethod( CMethod *pMethod );
	void				BuildForVariable( CVariable *pVariable );
	void				CloseUp();
	void				FillMethodList( int Selected );
	void				FillVariableList( int Selected );
	CKlassModelerDoc	*GetDoc(){ return m_pDoc; }
	DECLARE_EVENT_TABLE()
	// methods
	void				OnMethodActivated( wxListEvent &Event );
	void				OnMethodSelected( wxListEvent &Event );
	void				OnMethodUpArrow( wxCommandEvent &Event );
	void				OnMethodDownArrow( wxCommandEvent &Event );
	void				OnAddMethod( wxCommandEvent &Event );
	void				OnDelMethod( wxCommandEvent &Event );
	void				OnSetMethodDoc( wxCommandEvent &Event );
	// variables
	void				OnVariableActivated( wxListEvent &Event );
	void				OnVariableSelected( wxListEvent &Event );
	void				OnVariableUpArrow( wxCommandEvent &Event );
	void				OnVariableDownArrow( wxCommandEvent &Event );
	void				OnAddVariable( wxCommandEvent &Event );
	void				OnDelVariable( wxCommandEvent &Event );
	void				OnSetVariableDoc( wxCommandEvent &Event );
	// inheritence
	void				OnAddInheritence( wxCommandEvent &Event );
	void				OnDelInheritence( wxCommandEvent &Event );
	// relations
	void				OnAddHasA( wxCommandEvent &Event );
	void				OnAddUsesA( wxCommandEvent &Event );
	void				OnDelRelation( wxCommandEvent &Event );
	// enum
	void				OnEnumSelected( wxListEvent &Event );
	void				OnAddEnum( wxCommandEvent &Event );
	void				OnSetEnum( wxCommandEvent &Event );
	void				OnDelEnum( wxCommandEvent &Event );
protected:
	void				CreateMethodListPage();
	void				CreateVariableListPage();
	void				CreateDocsPage();
	void				CreateRelationsPage();
	void				CreateClassMiscPage();
	void				CreateMethodCodePage();
	void				CreateAccessImages( wxImageList *pList );
	void				CreateRelationImages( wxImageList *pList );
	void				AddMethodToEnd( CMethod *pMethod );
	void				AddVariableToEnd( CVariable *pVariable );
	void				FillInheritenceList( int Selected );
	void				AddRelationToEnd( CRelation *pRelation );
	void				FillRelationList( int Selected );
	void				AddEnumToEnd( CEnum *pEnum );
	void				FillEnumList( int Selected );
	ObjectNotebookType	m_Type;
	CKlassModelerDoc	*m_pDoc;
	CCodeObjectsDlg		*m_pParentDlg;
	wxTextCtrl			*m_pMethodDocText;
	wxListCtrl			*m_pMethodList;
	wxTextCtrl			*m_pVariableDocText;
	wxListCtrl			*m_pVariableList;
	wxListCtrl			*m_pEnumList;
	wxTextCtrl			*m_pEnumBody;
	wxRadioBox			*m_pAccessType;
	wxTextCtrl			*m_pDocText;
	wxListCtrl			*m_pInheritenceList;
	wxTextCtrl			*m_pHeaderFileText;
	wxTextCtrl			*m_pHTMLFileText;
	wxCheckBox			*m_pIsQtObjectCheck;
	wxListCtrl			*m_pRelationList;
	wxTextCtrl			*m_pMethodBodyText;
	wxCheckBox			*m_pExcludeHeader;
	wxCheckBox			*m_pExcludeHTML;
	union {
		CClass			*m_pClass;
		CMethod			*m_pMethod;
		CVariable		*m_pVariable;
	};
};

#endif
