/***************************************************************************
                             ModelPrinter.cpp
                             -------------------
    begin                : Mon April 7, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif
#include "ModelPrinter.h"

CModelPrinter::CModelPrinter( wxString Title, CModelCanvas *pCanvas )
	: wxPrintout( Title )
{
	m_pCanvas = pCanvas;
}

CModelPrinter::~CModelPrinter()
{
}

bool CModelPrinter::OnBeginDocument( int StartPage, int EndPage )
{
	if( !wxPrintout::OnBeginDocument( StartPage, EndPage ) )
		return false;
	wxDC	*pDC;
	int		PageWidth, PageHeight;
	int		CanvasWidth, CanvasHeight;

	pDC = GetDC();
	if( pDC == NULL )
		return false;
	m_pCanvas->GetPageSize( CanvasWidth, CanvasHeight );
	pDC->GetSize( &PageWidth, &PageHeight );
	pDC->SetUserScale( (PageWidth/CanvasWidth), (PageHeight/CanvasHeight) );

	return true;
}

bool CModelPrinter::OnPrintPage( int Page )
{
	wxDC	*pDC;
	int		PageWidth, PageHeight;
	int		CanvasWidth, CanvasHeight;
	wxRect	BoundingRect;
	wxRect	PageRect;
	int		x, y;

	pDC = GetDC();
	if( pDC == NULL )
		return false;
	m_pCanvas->GetPageSize( CanvasWidth, CanvasHeight );
	pDC->GetSize( &PageWidth, &PageHeight );
	GetPageRect( PageRect );
	x = ((Page-1)%PageRect.width) + PageRect.x-1;
	y = ((float)Page/(float)(PageRect.width+1)) + PageRect.y-1;
	BoundingRect.x = x*CanvasWidth;
	BoundingRect.y = y*CanvasHeight;
	BoundingRect.width = CanvasWidth;
	BoundingRect.height = CanvasHeight;
	m_pCanvas->DrawSection( *pDC, wxPoint(BoundingRect.x,BoundingRect.y), BoundingRect );

	return true;
}

void CModelPrinter::GetPageInfo( int *MinPage, int *MaxPage, int *SelPageFrom, int *SelPageTo )
{
	wxRect	PageRect;

	GetPageRect( PageRect );
	*MinPage = ((PageRect.y-1)*PageRect.width)+PageRect.x;
	*MaxPage = (PageRect.width+PageRect.x-1)*(PageRect.y-1+PageRect.height);
    *SelPageFrom = *MinPage;
    *SelPageTo = *MaxPage;
}

void CModelPrinter::GetPageRect( wxRect &PageRect )
{
	wxRect	BoundingRect;
	int		PageWidth, PageHeight;

	m_pCanvas->GetModelDimensions( BoundingRect );
	m_pCanvas->GetPageSize( PageWidth, PageHeight );
	PageRect.x = BoundingRect.x/PageWidth;
	PageRect.y = BoundingRect.y/PageHeight;
	PageRect.width = BoundingRect.width/PageWidth;
	if( (float)BoundingRect.width/(float)PageWidth > (float)PageRect.width )
		PageRect.width++;
	PageRect.height = BoundingRect.height/PageHeight;
	if( (float)BoundingRect.height/(float)PageHeight > (float)PageRect.height )
		PageRect.height++;
	// pages are one based, so add some ones
	PageRect.x++;
	PageRect.y++;
}

bool CModelPrinter::HasPage( int Page )
{	
	int Min, Max;
	int SelStart, SelEnd;

	GetPageInfo( &Min, &Max, &SelStart, &SelEnd );
	return ((Page>=Min) && (Page<=Max));
}
