/***************************************************************************
                             MainFrame.h
                             -------------------
    begin                : Thu April 3, 2003
    copyright            : (C) 2003 by James Wells
    email                : james@wells.net

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 ***************************************************************************/
#ifndef _MAINFRAME_H_
#define _MAINFRAME_H_

#include "CodeObjects.h"
#include <wx/docview.h>
#include <wx/treectrl.h>

class CKlassModelerDoc;

class CMainFrame : public wxDocParentFrame
{
	DECLARE_CLASS(CMainFrame)
	DECLARE_EVENT_TABLE()
public:
	CMainFrame( wxDocManager *pDocManager, const wxString &Title, const wxSize &Size );
	virtual				~CMainFrame();
	bool				Init();
	void				DrawTree( CKlassModelerDoc *pDoc, bool bForceRefresh );
	void				OnAbout( wxCommandEvent& event );
	void				OnContents( wxCommandEvent& event );
	void				OnGenerateCode( wxCommandEvent& event );
	void				OnGenerateHTML( wxCommandEvent& event );
	void				OnItemActivated( wxTreeEvent &Event );
	void				OnRebuildTree( wxCommandEvent &Event );
protected:
	wxTreeCtrl			*m_pClassTree;
	CKlassModelerDoc	*m_pCurrentDoc;
};

enum NodeType { TClass, TMethod, TVariable };

class CTreeNode : public wxTreeItemData
{
public:
	CTreeNode( CClass *pClass );
	CTreeNode( CMethod *pMethod );
	CTreeNode( CVariable *pVariable );
	virtual			~CTreeNode();
	NodeType		GetType(){ return m_Type; }
	CClass			*GetClass(){ return m_pClass; }
	CMethod			*GetMethod(){ return m_pMethod; }
	CVariable		*GetVariable(){ return m_pVariable; }
protected:
	union {
		CClass		*m_pClass;
		CMethod		*m_pMethod;
		CVariable	*m_pVariable;
	};
	NodeType		m_Type;
};

#endif
